c
c
      subroutine manovx (iwk, n, ng, nout, nvar, nvmax, nvmax1,
     +                   eigval, gc, tb, tbtwi, tt, tw, twi,
     +                   abort)
c
c action: create tb, tw, tw^{-1}, tt, tb*tw^{-1} from arguments returned by g03daf$/dafg03
c author: w.g.bardsley, university of manchester, u.k., 29/10/2003 
c         05/11/2006 edited and added intents
c
c         Note: the extra dimension nvmax1 = nvmax + 1 for tbtwi as it is used
c               for matrix inversion by f01abf$
c
c          iwk: workspace
c            n: (input/unchanged) as returned from g03daf$ 
c           ng: (input/unchanged) as returned from g03daf$ 
c         nvar: (input/unchanged) as returned from g03daf$ 
c        nvmax: (input/unchanged) maximum number of variables 
c       nvmax1: (input/unchanged) leading dimension for tbtwi 
c       eigval: (output) eigenvalues of tb*tw^{-1}
c        gc(*): (input/unchanged) as returned from g03daf$ then dafg03 
c           tb: (output) as between groups ssp matrix
c        tbtwi: (output) as tb*tw^{-1}
c           tt: (output) as total ssp matrix
c           tw: (output) as within group ssp matrix
c          twi: (output) as tw^{-1}
c        abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: n, ng, nout, nvar, nvmax,
     +                                    nvmax1
      integer,          intent (inout) :: iwk(nvar)
      double precision, intent (in)    :: gc((ng + 2)*nvar*(nvar + 1)/2)
      double precision, intent (out)   :: eigval(2*nvmax),
     +                                    tb(nvmax,nvar), 
     +                                    tbtwi(nvmax1,nvmax),
     +                                    tt(nvmax,nvar),
     +                                    tw(nvmax,nvar),
     +                                    twi(nvmax,nvar)
      logical,          intent (out)   :: abort
c
c locals
c
      integer    nbig, nstart
      integer    i, ia, ib, ifail, j, k
      integer    isend
      parameter (isend = 1)
      double precision factor
      double precision zero
      parameter (zero = 0.0d+00)
      external   utranu, putifa
      external   f01abf$, f02aff$
      intrinsic  dble
c
c check
c
      if (nvar.lt.2 .or. ng.lt.2 .or. nvmax.lt.nvar) then
         abort = .true.
         return
      else
         abort = .false.
      endif
c
c create tw
c
      nstart = 1
      call utranu (isend, nvar, nvmax,
     +             tw, gc(nstart),
     +             abort)
      if (abort) return
      factor = dble(n - ng)
      do j = 1, nvar
         do i = 1, nvar
            tw(i,j) = factor*tw(i,j)
         enddo
      enddo
c
c create tt
c
      nbig = nvar*(nvar + 1)/2
      nstart = (ng + 1)*nbig + 1
      call utranu (isend, nvar, nvmax, 
     +             tt, gc(nstart),
     +             abort)
      if (abort) return
      factor = dble(n - 1)
      do j = 1, nvar
         do i = 1, nvar
            tt(i,j) = factor*tt(i,j)
         enddo
      enddo
c
c create tb = tt - tw
c
      do j = 1, nvar
         do i = 1, nvar
            tb(i,j) = tt(i,j) - tw(i,j)
         enddo
      enddo
c
c create tw^{-1}
c
      do i = 1, nvar
         do j = i, nvar
            tbtwi(i,j) = tw(i,j)
         enddo
      enddo
      ia = nvmax1
      ib = nvmax
      ifail = 1
      call f01abf$(tbtwi, ia, nvar, tt, ib, eigval, ifail)
      call putifa (ifail, nout, 'F01ABF/MANOVX')
      if (ifail.ne.0) then
         abort = .true.
         return
      endif
      do i = 1, nvar
         do j = 1, i
            twi(i,j) = tt(i,j)
            tbtwi(i,j) = tt(i,j)
         enddo
      enddo
      do i = 1, nvar
         do j = i + 1, nvar
            twi(i,j) = twi(j,i)
            tbtwi(i,j) = tbtwi(j,i)
         enddo
      enddo
c
c create tb(tw^{-1})
c
      do i = 1, nvar
         do j = 1, nvar
            tt(i,j) = zero
            do k = 1, nvar
               tt(i,j) = tt(i,j) + tb(i,k)*(tbtwi(k,j))
            enddo
         enddo
      enddo
      do j = 1, nvar
         do i = 1, nvar
            tbtwi(i,j) = tt(i,j)
         enddo
      enddo
c
c calculate the eigenvalues of tb*tw^{-1}
c
      ia = nvmax + 1
      ib = nvmax
      ifail = 1
      call f02aff$(tbtwi, ia, nvar, eigval(1), eigval(nvmax + 1),
     +             iwk, ifail)
      call putifa (ifail, nout, 'F02AFF/MANOVX')
      if (ifail.ne.0) then
         abort = .true.
         return
      endif
c
c restore tbtwi
c
      do j = 1, nvar
         do i = 1, nvar
            tbtwi(i,j) = tt(i,j)
         enddo
      enddo
c
c re-create tt
c
      nstart = (ng + 1)*nbig + 1
      call utranu (isend, nvar, nvmax,
     +             tt, gc(nstart), 
     +             abort)
      if (abort) return
      factor = dble(n - 1)
      do j = 1, nvar
         do i = 1, nvar
            tt(i,j) = factor*tt(i,j)
         enddo
      enddo
      end
c
c
