c
c
      subroutine manovy (isend, ldg, n, ng, ng1, ng2, nig, nout, nvar,
     +                   nvmax,
     +                   c, d, det, df, gc, gmean, sig, stat, vec, wk,
     +                   abort)
c
c action: subgroup manova calculations on results returned by g03daf$ then dafg03
c author: w.g.bardsley, university of manchester, u.k., 02/11/2003
c         05/11/2006 edited and added intents
c
c         isend: (input/unchanged)program control 
c                 isend = 1: test for equality of covariances
c                 isend = 2: test for equality of means
c                 isend = 3: test for equal profiles
c           ldg: (input/unchanged) leading dimension of gmean 
c             n: (input/unchanged) no. of observations
c            ng: (input/unchanged) no. of groups 
c           ng1: (input/unchanged) identifier for group 1 
c           ng2: (input/unchanged) identifier for group 2 
c           nig: (input/unchanged) group sizes 
c          nout: (input/unchanged) pre-connected unit 
c          nvar: (input/unchanged) no. of variables 
c         nvmax: (input/unchanged) leading dimension of c 
c             c: workspace
c             d: workspace
c           det: (input/unchanged) determinants 
c            df: (output) degrees of freedom
c            gc: (input/unchanged) packed matrices from g03daf
c         gmean: (input/unchanged) group means 
c           sig: (output) significance level(s) 
c          stat: (output) test statistic(s) 
c           vec: workspace
c            wk: workspace
c         abort: (output) error indicator 
c
c
      implicit none
c
c arguments
c
      integer,          intent (in)    :: isend, ldg, n, ng, ng1, ng2,
     +                                    nig(ng), nout, nvar, nvmax
      double precision, intent (in)    :: det(ng + 2), 
     +                                    gc((ng+2)*nvar*(nvar+1)/2),      
     +                                    gmean(ldg,nvar)
      double precision, intent (out)   :: df(2), sig(2), stat(2) 
      double precision, intent (inout) :: c(nvmax,nvmax),
     +                                    d(nvmax,nvmax), 
   
     +                                    vec(nvar), wk(n,nvar+1)
      logical,          intent (out)   :: abort
c
c locals
c
      integer    i, id, ifail, j, k, nbig, nstart, nvm1, nvp1
      integer    jsend, ksend
      parameter (jsend = 1, ksend = 2)
      double precision d1, dng1m1, dng2m1, dn1, dn2, dnvar, temp
      double precision zero, one, two, three, six
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           three = 3.0d+00, six = 6.0d+00)
      double precision g01ecf$, g01edf$
      external   utranu, putifa, xtrnax
      external   f03aef$, g01ecf$, g01edf$
      intrinsic  dble, log
      if (isend.lt.1 .or. isend.gt.3 .or.
     +    ng.lt.2 .or.
     +    ng1.lt.1 .or. ng1.gt.ng .or.
     +    ng2.lt.1 .or. ng2.gt.ng .or.
     +    nvar.lt.2 .or.
     +    nig(ng1).lt.nvar .or.
     +    nig(ng2).lt.nvar) then
         abort = .true.
         return
      endif
      if (isend.le.3) then
c
c Part 1: reconsitute the pooled covariance matrix from the two groups into array wk
c
         dng1m1 = dble(nig(ng1) - 1)
         dng2m1 = dble(nig(ng2) - 1)
         dnvar = dble(nvar)
         nbig = nvar*(nvar + 1)/2
         nstart = ng1*nbig + 1
         call utranu (jsend, nvar, n,
     +                wk, gc(nstart),
     +                abort)
         if (abort) return
         do i = 1, nvar
            do j = 1, nvar
               wk(nvar + i,j) = wk(i,j)
            enddo
         enddo
         nstart = ng2*nbig + 1
         call utranu (jsend, nvar, n, 
     +                wk, gc(nstart),
     +                abort)
         if (abort) return
c
c Part 1: work out cv = [(n1 - 1)s1 + (n2 - 1)s2]/(n1 + n2 - 2)
c
         temp = dng1m1 + dng2m1
         do i = 1, nvar
            do j = 1, nvar
               wk(i,j) = dng2m1*wk(i,j) + dng1m1*wk(nvar + i,j)
               wk(i,j) = wk(i,j)/temp
            enddo
         enddo
c
c Part 1: now wk = the pooled covariance matrix reconstituted from the two groups
c
      endif
c
c Part 2: calculate depending on isend
c
      if (isend.eq.1) then
c
c isend = 1: test for equality of covariance matrices
c
         ifail = 1
         call f03aef$(nvar, wk, n, vec, d1, id, ifail)
         call putifa (ifail, nout, 'F03AEF/MANOVAY')
         if (ifail.ne.0) return
         temp = (dng1m1 + dng2m1)*log(d1*(two**id))
         stat(1) = temp - dng1m1*det(ng1) - dng2m1*det(ng2)
         temp = one/dng1m1 + one/dng2m1 - one/(dng1m1 + dng2m1)
         temp = temp*(two*(dnvar**2) + three*dnvar - one)
         temp = temp/(six*(dnvar + one))
         temp = one - temp
         stat(1) = temp*stat(1)
         df(1) = dnvar*(dnvar + one)/two
         ifail = 1
         sig(1) = g01ecf$('U', stat(1), df(1), ifail)
         call putifa (ifail, nout, 'G01ECF/MANOVY')
         if (ifail.ne.0) return
      elseif (isend.eq.2) then
c
c isend = 2: Hotelling T-squared test on means
c
         do i = 1, nvar
            vec(i) = gmean(ng1,i) - gmean(ng2,i)
         enddo
         call xtrnax (ksend, nout, n, nvar,
     +                wk, temp, vec,
     +                abort)
         dn1 = dble(nig(ng1))
         dn2 = dble(nig(ng2))
         stat(1) = (dn1*dn2)*temp/(dn1 + dn2)
         df(1) = dnvar
         df(2) = dn1 + dn2 - dnvar - one
         stat(2) = df(2)*stat(1)/(dnvar*(dng1m1 + dng2m1))
         ifail = 1
         sig(1) =  g01edf$('U', stat(2), df(1), df(2), ifail)
         call putifa (ifail, nout, 'G01EDF/MANOVY')
         if (ifail.ne.0) return
      elseif (isend.eq.3) then
c
c isend = 3: test profiles but first creat the helmert matrix
c
         do i = 1, nvar - 1
            do j = 1, nvar
               if (j.eq.i) then
                  c(i,j) = one
               elseif (j.eq.i + 1) then
                  c(i,j) = - one
               else
                  c(i,j) = zero
               endif
            enddo
         enddo
c
c isend = 3: use the helmert matrix c to define the difference vector
c
         nvm1 = nvar - 1
         nvp1 = nvar + 1
         do i = 1, nvar
            wk(i,nvp1) = gmean(ng1,i) - gmean(ng2,i)
         enddo
         do i = 1, nvm1
            vec(i) = zero
            do j = 1, nvar
               vec(i) = vec(i) + c(i,j)*wk(j,nvp1)
            enddo
         enddo
c
c isend = 3: post multiply the covariance matrix by c^T
c
         do i = 1, nvar
            do j = 1, nvm1
               d(i,j) = zero
               do k = 1, nvar
                  d(i,j) = d(i,j) + wk(i,k)*c(j,k)
               enddo
            enddo
         enddo
c
c isend = 3: premultiply by c to put csc^T into wk
c
         do i = 1, nvm1
            do j = 1, nvm1
               wk(i,j) = zero
               do k = 1, nvar
                  wk(i,j) = wk(i,j) + c(i,k)*d(k,j)
               enddo
            enddo
         enddo
c
c isend = 3: now work out the Hotelling T squared data
c
         call xtrnax (ksend, nout, n, nvm1,
     +                wk, temp, vec,
     +                abort)
         dn1 = dble(nig(ng1))
         dn2 = dble(nig(ng2))
         stat(1) = (dn1*dn2)*temp/(dn1 + dn2)
         df(1) = dnvar - one
         df(2) = dn1 + dn2 - dnvar
         stat(2) = df(2)*stat(1)/((dnvar - one)*(dng1m1 + dng2m1))
         ifail = 1
         sig(1) =  g01edf$('U', stat(2), df(1), df(2), ifail)
         call putifa (ifail, nout, 'G01EDF/MANOVY')
         if (ifail.ne.0) return
      endif
c
c OK so set abort = .false.
c
      abort = .false.
      end
c
c
