c
c
      subroutine mat2cr (isend, ncol, nout, nrmax, nrow,
     +                   a)
c
c action: analyse two columns or rows of a matrix
c author: w.g.bardsley, university of manchester, u.k., 11/05/2004
c         06/02/2006 added nmax to argument list to create larger workspace
c                    and allocatable workspace if ties and n =< ntop
c         07/03/2007 extensive editing and all workspaces now allocatable 
c         22/11/2010 replaced missing definition for dn in paired t test
C         05/05/2016 increased number of significant figures in output  
C         28/06/2021 introduced e_numbers and e_formats, etc.
c
c         isend: (input/unchanged)
c                 isend = 1: analyse columns
c                 isend = 2: analyse rows
c                 isend = 3: user decides
c          ncol: (input/unchanged) no. columns
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) max. no. of rows
c          nrow: (input/unchanged) no. rows
c             a: (input/unchanged)
c
      implicit none
c
c arguments
c
      integer,          intent (in)    :: isend, ncol, nout, nrmax, nrow  
      double precision, intent (in)    :: a(nrmax,ncol)
c
c local allocatable workspace
c     
      integer, allocatable :: iwrk(:)
      double precision, allocatable :: w(:), wrk(:), x(:), y(:)
c
c locals
c
      integer    i, icolor, ierr, is, ifail, l, lwrk, m, mx, my, n,
     +           nneg, nopt, npos, nrmax2, nrun, nr1, nr5, ntest, ntext,
     +           ntype, nwork, nx, nxmax, ny, nymax, n1
      integer    len200
      integer    nmax, ntop
      parameter (nmax = 13, ntop = 30)
      double precision bot, dbar, dn, dof, dvar, ratio, top, xbar, xvar,
     +                 ybar, yvar
      double precision tp, ptp, tu, ptu
      double precision dks2, pks2, zks2
      double precision u, unor, pu
      double precision wx, wnor, pw
      double precision probr, probs, probt
      double precision ps
      double precision rtol, x02amf$, g01ebf$
      double precision cos_theta, distance, dot, theta_deg, theta_rad,
     +                 xl, yl
      double precision zero, one, two, pnt01, pnt05
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           pnt01 = 0.01d+00, pnt05 = 0.05d+00)
      character (len = 13) d13(2), showlj
      character  text(40)*100, title*80
      parameter (title = 'Select or suppress the options required')
      character  line*100, siglev*10, type10*10, x8*8, y8*8, z8*8
      character  ptitle*50, xtitle*30, ytitle*30 
      character  text2(2)*100
      character  high*10, low*10, notsig*10
      parameter (high = '*p =< 0.01',
     +            low = '*p =< 0.05',
     +         notsig = '          ')
      logical    e_formats, e_numbers
      logical    abort, ties, useit(nmax)
      logical    file1, print1
      parameter (file1 = .true., print1 = .true.)
      external   putfat, chkbox, gks001, linfit, putifa, triml1, table1,
     +           probrs, len200, getjm1, nxxbar, dotprd
      external   x02amf$, g01ebf$, g08cdf$, g08ahf$, g08akf$, g08ajf$,
     +           g08aaf$, g08agf$
      external   e_formats, showlj
      intrinsic  dble, sqrt, min, max
      save       nx, ny
      save       useit
      data       nx, ny / 1, 2 /
      data       useit / nmax*.true. /
c
c check isend
c
      if (isend.eq.1) then
c
c two columns
c
         nopt = nmax - 1
         useit (nmax) = .true.
      elseif (isend.eq.2) then
c
c two rows
c
         nopt = nmax - 1
         useit(nmax) = .false.
      elseif (isend.eq.3) then
c
c user chooses
c
         nopt = nmax
      else
c
c illegal value for isend
c
         write (line,100) 'ISEND'
         call putfat (line)
         return
      endif    
c
c check input parameters
c                   
      if (ncol.lt.2) then
         write (line,100) 'Column dimension'
         call putfat (line)
         return
      endif 
      if (nrow.lt.2 .or. nrow.gt.nrmax) then
         write (line,100) 'Row dimension'
         call putfat (line)
         return
      endif  
      if (nout.lt.1) then
         write (line,100) 'NOUT'
         call putfat (line)
         return
      endif        
c
c initialise: nwork = dimension of w
c
      e_numbers = e_formats()
      ntext = 0 
      nrmax2 = 2*max(ncol,nrow)
      nwork = 4*nrmax2
      rtol = 1.0d+09*x02amf$() 
c
c allocate workspaces
c      
      ierr = 0
      if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return   
      allocate(iwrk(4*nrmax2 + 2), stat = ierr)
      if (ierr.ne.0) return 
      allocate(w(nwork), stat = ierr)
      if (ierr.ne.0) return 
      allocate(x(nrmax2), stat = ierr)
      if (ierr.ne.0) return 
      allocate(y(nrmax2), stat = ierr)
      if (ierr.ne.0) return 
c
c display the check box
c
      write (text,200) nx, ny
      call chkbox (nopt,
     +             text, title,
     +             useit)
      if (useit(nmax)) then
c
c columns chosen so check column and row dimensions
c
         if (ncol.lt.2 .or. nrow.lt.3 .or. nrow.gt.nrmax .or.
     +       nrow.gt.nwork) then
            write (line,300)
            call putfat (line)
            return
         endif
         nxmax = ncol
         nymax = ncol
         if (nx.gt.nxmax .or. ny.gt.nymax) then
            nx = 1
            ny = 2
         endif
         type10 = 'column'
      else
c
c rows chosen so check column and row dimensions
c
         if (nrow.lt.2 .or. ncol.lt.3 .or. nrow.gt.nrmax .or.
     +       ncol.gt.nwork) then
            write (line,300)
            call putfat (line)
            return
         endif
         nxmax = nrow
         nymax = nrow
         if (nx.gt.nxmax .or. ny.gt.nymax) then
            nx = 1
            ny = 2
         endif
         type10 = 'row'
      endif
c
c prepare the row/column identifiers
c
      write (x8,'(i8)') nx
      write (y8,'(i8)') ny
      call triml1 (x8)
      call triml1 (y8)
      if (useit(1)) then
c
c useit(1): assign nx
c
         l = len200(type10)
         write (line,400) type10(1:l)
         i = 1
         call getjm1 (i, nx, nxmax,
     +                line)
         write (x8,'(i8)') nx
         call triml1 (x8)
      endif
      if (useit(2)) then
c
c useit(2): assign ny
c
         l = len200(type10)
         write (line,500) type10(1:l)
         i = 1
         call getjm1 (i, ny, nymax,
     +                line)
         write (y8,'(i8)') ny
         call triml1 (y8)
      endif
      if (nx.eq.ny) then
         write (line,600)
         call putfat (line)
         return
      endif
      if (useit(nmax)) then
c
c define x and y = columns
c
         ptitle = 'Columns'
         write (xtitle,700) x8
         write (ytitle,700) y8
         n = nrow
         do i = 1, n
            x(i) = a(i,nx)
            y(i) = a(i,ny)
         enddo
      else
c
c define x and y = rows
c
         ptitle = 'Rows'
         write (xtitle,800) x8
         write (ytitle,800) y8
         n = ncol
         do i = 1, n
            x(i) = a(nx,i)
            y(i) = a(ny,i)
         enddo
      endif
      write (z8,'(i8)') n
      call triml1 (z8)
      if (useit(3)) then
c
c useit(3): simple plot
c
         l = 0
         m = 5
         call gks001 (l, m, n,
     +                x, y,
     +                ptitle, xtitle, ytitle)
      endif
c
c write details out to results file
c
      if (useit(4) .or. useit(5) .or. useit(6) .or. useit(7) .or.
     +    useit(8) .or. useit(9) .or. useit(10) .or. useit(11) .or.
     +    useit(12)) then
          l = len200(type10)
          write (text,900) z8, type10(1:l), x8, type10(1:l), y8
          write (nout,'(a)') notsig
          write (nout,900) z8, type10(1:l), x8, type10(1:l), y8
          ntext = 2
      endif
      if (useit(4)) then
c
c useit(4): regression/correlation
c
         call linfit (nout, n,
     +                x, y, 
     +                file1, print1)
      endif
      if (useit(5)) then
c
c useit(5): unpaired t test
c
         call nxxbar (n,
     +                x, xbar, xvar)
         call nxxbar (n,
     +                y, ybar, yvar)
         if (xvar.gt.rtol .and. yvar.gt.rtol) then
            dn = dble(n)
            dof = two*(dn - one)
            top = two*(dn - one)*(xvar + yvar)
            bot = dn*dof
            ratio = top/bot
            tu = (xbar - ybar)/sqrt(ratio)
            ifail = 1
            ptu = g01ebf$('S', tu, dof, ifail)
            call putifa (ifail, nout, 'G01EBF/MAT2CR')
            ntext = ntext + 1
            write (text(ntext),1000)
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),1100) tu
            else
               d13(1) = showlj(tu)
               write (text(ntext),1150) d13(1)
            endif      
            ntext = ntext + 1
            if (ptu.le.pnt01) then
               siglev = high
            elseif (ptu.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),1200) ptu, siglev
         else
            write (line,1300)
            call putfat (line)
         endif
      endif
      if (useit(6)) then
c
c paired t test
c
         do i = 1, n
            w(i) = x(i) - y(i)
         enddo
         call nxxbar (n, w, dbar, dvar)
         if (dvar.gt.rtol) then
            dn = dble(n)
            dof = dn - one
            tp = dbar/sqrt(dvar/dn)
            ifail = 1
            ptp = g01ebf$('S', tp, dof, ifail)
            call putifa (ifail, nout, 'G01EBF/MAT2CR')
            ntext = ntext + 1
            write (text(ntext),1400)
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),1500) tp
            else
               d13(1) = showlj(tp) 
                write (text(ntext),1550) d13(1) 
            endif  
            ntext = ntext + 1
            if (ptp.le.pnt01) then
               siglev = high
            elseif (ptp.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),1600) ptp, siglev
         else
            write (line,1700)
            call putfat (line)
         endif
      endif
      if (useit(7)) then
c
c KS 2-sample test
c

         ifail = 1
         ntype = 1
         mx = n
         my = n
         call g08cdf$(mx, x, my, y, ntype, dks2, zks2, pks2, w(1),
     +                w(n + 1), ifail)
         if (ifail.eq.0) then
            ntext = ntext + 1
            write (text(ntext),1800)
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),1900) dks2
            else
               d13(1) = showlj(dks2) 
               write (text(ntext),1950) d13(1)
            endif  
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),2000) zks2
            else
               d13(2) = showlj(zks2)
               write (text(ntext),2050) d13(2)
            endif 
            ntext = ntext + 1
            if (pks2.le.pnt01) then
               siglev = high
            elseif (pks2.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),2100) pks2, siglev
         else
            call putifa (ifail, nout, 'G08CDF/MAT2CR')
         endif
      endif
      if (useit(8)) then
c
c MWU test
c
         ifail = 1
         mx = n
         my = n
         call g08ahf$(mx, x, my, y, 'T', u, unor, pu, ties, w(1),
     +                w(2*n + 1), ifail)
         if (ifail.eq.0) then
            if (n.le.ntop) then
               if (ties) then
                  ntest = n + 2*n*n*(n + 1) - n*(n + 1)*(2*n + 1)/3 + 2
                  lwrk  = nwork - 2*n
                  if (lwrk.ge.ntest) then
                     mx = n
                     my = n
                     call g08akf$(mx, my, 'T', w(1), u, pu, w(2*n + 1),
     +                            lwrk, iwrk, ifail)
                  else
                     lwrk = ntest
                     ierr = 0
                     if (allocated(wrk)) deallocate(wrk, stat = ierr)
                     if (ierr.ne.0) return
                     allocate(wrk(lwrk), stat = ierr)
                     if (ierr.ne.0) return
                     mx = n
                     my = n
                     call g08akf$(mx, my, 'T', w, u, pu, wrk, lwrk,
     +                            iwrk, ifail)
                     deallocate(wrk, stat = ierr)
                  endif
                  call putifa (ifail, nout, 'G08AKF/MAT2CR')
               else
                  ntest = n*n + 1
                  if (nwork.ge.ntest) then
                     mx = n
                     my = n
                     call g08ajf$(mx, my, 'T', u, pu, w, nwork, ifail)
                  else
                     lwrk = ntest
                     ierr = 0
                     if (allocated(wrk)) deallocate(wrk, stat = ierr)
                     if (ierr.ne.0) return
                     allocate(wrk(lwrk), stat = ierr)
                     if (ierr.ne.0) return
                     mx = n
                     my = n
                     call g08ajf$(mx, my, 'T', u, pu, wrk, lwrk, ifail)
                     deallocate(wrk, stat = ierr)
                  endif
                  call putifa (ifail, nout, 'G08AJF/MAT2CR')
               endif
            endif
            if (ifail.eq.0) then
                ntext = ntext + 1
                write (text(ntext),2200)
                ntext = ntext + 1
                if (e_numbers) then
                   write (text(ntext),2300) u
                else
                   d13(1) = showlj(u)
                   write (text(ntext),2350) d13(1) 
                endif  
                ntext = ntext + 1
                if (e_numbers) then
                   write (text(ntext),2400) unor
                else
                   d13(2) = showlj(unor)
                   write (text(ntext),2450) d13(2)
                endif 
                ntext = ntext + 1
               if (pu.le.pnt01) then
                  siglev = high
               elseif (pu.le.pnt05) then
                  siglev = low
               else
                  siglev = notsig
               endif
               write (text(ntext),2500) pu, siglev
            endif
         else
            call putifa (ifail, nout, 'G08AHF/MAT2CR')
         endif
      endif
      if (useit(9)) then
c
c useit(9): Wilcoxon signed rank test
c
         do i = 1, n
            w(i) = x(i) - y(i)
         enddo
         ifail = 1
         call g08agf$(n, w(1), zero, 'T', 'Y', wx, wnor, pw, i,
     +                w(n + 1), ifail)
         if (ifail.eq.0) then
            ntext = ntext + 1
            write (text(ntext),2600)
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),2700) wx
            else
               d13(1) = showlj(wx) 
               write (text(ntext),2750) d13(1)
            endif  
            ntext = ntext + 1
            if (e_numbers) then
               write (text(ntext),2800) wnor
            else
               d13(2) = showlj(wnor)
               write (text(ntext),2850) d13(2)
            endif   
            ntext = ntext + 1
            if (pw.le.pnt01) then
               siglev = high
            elseif (pw.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),2900) pw, siglev
         else
            call putifa (ifail, nout, 'G08AGF/MAT2CR')
         endif
      endif
      if (useit(10)) then
c
c useit(10): run test
c
         do i = 1, n
            w(i) = x(i) - y(i)
         enddo
         i = 1
         call probrs (i, nout, nneg, npos, n, nrun, nr1, nr5,
     +                probr, probs, probt, w)
         if (nneg.gt.0 .or. npos.gt.0) then
            ntext = ntext + 1
            write (text(ntext),3000)
            ntext = ntext + 1
            write (text(ntext),3100) npos
            ntext = ntext + 1
            write (text(ntext),3200) nneg
            ntext = ntext + 1
            if (probr.le.pnt01) then
               siglev = high
            elseif (probr.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),3300) probr, siglev
         endif
      endif
      if (useit(11)) then
c
c sign test
c
         ifail = 1
         call g08aaf$(x, y, n, is, n1, ps, ifail)
         if (ifail.eq.0) then
            ps = two*min(ps, one - ps)
            ntext = ntext + 1
            write (text(ntext),3400)
            ntext = ntext + 1
            write (text(ntext),3500) n1
            ntext = ntext + 1
            write (text(ntext),3600) is
            ntext = ntext + 1
            if (ps.le.pnt01) then
               siglev = high
            elseif (ps.le.pnt05) then
               siglev = low
            else
               siglev = notsig
            endif
            write (text(ntext),3700) ps, siglev
         else
            call putifa (ifail, nout, 'G08AAF/MAT2CR')
         endif
      endif 
      if (useit(12)) then
c
c dot product
c            
         call dotprd (n,
     +                cos_theta, distance, dot, theta_deg, theta_rad,
     +                x, xl, y, yl,
     +                text2,
     +                abort)
         if (.not.abort) then
            ntext = ntext + 1
            text(ntext) = text2(1)
            ntext = ntext + 1
            text(ntext) = text2(2)
         endif         
      endif
c
c table of results
c
      if (ntext.gt.0) then
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, ntext
            if (i.eq.1) then
               icolor = 4
               call table1 (icolor, text(i))
            elseif (i.eq.2) then
               icolor = 1
               call table1 (icolor, text(i))
            else
               icolor = 0
               call table1 (icolor, text(i))
               write (nout,'(a)') text(i)
            endif
         enddo
         call table1 (icolor, 'CLOSE')
      endif   
c
c deallocate
c           
      deallocate(iwrk, stat = ierr)    
      deallocate(w, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c      
  100 format (a,1x,'out of range in call to MAT2CR')
  200 format (
     + 'Change X-assignment: current X = column/row',i6
     +/'Change Y-assignment: current Y = column/row',i6
     +/'Simple X,Y plot'
     +/'Regression/Correlation'
     +/'Unpaired t test'
     +/'Paired t test'
     +/'Kolmogorov-Smirnov 2-sample test'
     +/'Mann-Whitney U test'
     +/'Wilcoxon signed rank test'
     +/'Run test'
     +/'Sign test'  
     +/'Dot product, sizes, and angles'
     +/'Analyse columns (otherwise rows)')
  300 format ('Insufficient data or work space for analysis')
  400 format (a,1x,'number required for X')
  500 format (a,1x,'number required for Y')
  600 format ('Cannot analyse two identical rows/columns')
  700 format ('Column',1x,a)
  800 format ('Row',1x,a)
  900 format (
     + 'Analyis and two-tail tests for:'
     +/'N =',1x,a,'X =',1x,a,1x,a,'Y =',1x,a,1x,a)
     
 1000 format ('Unpaired t test:')
 1100 format ('t =',1p,e13.5)
 1150 format ('t =',1x,a)
 1200 format ('p =',F9.5,4x,a)
 1300 format ('Data too limited for an unpaired t test')
 
 1400 format ('Paired t test:')
 1500 format ('t =',1p,e13.5)
 1550 format ('t =',1x,a)
 1600 format ('p =',F9.5,4x,a)
 1700 format ('Data too limited for a paired t test')
 
 1800 format ('Kolmogorov-Smirnov 2-sample test:')
 1900 format ('d =',1p,e13.5)
 1950 format ('d =',1x,a)
 2000 format ('z =',1p,e13.5)
 2050 format ('z =',1x,a)
 2100 format ('p =',F9.5,4x,a)
 
 2200 format ('Mann-Whitney U test:')
 2300 format ('u =',1p,e13.5)
 2350 format ('u =',1x,a)
 2400 format ('z =',1p,e13.5)
 2450 format ('z =',1x,a)
 2500 format ('p =',F9.5,4x,a)
 
 2600 format ('Wilcoxon signed rank test:')
 2700 format ('w =',1p,e13.5)
 2750 format ('w =',1x,a)
 2800 format ('z =',1p,e13.5)
 2850 format ('z =',1x,a)
 2900 format ('p =',F9.5,4x,a)
 
 3000 format ('Run test:')
 3100 format ('+ =',i8,4x,'(number of x > y)')
 3200 format ('- =',i8,4x,'(number of x < y)')
 3300 format ('p =',F9.5,4x,a)
 3400 format ('Sign test:')
 3500 format ('N =',i8,4x,'(non-tied pairs)')
 3600 format ('- =',i8,4x,'(number of x < y)')
 3700 format ('p =',F9.5,4x,a)
      end
c
c

   
  