C
C
      SUBROUTINE MATEXH (NCMAX, NCOL, NF, NIN, NROW, NRMAX, NSMALL,
     +                   A,  
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   SUPPLY)
C
C ACTION: exhaustive analysis of an arbitrary matrix
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         Derived from XYCORR 05/08/99
C         08/08/1999 added VECCHK and VECCPY
C         04/06/2001 added call to BCPLOT$
C         18/08/2001 added N100, W, Z1, Z2, UNUSED for SURFAC$
C         18/12/2001 added BWPLOT$ and PATCH1
C         30/01/2002 added NCOL and NROW to argument list and STATMT
C         21/04/2002 added EBPLOT$
C         28/04/2002 added GKS001 and GKS012
C         09/09/2003 added SPHER1, HOTEL1 and Z to argument list
C         17/10/2003 removed SPHER1, HOTEL1, EDITOR, Z
C         28/05/2004 added MAT2CR and increased dimensions for W
C         03/05/2005 added MTPLOT and made FILEIT an array
C         06/01/2006 removed N100, W3, W4, W5, Z1, Z2, UNUSED from
C                    argument list and introduced deferred shape arrays
C         06/02/2006 added SUPPLY and NRMAX to argument list
C         21/06/2006 ISIZE to JSIZE in loop to define box and whisker labels
C                    and added WK as allocatable for boxes and whiskers
C         27/07/2006 corrected CV calculation for NCOL > NROW 
C         28/07/2006 corrected arguments to MAT2CR 
C         20/09/2006 replaced MTPLOT by MATPLT 
C         07/03/2007 changed argument list for MAT2CR
C         02/02/2008 added call to SBPLOT
C         10/08/2008 added call to GETWRD for LABELS
C         09/04/2009 deleted LIW and LWRK from argument list 
C         16/04/2009 deleted Y, B, W, W1, W2, NMAX, and X from argument list
C         06/05/2011 added calls to FORM12 and replaced DSPLAY by CORCOV
C         21/03/2012 replaced EBPLOT$, BWPLOT$, SBPLOT$ and BCPLOT$ by EBPLOT, BWPLOT, SBPLOT and BWPLOT
C         05/05/2016 increased formats 500/600 to 6 significant figures
C         28/06/2021 introduced e_numbers and e_formats, etc.
C
C  NCMAX: (input/unchanged) max. columns
C   NCOL: returned as no. columns if successful
C     NF: (input/unchanged) preconnected unit for results
C    NIN: (input/unchanged) unconnected unit for data input
C   NROW: returned as no. rows if successful
C  NRMAX: (input/unchanged) leading dimension of matrix
C NSMALL: (input/unchanged) max. no. of files referenced by a library file
C      A: depends on SUPPLY: returned as the matrix if successful
C
C FNAME, FSAV, TITLE, TSAV: workspaces (except that the current names and
C                           titles are returned if successful)
C SUPPLY: (input/unchanged) if .TRUE. then the matrix, title, dimensions, etc.
C                           are supplied and returned unchanged
C

      IMPLICIT NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NRMAX,
     +                                       NSMALL
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NSMALL),
     +                                       TITLE, TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Deferred shape local arrays
C
      INTEGER,              ALLOCATABLE :: NOBS(:)
      DOUBLE PRECISION,     ALLOCATABLE :: B(:), W(:), W1(:), W2(:),
     +                                     X(:)
      DOUBLE PRECISION ,    ALLOCATABLE :: XX(:), YY(:), VECTOR(:),
     +                                     WK(:), Z1(:,:), Z2(:,:)
      CHARACTER (LEN = 20), ALLOCATABLE :: LABELS(:)
      LOGICAL,              ALLOCATABLE :: UNUSED(:,:)
C
C Other locals
C
      INTEGER    I, I1, I2, I3, I4
      INTEGER    IERR, IFAIL, ISEND, J, JCOLOR, JSEND, K, NPDF
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT, NUMOPT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 4,
     +           NUMOPT = 21)
      INTEGER    MAXPLT, N0, N1, N2, N3, N4, N5, N100, NSQDP6
      PARAMETER (MAXPLT = 300, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N100 = 100, NSQDP6 = N100**2 + 6)
      INTEGER    NSET, NVEC
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    ICOUNT, ISIZE, JSIZE, MODEL, NTYPE, NX, NY
      INTEGER    KCMAX, KRMAX, KTOTAL, K1, K2, K3, K4, K5, K6, K7, K8,
     +           K9, K10, K11, K12
      PARAMETER (KCMAX = 100, KRMAX = 12, KTOTAL = KCMAX*KRMAX,
     +           K1 = 1,            K2 = KRMAX + 1,    K3 = 2*KRMAX + 1,
     +           K4 = 3*KRMAX + 1,  K5 = 4*KRMAX + 1,  K6 = 5*KRMAX + 1,
     +           K7 = 6*KRMAX + 1,  K8 = 7*KRMAX + 1,  K9 = 8*KRMAX + 1,
     +           K10 = 9*KRMAX + 1, K11 = 10*KRMAX + 1,
     +           K12 = 11*KRMAX + 1)
      INTEGER    LL(KRMAX), MM(KRMAX), NN(KRMAX)
      INTEGER    LEN200, L_ISIZE, L_JSIZE
      DOUBLE PRECISION ABSX, EPSI, F100, ZERO, ONE
      PARAMETER (EPSI = 1.0D-100, F100 = 100.0D+00, ZERO = 0.0D+00,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION CV, DNM1, STDEV, XBAR, XVAR
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      CHARACTER (LEN = 13) D13(4), SHOWRJ
      CHARACTER (LEN = 12) FORM12, WORD12_ISIZE, WORD12_JSIZE
      
      CHARACTER  CIPHER*10, LINE*100, TEXT(30)*100, MSSAGE*4, MTYPE*20
      CHARACTER  PCENT*10, UNDEF*10
      PARAMETER (PCENT = '%         ', UNDEF = ' Undefined')
      CHARACTER  TITLES(4)*20
      CHARACTER  CHOP80*80, WORD80*80
      CHARACTER  DUMMY*1, BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    LOOP1, LOOP2, LOWER_TRIANGLE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FILEIT(3)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   PUTFAT, GETIM1, GETNOU, VECEXH, NXXBAR, LBOX01, TABLE1,
     +           PUTIFA, PATCH1, STATMT, CHOP80, REVPRO, MAT2CR, PUTADV,
     +           MATPLT, PUTWAR, GETWRD, FORM12, CORCOV, LEN200
      EXTERNAL   G02BAF$
      EXTERNAL   BCPLOT, SURFAC, BWPLOT, GKS001, EBPLOT, GKS012, 
     +           SBPLOT
      EXTERNAL   E_FORMATS, SHOWRJ
      INTRINSIC  SQRT, ABS, DBLE
      SAVE       ICOUNT, LOWER_TRIANGLE
      DATA       ICOUNT / 0 /
      DATA       LOWER_TRIANGLE / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check if parameters supplied are OK
C
      IF (SUPPLY) THEN
         IF (NCOL.LT.N2 .OR. NROW.LT.N2 .OR.
     +       NCOL.GT.NCMAX .OR. NROW.GT.NRMAX) THEN
             WRITE (LINE,100)
             CALL PUTFAT (LINE)
            RETURN
         ENDIF
         DO I = N1, N3
            FILEIT(I) = .TRUE.
         ENDDO
      ELSE
         NCOL = N0
         NROW = N0   
      ENDIF
C
C Check that the deferred shape arrays are not allocated
C
      IERR = N0
      
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR)
      IF (IERR.NE.N0) RETURN      
      IF (ALLOCATED(W2)) DEALLOCATE(W2, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN
        
      IF (ALLOCATED(NOBS)) DEALLOCATE(NOBS, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(VECTOR)) DEALLOCATE(VECTOR, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(WK)) DEALLOCATE(WK, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(VECTOR)) DEALLOCATE(XX, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(VECTOR)) DEALLOCATE(YY, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Z1)) DEALLOCATE(Z1, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Z2)) DEALLOCATE(Z2, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(LABELS)) DEALLOCATE(LABELS, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(UNUSED)) DEALLOCATE(UNUSED, STAT = IERR)
      IF (IERR.NE.N0) RETURN

C
C LOOP1: Main menu
C =====
C
      E_NUMBERS = E_FORMATS()
      NDEC = NOPT - N1
      LOOP1 = .TRUE.
      DO WHILE (LOOP1)
C
C Start of LOOP 1.......................................................
C
      IF (SUPPLY) THEN
         NDEC = N2
         WORD80 = CHOP80(TITLE)
      ELSE
         IF (NCOL.GT.N0 .AND. NROW.GT.N0) THEN
            MSSAGE = '    '
            WORD80 = CHOP80(TITLE)
         ELSE
            MSSAGE = '(NA)'
            WORD80 = 'No data'
         ENDIF
         
         WRITE (TEXT,200) WORD80, MSSAGE
         NSTART = 6
         NUMTXT = NSTART + NOPT - 1
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         NDEC = NOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
       ENDIF
C
C Check that DATA are ready if 2 selected
C
      IF (NDEC.EQ.N2) THEN
         IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
            CALL PUTFAT ('First input your current data')
            NDEC = N0
         ELSEIF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
            CALL PUTFAT ('Must have at least 2 rows and 2 columns')
            NDEC = N0
         ENDIF
      ENDIF
C
C Read in data
C
      IF (NDEC.EQ.1) THEN
C
C Data input ... requires allocation of B and X
C
         IF (SUPPLY) THEN
            RETURN
         ELSE
           
            ALLOCATE(B(NRMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(X(NRMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN  
              
            CALL STATMT (NCMAX, NCOL, NF, NIN, NRMAX, NROW, NSMALL,
     +                   A, B, X,
     +                   FNAME, FSAV, TITLE, TSAV)
     
            DEALLOCATE(B, STAT = IERR)
            DEALLOCATE(X, STAT = IERR)
            
            WORD80 = CHOP80(TITLE)
            IF (NCOL.GT.N0 .AND. NROW.GT.N0) THEN
               DO I = N1, N3
                  FILEIT(I) = .TRUE.
               ENDDO
               NDEC = N2
            ELSE
               NDEC = N1
            ENDIF
         ENDIF
      ELSEIF (NDEC.EQ.2) THEN
C
C Analysis of data ... 
C
         ISIZE = NROW
         JSIZE = NCOL
         ICOUNT = ICOUNT + N1
         WRITE (NF,300) ICOUNT, TITLE
C
C LOOP 2: Main loop for repeated analysis of the data selected
C =======
C
         LOOP2 = .TRUE.
         DO WHILE (LOOP2)
C
C Start of LOOP 2.......................................................
C
         NSTART = N5
         NUMTXT = NUMOPT + NSTART - N1
         WORD12_ISIZE = FORM12(ISIZE)
         WORD12_JSIZE = FORM12(JSIZE)
         L_ISIZE = LEN200(WORD12_ISIZE)
         L_JSIZE = LEN200(WORD12_JSIZE)
         IF (LOWER_TRIANGLE) THEN
            MTYPE = '(Lower Triangle)'
         ELSE
            MTYPE = '(Full matrix)'
         ENDIF   
         WRITE (TEXT,400) WORD12_ISIZE(1:L_ISIZE),
     +                    WORD12_JSIZE(1:L_JSIZE), MTYPE, MTYPE, MTYPE
         NDEC = NUMOPT - N1
         NUMBLD(1) = N4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Row summary ... requires allocation of B
C
            ALLOCATE(B(JSIZE), STAT = IERR)
            IF (IERR.NE.N0) RETURN
              
            JCOLOR = 15
            CALL TABLE1 (JCOLOR, 'OPEN')
            WRITE (NF,500) '   Row'
            WRITE (LINE,500) '   Row'
            JCOLOR = N4
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = N0
            DO I = N1, ISIZE
               DO J = N1, JSIZE
                  B(J) = A(I,J)
               ENDDO
               CALL NXXBAR (JSIZE,
     +                      B, XBAR, XVAR)
               STDEV = SQRT(XVAR)
               ABSX = ABS(XBAR)
               IF (ABSX.GT.EPSI) THEN
                  CV = F100*STDEV/ABSX
                  CIPHER = PCENT
               ELSE
                  CV = ZERO
                  CIPHER = UNDEF
               ENDIF
               IF (E_NUMBERS) THEN
                  WRITE (NF,600) I, XBAR, XVAR, STDEV, CV, CIPHER
                  WRITE (LINE,600) I, XBAR, XVAR, STDEV, CV, CIPHER
               ELSE
                  D13(1) = SHOWRJ(XBAR)
                  D13(2) = SHOWRJ(XVAR)
                  D13(3) = SHOWRJ(STDEV)
                  WRITE (NF,650) I, D13(1), D13(2), D13(3), CV, CIPHER
                  WRITE (LINE,650) I, D13(1), D13(2), D13(3), CV, CIPHER 
               ENDIF  
               CALL TABLE1 (JCOLOR, LINE)
            ENDDO
            CALL TABLE1 (JCOLOR, 'CLOSE')
            
            DEALLOCATE(B, STAT = IERR)
            
         ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Column summary ... requires allocation of B
C
            ALLOCATE(B(ISIZE), STAT = IERR)
            IF (IERR.NE.N0) RETURN
              
            JCOLOR = 15
            CALL TABLE1 (JCOLOR, 'OPEN')
            WRITE (NF,500) 'Column'
            WRITE (LINE,500) 'Column'
            JCOLOR = 4
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = N0
            DO I = N1, JSIZE
               DO J = N1, ISIZE
                  B(J) = A(J,I)
               ENDDO
               CALL NXXBAR (ISIZE,
     +                      B, XBAR, XVAR)
               STDEV = SQRT(XVAR)
               ABSX = ABS(XBAR)
               IF (ABSX.GT.EPSI) THEN
                  CV = F100*STDEV/ABSX
                  CIPHER = PCENT
               ELSE
                  CV = ZERO
                  CIPHER = UNDEF
               ENDIF
               IF (E_NUMBERS) THEN
                  WRITE (NF,600) I, XBAR, XVAR, STDEV, CV, CIPHER
                  WRITE (LINE,600) I, XBAR, XVAR, STDEV, CV, CIPHER
               ELSE
                  D13(1) = SHOWRJ(XBAR)
                  D13(2) = SHOWRJ(XVAR)
                  D13(3) = SHOWRJ(STDEV)
                  WRITE (NF,650) I, D13(1), D13(2), D13(3), CV, CIPHER
                  WRITE (LINE,650) I, D13(1), D13(2), D13(3), CV, CIPHER 
               ENDIF 
               CALL TABLE1 (JCOLOR, LINE)
            ENDDO
            CALL TABLE1 (JCOLOR, 'CLOSE')

            DEALLOCATE(B, STAT = IERR)
            
         ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Selected row ... requires allocation of B
C
            ALLOCATE(B(JSIZE), STAT = IERR)
            IF (IERR.NE.N0) RETURN
              
            I = N0
            CALL GETIM1 (I, J, ISIZE, ' Row selected (0 to cancel)')
            IF (J.GT.N0) THEN
               WRITE (LINE,700) 'row number', J
               DO I = N1, JSIZE
                  B(I) = A(J,I)
               ENDDO
               CALL GETNOU (NPDF)
               CLOSE (NPDF)
               ISEND = N0
               DUMMY = BLANK
               CALL VECEXH (ISEND, NPDF, NIN, JSIZE, NF,
     +                      JSIZE,
     +                      B, 
     +                      DUMMY, LINE,
     +                      FILEIT)
               CLOSE (NPDF)
            ENDIF

            DEALLOCATE(B, STAT = IERR)
            
         ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: Selected column ... requires allocation of B
C
            ALLOCATE(B(ISIZE), STAT = IERR)
            IF (IERR.NE.N0) RETURN
              
            I = N0
            CALL GETIM1 (I, J, JSIZE, ' Column selected (0 to cancel)')
            IF (J.GT.N0) THEN
               WRITE (LINE,700) 'column number', J
               DO I = N1, ISIZE
                  B(I) = A(I,J)
               ENDDO
               CALL GETNOU (NPDF)
               CLOSE (NPDF)
               ISEND = N0
               DUMMY = BLANK
               CALL VECEXH (ISEND, NPDF, NIN, ISIZE, NF,
     +                      ISIZE,
     +                      B, 
     +                      DUMMY, LINE,
     +                      FILEIT)
               CLOSE (NPDF)
            ENDIF
            
            DEALLOCATE(B, STAT = IERR)
            
         ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: Two rows
C
            CALL MAT2CR (N2, JSIZE, NF, NRMAX, ISIZE,
     +                   A)
         ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: Two columns
C
            CALL MAT2CR (N1, JSIZE, NF, NRMAX, ISIZE,
     +                   A)
         ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: Plot as a bar chart ... requires allocation of LABELS
C
            IF (ISIZE.LE.MAXPLT .AND. JSIZE.LE.20) THEN
C
C NOTE: 'Bar Chart' will be the plot title and is arbitrary
C
               ALLOCATE(LABELS(ISIZE), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  TITLES(1) = 'Bar Chart'
                  TITLES(2) = 'Rows'
                  TITLES(3) = 'Columns'
                  TITLES(4) = ' '
                  ISEND = N1
                  CALL GETWRD (ISEND, JSIZE, NIN, ISIZE, ISIZE,
     +                         FNAME, LABELS) 
                  ISEND = N2
                  CALL BCPLOT (ISEND, JSIZE, NRMAX, ISIZE,
     +                         A,
     +                         LABELS, TITLES)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE(LABELS, STAT = IERR)
               
            ELSE
               CALL PUTFAT ('Matrix is too large for a bar chart')
            ENDIF
         ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: Plot as a stacked bar chart ... requires allocation of LABELS
C
            IF (ISIZE.LE.MAXPLT .AND. JSIZE.LE.20) THEN
C
C NOTE: 'Bar Chart' will be the plot title and is arbitrary
C
               ALLOCATE(LABELS(ISIZE), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  TITLES(1) = 'Stacked Bar Chart'
                  TITLES(2) = 'Rows'
                  TITLES(3) = 'Columns'
                  TITLES(4) = ' '
                  ISEND = N1
                  CALL GETWRD (ISEND, JSIZE, NIN, ISIZE, ISIZE,
     +                         FNAME, LABELS)                  
                  ISEND = N2
                  CALL SBPLOT (ISEND, JSIZE, NRMAX, ISIZE,
     +                         A,
     +                         LABELS, TITLES)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE(LABELS, STAT = IERR)
            ELSE
               CALL PUTFAT ('Matrix too large for a stacked barchart')
            ENDIF   
         ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: Plot as a box and whisker plot ... requires allocataion of NOBS, WK, and LABELS
C
            IF (JSIZE.LE.MAXPLT) THEN
C
C NOTE: 'Box and Whisker Plot' is the plot title and is not arbitrary
C
               ALLOCATE(NOBS(MAXPLT), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(WK(NCOL*NROW), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               JSEND = ISIZE + JSIZE  
               ALLOCATE(LABELS(JSEND), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  TITLES(1) = 'Box and Whisker Plot'
                  TITLES(2) = 'Columns'
                  TITLES(3) = 'Medians'
                  TITLES(4) = ' '
                  ISEND = N3
                  CALL GETWRD (ISEND, JSIZE, NIN, ISIZE, JSEND,
     +                         FNAME, LABELS)                  
                  NVEC = N0
                  NSET = JSIZE
                  DO J = N1, NSET
                     NOBS(J) = ISIZE
                     DO I = N1, ISIZE
                        NVEC = NVEC + N1
                        WK(NVEC) = A(I,J)
                     ENDDO
                  ENDDO
                  ISEND = N2
                  JSEND = ISIZE + N1
                  CALL BWPLOT (ISEND, NOBS, NSET, NVEC,
     +                         WK,
     +                         LABELS(JSEND), TITLES)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE(NOBS, STAT = IERR)
               DEALLOCATE(WK, STAT = IERR)
               DEALLOCATE(LABELS, STAT = IERR)
               
            ELSE
               CALL PUTFAT ('Matrix is too large for a plot')
            ENDIF
         ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: Plot as a barchart with error bars .. requires allocation of NOBS, LABELS, and WK
C
            IF (JSIZE.LE.MAXPLT) THEN
C
C NOTE: 'Barchart & Errorbars' is the title required by GKSF2B$ to interpret
C        the data as a Barchart & Errorbars and MUST NOT be altered
C
               ALLOCATE(NOBS(MAXPLT), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               JSEND = ISIZE + JSIZE
               ALLOCATE(LABELS(JSEND), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(WK(NCOL*NROW), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  TITLES(1) = 'Barchart & Errorbars'
                  TITLES(2) = 'Columns'
                  TITLES(3) = 'Means'
                  TITLES(4) = ' '
                  ISEND = N3
                  CALL GETWRD (ISEND, JSIZE, NIN, ISIZE, JSEND,
     +                         FNAME, LABELS)                        
                  NVEC = N0
                  NSET = JSIZE
                  DO J = N1, NSET
                     NOBS(J) = ISIZE
                     DO I = N1, ISIZE
                        NVEC = NVEC + N1
                        WK(NVEC) = A(I,J)
                     ENDDO
                  ENDDO
                  ISEND = N2
                  JSEND = ISIZE + N1
                  CALL EBPLOT (ISEND, NOBS, NSET, NVEC,
     +                         WK,
     +                         LABELS(JSEND), TITLES)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE(NOBS, STAT = IERR)
               DEALLOCATE(WK, STAT = IERR)
               DEALLOCATE(LABELS, STAT = IERR)
               
            ELSE
               CALL PUTFAT ('Matrix is too large for a plot')
            ENDIF
         ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: Plot as a scatter plot ... requires allocation of B, and W
C
            IF (ISIZE*JSIZE.LE.KTOTAL) THEN
              
               I = ISIZE*JSIZE
               ALLOCATE(B(I), STAT = IERR)
               IF (IERR.NE.0) RETURN 
               ALLOCATE(W(I), STAT = IERR)
               IF (IERR.NE.0) RETURN
                    
               NVEC = N0
               DO J = N1, JSIZE
                  DO I = N1, ISIZE
                     NVEC = NVEC + N1
                     B(NVEC) = DBLE(J)
                     W(NVEC) = A(I,J)
                  ENDDO
               ENDDO
               CALL GKS001 (N0, N5, NVEC,
     +                      B, W,
     +                     'Scatter Plot', 'Columns', 'Values')

               DEALLOCATE(B, STAT = IERR)
               DEALLOCATE(W, STAT = IERR)
               
            ELSE
               CALL PUTFAT ('Matrix too large for scatter plot')
            ENDIF
         ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: Plot as a scatter plot with rows as symbols ... requires allocation of XX and YY
C
            IF (ISIZE.GT.KRMAX) THEN
               CALL PUTFAT ('Too many rows to plot')
            ELSEIF (JSIZE.GT.KCMAX) THEN
               CALL PUTFAT ('Too many columns to plot')
            ELSEIF (ISIZE*JSIZE.GT.KTOTAL) THEN
               CALL PUTFAT ('Matrix too large to plot')
            ELSE
              
               ALLOCATE (XX(KTOTAL), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(YY(KTOTAL), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  J = - KRMAX
                  DO I = N1, KRMAX
                     IF (I.LE.ISIZE) THEN
                        J = J + KRMAX
                        LL(I) = N3
                        MM(I) = N4 + I
                        NN(I) = JSIZE
                        DO K = N1, JSIZE
                           XX(J + K) = DBLE(K)
                           YY(J + K) = A(I,K)
                        ENDDO
                     ELSE
                        LL(I) = N0
                        MM(I) = N0
                        NN(I) = N0
                     ENDIF
                  ENDDO
                  CALL GKS012 (
     +LL(1), LL(2), LL(3), LL(4),  LL(5),  LL(6),
     +LL(7), LL(8), LL(9), LL(10), LL(11), LL(12),
     +MM(1), MM(2), MM(3), MM(4),  MM(5),  MM(6),
     +MM(7), MM(8), MM(9), MM(10), MM(11), MM(12),
     +NN(1), NN(2), NN(3), NN(4),  NN(5),  NN(6),
     +NN(7), NN(8), NN(9), NN(10), NN(11), NN(12),
     +XX(K1), XX(K2), XX(K3), XX(K4),  XX(K5),  XX(K6),
     +XX(K7), XX(K8), XX(K9), XX(K10), XX(K11), XX(K12),
     +YY(K1), YY(K2), YY(K3), YY(K4) , YY(K5),  YY(K6),
     +YY(K7), YY(K8), YY(K9), YY(K10), YY(K11), YY(K12),
     +                        'Scatter Plot', 'Columns', 'Values',
     +                         AXES, GSAVE)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE (XX, STAT = IERR)
               DEALLOCATE (YY, STAT = IERR)
               
            ENDIF
         ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: Plot as a 3-D barchart ... requires allocation of B, VECTOR, W, W1, Z1, Z2, UNUSED
C
            IF (ISIZE.LE.N100 .AND. JSIZE.LE.N100) THEN

C
C Initialise counters to partition W
C
               I1 = N1
               I2 = I1 + N100
               I3 = I2 + N100
               I4 = I3 + N100
              
               ALLOCATE(B(N100), STAT = IERR) 
               IF (IERR.NE.N0) RETURN
               ALLOCATE(VECTOR(NSQDP6), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               I = N4*N100
               ALLOCATE(W(I), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(W1(N100), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(Z1(N100,N100), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(Z2(N100,N100), STAT = IERR)
               IF (IERR.NE.N0) RETURN
               ALLOCATE(UNUSED(N100,N100), STAT = IERR)
               
               IF (IERR.EQ.N0) THEN
                  ISEND = N4
                  MODEL = N1
                  NX = ISIZE
                  NY = JSIZE
                  XMIN = ONE
                  XMAX = DBLE(NX)
                  YMIN = ONE
                  YMAX = DBLE(NY)
                  DO J = N1, NY
                     DO I = N1, NX
                        Z1(I,J) = A(I,J)
                     ENDDO
                  ENDDO
                  CALL SURFAC (ISEND, MODEL, N100, NX, NY,
     +                         VECTOR, W(I1), XMAX, XMIN, W(I2), W(I3),
     +                         W(I4), YMAX, YMIN, W1, B, Z1, Z2,
     +                         UNUSED)
               ELSE
                  RETURN
               ENDIF
               
               DEALLOCATE(B, STAT = IERR)
               DEALLOCATE(VECTOR, STAT = IERR)
               DEALLOCATE(W, STAT = IERR)
               DEALLOCATE(W1, STAT = IERR)
               DEALLOCATE(Z1, STAT = IERR)
               DEALLOCATE(Z2, STAT = IERR)
               DEALLOCATE(UNUSED, STAT = IERR)
               
            ELSE
               CALL PUTFAT ('Matrix is too large for a bar chart')
            ENDIF
         ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: Arbitrary plot
C
            CALL MATPLT (N4, NCMAX, NCOL, NF, NRMAX, NROW,
     +                   A)
         ELSEIF (NDEC.GE.15 .AND. NDEC.LE.17) THEN
C
C NDEC = 15: Sums of squares matrix, etc. ... requires allocation of W1, W2, Z1, Z2
C
            
            ALLOCATE(Z1(NCOL,NCOL), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(Z2(NCOL,NCOL), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(W1(NCOL), STAT = IERR)
            IF (IERR.NE.N0) RETURN 
            ALLOCATE(W2(NCOL), STAT = IERR)
              
            IF (IERR.EQ.N0) THEN
               IF (NCOL.GE.NROW) CALL PUTWAR ('No. columns >= no. rows')
               IFAIL = N1
               CALL G02BAF$(ISIZE, JSIZE, A, NRMAX, W1, W2, Z1, NCOL,
     +                      Z2, NCOL, IFAIL)
               IF (IFAIL.NE.0) THEN
                  CALL PUTIFA (IFAIL, NF, 'G02BAF/MATEXH')
               ELSE
                  WRITE (NF,'(A)') '***'
                  WRITE (NF,'(A)') BLANK
                  IF (NDEC.EQ.15) THEN
                     LINE = 'Sums of squares and cross products'
                     NTYPE = N1
                     IF (LOWER_TRIANGLE) NTYPE = - NTYPE
                     CALL CORCOV (NTYPE, NCOL, NCOL, NF,
     +                            Z1,
     +                            LINE,
     +                            FILEIT(1))    
                     FILEIT(1) = .FALSE.
                  ELSEIF (NDEC.EQ.16) THEN
                     DNM1 = DBLE(ISIZE - 1)
                     DO J = N1, JSIZE
                        DO I = N1, JSIZE
                           Z1(I,J) = Z1(I,J)/DNM1
                        ENDDO
                     ENDDO
                     LINE = 'Variance-Covariance matrix'
                     NTYPE = N1
                     IF (LOWER_TRIANGLE) NTYPE = - NTYPE
                     CALL CORCOV (NTYPE, NCOL, NCOL, NF,
     +                            Z1,
     +                            LINE,
     +                            FILEIT(2))                    
                     FILEIT(2) = .FALSE.
                  ELSEIF (NDEC.EQ.17) THEN
                     LINE = 'Pearson product-moment correlations'
                     NTYPE = N2
                     IF (LOWER_TRIANGLE) NTYPE = - NTYPE
                     CALL CORCOV (NTYPE, NCOL, NCOL, NF,
     +                            Z2,
     +                            LINE,
     +                            FILEIT(3))                   
                     FILEIT(3) = .FALSE.
                  ENDIF
                  
                  DEALLOCATE(Z1, STAT = IERR)
                  DEALLOCATE(Z2, STAT = IERR)
                  DEALLOCATE(W1, STAT = IERR)
                  DEALLOCATE(W2, STAT = IERR)
                  
               ENDIF
            ENDIF
         ELSEIF (NDEC.EQ.18) THEN
C
C NDEC = 18: change display type
C         
            LOWER_TRIANGLE = .NOT.LOWER_TRIANGLE 
            IF (LOWER_TRIANGLE) THEN
               CALL PUTADV (
     +'Only lower triangles will be displayed for symmetric matrices')
            ELSE
               CALL PUTADV (
     +'All rows and columns will be displayed for symmetric matrices')	  
            ENDIF
         ELSEIF (NDEC.EQ.NUMOPT - N2) THEN
C
C NDEC = NUMOPT - 2: Review progress
C
            CALL REVPRO (NF)
         ELSEIF (NDEC.EQ.NUMOPT - N1) THEN
C
C NDEC = NUMOPT - 1: Help
C
            WRITE (TEXT,800)
            NUMTXT = 20
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSE 
            IF (SUPPLY) THEN
               RETURN
            ELSE
               LOOP2 = .FALSE.
            ENDIF
         ENDIF
C
C End of LOOP 2.........................................................
C
         ENDDO
      ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NOPT - 1: Help
C
         WRITE (TEXT,800)
         NUMTXT = 20
         NUMBLD(1) = 1
         CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
         NUMBLD(1) = 0
      ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NOPT: Quit
C      
         LOOP1 = .FALSE.
      ENDIF
C
C End of LOOP 1.........................................................
C
      ENDDO
C
C Format statements
C      
  100 FORMAT ('Incorrect data supplied to MATEXH')
  200 FORMAT (
     + 'Exhaustive analysis: arbitrary matrix'
     +/
     +/'Title of current data:'
     +/A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse current data',2X,A
     +/'Help'
     +/'Quit ... Exit these data options')
  300 FORMAT (
     +/' Exhaustive analysis: arbitrary matrix',I4
     +/' -----------------------------------------'
     +/' Data: ',A)
  400 FORMAT (
     + 'Exhaustive analysis of a matrix'
     +/
     +/'Number of rows =',1X,A,', Number of columns =',1X,A
     +/
     +/'Summary (all rows)'
     +/'Summary (all columns)'
     +/'Analyse/test one row'
     +/'Analyse/test one column'
     +/'Analyse/paired-test two rows'
     +/'Analyse/paired-test two columns'
     +/'Plot 2D barchart (groups = rows)'
     +/'Plot 2D stack plot (groups = rows)'
     +/'Plot 2D boxes and whiskers'
     +/'Plot 2D bars and error bars'
     +/'Plot 2D scattergram (just one symbol) '
     +/'Plot 2D scattergram (lines and symbols)'
     +/'Plot 3D barchart/cylinder plot'
     +/'Plot 1D,2D,3D selected rows or columns'
     +/'Display/file SSQ-cross-products matrix',1X,A
     +/'Display/file Covariance matrix',1X,A
     +/'Display/file Correlation matrix',1X,A
     +/'Display/file Change format for symmetric matrices'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit exhaustive analysis of a matrix')
  500 FORMAT (1X,A6,9X,'Mean     Variance      St.Dev.     Coeff.Var.')
  600 FORMAT (I7,1P,3E13.5,0P,F14.2,A)
  650 FORMAT (I7,3(A13),F14.2,A)
  700 FORMAT ('Matrix ',A,I6)
  800 FORMAT (
     + 'Exhaustive analysis: arbitrary matrix (Summary statistics)'
     +/
     +/'This option is for the exploration of a data matrix having n'
     +/'rows (i.e. cases) and m columns (i.e. variables). For instance'
     +/'the means, standard deviations, and coefficients of variation'
     +/'can be calculated for all rows or all columns, or just single'
     +/'rows or columns can be selected for a more thorough analysis,'
     +/'including plotting histograms, etc.'
     +/
     +/'If the rows represent a sequence of measurements of the same'
     +/'variables as a function of some independent variable, such as'
     +/'time, etc. then a bar chart can be plotted with each row taken'
     +/'as a group, i.e., n groups, each with m objects.'
     +/'If the rows represent samples of size n measured at m settings'
     +/'of an independent variable, a box and whisker plot can be shown'
     +/'for the m sets of ranges, quartiles and medians. Alternatively,'
     +/'barcharts with errorbars, or scattered data, can be plotted.'
     +/'If the nm cells need to be visualised as a skyscraper plot then'
     +/'this can be done at a n by m grid of equally spaced points.'
     +/'Sample covariance or correlation matrices can be calculated.')
      END
C
C

  