c
c
      subroutine matmul (ncmaxa, ncmaxb, ncola, ncolb, nin, nout,
     +                   nrmaxa, nrmaxb, nrowa, nrowb,
     +                   a, b,
     +                   titlea, titleb,
     +                   newdat, supply)
c
c action: multiply two matrices or transposes
c author: w.g.bardsley, university of manchester, u.k., 01/04/2003
c         16/01/2006 made a, b, c, d allocatable
c         25/02/2006 extensive revision adding newdat and supply
c         02/08/2006 made newdat an array to allow for A or B renewal 
c         16/10/2006 edited, note: only c, d now allocatable  
c         20/05/2007 replaced dgemm by f06yaf$
c         06/08/2012 improved the interface and added lstbox and form12
c         07/08/2012 corrected call to display B
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmaxa, ncmaxb, nin, nout,
     +                                       nrmaxa, nrmaxb  
      integer,             intent (inout) :: ncola, ncolb, nrowa, nrowb
      double precision,    intent (inout) :: a(nrmaxa,ncmaxa),
     +                                       b(nrmaxb,ncmaxb)
      character (len = *), intent (inout) :: titlea, titleb
      logical,             intent (in)    :: supply
      logical,             intent (inout) :: newdat(2)
c
c local allocatable arrays
c
      double precision, allocatable :: c(:,:), d(:)
c
c locals
c
      integer    lda, ldb, ldc, ntext
      integer    lma, lmb, lna, lnb
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 13,
     +           numsta = 9, numtxt = numsta + numopt - 1)
      integer    numbld(30)
      integer    i, ierr, isend, k, m, n, ncol, nrow
      integer    ka, kb, ma, na, mb, nb
      integer    ntype
      parameter (ntype = 3)
      double precision alpha, beta
      parameter (alpha = 1.0d+00, beta = 0.0d+00)
      character (len = 12) form12, ma12, mb12, na12, nb12
      character (len = 80) chop80, ta80, tb80
      character  cipher(6)*60, fname*1024, text(30)*100, title*80,
     +           titlec*80
      character  transa*1, transb*1, line*100
      character  blank*1, ready*20
      parameter (blank = ' ', ready = '[* ready *]')
      logical    oka, okb, okc, repeet
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    abort
      logical    fileit, header, qtext, qtitle
      parameter (header = .true., qtext = .true.,
     +           qtitle = .true.)
      logical    border
      parameter (border = .false.)
      external   putfat, mattin, dsplay, matout, patch1, chop80,
     +           viewit, putadv, revpro, form12, lstbox
      external   f06yaf$
      intrinsic  max, len_trim
      data       numbld / 30*0 /
c
c check
c
      if (ncmaxa.lt.1 .or. ncmaxb.lt.1 .or.
     +    nrmaxa.lt.1 .or. nrmaxb.lt.1) return
      if (supply) then
         if (ncola.lt.1 .or. ncolb.lt.1 .or.
     +       nrowa.lt.1 .or. nrowb.lt.1) return
      endif
c
c initialise leading dimensions
c
      lda = nrmaxa
      ldb = nrmaxb
      ldc = max(ncmaxa, ncmaxb, nrmaxa, nrmaxb)
c
c allocate workspace
c
      ierr = 0
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      allocate(c(ldc,ldc), stat = ierr)
      if (ierr.ne.0) return
      allocate(d(ldc), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      newdat(1) = .false.
      newdat(2) = .false.
      do i = 1, 6
         cipher(i) = blank
      enddo
      fileit = .false.
      if (supply) then
         oka = .true.
         okb = .true.
         ma = nrowa
         na = ncola
         mb = nrowb
         nb = ncolb
         ma12 = form12(ma)
         mb12 = form12(mb)
         na12 = form12(na)
         nb12 = form12(nb)
         lma = len_trim(ma12)
         lmb = len_trim(mb12)
         lna = len_trim(na12)
         lnb = len_trim(nb12)
         write (cipher(1),100) ma12(1:lma), na12(1:lna)
         write (cipher(2),200) mb12(1:lmb), nb12(1:lnb)
      else
         oka = .false.
         okb = .false.
         ma = 0
         na = 0
         mb = 0
         nb = 0
         titlea = 'No current matrix A'
         titleb = 'No current matrix B'
      endif
      m = 0
      n = 0
      k = 0
      ncol = 0
      nrow = 0
      okc = .false.
      numdec = numopt - 1
c
c main loop
c
      ta80 = chop80(titlea)
      tb80 = chop80(titleb)
      repeet = .true.
      do while (repeet)
         write (text,300) cipher(1), ta80, cipher(2), tb80,
     +         (cipher(i), i = 3, 6)
         numbld(1) = 4
         numbld(4) = 1
         numbld(7) = 1
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = numopt - 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text) 
         numbld(1) = 0        
         numbld(4) = 0
         numbld(7) = 0
c
c check option chosen
c
         if (numdec.ge.1 .and. numdec.le.6) then
            okc = .false.
            do i = 3, 6
               cipher(i) = blank
            enddo
         endif
         if (numdec.ge.3 .and. numdec.le.8) then
            if (.not.oka) then
               call putfat ('First input matrix A')
               numdec = 0
            elseif (.not.okb) then
               call putfat ('First input matrix B')
               numdec = 0
            endif
         endif
         if (numdec.ge.7 .and. numdec.le.8 .and. .not.okc) then
            call putfat ('First calculate C')
            numdec = 0
         endif
         if (numdec.eq.1) then
c
c new matrix A
c
            if (supply) then
               newdat(1) = .true.
               newdat(2) = .false.
               deallocate(c, stat = ierr)
               deallocate(d, stat = ierr)
               return
            endif
            fileit = .false.
            okc = .false.
            isend = 3
            close (unit = nin)
            call mattin (isend, ncmaxa, na, nin, nrmaxa, ma,
     +                   a, d,
     +                   fname, titlea,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort) then
               numdec = 2
               oka = .true.
               ma12 = form12(ma)
               na12 = form12(na)
               lma = len_trim(ma12)
               lna = len_trim(na12)
               write (cipher(1),100) ma12(1:lma), na12(1:lna)
            else
               oka = .false.
               cipher(1) = blank
            endif
            ta80 = chop80(titlea)
         elseif (numdec.eq.2) then
c
c new matrix B
c
            if (supply) then
               newdat(1) = .false.
               newdat(2) = .true.
               deallocate(c, stat = ierr)
               deallocate(d, stat = ierr)
               return
            endif
            fileit = .false.
            okc = .false.
            isend = 3
            close (unit = nin)
            call mattin (isend, ncmaxb, nb, nin, nrmaxb, mb,
     +                   b, d,
     +                   fname, titleb,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort) then
               numdec = 3
               okb = .true.
               mb12 = form12(mb)
               nb12 = form12(nb)
               lmb = len_trim(mb12)
               lnb = len_trim(nb12)
               write (cipher(2),200) mb12(1:lmb), nb12(1:lnb)
            else
               okb = .false.
               cipher(2) = blank
            endif
            tb80 = chop80(titleb)
         elseif (numdec.eq.3) then
c
c C = A*B
c
            transa = 'N'
            transb = 'N'
            m = ma
            n = nb
            ka = na
            kb = mb
            if (ka.eq.kb) then
               numdec = numopt - 6
               k = ka
               cipher (3) = ready
               nrow = m
               ncol = n
               call f06yaf$(transa, transb, m, n, k, alpha, a, lda, b,
     +                      ldb, beta, c, ldc)
               okc = .true.
               titlec = 'C = A*B'
               write (line,400)
               call putadv (line)
               fileit = .true.
            else
               write (line,500)
               call putfat (line)
               fileit = .false.
               numdec = numopt - 1
               okc = .false.
               nrow = 0
               ncol = 0
            endif
         elseif (numdec.eq.4) then
c
c C = A^T*B
c
            transa = 'T'
            transb = 'N'
            m = na
            n = nb
            ka = ma
            kb = mb
            if (ka.eq.kb) then
               numdec = numopt - 6
               k = ka
               cipher (4) = ready
               nrow = m
               ncol = n
               call f06yaf$(transa, transb, m, n, k, alpha, a, lda, b,
     +                      ldb, beta, c, ldc)
               okc = .true.
               titlec = 'C = (A^T)*B'
               write (line,400)
               call putadv (line)
               fileit = .true.
            else
               write (line,500)
               call putfat (line)
               fileit = .false.
               nrow = 0
               ncol = 0
               numdec = numopt - 1
               okc = .false.
            endif
         elseif (numdec.eq.5) then
c
c C = A*B^T
c
            transa = 'N'
            transb = 'T'
            m = ma
            n = mb
            ka = na
            kb = nb
            if (ka.eq.kb) then
               numdec = numopt - 6
               k = ka
               cipher (5) = ready
               nrow = m
               ncol = n
               call f06yaf$(transa, transb, m, n, k, alpha, a, lda, b,
     +                      ldb, beta, c, ldc)
               okc = .true.
               titlec = 'C = A*(B^T)'
               write (line,400)
               call putadv (line)
               fileit = .true.
            else
               write (line,500)
               call putfat (line)
               fileit = .false.
               nrow = 0
               ncol = 0
               numdec = numopt - 1
               okc = .false.
            endif
         elseif (numdec.eq.6) then
c
c C = A^T*B^T
c
            transa = 'T'
            transb = 'T'
            m = na
            n = mb
            ka = ma
            kb = nb
            if (ka.eq.kb) then
               numdec = numopt - 6
               k = ka
               okc = .true.
               cipher (6) = ready
               nrow = m
               ncol = n
               call f06yaf$(transa, transb, m, n, k, alpha, a, lda, b,
     +                      ldb, beta, c, ldc)
               titlec = 'C = (A^T)*(B^T)'
               write (line,400)
               call putadv (line)
               fileit = .true.
            else
               write (line,500)
               call putfat (line)
               fileit = .false.
               numdec = numopt - 1
               okc = .false.
            endif
         elseif (numdec.eq.7) then
c
c display
c
            call dsplay (ldc, ncol, nout, ldc, nrow, ntype,
     +                   c,
     +                   titlec,
     +                   fileit)
            fileit = .false.
            numdec = numopt - 1
         elseif (numdec.eq.8) then
c
c file
c
            isend = 1
            ntext = 1   
            title = titlec
            close (unit = nin)
            call matout (isend, ncol, nin, ldc, nrow, ntext,
     +                   c,
     +                   fname, text, title,
     +                   abort, header, qtext, qtitle)
            close (unit = nin)
            numdec = numopt -1
         elseif (numdec.eq.9) then
c
c View A
c
            if (ma.ge.1 .and. na.ge.1) then
               call viewit (na, lda, ma, ntype,
     +                      a,
     +                      titlea)
            endif
            numdec = numopt - 1
         elseif (numdec.eq.10) then
c
c View B
c
            if (mb.ge.1 .and. nb.ge.1) then
               call viewit (nb, ldb, mb, ntype,
     +                      b,
     +                      titleb)
            endif
            numdec = numopt - 1        
         elseif (numdec.eq.numopt - 2) then
c
c results
c        
            call revpro (nout)    
            numdec = numopt - 1
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,600)
            ntext = 20
            numbld(1) = 1
            numbld(6) = 1
            numbld(10) = 1
            numbld(14) = 1
            numbld(18) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                   text,
     +                   border)
            numbld(1) = 0
            numbld(6) = 0
            numbld(10) = 0
            numbld(14) = 0
            numbld(18) = 0
         elseif (numdec.eq.numopt) then
            if (supply) then
               newdat(1) = .false.
               newdat(2) = .false.
            endif   
            repeet = .false.
         endif
      enddo
c
c deallocate workspaces
c
      deallocate(c, stat = ierr)
      deallocate(d, stat = ierr)
c
c format statements
c
  100 format ('ma = ',a,', na = ',a)
  200 format ('mb = ',a,', nb = ',a)
  300 format (
     + 'Matrix multiplication'
     +/
     +/'Current matrix A(ma,na):',1x,a
     +/a
     +/
     +/'Current matrix B(mb,nb):',1x,a
     +/a
     +/
     +/'Input: new matrix A'
     +/'Input: new matrix B'
     +/'Set C = A*B',2x,a
     +/'Set C = (A^T)*B',2x,a
     +/'Set C = A*(B^T)',2x,a
     +/'Set C = (A*T)*(B^T)',2x,a
     +/'View/File current matrix C'
     +/'Save C As ...'
     +/'View current matrix A'
     +/'View current matrix B'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit matrix multiplication')
  400 format ('Success ... Matrix multiplication completed')
  500 format ('Failure ... Inconsistent dimensions')
  600 format (
     + 'Matrix multiplication for A(ma,na), B(mb,nb)'
     +/
     +/'The dimensions must be consistent as follows,'
     +/'otherwise a warning will be given.'
     +/
     +/'C = A*B'
     +/'Dimensions: A(m,k), B(k,n), C(m,n)'
     +/'require m = ma, k = na = mb, n = nb'
     +/
     +/'C = (A^T)*B'
     +/'Dimensions: A(k,m), B(k,n), C(m,n)'
     +/'require k = ma = na, m = na, n = nb'
     +/
     +/'C = A*(B^T)'
     +/'Dimensions: A(m,k), B(n,k), C(m,n)'
     +/'require m = ma, k = na = nb, n = mb'
     +/
     +/'C = (A^T)*(B^T)'
     +/'Dimensions: A(k,m), B(n,k), C(m,n)'
     +/'require k = ma = nb, m = na, n = mb')
      end

c
c
      



