C
C
      SUBROUTINE MATRIX (NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK,
     +                   A, B, DET, U, V, W,
     +                   TITLE,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Matrix arithmetic
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 17/7/96
C          12/08/99 New version of DSPLAY with extra arguments
C          07/02/2001 added CHOP80
C          03/12/2003 extensive revision
C          03/03/2005 used all calls by NAG calls and added D to argument list
C          09/01/2006 changed C and D to allocatable arrays 
C          16/10/2006 extensive revision
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ
C          30/10/2021 added REVPRO, E_NUMBERS and E_FORMATS, etc. 
C
C ADVICE : If successful then on exit ABORT = .FALSE., and:-
C          A is returned as the matrix
C          B is returned as the inverse
C          DET is returned as the determinant
C          (U,V) are returned as (real,imag) eigenvalues
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C
C         NCMAX: max. column dimension (input/unchanged)
C          NCOL: actual no. columns (input if SUPPLY o/w output)
C           NIN: unconnected input unit (input/unchanged)
C            NF: pre-connected output unit (input/unchanged)
C         NRMAX: max. row dimension (input/unchanged)
C          NROW: actual no. rows (input if SUPPLY o/w output)
C         NWORK: workspace
C             A: matrix (input if SUPPLY o/w output)
C             B: inverse of A if successful (output)
C           DET: determinant if successful (output)
C             U: real part of eigenvalues if successful (output)
C             V: imaginary part of eigenvalues if successful (output)
C             W: vector (workspace)
C         TITLE: data title (input if SUPPLY o/w output)
C         ABORT: success/failure ? (output)
C        DISPLY: tables to screen ? (input/unchanged)
C          FILE: output to file ? (input/unchanged)
C        SUPPLY: provide data matrix ? (input/unchanged)
C  
C             C: eigenvectors real part if successful 
C             D: eigenvectors imaginary part if successful 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NIN, NF, NRMAX 
      INTEGER,             INTENT (INOUT) :: NCOL, NROW, NWORK(NRMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX) 
      DOUBLE PRECISION,    INTENT (OUT)   :: B(NRMAX,NCMAX), DET,
     +                                       U(NRMAX), V(NRMAX),
     +                                       W(4*NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL,             INTENT (IN)    :: DISPLY, FILE, SUPPLY
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: C(:,:), D(:,:)
C
C Locals
C
      INTEGER    NCMAX1, NCOL1, NRMAX1, NROW1
      INTEGER    I, ICOLOR, ICOUNT, IERR, IFAIL, ISEND, J, K, LWORK
      INTEGER    KVAL9, NKLCFG
      INTEGER    IX, IY, NUMDEC, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 12)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N4, N15, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N15 = 15, N21 = 21)
      INTEGER    NTEXT1, NTYPE
      PARAMETER (NTEXT1 = 1, NTYPE = 3)
      CHARACTER (LEN = 13) D13(2), SHOWLJ, SHOWRJ 
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, TEXT(NUMOPT)*100,
     +           TEXT1(NTEXT1)*100, TITLE1*80
      CHARACTER  JOBVR*1
      PARAMETER (JOBVR = 'V')
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FILE1, FILE2, FILE3, FILE4, FILE5, OK
      LOGICAL    FIXCOL, FIXROW, LABEL, REPEET
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT1, HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   F02EBF$, F03AAF$, F07ADF$, F07AJF$
      EXTERNAL   MATTIN, TABLE1, PUTIFA, PUTFAT, PUTADV, DSPLAY, CHOP80,
     +           LBOX02, MATOUT, REVPRO
      EXTERNAL   NKLCFG, TFILEQ
      DATA       NUMPOS / NUMOPT*1 /
      DATA       ICOUNT / 0 /

      IF (.NOT.SUPPLY) THEN
C
C Read in the matrix if .NOT.SUPPLY
C
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) THEN
            WRITE (LINE,100)
            CALL TFILEQ (LINE)
         ENDIF   
         ISEND = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW, A, W, FNAME,
     +                TITLE, ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Check the dimensions
C
      IF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
          WRITE (LINE,200)
          IF (DISPLY) CALL PUTFAT (LINE)
          ABORT = .TRUE.
          RETURN
      ENDIF
     
      IF (NCOL.NE.NROW) THEN
         WRITE (LINE,300)
         IF (DISPLY) CALL PUTFAT (LINE)
         ABORT = .TRUE.
         RETURN
      ELSE
C
C Further action now only if A is square
C
         ABORT = .FALSE.
         IERR = 0
         IF (ALLOCATED(C)) DEALLOCATE(C, STAT = IERR)
         IF (IERR.NE.0) RETURN
         IF (ALLOCATED(D)) DEALLOCATE(D, STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(C(NRMAX,NCMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(D(NRMAX,NCMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
         E_NUMBERS = E_FORMATS()  
         ICOUNT = ICOUNT + 1 
         WRITE (NF,350) ICOUNT	 
C
C First copy A into B since matrices are overwritten
C
         NCOL1 = NCOL
         NROW1 = NROW
         NRMAX1 = NRMAX
         DO J = N1, NCOL1
            DO I = N1, NROW1
               B(I,J) = A(I,J)
            ENDDO
         ENDDO
C
C Find the determinant
C
         IFAIL = N1
         CALL F03AAF$(B, NRMAX1, NCOL1, DET, W, IFAIL)
         IF (IFAIL.EQ.N0) THEN
            IF (FILE) THEN
               WRITE (NF,'(A)') BLANK
               WRITE (NF,400)
               WRITE (NF,500) TITLE
               IF (E_NUMBERS) THEN
                  WRITE (NF,600) DET
               ELSE
                 D13(1) = SHOWLJ(DET)
                 WRITE (NF,650) D13(1)  
              ENDIF    
            ENDIF
         ELSE
            IF (DISPLY) CALL PUTIFA (IFAIL, NF, 'F03AAF/MATRIX')
            ABORT = .TRUE.
            DEALLOCATE(C, STAT = IERR)
            DEALLOCATE(D, STAT = IERR)
            RETURN
         ENDIF
C
C Now copy A into B again since matrices are overwritten
C
         NCOL1 = NCOL
         NROW1 = NROW
         NRMAX1 = NRMAX
         DO J = N1, NCOL1
            DO I = N1, NROW1
               B(I,J) = A(I,J)
            ENDDO
         ENDDO
C
C Find the eigenvalues
C
         LWORK = 4*NRMAX
         IFAIL = N1
         CALL F02EBF$(JOBVR, NCOL1, B, NRMAX1, U, V, C, NRMAX1,
     +                D, NRMAX1, W, LWORK, IFAIL)
         IF (IFAIL.NE.N0) THEN
            IF (DISPLY) CALL PUTIFA (IFAIL, NF, 'F02EBF/MATRIX')
            ABORT = .TRUE.
            DEALLOCATE(C, STAT = IERR)
            DEALLOCATE(D, STAT = IERR)
            RETURN
         ENDIF
C
C Now copy A into B again since matrices are overwritten
C
         NCOL1 = NCOL
         NROW1 = NROW
         NRMAX1 = NRMAX
         DO J = N1, NCOL1
            DO I = N1, NROW1
               B(I,J) = A(I,J)
            ENDDO
         ENDDO
C
C Find the inverse
C
         IFAIL = N1
         CALL F07ADF$(NROW1, NCOL1, B, NRMAX1, NWORK, IFAIL)
         IF (IFAIL.EQ.N0) THEN
            NCOL1 = NCOL
            NROW1 = NROW
            NRMAX1 = NRMAX
            CALL F07AJF$(NCOL1, B, NRMAX1, NWORK, W, NRMAX, IFAIL)
            IF (IFAIL.EQ.N0) THEN
               ABORT = .FALSE.
               OK = .TRUE.
            ELSE
               IF (DISPLY) CALL PUTIFA (IFAIL, NF, 'F07AJF/MATRIX')
               ABORT = .TRUE.
               OK = .FALSE.
             ENDIF
         ELSE
            IF (DISPLY) CALL PUTIFA (IFAIL, NF, 'F07ADF/MATRIX')
            ABORT = .TRUE.
            OK = .FALSE.
         ENDIF
C
C Assign temporary logicals
C
         FILE1 = FILE
         FILE2 = FILE
         FILE3 = FILE
         FILE4 = FILE
         FILE5 = FILE
         IF (NCOL.GT.20) THEN
            FILE1 = .FALSE.
            FILE2 = .FALSE.
            IF (NCOL.GT.30) FILE3 = .FALSE.
            FILE4 = .FALSE.
            FILE5 = .FALSE.
         ENDIF
C
C Output if DISPLY = .TRUE.
C
         IF (DISPLY) THEN
            WRITE (LINE,700)
            CALL PUTADV (LINE)
         ENDIF
         REPEET = DISPLY
         DO WHILE (REPEET)
            NCMAX1 = NCMAX
            NCOL1 = NCOL
            NRMAX1 = NRMAX
            NROW1 = NROW
            WRITE (TEXT,800)
            NUMDEC = NUMOPT
            ICOLOR = 7
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
            IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Display matrix
C
               WRITE (LINE,900)
               CALL DSPLAY (NCMAX1, NCOL1, NF, NRMAX1, NROW1, NTYPE,
     +                      A, LINE, FILE1)
               FILE1 = .FALSE.
            ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Display determinant
C
               ICOLOR = N15
               CALL TABLE1 (ICOLOR, 'OPEN')
               ICOLOR = N0
               WRITE (LINE,400)
               CALL TABLE1 (ICOLOR, LINE)
               ICOLOR = N4
               WRITE (LINE,500) CHOP80(TITLE)
               CALL TABLE1 (ICOLOR, LINE)
               ICOLOR = N0
               IF (E_NUMBERS) THEN
                  WRITE (LINE,600) DET
               ELSE
                  D13(1) = SHOWLJ(DET)
                  WRITE (LINE,650) D13(1)
               ENDIF      
               CALL TABLE1 (ICOLOR, LINE)
               CALL TABLE1 (ICOLOR, 'CLOSE')
            ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Display inverse
C
               IF (OK) THEN
                  WRITE (LINE,1000)
                  CALL DSPLAY (NCMAX1, NCOL1, NF, NRMAX1, NROW1, NTYPE,
     +                         B, LINE, FILE2)
                  FILE2 = .FALSE.
               ELSE
                  WRITE (LINE,1100)
                  CALL PUTFAT (LINE)
               ENDIF
            ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Display eigenvalues
C
               ICOLOR = N15
               CALL TABLE1 (ICOLOR, 'OPEN')
               ICOLOR = N4
               WRITE (LINE,1200)
               CALL TABLE1 (ICOLOR,LINE)
               ICOLOR = N0
               DO I = N1, NCOL1
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1300) U(I), V(I)
                  ELSE
                     D13(1) = SHOWRJ(U(I))
                     D13(2) = SHOWRJ(V(I))
                     WRITE (LINE,1350) D13(1), D13(2)
                  ENDIF       
                  CALL TABLE1 (ICOLOR, LINE)
               ENDDO
               CALL TABLE1 (ICOLOR, 'CLOSE')
               IF (FILE3) THEN
                  WRITE (NF,'(A)') BLANK
                  WRITE (NF,1200)
                  DO I = N1, NCOL1
                     IF (E_NUMBERS) THEN
                        WRITE (NF,1300) U(I), V(I)
                     ELSE
                        D13(1) = SHOWRJ(U(I))
                        D13(2) = SHOWRJ(V(I))
                        WRITE (NF,1350) D13(1), D13(2)
                     ENDIF       
                  ENDDO
                  FILE3 = .FALSE.
               ENDIF
            ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Display eigenvector real parts
C
               WRITE (LINE,1400)
               CALL DSPLAY (NCMAX1, NCOL1, NF, NRMAX1, NROW1, NTYPE,
     +                      C, LINE, FILE4)
               FILE4 = .FALSE.
            ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Display eigenvector imaginary parts
C
               WRITE (LINE,1500)
               CALL DSPLAY (NCMAX1, NCOL1, NF, NRMAX1, NROW1, NTYPE,
     +                      D, LINE, FILE5)
               FILE5 = .FALSE.
            ELSEIF (NUMDEC.EQ.7) THEN
C
C NUMDEC = 7: Save inverse As ...
C
               IF (OK) THEN
                  FNAME = BLANK
                  TITLE1 = 'Matrix Inverse'
                  TEXT1(1) = BLANK
                  ISEND = 1
                  CLOSE (UNIT = NIN)
                  CALL MATOUT (ISEND, NCOL1, NIN, NRMAX1, NROW1, NTEXT1,
     +                         B,
     +                         FNAME, TEXT1, TITLE1,
     +                         ABORT1, HEADER, QTEXT, QTITLE)
                  CLOSE (UNIT = NIN)
               ELSE
                  WRITE (LINE,1100)
                  CALL PUTFAT (LINE)
               ENDIF
            ELSEIF (NUMDEC.EQ.8) THEN
C
C NUMDEC = 8: Save eigenvalues As ...  (copy C into W, copy U,V into C, copy W into C)
C
               K = N0
               DO J = N1, NCOL1
                  DO I = N1, NROW1
                     K = K + N1
                     W(K) = C(I,J)
                  ENDDO
               ENDDO
               DO I = N1, NCOL1
                  C(I,N1) = U(I)
                  C(I,N2) = V(I)
               ENDDO
               FNAME = BLANK
               TITLE1 = 'Eigenvalues z = x + i*y'
               TEXT1(1) = BLANK
               ISEND = 1
               CLOSE (UNIT = NIN)
               CALL MATOUT (ISEND, N2, NIN, NRMAX1, NROW1, NTEXT1,
     +                      C,
     +                      FNAME, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
               K = N0
               DO J = N1, NCOL1
                  DO I = N1, NROW1
                     K = K + N1
                     C(I,J) = W(K)
                  ENDDO
               ENDDO
            ELSEIF (NUMDEC.EQ.9) THEN
C
C NUMDEC = 9: Save eigenvector real parts As ...
C
               FNAME = BLANK
               TITLE1 = 'Eigenvctor real parts'
               TEXT1(1) = BLANK
               ISEND = 1
               CLOSE (UNIT = NIN)
               CALL MATOUT (ISEND, NCOL1, NIN, NRMAX1, NROW1, NTEXT1,
     +                      C,
     +                      FNAME, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.10) THEN
C
C NUMDEC = 10: Save eigenvector imaginary parts As ...
C
               FNAME = BLANK
               TITLE1 = 'Eigenvector imaginary parts'
               TEXT1(1) = BLANK
               ISEND = 1
               CLOSE (UNIT = NIN)
               CALL MATOUT (ISEND, NCOL1, NIN, NRMAX1, NROW1, NTEXT1,
     +                      D,
     +                      FNAME, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.11) THEN
C
C NUMDEC = 11: Results
C            
               CALL REVPRO (NF)   
            ELSE   
               REPEET = .FALSE.
            ENDIF
         ENDDO
         DEALLOCATE(C, STAT = IERR)
         DEALLOCATE(D, STAT = IERR)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Now input a square matrix formatted like matrix.tf1')
  200 FORMAT ('Not a matrix ... Must have m, n > 1')
  300 FORMAT ('Matrix not square ... No determinant, eigenvalues, etc.')
  350 FORMAT (
     +/' Analysis of a square matrix:',I3,
     +/' ===============================')
  400 FORMAT ('Current data:')
  500 FORMAT (A)
  600 FORMAT ('Value of the determinant =',1P,E15.7)
  650 FORMAT ('Value of the determinant =',1X,A)
  700 FORMAT (
     +'Determinant, inverse, and eigenvalues have now been calculated')
  800 FORMAT (
     + 'Display matrix'
     +/'Display determinant'
     +/'Display inverse'
     +/'Display eigenvalues'
     +/'Display eigenvector real parts'
     +/'Display eigenvector imaginary parts'
     +/'File: Save inverse As ...'
     +/'File: Save eigenvalues As ...'
     +/'File: Save eigenvector real parts As ...'
     +/'File: Save eigenvector imaginary parts As ...'
     +/'Results'
     +/'Quit ... Exit these matrix options')
  900 FORMAT ('Values for the current square matrix are as follows:')
 1000 FORMAT ('Values for the current inverse are as follows:')
 1100 FORMAT ('Matrix is singular')
 1200 FORMAT ('Eigenvalues:       Real Part Imaginary Part')
 1300 FORMAT (13X,1P,2E15.7)
 1350 FORMAT (13X,2(2X,A13))
 1400 FORMAT ('Eigenvector columns (real parts only)')
 1500 FORMAT ('Eigenvector columns (imaginary parts only)')
      END
C
C

