C
C
      SUBROUTINE MCNMAR (NCMAX, NCOL, NIN, NOBS, NOUT, NRMAX, NROW,
     +                   A, X,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION : McNemar test
C AUTHOR : W.G.Bardsley, University of Manchester, 01/08/2002
C          01/08/2002 derived from CONTIN
C          11/02/2006 added NCOL, NROW, NEWDAT and SUPPLY to arguments
C          08/05/2011 added call to FORM12
C          27/07/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NCOL, NIN, NOUT, NRMAX, NROW
      INTEGER    NOBS(NRMAX,NCMAX)
      DOUBLE PRECISION A(NRMAX,NCMAX), X(NRMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    NEWDAT, SUPPLY
C
C Locals
C
      INTEGER    N3
      PARAMETER (N3 = 3)
      INTEGER    K0, K1, K2, K3, K4, K5, K10, K20
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5,
     +           K10 = 10, K20 = 20)
      INTEGER    IFAIL, NDF
      INTEGER    I, ICOUNT, J, K, KMIN
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NUMDEC, NUMOPT,
     +           NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NUMBLD(30), NUMPOS(10)
      DOUBLE PRECISION ZERO, PNT01, PNT05, PNT95, PNT99, TWO
      PARAMETER (ZERO = 0.0D+00, PNT01 = 0.01D+00, PNT05 = 0.05D+00,
     +           PNT95 = 0.95D+00, PNT99 = 0.99D+00, TWO = 2.0D+00)
      DOUBLE PRECISION CHIS, FIJ, FJI, SUM1
      DOUBLE PRECISION PGCHI, P95, P99
      DOUBLE PRECISION G01ECF$, G01FCF$
      CHARACTER (LEN = 12 ) I12(2), FORM12, WORD12
      CHARACTER (LEN = 13 ) D13(3), SHOWLJ 
      CHARACTER (LEN = 21 ) RESUL
      CHARACTER (LEN = 60 ) CHOP60
      CHARACTER (LEN = 80 ) H0, CHOP80
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ABORT, FIXCOL, FIXROW, LABEL
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .FALSE.)
      LOGICAL    REPEET
      EXTERNAL   G01ECF$, G01FCF$
      EXTERNAL   PUTADV, MATTIN, PUTFAT, PUTIFA, TABLE1, PATCH1,
     +           LBOX01, CHOP60, CHOP80, FORM12, SHOWLJ, E_FORMATS
      INTRINSIC  NINT, ABS, DBLE
      SAVE ICOUNT
      DATA ICOUNT / 0 /
      DATA NUMBLD / 30*0 /
      DATA NUMPOS / 10*1 /
      ABORT = .FALSE.
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCOL.LT.K2 .OR. NROW.LT.K2) THEN
            CALL PUTFAT ('Must have at least 2 rows and 2 columns')
            RETURN
         ENDIF
         IF (NROW.GT.NRMAX) THEN
            CALL PUTFAT ('Too many rows requested')
            RETURN
         ENDIF
         IF (NCOL.GT.NCMAX) THEN
            CALL PUTFAT ('Too many columns requested')
            RETURN
         ENDIF
         IF (NCOL.NE.NROW) THEN
            CALL PUTFAT ('No. rows must equal no. columns')
            RETURN
         ENDIF
         IF (.NOT.ABORT) THEN
            DO J = K1, NCOL
               IF (.NOT.ABORT) THEN
                  DO I = K1, NROW
                     IF (.NOT.ABORT) THEN
                        IF (A(I,J).LT.ZERO) ABORT = .TRUE.
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IF (ABORT) THEN
               CALL PUTFAT (
     +'McNemar frequencies must be non-negative integers')
               RETURN
            ENDIF
            IF (.NOT.ABORT) THEN
               K = K0
               DO J = K1, NCOL
                  DO I = K1, NROW
                     NOBS(I,J) = NINT(A(I,J))
                     K = K + NOBS(I,J)
                  ENDDO
               ENDDO
               IF (NCOL.EQ.K2) THEN
                   KMIN = NOBS(1,2) + NOBS(2,1)
               ELSE
                  KMIN = K   
               ENDIF   
               IF (KMIN.LT.K10) THEN
                  ABORT = .TRUE.
                  CALL PUTFAT (
     +'Sum of McNemar frequencies must be greater than 10')
                  RETURN
               ENDIF
            ENDIF
            NDF = (NROW*(NCOL - K1))/K2
         ENDIF
      ELSE
         NCOL = K0
         NROW = K0
         TITLE = 'No data'
      ENDIF
      E_NUMBERS = E_FORMATS()
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Main menu
C
         WORD12 = FORM12(NROW)
         WRITE (TEXT,100) CHOP60(TITLE), WORD12
         NUMBLD(1) = 1
         NUMBLD(4) = 1
         NSTART = 8
         NUMOPT = 4
         NUMTXT = NSTART + NUMOPT - 1
         NUMDEC = NUMOPT - K1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         IF (NUMDEC.EQ.K2) THEN
C
C Check that data is available before analysis is done
C
            IF (NCOL.LT.K2 .OR. NROW.LT.K2) THEN
               CALL PUTFAT ('First input your data')
               ABORT = .TRUE.
               NCOL = K0
               NROW = K0
               TITLE = 'No data'
               NUMDEC = K0
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.K1) THEN
C
C New data
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               RETURN
            ELSE
               I = N3
               J = NIN
               FNAME = BLANK
               FIXCOL = .FALSE.
               FIXROW = .FALSE.
               LABEL = .TRUE.
               CLOSE (UNIT = J)
               CALL PUTADV (
     +'Now input data formatted like McNemar.tf1 (n by n frequencies)')
               CALL MATTIN (I, NCMAX, NCOL, J, NRMAX, NROW,
     +                      A, X,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = J)
               IF (ABORT) THEN
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. (NCOL.LT.K2 .OR. NROW.LT.K2)) THEN
                  CALL PUTFAT (
     +'Must have at least 2 rows and 2 columns')
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
              IF (.NOT.ABORT .AND. NROW.GT.NRMAX) THEN
                  CALL PUTFAT ('Too many rows requested')
                  WRITE (LINE,200) NRMAX
                  CALL PUTADV (LINE)
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. NCOL.GT.NCMAX) THEN
                  CALL PUTFAT ('Too many columns requested')
                  WRITE (LINE,200) NCMAX
                  CALL PUTADV (LINE)
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. NCOL.NE.NROW) THEN
                  CALL PUTFAT ('No. rows must equal no. columns')
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT) THEN
                  DO J = K1, NCOL
                     IF (.NOT.ABORT) THEN
                        DO I = K1, NROW
                           IF (.NOT.ABORT) THEN
                              IF (A(I,J).LT.ZERO) ABORT = .TRUE.
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
                  IF (ABORT) THEN
                     CALL PUTFAT (
     +'McNemar frequencies must be non-negative integers')
                     NCOL = K0
                     NROW = K0
                     TITLE = 'No data'
                  ENDIF
               ENDIF
               IF (.NOT.ABORT) THEN
                  K = K0
                  DO J = K1, NCOL
                     DO I = K1, NROW
                        NOBS(I,J) = NINT(A(I,J))
                        K = K + NOBS(I,J)
                     ENDDO
                  ENDDO
                  IF (NCOL.EQ.K2) THEN
                     KMIN = NOBS(1,2) + NOBS(2,1)
                  ELSE
                     KMIN = K   
                  ENDIF   
                  IF (KMIN.LT.K10) THEN
                     ABORT = .TRUE.
                     CALL PUTFAT (
     +'Sum of McNemar frequencies must be greater than 10')
                     NCOL = K0
                     NROW = K0
                     FNAME = BLANK
                     TITLE = 'No data'
                  ENDIF
               ENDIF
               NDF = (NROW*(NCOL - K1))/K2
           ENDIF
        ELSEIF (NUMDEC.EQ.K2) THEN
C
C Calculate
C
            ICOUNT = ICOUNT + 1
            IF (NROW.EQ.K2) THEN
               FIJ = DBLE(NOBS(1,2))
               FJI = DBLE(NOBS(2,1))
               CHIS = (ABS(FIJ - FJI) - K1)**2/(FIJ + FJI)
            ELSE
               CHIS = ZERO
               DO I = K1,NROW
                  DO J = I + K1, NCOL
                     FIJ = DBLE(NOBS(I,J))
                     FJI = DBLE(NOBS(J,I))
                     SUM1 = FIJ + FJI
                     IF (SUM1.GT.ZERO) CHIS = CHIS + (FIJ - FJI)**2/SUM1
                  ENDDO
               ENDDO
            ENDIF
C
C Significance levels
C
            IFAIL = K1
            PGCHI = G01ECF$('Upper-tail', CHIS, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/MCNMAR')
            IF (PGCHI.GE.PNT05) THEN
               RESUL = 'Consider accepting H0'
            ELSEIF (PGCHI.GE.PNT01) THEN
               RESUL = 'Reject H0 at 5% level'
            ELSE
               RESUL = 'Reject H0 at 1% level'
            ENDIF
            IFAIL = K1
            P95 = G01FCF$(PNT95, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/MCNMAR')
            IFAIL = K1
            P99 = G01FCF$(PNT99, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/MCNMAR')
C
C Output results
C
            WRITE (NOUT,'(A)') BLANK	
            WRITE (NOUT,'(A)') '***'	
            IF (NROW.LE.K10) THEN
               WRITE (NOUT,300) ICOUNT
               DO I = K1, NROW
                  WRITE (NOUT,'(10I8)') (NOBS(I,J), J = K1, NCOL)
               ENDDO
            ENDIF
            IF (NROW.EQ.K2) THEN
               H0 = 'H0: Expected value of [(f(1,2) - (f(2,1))/n] = 0'
               KMIN = NINT((DBLE(NOBS(1,2)) + DBLE(NOBS(2,1)))/TWO) 
               IF (KMIN.LT.K20) CALL PUTADV (
     +        'This is a rather small sample: f(1,2) + f(2,1) < 20')                 
            ELSE
               H0 =
     +        'H0: intentional association between row and column data.'
            ENDIF  
            IF (E_NUMBERS) THEN   
               WRITE (TEXT,400) ICOUNT, H0, CHOP80(TITLE), NROW,
     +                          CHIS, NDF,
     +                          PGCHI, RESUL, P95, P99
               WRITE (NOUT,500) ICOUNT, H0, CHOP80(TITLE), NROW,
     +                          CHIS, NDF,
     +                          PGCHI, RESUL, P95, P99
            ELSE
               I12(1) = FORM12(NROW)
               I12(2) = FORM12(NDF)
               D13(1) = SHOWLJ(CHIS)
               D13(2) = SHOWLJ(P95)
               D13(3) = SHOWLJ(P99)
               WRITE (TEXT,405) ICOUNT, H0, CHOP80(TITLE), I12(1),
     +                          D13(1), I12(2),
     +                          PGCHI, RESUL, D13(2), D13(3)
               WRITE (NOUT,505) ICOUNT, H0, CHOP80(TITLE), I12(1),
     +                          D13(1), I12(2),
     +                          PGCHI, RESUL, D13(2), D13(3)
            ENDIF  
            NUMTXT = 11
            IF (NROW.EQ.K2 .AND. NCOL.EQ.K2) THEN
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = BLANK
               NUMTXT = NUMTXT + K1
               WRITE (TEXT(NUMTXT),600)
               WRITE (NOUT,700)
            ENDIF
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            DO I = K1, NUMTXT
               IF (I.EQ.K1 .OR. I.EQ.K5) THEN
                  COLOUR = K4
               ELSE
                  COLOUR = K0
               ENDIF
               CALL TABLE1 (COLOUR,TEXT(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ELSEIF (NUMDEC.EQ.K3) THEN
            WRITE (TEXT,800)
            NUMBLD(1) = K1
            NUMTXT = 23
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = K0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'McNemar test'
     +/
     +/'Current data:'
     +/A
     +/
     +/'Number of rows and columns =',1X,A
     +/
     +/'New data'
     +/'Test the current data'
     +/'Help'
     +/'Quit ... Exit McNemar test options')
  200 FORMAT ('Maximum dimension in this version =',I6)
  300 FORMAT (
     +/1X,'Data for McNemar test',I4
     +/1x,'-------------------------')
  400 FORMAT (
     + 'McNemar test',I4
     +/
     +/A
     +/'Data: '
     +/A
     +/'Number of rows/columns   =',I4
     +/'Chi-sq. test statistic C =',1P,E12.5
     +/'Degrees of freedom       =',I4
     +/'p = P(chi-sq. >= C)      =',0P,F7.4,5X,A
     +/'Upper tail 5% point      =',1P,E12.5
     +/'Upper tail 1% point      =',   E12.5)
  405 FORMAT (
     + 'McNemar test',I4
     +/
     +/A
     +/'Data: '
     +/A
     +/'Number of rows/columns   =',1X,A
     +/'Chi-sq. test statistic C =',1X,A
     +/'Degrees of freedom       =',1X,A
     +/'p = P(chi-sq. >= C)      =',F7.4,5X,A
     +/'Upper tail 5% point      =',1X,A
     +/'Upper tail 1% point      =',1X,A)     
  500 FORMAT (
     +/1X,'McNemar test',I4
     +/1X,'----------------'
     +/1X,A
     +/1X,'Data: ',A
     +/1X,'Number of rows/columns   =',I4
     +/1X,'Chi-sq. test statistic C =',1P,E12.5
     +/1X,'Degrees of freedom       =',I4
     +/1X,'p = P(chi-sq. >= C)      =',0P,F7.4,5X,A
     +/1X,'Upper tail 5% point      =',1P,E12.5
     +/1X,'Upper tail 1% point      =',   E12.5)
  505 FORMAT (
     +/1X,'McNemar test',I4
     +/1X,'----------------'
     +/1X,A
     +/1X,'Data: ',A
     +/1X,'Number of rows/columns   =',1X,A
     +/1X,'Chi-sq. test statistic C =',1X,A
     +/1X,'Degrees of freedom       =',1X,A
     +/1X,'p = P(chi-sq. >= C)      =',F7.4,5X,A
     +/1X,'Upper tail 5% point      =',1X,A
     +/1X,'Upper tail 1% point      =',1X,A)     
  600 FORMAT ('Continuity correction used in chi-square')
  700 FORMAT (1X,'Continuity correction used in chi-square')
  800 FORMAT (
     + 'McNemar analysis of paired sample nominal-scale data'
     +/
     +/'This procedure takes a matrix with r rows and columns of n'
     +/'non-negative integer frequencies f(i,j) to test'
     +/
     +/'H0:`intentional association between row and column data or,'
     +/'   `when r = 2, equal expectations E(f(1,2)) = E(f(2,1)).'
     +/
     +/'When r = 2 the following test statistic is calculated:'
     +/
     +/'C = [|f(1,2) - f(2,1)| - 1]^2/{f(1,2) + f(2,1)}'
     +/
     +/'but, when r > 2, the following test statistic is calculated:'
     +/
     +/'C = Sum(i=1,...,r; j>i) [f(i,j) - f(j,i)]^2/{f(i,j) + f(j,i)}.'
     +/
     +/'The degrees of freedom for a chi-square test are in both cases'
     +/'given by NDOF = r(r - 1)/2.'
     +/
     +/'If f(i,j) < 0 or  n = sum(i=1,...,r; j = 1,...,r){f(i,j)} < 10'
     +/'the data set will be rejected.'
     +/
     +/'Suitable test files: mcnemar.tf1, mcnemar.tf2, and mcnemar.tf3')
      END

C
C
