C
C
      SUBROUTINE META00 (ICOUNT, ILIM, NCOL, NDF1, NDF2, NIN, NOBS,
     +                   NOUT, NRMAX, NROW, NTEMP, NUMN, NUMX,
     +                   A, ATEMP, CHISQ1, CHISQ2, PBIG, PBOT, PHAT,
     +                   PHIGH, PLOW, PTOP, P1, P2, T, X,
     +                   FNAME, INFO, TITLE, WORD1, WORD2,
     +                   ABORT, META, NEWDAT, SUPRC)
C
C ACTION: prepare data for analysis of proportions/meta-analysis
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 09/06/2005
C         14/02/2006 added NEWDAT to arguments
C         02/02/2021 added INTENTS and on exit ATEMP has y, N, x, and X(i) = ATEMP(I,3) = N (to store N)
C                    Note: to refresh META00 after changing ILIM then re-enter with NCOL = 2 or 3 (but not 4)
C                          and input A using META = NEWDAT = SUPRC = .FALSE.
C                    On exit:     y is the number of "successes" in N trials, while x is the ordering parameter for plotting
C                                 A is y, N, x
C                             ATEMP is y, N - y, N
C                              NOBS is y, N - y
C                                 X is N
C                                 T is x (the ordering parameter for plotting)  
C        13/02/2021 now only allowed to have 2 or 3 columns i.e. (y,N) or (y,N,x) and always allocates ASAV(I,3)
C                   Also made sure NIN is always closed on exit   
C                                     
C
C  If NEWDAT = .TRUE. then attempt to read in a new data set
C  If SUPRC = .TRUE. then see if row suppression is required
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ILIM, NIN, NOUT, NRMAX
      INTEGER,             INTENT (INOUT) :: ICOUNT, NCOL, NDF1, NDF2,
     +                                       NROW, NUMN, NUMX,
     +                                       NOBS(NRMAX,3),
     +                                       NTEMP(NRMAX,3)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,3), ATEMP(NRMAX,4), 
     +                                       T(NRMAX), X(NRMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: PBOT(NRMAX), PHAT(NRMAX),
     +                                       PTOP(NRMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: CHISQ1, CHISQ2, PBIG, 
     +                                       PHIGH, PLOW, P1, P2
      CHARACTER (LEN = *), INTENT (IN)    :: INFO(*)  
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE,
     +                                       WORD1, WORD2
      LOGICAL,             INTENT (IN)    :: META, NEWDAT, SUPRC
      LOGICAL,             INTENT (INOUT) :: ABORT
C
C allocatable
C
      DOUBLE PRECISION, ALLOCATABLE :: ASAV(:,:)       
C
C Locals
C
      INTEGER    I, IFAIL, INOB, IPRED, ISEND, J, K, M, M1, N, N1, NPOS,
     +           NUM
      INTEGER    NCMAX
      PARAMETER (NCMAX = 4)
      DOUBLE PRECISION A11, A12, A21, A22, C1, C2, R1, R2
      DOUBLE PRECISION BOT, DIFF, P(21), PLOG,
     +                 QLOG, SUM1, TOP
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION G01ECF$
      CHARACTER  LINE*100
      CHARACTER  BLANK*1, UPPER*1
      PARAMETER (BLANK = ' ', UPPER = 'U')
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   PUTADV, MATTIN, PHAT95, PUTIFA, PUTFAT, PLEVEL,
     +           SUPRC1
      EXTERNAL   G01AFF$, G01ECF$
      INTRINSIC  NINT, DBLE, LOG, ABS

C
C Part 1: Read in the data matrix ATEMP
C ======
C
      IF (SUPRC) THEN
C
C Re-initialise ATEMP then suppress rows
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)') TITLE
         READ (NIN,*) NROW, NCOL
         DO I = 1, NROW
            READ (NIN,*) (ATEMP(I,J), J = 1, NCOL)
         ENDDO
         CLOSE (UNIT = NIN)
         IF (META) CALL PUTADV (INFO(11))
         ISEND = 1
         CALL SUPRC1 (ISEND, NCMAX, NCOL, NRMAX, NROW,
     +                ATEMP,
     +                TITLE)
C
C Check there at least 2 rows and either 2 or 3 columns
C
         IF (NROW.LT.2 .OR. NCOL.LT.2 .OR. NCOL.GT.3) THEN
            WRITE (LINE,100)
            CALL PUTFAT (LINE)
            CLOSE (UNIT = NIN)
            RETURN
         ELSE   
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)') TITLE
            READ (NIN,*) NROW, NCOL
            DO I = 1, NROW
               READ (NIN,*) (ATEMP(I,J), J = 1, NCOL)
            ENDDO
            CLOSE (UNIT = NIN)
         ENDIF
C
C Check for even number
C
         IF (META) THEN
            I = NROW/2
            I = 2*I
            IF (I.NE.NROW) THEN
               CALL PUTFAT (INFO(4))
               CLOSE (UNIT = NIN)
               RETURN
            ELSE   
               OPEN (UNIT = NIN, FILE = FNAME)
               READ (NIN,'(A)') TITLE
               READ (NIN,*) NROW, NCOL
               DO I = 1, NROW
                  READ (NIN,*) (ATEMP(I,J), J = 1, NCOL)
               ENDDO
               CLOSE (UNIT = NIN)
            ENDIF
         ENDIF
      ENDIF
      IF (NEWDAT) THEN
C
C Read new data into ATEMP
C
         ABORT = .TRUE.
         ISEND = 3
         FNAME = BLANK
         TITLE = BLANK
C
C Matrix with arbitrary number of columns
C
         CALL PUTADV (INFO(1))
         IF (ICOUNT.EQ.0) CALL PUTADV (INFO(2))
         CLOSE (UNIT = NIN)
         CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                ATEMP, T,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Check if at least 2 rows and only 2 or 3 columns 
C
      ABORT = .TRUE.
      IF (NROW.LT.2 .OR. NCOL.LT.2 .OR. NCOL.GT.3) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
C
C Check for even number
C
      IF (META) THEN
         I = NROW/2
         I = 2*I
         IF (I.NE.NROW) THEN
            CALL PUTFAT (INFO(4))
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
      ENDIF
C
C Check if matrix too large
C
      IF (NROW.GT.NRMAX) THEN
         CALL PUTFAT (INFO(5))
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
C
C Check if matrix has a spare row and column for G01AFF
C
      IF (NROW.GE.NRMAX - 1) THEN
         CALL PUTFAT (INFO(6))
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
C
C Allocate
C   
      I = NROW
      J = 3
      ALLOCATE (ASAV(I,J), STAT = K)
      IF (K.NE.0) THEN
         CALL PUTFAT ('Cannot allocate memory for matrix ASAV')
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF      
      IF (NCOL.EQ.2) THEN
C
C Columns of y and N have been supplied so set T to successive integers as only two columns have been supplied
C
         NCOL = 3
         DO I = 1, NROW
            A(I,1) = ATEMP(I,1)
            A(I,2) = ATEMP(I,2)
            A(I,3) = DBLE(I) 
            ATEMP(I,3) = A(I,3)
            T(I) = A(I,3) 
            X(I) = A(I,2)
         ENDDO
C
C A now has columns y, N, t, also A = ATEMP, T is defined and X = N
C         
      ELSEIF (NCOL.EQ.3) THEN
C
C Copy ATEMP into A
C
         DO I = 1, NROW
            A(I,1) = ATEMP(I,1)
            A(I,2) = ATEMP(I,2)
            A(I,3) = ATEMP(I,3)
            T(I) = A(I,3)
            X(I) = A(I,2)
         ENDDO
C
C A now has columns y, N, t, also A = ATEMP, T is defined and X = N
C         
      ELSEIF (NCOL.EQ.4) THEN! 13/02/2021 This option was discontinued as it is no longer used
C
C x,y,N,s file has been supplied
C
         NCOL = 3
         DO I = 1, NROW
            A(I,1) = ATEMP(I,2)
            A(I,2) = ATEMP(I,3)
            A(I,3) = ATEMP(I,1)
            T(I) = ATEMP(I,1)
            X(I) = ATEMP(I,3) 
         ENDDO
         CALL PUTADV (INFO(8))
      ENDIF
C
C A now has columns y, N, x, also A = ATEMP, T is defined and X = N so create ASAV 
C      
      DO I = 1, NROW
         DO J = 1, 3
            ASAV(I,J) = A(I,J)
         ENDDO
      ENDDO       
C
C Truncate A to nearest integers
C Fill in NTEMP in the order: y, N
C Fill in ATEMP in the order: y, N - y, N
C ========================================
C
      DO I = 1, NROW
C
C Transform to integers
C
         NTEMP(I,1) = NINT(A(I,1))
         NTEMP(I,2) = NINT(A(I,2))
C
C Round up the matrix entries
C
         A(I,1) = DBLE(NTEMP(I,1))
         A(I,2) = DBLE(NTEMP(I,2))
C
C Generate ATEMP y, N - y, N
C
         ATEMP(I,1) = A(I,1)
         ATEMP(I,2) = A(I,2) - A(I,1)
         ATEMP(I,3) = A(I,2)
      ENDDO
C
C Part 2: Do the calculations for NOBS, PBOT, PHAT, PTOP, T
C =======
C
      NUMN = 0
      NUMX = 0
      DO I = 1, NROW
C
C First of all NOBS(I,1) = A(I,1)
C
         NOBS(I,1) = NTEMP(I,1)
         IF (NOBS(I,1).LT.0) THEN
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         NUMX = NUMX + NOBS(I,1)
C
C Now NOBS(I,2) = A(I,2)
C
         NOBS(I,2) = NTEMP(I,2)
         IF (NOBS(I,2).LT.NOBS(I,1)) THEN
            WRITE (LINE,300) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         NUMN = NUMN + NOBS(I,2)
C
C The p and 95% con. lims. are calculated
C
         CALL PHAT95 (ILIM, NOBS(I,1), NOBS(I,2), NOUT, PBOT(I),
     +                PHAT(I), PTOP(I))
C
C Now redefine NOBS(I,2) = N - y for chi-square test
C
         NOBS(I,2) = NOBS(I,2) - NOBS(I,1)
C
C T(i) is set to the third column A(I,3), i.e. the t(i) value
C
         IF (NCOL.EQ.3) THEN
            T(I) = A(I,3)
            IF (I.GT.1) THEN
               IF (T(I).LT.T(I - 1)) THEN
                  WRITE (LINE,400) I, I - 1
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
            ENDIF
         ENDIF
      ENDDO
C
C Check for the singular cases
C
      IF (NUMN.LE.0 .OR. NUMX.LE.0 .OR. NUMN.LE.NUMX) THEN
         CALL PUTFAT (INFO(9))
         RETURN
      ENDIF
C
C The overall p estimate is now calculated
C
      CALL PHAT95 (ILIM, NUMX, NUMN, NOUT, PLOW, PBIG, PHIGH)
C
C The likelihood ratio first in case NOBS gets overwritten by G01AFF
C
      DIFF = ONE - PBIG
      PLOG = LOG(PBIG)
      QLOG = LOG(DIFF)
      SUM1 = ZERO
      DO I = 1, NROW
C********************************************************
C The next calculation seems to be unreliable
C so it was replaced by a string of logs on 22/4/96
C
C        BOT = PHAT(I)**NOBS(I,1)*(ONE - PHAT(I))**NOBS(I,2)
C        TOP = PBIG**NOBS(I,1)*(DIFF)**NOBS(I,2)
C        RATIO = TOP/BOT
C        SUM1 = SUM + LOG(RATIO)
C***********************************************************
C********SUM1 = SUM1 + A(I,1)*(PLOG - LOG(A(I,1)) + LOG(A(I,2)))
C****+              + (A(I,2) - A(I,1))*(QLOG - LOG(ONE - A(I,1)/A(I,2)))
C
         TOP = A(I,1)
         IF (TOP.LT.HALF) TOP = HALF
         BOT = A(I,2)
         IF (BOT - TOP.LT.HALF) TOP = BOT - HALF
         DIFF = BOT - TOP
         SUM1 = SUM1 + TOP*(PLOG - LOG(TOP) + LOG(BOT))
     +               + DIFF*(QLOG - LOG(DIFF)  + LOG(BOT))
      ENDDO
      CHISQ1 = - TWO*SUM1
      IF (CHISQ1.LT.ZERO) CHISQ1 = ZERO
      NDF1 = NROW - 1
      IFAIL = 1
      P1 = G01ECF$(UPPER, CHISQ1, DBLE(NDF1), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01ECF/ANOVAP')
      CALL PLEVEL (P1, WORD1)
C
C Chi-square test on NOBS ... A will be overwritten now and maybe NOBS
C
      INOB = NRMAX
      IPRED = NRMAX
      M = NROW + 1
      N = 3
      NUM = 0
      IFAIL = 1
      CALL G01AFF$(INOB, IPRED, M, N, NOBS, NUM, A, CHISQ2, P,
     +             NPOS, NDF2, M1, N1, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01AFF/ANOVAP')
C
C Test to see if shrinkage has occurred and NOBS has been changed
C
      IF (M1.NE.NROW .OR. N1.NE.2) CALL PUTADV (INFO(10))
C
C The special case of a 2 by 2 Fisher exact test if NUM > 0 and CHISQ2
C is not returned by G01AFF so CHISQ2 has to be calculated
C
      IF (NUM.GT.0) THEN
         A11 = DBLE(NOBS(1,1))
         A12 = DBLE(NOBS(1,2))
         A21 = DBLE(NOBS(2,1))
         A22 = DBLE(NOBS(2,2))
         C1 = A11 + A21
         C2 = A12 + A22
         R1 = A11 + A12
         R2 = A21 + A22
         SUM1 = R1 + R2
         NDF2 = 1
         CHISQ2 = SUM1*((ABS(A11*A22 - A12*A21) -
     +           (SUM1/2.0D+00))**2)/(C1*C2*R1*R2)
      ENDIF
      IFAIL = 1
      P2 = G01ECF$(UPPER, CHISQ2, DBLE(NDF2), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01ECF/ANOVAP')
      CALL PLEVEL (P2, WORD2)
      ABORT = .FALSE.
C
C Restore A 
C      
      DO I = 1, NROW
         DO J = 1, 3
            A(I,J) = ASAV(I,J)
         ENDDO   
         T(I) = A(I,3) 
         X(I) = A(I,2)
      ENDDO    
      DEALLOCATE (ASAV)    
C
C Format statements
C      
  100 FORMAT (
     +'Must have #rows >=2 and 2 or 3 columns (i.e. y,N or y,N,x')
  200 FORMAT ('y < 0 at data item number',I5,' ... Must have y >= 0')
  300 FORMAT ('y > N at data item number',I5,' ... Must have y =< N' )
  400 FORMAT ('x(',I5,') < x(',I5,') ... Must be in increasing order')
      END
C
C
