C
C META01: binomial probabilities and limits 
C NNTSIG: confidence limits for NNT
C METACL: significance, limit types and base10 selected individually
C CLMETA: significance, limit types and base10 selection from grouped possibilities
C
      SUBROUTINE META01 (NCOL, NGRAF, NIN, NOBS, NOUT, NRMAX,
     +                   NROW, NTEMP,
     +                   A, ATEMP, PBOT, PBOT1, PHAT, PHAT1, PTOP,
     +                   PTOP1, T, T1, X,
     +                   FNAME, TITLE,
     +                   SUPPLY)
C
C ACTION : Analysis of proportions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/11/95
C ADVICE : Be very careful in the way that the arrays are redefined
C          to re-use storage. The logical variables FIRST1/2/3/4
C          and FILED1/2 are vital to the overall printing control.
C          27/08/2021 added E_NUMBERS and E_FORMATS, etc.
C          30/08/2021 increased line to len = 120 and edited formats 900 and 1150
C
C          NCOL: (input/output) depending on SUPPLY
C         NGRAF: (input/unchanged) Dimension
C           NIN: (input/unchanged) Unconnected unit for data input
C          NOBS: Workspace
C          NOUT: (input/unchanged) Unit connected for results
C         NRMAX: (input/unchanged) Dimension
C          NROW: (iput/output) depending on SUPPLY
C         NTEMP: workspace
C             A: (input/output) depending on SUPPLY
C         ATEMP: (input/output) depending on SUPPLY
C          PBOT: Workspace
C         PBOT1: Workspace
C          PHAT: Workspace
C         PHAT1: Workspace
C          PTOP: Workspace
C         PTOP1: Workspace
C             T: Workspace
C            T1: workspace
C             X: Workspace
C         FNAME: (input/output) depending on SUPPLY
C         TITLE: (input/output) depending on SUPPLY
C        SUPPLY: (input/unchanged) as follows:
C                SUPPLY = .TRUE. then supply NCOL, NROW, FNAME, TITLE then
C                ATEMP is read off FNAME and transformed into A
C
C Internal counters:
C          NUMN: Total no. of N
C          NUMX: Total no. of X
C
C Documentation:
C          Standard errors from Agresti. An Introduction to Categorical
C          Data Analysis. Wiley 1996. Each matrix nij is supposed 2 x 2
C          se(p1 - p2)   = z_alpha/2*sqrt[p1(1-p1)/N1 + p2(1-p2)/N2]
C          se[log(p1/p2) = z_alpha/2*sqrt[(1-p1)/(N1p1) + (1-p2)/(n2p2)]
C          se[logodds]   = z_alpha/2*sqrt[1/n11 + 1/n12 + 1/n21 + 1/n22]
C                          add 0.01 to all if any nij small (< 1)
C
C Revisions:
C          30/06/1999 option to redefine T if only two columns supplied
C                     and altered data input for arbitrary matrix format.
C                     Also options for alternative curve-fitting weights.
C          06/08/1999 added log odds plot
C          23/01/2000 added all possible diferences
C          28/01/2000 added NKTEMP, ATEMP and NTEMP to make sure that
C                     maximum dimensions are not exceeded and that all
C                     data are correct and not overwritten by the call
C                     to G01AFF. Also added code for log odds ratios and
C                     correcting for zero entry cells.
C          07/02/2001 added CHOP80
C          14/06/2001 introduced AGAIN and rearranged menus
C          21/05/2002 redefined x as y to agree with GLIM convention
C          21/12/2004 added overall p and confidence limits to plots
C          10/01/2005 made graph title arrays for call to gkshb4
C          06/06/2005 extensive revision to delete the meta analysis option,
C                     transfer data input to meta00, and allow row suppression
C          20/06/2005 corrected error with log_e, added VAR and ADDON, improved
C                     output, made log_e the default, and many other improvements
C          14/02/2006 added NCOL, NROW, FNAME, TITLE, and SUPPLy to argument list
C          17/04/2012 corrected error with NUMDEC = 11 > numopt after graphics 
C          10/01/2013 added INTENTS and calculation for NNT
C          13/08/2014 replaced NNT=1/d by NNT=1/|d| and made log_10 the default
C          24/04/2016 added flag for NNH and approximate 95%cl for NNT 
C          29/12/2020 re-set FIRST1 etc. when log type changes and added PTEMP, STEMP, XTEMP and
C                     call to G01EAF for p-values in difference between parameters  
C          31/12/2020 also added p-values to log options
C          19/01/2021 extensive re-write to agree with META03
C          26/01/2021 called METACL with ISEND = 2 to only change the parameter limits type because ILIM is INTENT (IN) 
C          02/02/2021 major changes as follows assumimg the corresponding changes to META00 namely:
C                     A is y, N, x and NOBS is y, N - y and ATEMP is y, N - y, N  
C                     replaced METACL by CLMETA and ILIM removed from argument list
C                     ILIM, JTYPE and BASE10 are now saved internally and can be changed
C          13/02/2021 corrected code for log odds ratio
C
C           
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGRAF, NIN, NOUT, NRMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NOBS(NRMAX,3), 
     +                                       NROW, NTEMP(NRMAX,3)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,3), ATEMP(NRMAX,4), 
     +                                       PBOT(NRMAX), PBOT1(NGRAF),
     +                                       PHAT(NRMAX), PHAT1(NGRAF),
     +                                       PTOP(NRMAX), PTOP1(NGRAF),
     +                                       T(NRMAX), T1(NGRAF),
     +                                       X(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Locals
C
      INTEGER    ILIM, ITEMP, JTEMP, KMAX
      INTEGER    I, J, JCOLOR, JTYPE
      INTEGER    ISEND
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ICOUNT, NUMN, NUMX
      INTEGER    IFAIL, ITYPE, NDF1, NDF2, NNT
      INTEGER    NSWAP
      PARAMETER (NSWAP = 5)
      INTEGER    K1, L1, L2, L3, L4, M1, M2, M3, M4, N0, N1, N2, N3
      PARAMETER (K1 = 1, L1 = 0, L3 = 0, M2 = 0, M4 = 0, N0 = 0, N2 = 2)
      INTEGER    NPLOTS
      DOUBLE PRECISION PTEMP, STEMP, XTEMP
      DOUBLE PRECISION G01EAF$
      DOUBLE PRECISION X2(N2), X3(N2), X4(N2), YH3(N2), YL3(N2), Y2(N2),
     +                 Y3(N2), Y4(N2)
      DOUBLE PRECISION Y2_T(N2), Y3_T(N2), YH3_T(N2), YL3_T(N2),
     +                 Y4_T(N2)
      DOUBLE PRECISION CHISQ1, CHISQ2, DIFF1, PBIG, PLOW, PHIGH, 
     +                 P1, P2, VAR
      DOUBLE PRECISION A11, A12, A21, A22, DNEW, FACTOR, PNEW, PSAV
      DOUBLE PRECISION BLOG, P_HIGH, P_LOW
      DOUBLE PRECISION BOT, DIFF, RATIO, SDIFF, TOP, VDIFF, ZVAL
      DOUBLE PRECISION XBOT, XMID, XTOP
      DOUBLE PRECISION ADDON, ZERO, HALF, ONE, TWO, FOUR, TEN, F100,
     +                 VMIN
      PARAMETER (ADDON = 0.01D+00, ZERO = 0.0D+00, HALF = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00, 
     +           TEN = 10.0D+00, F100 = 100.0D+00,
     +           VMIN = 1.0D-12)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMIN = 1.0D-10, PMAX = ONE - PMIN)
      DOUBLE PRECISION DMINUS, DPLUS
      PARAMETER (DPLUS = 1.0D-08, DMINUS = -DPLUS)
      DOUBLE PRECISION G01FAF$
      CHARACTER (LEN = 61) APPROX, ERROR, EXACT
      PARAMETER (
     + EXACT =
     +'p_hat=y/N with exact unsymmetrical small sample limits       ',
     + ERROR =
     +'*** Indicates parameter limits outside the range (0,1)       ', 
     +APPROX =
     +'p_app=(y+2)/(N+4) with approximate central limits [p_app(+/-)')
      CHARACTER (LEN = 120) LINE
      CHARACTER (LEN = 100) INFO(30), TEXT(30)
      CHARACTER (LEN = 80 ) CHOP80  
      CHARACTER (LEN = 23 ) WORD1, WORD2
      CHARACTER (LEN = 16 ) WORD16
      CHARACTER (LEN = 13 ) D13(3), SHOWLJ, SHOWRJ 
      CHARACTER (LEN = 12 ) FORM12, WORD12, WORD12_ICOUNT, WORD12_NDF1,
     +                      WORD12_NDF2, WORD12_NROW, WORD12_NUMN,
     +                      WORD12_NUMX
      CHARACTER (LEN = 10 ) WORD10
      CHARACTER (LEN = 8  ) WORD8
      CHARACTER (LEN = 4  ) STARS
      CHARACTER (LEN = 7  ) WORD7
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
C
C Note: if CIPHER is not length 15 then A15 must be changed in format 1200
C
      CHARACTER (LEN = 15) CIPHER, CIPHER1
      CHARACTER (LEN = 30) CYPHER
C
C ***********************************************************************
C Start of plot titles ..................................................
C
      CHARACTER (LEN = 30) PTITLE, XTITLE, YTITLE
C
C Plot titles for p(x) in call to GKSEB4
C
      PARAMETER (PTITLE = 'p-estimated as a function of x',
     +           XTITLE = 'x (control variable)',
     +           YTITLE = 'p(x) with con.lims.')
C
C Primary plot titles for Log Odds in call to GKSHB4
C
      CHARACTER (LEN = 30) PTITL1, YTITL1, YTITL2
      PARAMETER (PTITL1 = 'Log Odds with confidence lims.',
     +           YTITL1 = 'log_e[y/(N - y)]',
     +           YTITL2 = 'log_10[y/(N - y)]')
C
C Secondary plot titles for Log Odds in call to SMPLOT from GKSHB4
C
      CHARACTER (LEN = 30) PTITL3, YTITL5
      PARAMETER (PTITL3 = 'Odds with confidence lims.',
     +           YTITL5 = 'y/(N - y)')
C
C Arrays for GKSHB4
C
      CHARACTER (LEN = 30) PTEXT(2), XTEXT(2), YTEXT(2)
C
C End of plot titles ..................................................
C *********************************************************************
C
      CHARACTER (LEN = 1) TAIL
      PARAMETER (TAIL = 'C')
      CHARACTER (LEN = 40) EXTRA
      PARAMETER (EXTRA =
     +', alternate rows: logs, then antilogs')
      CHARACTER (LEN = 50) IWARNU
      PARAMETER (IWARNU =
     +'*** 0.01 added to all cells for next calculation')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    FIRST1, FIRST2, FIRST3, FIRST4, FILED1, FILED2
      LOGICAL    BASE10, REPEET, SUPRC
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SIGNIF
      LOGICAL    ABORT, APPROX_WARN, LTEMP, NEWDAT, NNT_WARN
      LOGICAL    AXES, GSAVE, META
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE., META = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   G01EAF$
      EXTERNAL   G01FAF$
      EXTERNAL   LBOX01, LBOX02, PUTFAT, PUTIFA, TABLE1, GKSEB4, GETRM1,
     +           NX3FIL, GKSHB4, CHOP80, META00, FORM12, NNTSIG, TRIML2
      EXTERNAL   REVPRO, CLMETA, PHAT95
      INTRINSIC  ABS, DBLE, LOG, SQRT, LOG10, MIN, EXP, NINT
      SAVE       BASE10, ILIM, JTYPE
      SAVE       PSAV
      SAVE       ICOUNT
      DATA       BASE10 / .TRUE. /
      DATA       PSAV / HALF /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      DATA       ICOUNT / 0 /
      DATA       JTYPE / 3 /
      
      E_NUMBERS = E_FORMATS()
C
C Initialise the fixed plot titles
C
      XTEXT(1) = XTITLE
      XTEXT(2) = XTITLE
      CYPHER = BLANK
      ISEND = 0
      CALL CLMETA (ISEND, ILIM, JTYPE,
     +             BASE10)
C
C Part 1: Read in the data matrix A
C ======
C
      KMAX = 1000
      WORD12 = FORM12(KMAX)
      WRITE (INFO,100) WORD12
      IF (SUPPLY) THEN
         NEWDAT = .FALSE.
      ELSE
         NEWDAT = .TRUE.
      ENDIF
      SUPRC = .FALSE.
      CALL META00 (ICOUNT, ILIM, NCOL, NDF1, NDF2, NIN, NOBS, NOUT,
     +             NRMAX, NROW, NTEMP, NUMN, NUMX,
     +             A, ATEMP, CHISQ1, CHISQ2, PBIG, PBOT, PHAT, PHIGH,
     +             PLOW, PTOP, P1, P2, T, X,
     +             FNAME, INFO, TITLE, WORD1, WORD2,
     +             ABORT, META, NEWDAT, SUPRC)
      IF (ABORT) RETURN
      IF (NROW.LT.2) THEN
         WRITE (LINE,200)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      IF (WORD1.EQ.BLANK) THEN
         NUMBLD(11) = 0
      ELSE
         NUMBLD(11) = 1
      ENDIF
      IF (WORD2.EQ.BLANK) THEN
         NUMBLD(13) = 0
      ELSE
         NUMBLD(13) = 1
      ENDIF
C
C Set FIRST1/2/3/4 and FILED1/2 then output results to the log file
C
      FIRST1 = .TRUE.
      FIRST2 = .TRUE.
      FIRST3 = .TRUE.
      FIRST4 = .TRUE.
      FILED1 = .FALSE.
      FILED2 = .FALSE.
      ICOUNT = ICOUNT + 1
      WORD12_ICOUNT = FORM12(ICOUNT)
      WORD12_NDF1 = FORM12(NDF1)
      WORD12_NDF2 = FORM12(NDF2)
      WORD12_NROW = FORM12(NROW)
      WORD12_NUMN = FORM12(NUMN)
      WORD12_NUMX = FORM12(NUMX)
      IF (E_NUMBERS) THEN
         WRITE (NOUT,500) WORD12_ICOUNT,
     +                    TITLE, TRIM(WORD12_NROW), TRIM(WORD12_NUMX),
     +                    TRIM(WORD12_NUMN),
     +                    PBIG, ILIM, PLOW, ILIM, PHIGH, CHISQ1,
     +                    WORD12_NDF1, P1, WORD1, CHISQ2, WORD12_NDF2,
     +                    P2, WORD2
      ELSE
         D13(1) = SHOWLJ(CHISQ1)
         D13(2) = SHOWLJ(CHISQ2) 
         WRITE (NOUT,550) WORD12_ICOUNT,
     +                    TITLE, TRIM(WORD12_NROW), TRIM(WORD12_NUMX),
     +                    TRIM(WORD12_NUMN),
     +                    PBIG, ILIM, PLOW, ILIM, PHIGH, TRIM(D13(1)),
     +                    WORD12_NDF1, P1, WORD1, TRIM(D13(2)),
     +                    WORD12_NDF2, P2, WORD2

       ENDIF 
C
C Calculate Z_alpha/2
C
      DIFF = DBLE(ILIM)/F100
      IFAIL = 1
      ZVAL = G01FAF$(TAIL, DIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FAF/META01')
C
C Initialise all temporary variables
C
       L2 = 0
       L4 = 0
       M1 = 5
       M3 = 7
       DO I = 1, 2
          X2(I) = ZERO
          X3(I) = ZERO
          X4(I) = ZERO
          YH3(I) = ZERO
          YH3_T(I) = ZERO
          YL3(I) = ZERO
          YL3_T(I) = ZERO
          Y2(I) = ZERO
          Y3(I) = ZERO
          Y4(I) = ZERO
          Y2_T(I) = ZERO
          Y3_T(I) = ZERO
          Y4_T(I) = ZERO
       ENDDO
C
C Part 2: main branch point to examine data, display table, file or plot
C ======================================================================
C
      REPEET = .TRUE.
      NUMDEC = 1
      DO WHILE (REPEET)
        
        IF (BASE10) THEN 
            BLOG = LOG10(EXP(ONE))
         ELSE
            BLOG = ONE
         ENDIF
         IF (E_NUMBERS) THEN
            IF (NROW.LE.NSWAP) THEN
               WRITE (TEXT,600) WORD12_ICOUNT,
     +                          CHOP80(TITLE), TRIM(WORD12_NROW),
     +                          TRIM(WORD12_NUMX), TRIM( WORD12_NUMN),
     +                          PBIG, ILIM, PLOW,
     +                          ILIM, PHIGH, CHISQ1, WORD12_NDF1, P1,
     +                          WORD1,
     +                          CHISQ2, WORD12_NDF2, P2, WORD2, ILIM, 
     +                          ILIM, ILIM, ILIM, ILIM
             ELSE
                WRITE (TEXT,650) WORD12_ICOUNT,
     +                           CHOP80(TITLE), TRIM(WORD12_NROW),
     +                           TRIM(WORD12_NUMX), TRIM( WORD12_NUMN),
     +                           PBIG, ILIM, PLOW,
     +                           ILIM, PHIGH, CHISQ1, WORD12_NDF1, P1,
     +                           WORD1,
     +                           CHISQ2, WORD12_NDF2, P2, WORD2, ILIM,
     +                           ILIM, ILIM, ILIM, ILIM
            ENDIF
         ELSE 
            IF (NROW.LE.NSWAP) THEN
               D13(1) = SHOWLJ(CHISQ1)
               D13(2) = SHOWLJ(CHISQ2) 
               WRITE (TEXT,610) WORD12_ICOUNT,
     +                          CHOP80(TITLE), TRIM(WORD12_NROW),
     +                          TRIM(WORD12_NUMX), TRIM( WORD12_NUMN),
     +                          PBIG, ILIM, PLOW,
     +                          ILIM, PHIGH, TRIM(D13(1)), WORD12_NDF1,
     +                          P1, WORD1,
     +                          TRIM(D13(2)), WORD12_NDF2, P2, WORD2,
     +                          ILIM, ILIM, ILIM, ILIM, ILIM
             ELSE
                WRITE (TEXT,660) WORD12_ICOUNT,
     +                           CHOP80(TITLE), TRIM(WORD12_NROW),
     +                           TRIM(WORD12_NUMX), TRIM( WORD12_NUMN),
     +                           PBIG, ILIM, PLOW,
     +                           ILIM, PHIGH, TRIM(D13(1)), WORD12_NDF1,
     +                           P1, WORD1,
     +                           TRIM(D13(2)), WORD12_NDF2, P2, WORD2,
     +                           ILIM, ILIM, ILIM, ILIM, ILIM
            ENDIF 
         ENDIF  

         
         NUMOPT = 10
         NSTART = 15
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 1
         NUMBLD(3) = 1
         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF   
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(3) = 0
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Table and output of p-hat to file if FIRST1 = .TRUE.
C
            JCOLOR = 15
            CALL TABLE1 (JCOLOR, 'OPEN')
C
C Exact
C           
            IF (JTYPE.EQ.1 .OR. JTYPE.EQ.3) THEN   
               IF (FIRST1) THEN
                  WRITE (NOUT,'(A)') BLANK
                  WRITE (NOUT,'(A)') EXACT
                  WRITE (NOUT,700) ILIM, ILIM
               ENDIF
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, EXACT)
               WRITE (LINE,700) ILIM, ILIM
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = 0
               DO I = 1, NROW
                  IF (FIRST1) WRITE (NOUT,800) NTEMP(I,1), NTEMP(I,2),
     +                                         PBOT(I), PHAT(I), PTOP(I)
                  WRITE (LINE,800) NTEMP(I,1), NTEMP(I,2), PBOT(I),
     +                             PHAT(I), PTOP(I)
                 CALL TABLE1 (JCOLOR, LINE)
               ENDDO
            ENDIF
C
C Approximate
C           
            IF (JTYPE.EQ.2 .OR. JTYPE.EQ.3) THEN
               APPROX_WARN = .FALSE.
               WRITE (WORD8,'(I2,A)') ILIM, '%limit'
               IF (FIRST1) THEN
                  WRITE (NOUT,'(A)') BLANK
                  WRITE (NOUT,'(A)') APPROX//WORD8//']'
                  WRITE (NOUT,750) ILIM, ILIM, WORD8
               ENDIF    
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, BLANK)
               CALL TABLE1 (JCOLOR, APPROX//WORD8//']')
               WRITE (LINE,750) ILIM, ILIM, WORD8
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = 0 
               DO I = 1, NROW
                  DNEW = DBLE(NTEMP(I,2)) + FOUR
                  PNEW = (DBLE(NTEMP(I,1)) + TWO)/DNEW   
                  FACTOR = ZVAL*SQRT(PNEW*(ONE - PNEW)/DNEW)  
                  P_LOW = PNEW - FACTOR
                  P_HIGH = PNEW + FACTOR
                  IF (P_LOW.LT.ZERO .OR. P_HIGH.GT.ONE) THEN
                     STARS = ' ***'  
                     APPROX_WARN = .TRUE.
                  ELSE
                     STARS = BLANK
                  ENDIF      
                  IF (FIRST1) WRITE (NOUT,850) NTEMP(I,1), NTEMP(I,2),
     +                                         P_LOW, PNEW, P_HIGH,
     +                                         FACTOR, STARS
                  WRITE (LINE,850) NTEMP(I,1), NTEMP(I,2),
     +                             P_LOW, PNEW, 
     +                             P_HIGH, FACTOR, STARS
                 CALL TABLE1 (JCOLOR, LINE)
               ENDDO
               IF (APPROX_WARN) THEN
                  IF (FIRST1) WRITE (NOUT,'(A)') ERROR
                  JCOLOR = 4 
                  CALL TABLE1 (JCOLOR, ERROR) 
               ENDIF   
            ENDIF
            CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Set FIRST1 = .FALSE. to prevent second copy
C
            FIRST1 = .FALSE.
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Table and output of p-delta to file if FIRST2 = .TRUE.
C
            NNT_WARN = .FALSE. 
            IF (NROW.EQ.1) THEN
               CALL PUTFAT (INFO(11))
            ELSEIF (NROW.GT.KMAX) THEN
               CALL PUTFAT (INFO(12))
            ELSE
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               LINE =
     +'d(i,j) = p_hat(i) - p_hat(j), NNT = 1/|d(i,j)|'
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               WRITE (LINE,900) ILIM, ILIM, ILIM
               CALL TABLE1 (JCOLOR, LINE)
               IF (FIRST2) THEN
                  WRITE (NOUT,'(A)') BLANK
                  LINE =
     +'d(i,j) = p_hat(i) - p_hat(j), NNT = 1/|d(i,j)|'
                  WRITE (NOUT,'(A)') LINE
                  WRITE (NOUT,900) ILIM, ILIM, ILIM
               ENDIF
               JCOLOR = 0
               IF (NROW.LE.NSWAP) THEN
                  ITEMP = 1
               ELSE
                  ITEMP = 2
               ENDIF      
               DO I = 1, NROW - 1, ITEMP
                  IF (NROW.LE.NSWAP) THEN
                     JTEMP = NROW
                  ELSE
                     JTEMP = I + 1
                  ENDIF      
                  DO J = I + 1, JTEMP
                     IF (A(I,2).GT.ZERO .AND.
     +                   A(J,2).GT.ZERO) THEN
                        TOP = PHAT(I)*(ONE - PHAT(I))
                        BOT = A(I,2)
                        VDIFF = TOP/BOT
                        TOP = PHAT(J)*(ONE - PHAT(J))
                        BOT = A(J,2)
                        VDIFF = VDIFF + TOP/BOT
                        VAR = VDIFF
                        IF (VAR.LT.VMIN) VAR = VMIN
                        STEMP = SQRT(VAR)
                        SDIFF = ZVAL*STEMP
                        DIFF = PHAT(I) - PHAT(J)
                        XTEMP = DIFF/STEMP
                        IFAIL = 1
                        PTEMP = G01EAF$('S', XTEMP, IFAIL)
                        IF (ABS(DIFF).GE.DPLUS) THEN
                           DIFF1 = DIFF
                        ELSE
                           IF (DIFF.LE.ZERO) THEN
                              DIFF1 = DMINUS
                           ELSE
                              DIFF1 = DPLUS
                           ENDIF
                        ENDIF
                        BOT = DIFF - SDIFF
                        TOP = DIFF + SDIFF
                        SIGNIF = .TRUE.
                        IF (BOT.GE.ZERO) THEN
                           WRITE (CIPHER,1000) I, J!p(i) > p(j)
                           CIPHER1 = CIPHER
                           CALL TRIML2 (CIPHER1)
                        ELSEIF (TOP.LE.ZERO) THEN
                           WRITE (CIPHER,1100) I, J!p(i) < p(j)
                           CIPHER1 = CIPHER
                           CALL TRIML2 (CIPHER1)
                        ELSE
                           SIGNIF = .FALSE.
                           CIPHER = 'Not significant'
                           CIPHER1 = CIPHER
                        ENDIF
                        NNT = NINT(ONE/ABS(DIFF1))
                        IF (NNT.GT.999999) THEN
                           WORD7 = '>999999'
                        ELSE
                           WRITE (WORD7,'(I7)') NNT
                        ENDIF 
                        DIFF = PHAT(I)- PHAT(J)!re-define DIFF      
                        CALL NNTSIG (NNT,
     +                               BOT, DIFF, TOP,
     +                               CYPHER,
     +                               SIGNIF) 
                        IF (INDEX(CYPHER,'NNH').GT.0 .OR.
     +                      INDEX(CYPHER,'*.*').GT.0 .OR.
     +                      INDEX(CYPHER,'NC') .GT.0) THEN
                           NNT_WARN = .TRUE. 
                        ELSE
                           NNT_WARN = .FALSE.
                        ENDIF                             
                        IF (FIRST2) WRITE (NOUT,1150) I, J, BOT, DIFF,
     +                                                TOP, CIPHER1,
     +                                                PTEMP, VAR,
     +                                                WORD7, CYPHER 
                        WRITE (LINE,1150) I, J, BOT, DIFF, TOP, CIPHER1,
     +                                    PTEMP, VAR, WORD7, CYPHER
                        CALL TABLE1 (JCOLOR, LINE)
                        CYPHER = BLANK
                     ENDIF
                  ENDDO
               ENDDO
               IF (NNT_WARN) THEN
                  LINE =
     +'p_sig. = significance, NNH = Number needed to harm, '//
     +'NS = Not significant, NC = Not calculated'
                  JCOLOR = 4
                  CALL TABLE1 (JCOLOR, LINE)
                  WRITE (NOUT,'(A)') LINE
               ENDIF   
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Set FIRST2 = .FALSE. to prevent second copy
C
               FIRST2 = .FALSE.
            ENDIF
            NUMDEC = 3
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Table and output of log p-ratios to file if FIRST3 = .TRUE.
C
            IF (NROW.EQ.1) THEN
               CALL PUTFAT (INFO(11))
            ELSEIF (NROW.GT.KMAX) THEN
               CALL PUTFAT (INFO(12))
            ELSE
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               IF (BASE10) THEN
                  LINE = 'L(i,j) = log_10(p_hat(i)/p_hat(j))'//EXTRA
               ELSE
                  LINE = 'L(i,j) = log_e(p_hat(i)/p_hat(j))'//EXTRA
               ENDIF
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               WRITE (LINE,1400) ILIM, ILIM
               CALL TABLE1 (JCOLOR, LINE)
               IF (FIRST3) THEN
                  WRITE (NOUT,'(A)') BLANK
                  IF (BASE10) THEN
                     LINE = 'L(i,j) = log_10(p_hat(i)/p_hat(j))'//EXTRA
                  ELSE
                     LINE = 'L(i,j) = log_e(p_hat(i)/p_hat(j))'//EXTRA
                  ENDIF
                  WRITE (NOUT,'(A)') LINE
                  WRITE (NOUT,1400) ILIM, ILIM
               ENDIF
               JCOLOR = 0
               IF (NROW.LE.NSWAP) THEN
                  ITEMP = 1
               ELSE
                  ITEMP = 2
               ENDIF      
               DO I = 1, NROW - 1, ITEMP
                  IF (NROW.LE.NSWAP) THEN
                     JTEMP = NROW
                  ELSE
                     JTEMP = I + 1
                  ENDIF      
                  DO J = I + 1, JTEMP
                     IF (PHAT(I).GE.PMIN .AND. PHAT(J).GE.PMIN) THEN
                        TOP = ONE - PHAT(I)
                        BOT = A(I,2)*PHAT(I)
                        VDIFF = TOP/BOT
                        TOP = ONE - PHAT(J)
                        BOT = A(J,2)*PHAT(J)
                        VDIFF = VDIFF + TOP/BOT
                        VAR = VDIFF
                        IF (VAR.LT.VMIN) VAR = VMIN
                        STEMP = BLOG*SQRT(VAR)
                        SDIFF = ZVAL*STEMP
                        RATIO = BLOG*LOG(PHAT(I)/PHAT(J))
                        XTEMP = RATIO/STEMP
                        IFAIL = 1
                        PTEMP = G01EAF$('S', XTEMP, IFAIL)
                        BOT = RATIO - SDIFF
                        TOP = RATIO + SDIFF
                        IF (BOT.GE.ZERO) THEN
                           WRITE (CIPHER,1000) I, J
                           CIPHER1 = CIPHER
                           CALL TRIML2 (CIPHER1)
                        ELSEIF (TOP.LE.ZERO) THEN
                           WRITE (CIPHER,1100) I, J
                           CIPHER1 = CIPHER
                           CALL TRIML2 (CIPHER1)
                        ELSE
                           CIPHER = 'Not significant'
                           CIPHER1 = CIPHER
                        ENDIF
                        IF (E_NUMBERS) THEN
                           IF (FIRST3) WRITE (NOUT,1200) I, J, BOT,
     +                                                   RATIO, TOP,
     +                                                   PTEMP, CIPHER1,
     +                                                   VAR
                           WRITE (LINE,1200) I, J, BOT, RATIO, TOP,
     +                                       PTEMP, CIPHER, VAR
                        ELSE
                           D13(1) = SHOWRJ(BOT)
                           D13(2) = SHOWRJ(RATIO)
                           D13(3) = SHOWRJ(TOP)
                           IF (FIRST3) WRITE (NOUT,1250) I, J, D13(1),
     +                                        D13(2), D13(3), PTEMP, 
     +                                        CIPHER1, VAR
                           WRITE (LINE,1250) I, J, D13(1), D13(2),
     +                                       D13(3), PTEMP, 
     +                                       CIPHER, VAR

                        ENDIF  
                        CALL TABLE1 (JCOLOR, LINE)
                        IF (BASE10) THEN
                           XBOT = TEN**BOT
                           XMID = TEN**RATIO
                           XTOP = TEN**TOP
                        ELSE
                           XBOT = EXP(BOT)
                           XMID = EXP(RATIO)
                           XTOP = EXP(TOP)
                        ENDIF
                        WORD7 = '    ...'
                        WORD10 = '    ...   ' 
                        WORD16 = '     ...        ' 
                        IF (E_NUMBERS) THEN      
                           IF (FIRST3) WRITE (NOUT,1300) WORD7, WORD7, 
     +                     XBOT, XMID, XTOP, WORD16, WORD10
                           WORD7 = '       ' 
                           WORD10 = '          '       
                           WORD16 = '               '      
                           WRITE (LINE,1300) WORD7, WORD7, 
     +                     XBOT, XMID, XTOP, WORD16, WORD10
                        ELSE
                           D13(1) = SHOWRJ(XBOT)
                           D13(2) = SHOWRJ(XMID)
                           D13(3) = SHOWRJ(XTOP)    
                           IF (FIRST3) WRITE (NOUT,1350) WORD7, WORD7, 
     +                     D13(1), D13(2), D13(3), WORD16, WORD10
                           WORD7 = '       ' 
                           WORD10 = '          '       
                           WORD16 = '               ' 
                           WRITE (LINE,1350) WORD7, WORD7, 
     +                     D13(1), D13(2), D13(3), WORD16, WORD10
                        ENDIF  
                        CALL TABLE1 (JCOLOR, LINE)
                     ENDIF
                  ENDDO
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Set FIRST3 = .FALSE. to prevent second copy
C
               FIRST3 = .FALSE.
            ENDIF
            NUMDEC = 4
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Table and output of log odds ratios to file if FIRST4 = .TRUE.
C
            IF (NROW.EQ.1) THEN
               CALL PUTFAT (INFO(11))
            ELSEIF (NROW.GT.KMAX) THEN
               CALL PUTFAT (INFO(12))
            ELSE
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               IF (BASE10) THEN
                  LINE = 'LO(i,j) = log_10(odds ratio)'//EXTRA
               ELSE
                  LINE = 'LO(i,j) = log_e(odds ratio)'//EXTRA
               ENDIF
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               WRITE (LINE,1500) ILIM, ILIM
               CALL TABLE1 (JCOLOR, LINE)
               IF (FIRST4) THEN
                  WRITE (NOUT,'(A)') BLANK
                  IF (BASE10) THEN
                     LINE = 'LO(i,j) = log_10(odds ratio)'//EXTRA
                  ELSE
                     LINE = 'LO(i,j) = log_e(odds ratio)'//EXTRA
                  ENDIF
                  WRITE (NOUT,'(A)') LINE
                  WRITE (NOUT,1500) ILIM, ILIM
               ENDIF
               JCOLOR = 0
               IF (NROW.LE.NSWAP) THEN
                  ITEMP = 1
               ELSE
                  ITEMP = 2
               ENDIF      
               DO I = 1, NROW - 1, ITEMP
                  IF (NROW.LE.NSWAP) THEN
                     JTEMP = NROW
                  ELSE
                     JTEMP = I + 1
                  ENDIF      
                  DO J = I + 1, JTEMP
                     A11 = A(I,1)
                     A12 = A(I,2)
                     A21 = A(J,1)
                     A22 = A(J,2)
                     IF (A11.LT.ONE .OR. A12.LT.ONE .OR.
     +                   A21.LT.ONE .OR. A22.LT.ONE) THEN
                         A11 = A11 + ADDON
                         A12 = A12 + TWO*ADDON
                         A21 = A21 + ADDON
                         A22 = A22 + TWO*ADDON
                         IF (FIRST4) WRITE (NOUT,'(A)') IWARNU
                         JCOLOR = 4
                         CALL TABLE1 (JCOLOR, IWARNU)
                         JCOLOR = 0
                     ENDIF
                     TOP = ONE/A11 + ONE/(A12 - A11)
                     BOT = ONE/A21 + ONE/(A22 - A21)
                     VDIFF = TOP + BOT
                     VAR = VDIFF
                     IF (VAR.LT.VMIN) VAR = VMIN
                     STEMP = BLOG*SQRT(VAR)
                     SDIFF = ZVAL*STEMP
                     TOP = PHAT(I)/(ONE - PHAT(I))
                     BOT = PHAT(J)/(ONE - PHAT(J))
                     RATIO = BLOG*LOG(TOP/BOT)
                     XTEMP = RATIO/STEMP
                     IFAIL = 1
                     PTEMP = G01EAF$('S', XTEMP, IFAIL)
                     BOT = RATIO - SDIFF
                     TOP = RATIO + SDIFF
                     IF (BOT.GE.ZERO) THEN
                        WRITE (CIPHER,1600) I, J
                        CIPHER1 = CIPHER
                        CALL TRIML2 (CIPHER1)
                     ELSEIF (TOP.LE.ZERO) THEN
                        WRITE (CIPHER,1700) I, J
                        CIPHER1 = CIPHER
                        CALL TRIML2 (CIPHER1)
                     ELSE
                        CIPHER = 'Not significant'
                        CIPHER1 = CIPHER
                     ENDIF
                     IF (E_NUMBERS) THEN
                        IF (FIRST4) WRITE (NOUT,1200) I, J, BOT, RATIO, 
     +                                                TOP, PTEMP, 
     +                                                CIPHER1, VAR
                        WRITE (LINE,1200) I, J, BOT, RATIO, TOP, PTEMP, 
     +                                    CIPHER, VAR
                     ELSE
                        D13(1) = SHOWRJ(BOT)
                        D13(2) = SHOWRJ(RATIO)
                        D13(3) = SHOWRJ(TOP)
                        IF (FIRST4) WRITE (NOUT,1250) I, J, D13(1), 
     +                                                D13(2), D13(3), 
     +                                                PTEMP,  CIPHER1,
     +                                                VAR
                        WRITE (LINE,1250) I, J, D13(1), D13(2), D13(3),
     +                                    PTEMP, CIPHER, VAR
                     ENDIF  
                     CALL TABLE1 (JCOLOR, LINE)
                     IF (BASE10) THEN
                        XBOT = TEN**BOT
                        XMID = TEN**RATIO
                        XTOP = TEN**TOP
                     ELSE
                        XBOT = EXP(BOT)
                        XMID = EXP(RATIO)
                        XTOP = EXP(TOP)
                     ENDIF
                     WORD7 = '    ...'
                     WORD10 = '    ...   ' 
                     WORD16 = '     ...       '
                     IF (E_NUMBERS) THEN
                        IF (FIRST4) WRITE (NOUT,1300) WORD7, WORD7,
     +                  XBOT, XMID, XTOP, WORD16, WORD10
                        WORD7 = '       ' 
                        WORD10 = '          '       
                        WORD16 = '               '     
                        WRITE (LINE,1300) WORD7, WORD7, 
     +                  XBOT, XMID, XTOP, WORD16, WORD10
                     ELSE
                        D13(1) = SHOWRJ(XBOT)
                        D13(2) = SHOWRJ(XMID)
                        D13(3) = SHOWRJ(XTOP)
                        IF (FIRST4) WRITE (NOUT,1350) WORD7, WORD7,
     +                  D13(1), D13(2), D13(3), WORD16, WORD10
                        WORD7 = '       ' 
                        WORD10 = '          '       
                        WORD16 = '               '     
                        WRITE (LINE,1350) WORD7, WORD7, 
     +                  D13(1), D13(2), D13(3), WORD16, WORD10
                     ENDIF  
                     CALL TABLE1 (JCOLOR, LINE)
                  ENDDO
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Set FIRST4 = .FALSE. to prevent second copy
C
               FIRST4 = .FALSE.
            ENDIF
            NUMDEC = 5
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: graphics
C
            IF (NCOL.EQ.2) THEN
               CALL PUTFAT (INFO(13))
            ELSE
               REPEET = .TRUE.
               DO WHILE (REPEET)
                  WRITE (TEXT,1800) ILIM
                  NUMOPT = 7
                  NUMDEC = NUMOPT
                  CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                         TEXT)
                  IF (NUMDEC.LT.NUMOPT) THEN
                     N1 = NROW
                     M1 = 5
                     M3 = 7
                     X2(1) = T(1) - ONE
                     X3(1) = T(1) - ONE
                     X4(1) = T(1) - ONE
                     X2(2) = T(NROW)
                     X4(2) = T(NROW)
                     Y2(1) = PLOW
                     Y3(1) = PBIG
                     Y4(1) = PHIGH
                     YH3(1) = PHIGH
                     YL3(1) = PLOW
                     L2 = 2
                     L4 = 0
                     IF (NUMDEC.EQ.1) THEN
                        L2 = 0
                     ELSEIF (NUMDEC.EQ.2) THEN
                        L2 = 2
                        Y2(1) = PBIG
                     ELSEIF (NUMDEC.EQ.3) THEN
                        Y2(1) = HALF
                     ELSEIF (NUMDEC.EQ.4) THEN
                        CALL GETRM1 (ZERO, PSAV, ONE, 'Value required')
                        Y2(1) = PSAV
                     ELSEIF (NUMDEC.EQ.5) THEN
                        L4 = 2
                     ELSEIF (NUMDEC.EQ.6) THEN
                        L2 = 2
                     ENDIF
                     Y2(2) = Y2(1)
                     Y4(2) = Y4(1)
                     IF (NUMDEC.LT.6) THEN
C
C Normal axes
C
                        CALL GKSEB4 (L1, L2, L3, L4,
     +                               M1, M2, M3, M4,
     +                               N1, N2, K1, N2,
     +                               T,  X2, X3, X4,
     +                               PTOP, YH3, PBOT, YL3,
     +                               PHAT, Y2, Y3, Y4,
     +                               PTITLE, XTITLE, YTITLE,
     +                               AXES, GSAVE)
                     ELSEIF (NUMDEC.EQ.6) THEN
C
C log odds so select non-extreme P-values
C
                        NPLOTS = 0
                        DO I = 1, MIN(NGRAF, N1)
                           IF (PBOT(I).GT.PMIN .AND.
     +                         PTOP(I).LT.PMAX) THEN
                               NPLOTS = NPLOTS + 1
                               T1(NPLOTS) = T(I)
                               PHAT1(NPLOTS) = PHAT(I)/(ONE - PHAT(I))
                               PBOT1(NPLOTS) = PBOT(I)/(ONE - PBOT(I))
                               PTOP1(NPLOTS) = PTOP(I)/(ONE - PTOP(I))
                           ENDIF
                        ENDDO
                        IF (NPLOTS.GT.0) THEN
                           X2(1) = T1(1)
                           X2(2) = T1(NPLOTS)
                           Y2_T(1) = ONE
                           Y2_T(2) = ONE
                           IF (YL3(1).GT.PMIN .AND.
     +                         YH3(1).LT.PMAX) THEN
                              N3 = 1
                              M3 = 7
                              X2(1) = T1(1) - ONE
                              X3(1) = T1(1) - ONE
                              Y3_T(1) = Y3(1)/(ONE - Y3(1))
                              YL3_T(1) = YL3(1)/(ONE - YL3(1))
                              YH3_T(1) = YH3(1)/(ONE - YH3(1))
                           ELSE
                              N3 = 0
                              M3 = 0
                           ENDIF
C ===========================================================================
C Note that GKSHB4 transforms YL1 = PBOT1, Y1 = PHAT1, YH1 = PTOP1, Y2 = ONE
C INTERNALLY to logs so output ascii files are ready to be
C transformed by SIMPLOT
C ITYPE = 1: log e
C ITYPE = 2: log 10
C ==========================================================================
                           PTEXT(1) = PTITL1
                           PTEXT(2) = PTITL3
                           IF (BASE10) THEN
                              YTEXT(1) = YTITL2
                              ITYPE = 2
                           ELSE
                              YTEXT(1) = YTITL1
                              ITYPE = 1
                           ENDIF
                           YTEXT(2) = YTITL5
                           CALL GKSHB4 (ITYPE,
     +                                  L1, L2, N0, N0,
     +                                  M1, N0, M3, N0,
     +                                  NPLOTS, N2, N3, N2,
     +                                  T1, X2, X3, X4,
     +                                  PTOP1, YH3_T, PBOT1, YL3_T,
     +                                  PHAT1, Y2_T, Y3_T, Y4_T,
     +                                  PTEXT, XTEXT, YTEXT,
     +                                  AXES, GSAVE)
                        ELSE
                           CALL PUTFAT (INFO(14))
                        ENDIF
                     ENDIF
                  ELSE
                     REPEET = .FALSE.
                  ENDIF
               ENDDO
               REPEET = .TRUE.
            ENDIF
            NUMDEC = 10
         ELSEIF (NUMDEC.EQ.6 .OR. NUMDEC.EQ.7) THEN
C
C NUMDEC = 6 or 7: Curve fitting file if NCOL = 3 and .NOT.FILED2
C
            IF (NUMDEC.EQ.6 .AND. FILED1) THEN
               CALL PUTFAT (INFO(15))
            ELSEIF (NUMDEC.EQ.7 .AND. FILED2) THEN
               CALL PUTFAT (INFO(15))
            ELSE
               IF (NUMDEC.EQ.6) THEN
                  FILED1 = .TRUE.
                  DO I = 1, NROW
                     X(I) = SQRT(PHAT(I)*(ONE - PHAT(I))/ATEMP(I,2))
                  ENDDO
               ELSEIF (NUMDEC.EQ.7) THEN
                  FILED2 = .TRUE.
                  DO I = 1, NROW
                     X(I) = ONE
                  ENDDO
               ENDIF
               CALL NX3FIL (NROW, T, PHAT, X)
            ENDIF
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
            ITEMP = ILIM
            JTEMP = JTYPE
            LTEMP = BASE10
            ISEND = 4
            CALL CLMETA (ISEND, ILIM, JTYPE,
     +                   BASE10)
            IF (ILIM.NE.ITEMP .OR. JTYPE.NE.JTEMP .OR. 
     +          BASE10.NEQV.LTEMP) THEN
               FIRST1 = .TRUE.
               FIRST2 = .TRUE.
               FIRST3 = .TRUE.
               FIRST4 = .TRUE.
            ENDIF 
            IF (ILIM.NE.ITEMP) THEN
               DIFF = DBLE(ILIM)/F100
               IFAIL = 1
               ZVAL = G01FAF$(TAIL, DIFF, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FAF/META01')
               DO I = 1, NROW
                  CALL PHAT95(ILIM, NOBS(I,1), NOBS(I,2), NOUT, PBOT(I),
     +                        PHAT(I), PTOP(I))
               ENDDO
            ENDIF   
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO (NOUT)   
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Input y,N data like binomial.tf2 (or y,N,x like binomial.tf3)'
     +/'Note: GLM-type data sets (i.e. x,y,N,s) are also acceptable'
     +/'Data table must have either 2, 3 or 4 columns'
     +/'...'
     +/'Maximum dimension exceeded in call to META01'
     +/'Sample size too large for array dimension'
     +/'Starting value required for X (i.e. plotting coordinates)'
     +/'s-values (i.e. weights) in column 4 have been ignored'
     +/'Singular data set ... No analysis possible'
     +/'Shrinkage of contingency table has taken place in G01AFF'
     +/'Analysis requires at least two rows'
     +/'Too many comparisons requested: number of rows > ', A
     +/'No values of t have been supplied'
     +/'Insufficient valid data'
     +/'Data have already been saved to file')
  200 FORMAT ('Must have at least 2 rows (cases)')
  500 FORMAT (
     + ' '
     +/'***'
     +/' '
     +/1X,'Analysis of binomial proportions',1X,A
     +/1X,'------------------------------------'
     +/1X,A
     +/1X,'To test H0: equal binomial p-values'
     +/1X,'Sample-size =',1X,A
     +/1X,'Overall sum of Y =',1X,A
     +/1X,'Overall sum of N =',1X,A
     +/1X,'Estimate of overall binomial parameter =',F9.6
     +/1X,'Lower ',I2,'% confidence limit =',F9.6
     +/1X,'Upper ',I2,'% confidence limit =',F9.6
     +/1X,'-2 log[lambda] (-2LL) =',1P,E13.5,', NDOF:',1X,A
     +/1X,'p = P(chi-sq. >= -2LL) =',0P,F7.4,1X,A
     +/1X,'chi-sq. test stat (C) =',1P,E13.5,', NDOF:',1X,A
     +/1X,'p = P(chi-sq. >= C) =',0P,F7.4,1X,A)
  550 FORMAT (
     + ' '
     +/'***'
     +/' '
     +/1X,'Analysis of binomial proportions',1X,A
     +/1X,'------------------------------------'
     +/1X,A
     +/1X,'To test H0: equal binomial p-values'
     +/1X,'Sample-size =',1X,A
     +/1X,'Overall sum of Y =',1X,A
     +/1X,'Overall sum of N =',1X,A
     +/1X,'Estimate of overall binomial parameter =',F9.6
     +/1X,'Lower ',I2,'% confidence limit =',F9.6
     +/1X,'Upper ',I2,'% confidence limit =',F9.6
     +/1X,'-2 log[lambda] (-2LL) =',1X,A,', NDOF:',1X,A
     +/1X,'p = P(chi-sq. >= -2LL) =',F7.4,1X,A
     +/1X,'chi-sq. test stat (C) =',1X,A,', NDOF:',1X,A
     +/1X,'p = P(chi-sq. >= C) =',F7.4,1X,A)     
  600 FORMAT (
     + 'Analysis of binomial proportions',1X,A
     +/
     +/A
     +/
     +/'To test H0: equal binomial p-values'
     +/'Sample-size =',1X,A,', Sum of Y =',1X,A,', Sum of N =',1X,A
     +/'Estimate of overall binomial parameter =',F9.6
     +/'Lower ',I2,'% confidence limit =',F9.6
     +/'Upper ',I2,'% confidence limit =',F9.6
     +/'-2 log[lambda] (-2LL) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',0P,F7.4,1X,A
     +/'chi-sq. test stat (C) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',0P,F7.4,1X,A
     +/
     +/'Proportions (all p_hat +/-',I2,'% cl)'
     +/'Differences (all p_hat differences +/-',I2,'% cl)'
     +/'Relative risks (all log[p_hat ratios] +/-',I2,'% cl)'
     +/'Relative odds (all log[odds_ratios] +/-',I2,'% cl)'
     +/'Plot p_hat(x) or Log-Odds(x) +/-',I2,'% cl'
     +/'Save a p_hat(x) curve-fit file: s = sqrt(p_hat(1-p_hat)/N)'
     +/'Save a p_hat(x) curve-fit file: s = 1'
     +/'Configure the run-time options'
     +/'Results'
     +/'Quit ... Exit analysis of binomial proportions')
  610 FORMAT (
     + 'Analysis of binomial proportions',1X,A
     +/
     +/A
     +/
     +/'To test H0: equal binomial p-values'
     +/'Sample-size =',1X,A,', Sum of Y =',1X,A,', Sum of N =',1X,A
     +/'Estimate of overall binomial parameter =',F9.6
     +/'Lower ',I2,'% confidence limit =',F9.6
     +/'Upper ',I2,'% confidence limit =',F9.6
     +/'-2 log[lambda] (-2LL) =',1X,A,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',F7.4,1X,A
     +/'chi-sq. test stat (C) =',1X,A,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',F7.4,1X,A
     +/
     +/'Proportions (all p_hat +/-',I2,'% cl)'
     +/'Differences (all p_hat differences +/-',I2,'% cl)'
     +/'Relative risks (all log[p_hat ratios] +/-',I2,'% cl)'
     +/'Relative odds (all log[odds_ratios] +/-',I2,'% cl)'
     +/'Plot p_hat(x) or Log-Odds(x) +/-',I2,'% cl'
     +/'Save a p_hat(x) curve-fit file: s = sqrt(p_hat(1-p_hat)/N)'
     +/'Save a p_hat(x) curve-fit file: s = 1'
     +/'Configure the run-time options'
     +/'Results'
     +/'Quit ... Exit analysis of binomial proportions')     
  650 FORMAT (
     + 'Analysis of binomial proportions',1X,A
     +/
     +/A
     +/
     +/'To test H0: equal binomial p-values'
     +/'Sample-size =',1X,A,', Sum of Y =',1X,A,', Sum of N =',1X,A
     +/'Estimate of overall binomial parameter =',F9.6
     +/'Lower ',I2,'% confidence limit =',F9.6
     +/'Upper ',I2,'% confidence limit =',F9.6
     +/'-2 log[lambda] (-2LL) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',0P,F7.4,1X,A
     +/'chi-sq. test stat (C) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',0P,F7.4,1X,A
     +/
     +/'Proportions (all p_hat +/-',I2,'% cl)'
     +/'Differences (pairs of p_hat_differences +/-',I2,'% cl)'
     +/'Relative risks (pairs of log[_phat_ratios] +/-',I2,'% cl)'
     +/'Relative odds (pairs of log[odds_ratios] +/-',I2,'% cl)'
     +/'Plot p_hat(x) or Log-Odds(x) +/-',I2,'% cl'
     +/'Save a p_hat(x) curve-fit file: s = sqrt(phat(1-phat)/N)'
     +/'Save a p_hat(x) curve-fit file: s = 1'
     +/'Configure the run time options'
     +/'Results'
     +/'Quit ... Exit analysis of binomial proportions')
  660 FORMAT (
     + 'Analysis of binomial proportions',1X,A
     +/
     +/A
     +/
     +/'To test H0: equal binomial p-values'
     +/'Sample-size =',1X,A,', Sum of Y =',1X,A,', Sum of N =',1X,A
     +/'Estimate of overall binomial parameter =',F9.6
     +/'Lower ',I2,'% confidence limit =',F9.6
     +/'Upper ',I2,'% confidence limit =',F9.6
     +/'-2 log[lambda] (-2LL) =',1X,A,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',F7.4,1X,A
     +/'chi-sq. test stat (C) =',1X,A,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',F7.4,1X,A
     +/
     +/'Proportions (all p_hat +/-',I2,'% cl)'
     +/'Differences (pairs of p_hat_differences +/-',I2,'% cl)'
     +/'Relative risks (pairs of log[_phat_ratios] +/-',I2,'% cl)'
     +/'Relative odds (pairs of log[odds_ratios] +/-',I2,'% cl)'
     +/'Plot p_hat(x) or Log-Odds(x) +/-',I2,'% cl'
     +/'Save a p_hat(x) curve-fit file: s = sqrt(phat(1-phat)/N)'
     +/'Save a p_hat(x) curve-fit file: s = 1'
     +/'Configure the run time options'
     +/'Results'
     +/'Quit ... Exit analysis of binomial proportions')     
  700 FORMAT (
     +11X,'y',11X,'N   Lower_',I2,'%    p_hat    Upper_',I2,'%')
  750 FORMAT ( 
     +11X,'y',11X,'N   Lower_',I2,'%    p_app    Upper_',I2,'%',2X,A)
  800 FORMAT (2I12,3(F11.6))
  850 FORMAT (2I12,4(F11.6),A)
  900 FORMAT (
     +'   i   j   Lower_',I2,'%    d(i,j)   Upper_',I2,'%',
     +'     Result       p_sig.  Var(d(i,j))   NNT (',I2,'%cl)')
 1000 FORMAT ('(',I3,') > (',I3,')')
 1100 FORMAT ('(',I3,') < (',I3,')')
 1150 FORMAT (2I4,3(F11.6),2X,A15,1X,F7.4,F11.6,1X,A7,1X,A)
 1200 FORMAT (2I7,1X,1P,3(1X,E13.5),2X,0P,F6.4,2X,A15,0P,F10.5)
 1250 FORMAT (2I7,1X,3(1X,A13),2X,F6.4,2X,A15,F10.5)
 1300 FORMAT (A7,A7,1X,1P,3(1X,E13.5),1X,A16,A10)
 1350 FORMAT (A7,A7,1X,1P,3(1X,A13),1X,A16,A10) 
 1400 FORMAT (
     +2X,'Row(i)',1X,
     +'Row(j)     Lower_',I2,'%        L(i,j)     Upper_',
     +I2,'%    p_sig      Result      Var(L(i,j))')
 1500 FORMAT (
     +2X,'Row(i)',1X,
     +'Row(j)     Lower_',I2,'%       LO(i,j)     Upper_',
     +I2,'%    p_sig      Result      Var(LO(i,j))')
 1600 FORMAT ('(',I3,') > (',I3,')')
 1700 FORMAT ('(',I3,') < (',I3,')')
 1800 FORMAT (
     + 'p_hat(x)'
     +/'p_hat(x) + estimated p-overall'
     +/'p_hat(x) + p_hat = 0.5'
     +/'p_hat(x) + p_hat chosen'
     +/'p_hat(x) + ',I2,'% cl'
     +/'Log Odds'
     +/'Quit ... Exit p_hat(x) plotting options')
      END
C
C
      SUBROUTINE NNTSIG (NNT, 
     +                   BOT, DIFF, TOP, 
     +                   CYPHER,
     +                   SIGNIF)
C
C Calculate 95% confidence limits for NNT
C 03/01/21 edited but decided to not develop the case where DIFF < 0 which is complicated as 
C          it has to accomdate ABS used for NNT with repirocals and negative values
C     
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NNT
      DOUBLE PRECISION,    INTENT (IN)  :: BOT, DIFF, TOP
      CHARACTER (LEN = *), INTENT (OUT) :: CYPHER
      LOGICAL,             INTENT (IN)  :: SIGNIF 
C
C Locals
C      
      INTEGER    I, J, K
      INTEGER    NNT_MAX, NNT_MIN
      PARAMETER  (NNT_MAX = 1000000, NNT_MIN = 1)
      DOUBLE PRECISION RATIO
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-08, ONE = 1.0D+00)
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER (LEN = 8 ) NOCALC, NOSIG
      PARAMETER (NOCALC = '(*.*) NC', NOSIG = '(*.*) NS') 
      CHARACTER (LEN = 4 ) WORD4
      CHARACTER (LEN = 1 ) BLANK
      PARAMETER (BLANK = ' ')
      EXTERNAL   FORM12
      INTRINSIC  ABS
C
C Initialise, check then define WORD4
C      
      CYPHER = BLANK
      IF (.NOT.SIGNIF) THEN
         CYPHER = NOSIG
         RETURN
      ENDIF
      IF (NNT.GE.NNT_MAX   .OR. NNT.LE.NNT_MIN   .OR.
     +    ABS(BOT).LT.EPSI .OR. ABS(TOP).LT.EPSI .OR.
     +    BOT*TOP.LE.ZERO) THEN
          CYPHER = NOCALC
          RETURN
      ENDIF       
      IF (DIFF.LE.ZERO) THEN
         WORD4 = ' NNH' 
      ELSE
         WORD4 = '    '
      ENDIF   
C
C Calculate lower confidence limit then start constructing CYPHER 
C     
      IF (TOP.LE.ZERO) THEN
         RATIO = ONE/(ABS(BOT))
      ELSE       
         RATIO = ONE/ABS(TOP)
      ENDIF    
      I = NINT(RATIO)
      IF (I.LE.0) THEN
         I = 1
      ELSEIF (I.EQ.NNT) THEN
         I = MAX(1,NNT - 1)
      ELSEIF (I.GT.NNT) THEN
         CYPHER = NOCALC
         RETURN
      ENDIF  
      WORD12 = FORM12(I)  
      J = LEN_TRIM(WORD12)
      CYPHER(1:J + 1) = '('//WORD12(1:J)
C
C Calculate upper confidence limit then finish contructing CYPHER
C    
      IF (TOP.LE.ZERO) THEN
         RATIO = ONE/ABS(TOP)
      ELSE     
         RATIO = ONE/ABS(BOT)
      ENDIF   
      I = NINT(RATIO)
      IF (I.LE.0) THEN
         I = 1
      ELSEIF (I.EQ.NNT) THEN
          I = NNT + 1
      ELSEIF (I.LE.NNT) THEN
         CYPHER = NOCALC
         RETURN
      ENDIF   
      WORD12 = FORM12(I)
      K = LEN_TRIM(WORD12)
      CYPHER(J + 2:J + K + 4) = ','//WORD12(1:K)//')'
      K = LEN_TRIM(CYPHER)
      CYPHER(K + 1: K + 4) = WORD4
      END
C
C
c***********************************************************************************************************
c
      subroutine metacl (isend, jlim, jtype)
c
c action: return significance level as either 90, 95, or 99% (or limit-type if isend .eq. 2)
c author: w.g.bardsley, university of manchester, u.k., 19/10/2017
c         27/01/2021 minor editing
c isend = 1: return jlim
c       = 2: return jtype
c         o/w: return default values for rjlim and jtype
c         jlim: returns 90, 95, or 99
c         jtype: returns 1, 2, or 3
c          
      implicit none
c
c argument
c      
      integer, intent (in)    :: isend 
      integer, intent (inout) :: jlim, jtype! 26/01/1921 must now be (inout) not (in)
c
c locals
c      
      integer    i
      integer    icolor, ixl, iyl, lshade, numdec, numopt, numsta,
     +           numtxt
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, numdec = 0, 
     +           numsta = 3) 
      integer    numbld(10), numpos(10)
      character (len = 100) text(10)
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.) 
      external   rbox01
      if (isend.eq.1) then
c
c isend = 1: just return jlim and leave jtype unchanged
c        
         write (text,100)
         numopt = 3
         numtxt = numsta + numopt - 1
         do i = 1, 2
            numbld(i) = 1
         enddo
         do i = 3, numtxt
            numbld(i) = 100
         enddo      
         do i = 1, numopt
            numpos(i) = 0
         enddo
         if (jlim.eq.90) then
              numpos(1) = 1
         elseif (jlim.eq.95) then
            numpos(2) = 1  
         elseif (jlim.eq.99) then
            numpos(3) = 1     
         else
            numpos(2) = 1   
         endif
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
         if (numpos(1).eq.1) then
            jlim = 90
         elseif (numpos(2).eq.1) then
            jlim = 95
         else
            jlim = 99
         endif   
      elseif (isend.eq.2) then
c
c isend = 2: just return jtype and leave jlim unchanged
c        
         write (text,200)
         numopt = 3
         numtxt = numsta + numopt - 1
         do i = 1, 2
            numbld(i) = 1
         enddo
         do i = 3, numtxt
            numbld(i) = 100
         enddo  
         do i = 1, numopt
            numpos(i) = 0
         enddo  
         numpos(jtype) = 1    
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
         if (numpos(1).eq.1) then
            jtype = 1
         elseif (numpos(2).eq.1) then
            jtype = 2
         elseif (numpos(3).eq.1) then
            jtype = 3
         endif 
      else
         jlim = 95
         jtype = 3     
      endif  
c
c format statements
c               
  100 format (
     + 'Select the significance level required'
     +/
     +/'90%'
     +/'95%'
     +/'99%') 
  200 format (   
     + 'Select binomial parameter limit  type'
     +/
     +/'p_hat limits: Exact small sample unsymmetrical'         
     +/'p_hat limits: Approximate large sample central'
     +/'p_hat limits: Both limit types')
      end  
c
c***************************************************************
c
c
c
      subroutine clmeta (isend, jlim, jtype,
     +                   base10)
c
c action: return jlim, jtype, base10 depending on isend
c author: w.g.bardsley, university of manchester, u.k., 19/10/2017
c         30/01/2021 derived from metacl
c isend = 1: return jlim
c       = 2: return jtype
c       = 3: return base10  
c       = 4: return jlim, jtype, base10
c         o/w: return current default values for rjlim, jtype, and base10
c         jlim: returns 90, 95, or 99
c         jtype: returns 1, 2, or 3
c         base10: returns .true. or .false.
c          
      implicit none
c
c argument
c      
      integer, intent (in)    :: isend 
      integer, intent (inout) :: jlim, jtype
      logical, intent (inout) :: base10 
c
c locals
c      
      integer    jlim_sav, jtype_sav
      integer    i
      integer    icolor, ixl, iyl, lshade, numdec, numopt, numsta,
     +           numtxt
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, numdec = 0, 
     +           numsta = 3) 
      integer    numbld(20), numpos(20)
      character (len = 100) text(20)
      logical    base10_sav
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.) 
      external   rbox01
      save       jlim_sav, jtype_sav, base10_sav
      data       jlim_sav, jtype_sav / 95, 3 /
      data       base10_sav / .true. /
      if (isend.eq.1) then
c
c isend = 1: just select jlim 
c        
         write (text,100)
         numopt = 3
         numtxt = numsta + numopt - 1
         do i = 1, 2
            numbld(i) = 1
         enddo
         do i = 3, numtxt
            numbld(i) = 100
         enddo      
         do i = 1, numopt
            numpos(i) = 0
         enddo
         if (jlim.eq.90) then
              numpos(1) = 1
         elseif (jlim.eq.95) then
            numpos(2) = 1  
         elseif (jlim.eq.99) then
            numpos(3) = 1     
         else
            numpos(2) = 1   
         endif
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
         if (numpos(1).eq.1) then
            jlim = 90
         elseif (numpos(2).eq.1) then
            jlim = 95
         else
            jlim = 99
         endif 
         jlim_sav = jlim   
      elseif (isend.eq.2) then
c
c isend = 2: just select jtype 
c        
         write (text,200)
         numopt = 3
         numtxt = numsta + numopt - 1
         do i = 1, 2
            numbld(i) = 1
         enddo
         do i = 3, numtxt
            numbld(i) = 100
         enddo  
         do i = 1, numopt
            numpos(i) = 0
         enddo  
         numpos(jtype) = 1    
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
         if (numpos(1).eq.1) then
            jtype = 1
         elseif (numpos(2).eq.1) then
            jtype = 2
         elseif (numpos(3).eq.1) then
            jtype = 3
         endif 
         jtype_sav = jtype
      elseif (isend.eq.3) then
c
c isend = 3: just select base10
c      
         write (text,300)
         numopt = 2
         numtxt = numsta + numopt - 1
         do i = 1, 2
            numbld(i) = 1
         enddo
         do i = 3, numtxt
            numbld(i) = 100
         enddo      
         do i = 1, numopt
            numpos(i) = 0
         enddo
         if (base10) then
            numpos(1) = 1
         else
            numpos(2) = 1  
         endif
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
         if (numpos(1).eq.1) then
            base10 = .true.
         elseif (numpos(2).eq.1) then
            base10 = .false.
         endif   
         base10_sav = base10   
      elseif (isend.eq.4) then   
c
c return the selection for jlim, jtype, and base10
c      
         write (text,400)
         numopt = 8
         numtxt = numsta + numopt - 1
         do i = 1, numtxt
            numbld(i) = 0
         enddo  
         do i = 1, numopt
            numpos(i) = 0
         enddo 
         do i = 3, 5
            numbld(i) = 100
         enddo      
         do i = 6, 8
            numbld(i) = 200
         enddo
         do i = 9, 10
            numbld(i) = 300
         enddo   
c
c significance level
c         
         if (jlim.eq.90) then
            numpos(1) = 1
         elseif (jlim.eq.95) then
            numpos(2) = 1  
         elseif (jlim.eq.99) then
            numpos(3) = 1     
         endif   
c
c jtype
c
         numpos(jtype + 3) = 1
c
c base10
c         
         if (base10) then
            numpos(7) = 1
         else
            numpos(8) = 1  
         endif
         call rbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                numopt, numpos, numsta, numtxt,
     +                text,
     +                fixed, full, high) 
c
c significance level
c     
         if (numpos(1).eq.1) then
            jlim = 90
         elseif (numpos(2).eq.1) then
            jlim = 95
         elseif (numpos(3).eq.1) then
            jlim = 99
         endif 
         jlim_sav = jlim 
c
c jtype
c
         if (numpos(4).eq.1) then
            jtype = 1
         elseif (numpos(5).eq.1) then
            jtype = 2
         elseif (numpos(6).eq.1) then
            jtype = 3
         endif 
         jtype_sav = jtype
c
c base10
c
         if (numpos(7).eq.1) then
            base10 = .true.
         elseif (numpos(8).eq.1) then
            base10 = .false.
         endif   
         base10_sav = base10  
      else
         jlim = jlim_sav
         jtype = jtype_sav
         base10 = base10_sav     
      endif  
c
c format statements
c               
  100 format (
     + 'Select the significance level required'
     +/
     +/'90%'
     +/'95%'
     +/'99%') 
  200 format (   
     + 'Select binomial parameter limit  type'
     +/
     +/'p_hat limits: Exact small sample unsymmetrical'         
     +/'p_hat limits: Approximate large sample central'
     +/'p_hat limits: Both limit types')
  300 format (   
     + 'Select base for logarithms'
     +/
     +/'base = 10'         
     +/'base = e')
 400  format (  
     + 'Select the configuration required'
     +/
     +/'significance level: 90%'
     +/'significance level: 95%'
     +/'significance level: 99%'
     +/'p_hat limits: Exact small sample unsymmetrical'         
     +/'p_hat limits: Approximate large sample central'
     +/'p_hat limits: Both types'
     +/'logarithms to base: 10'         
     +/'logarithms to base: e')  
      end  
c
c
