C
C
      SUBROUTINE META02 (ILIM, NCOL, NGRAF, NIN, NOBS, NOUT, NRMAX,
     +                   NROW, NTEMP,
     +                   A, ATEMP, PBOT, PBOT1, PHAT, PHAT1, PTOP,
     +                   PTOP1, T, T1, X,
     +                   FNAME, TITLE,
     +                   SUPPLY)
C
C ACTION : Meta analysis
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/11/95
C ADVICE : Be very careful in the way that the arrays are redefined
C          to re-use storage. The logical variables FIRST1/2/3/4/5
C          and FILED1/2 are vital to the overall printing control.
C
C          ILIM: (input/unchanged) % confidence limit required, e.g. 95%
C          NCOL: (input/output) depending on SUPPLY
C         NGRAF: (input/unchanged) Dimension
C           NIN: (input/unchanged) Unconnected unit for data input
C          NOBS: Workspace
C          NOUT: (input/unchanged) Unit connected for results
C         NRMAX: (input/unchanged) Dimension
C          NROW: (input/output) depending on SUPPLY
C         NTEMP: Wprkspace
C             A: (input/output) depending on SUPPLY
C         ATEMP: (input/output) depending on SUPPLY
C          PBOT: Workspace
C         PBOT1: Workspace
C          PHAT: Workspace
C         PHAT1: Workspace
C          PTOP: Workspace
C         PTOP1: Workspace
C             T: Workspace
C            T1: Workspace
C             X: Workspace
C         FNAME: (input/output) depending on SUPPLY
C         TITLE: (input/output) depending on SUPPLY
c        SUPPLY: (input/unchamged) as follows:
C                SUPPLY = .TRUE. then supply NCOL, NROW, ATEMP, FNAME, TITLE
C Local counters:
C          NUMN: Total no. of N
C          NUMX: Total no. of X
C
C References:
C          Standard errors from Agresti. An Introduction to Categorical
C          Data Analysis. Wiley 1996. Each matrix nij is supposed 2 x 2
C          se(p1 - p2)   = z_alpha/2*sqrt[p1(1-p1)/N1 + p2(1-p2)/N2]
C          se[log(p1/p2) = z_alpha/2*sqrt[(1-p1)/(N1p1) + (1-p2)/(n2p2)]
C          se[logodds]   = z_alpha/2*sqrt[1/n11 + 1/n12 + 1/n21 + 1/n22]
C                          add 0.5 to all if any nij small (< 2 ?)
C          Common confidence limits from Agresti A, Categorical Data
C          Analysis, Wiley 1990, page 236
C
C
C Revisions:
C          30/06/1999 option to redefine T if only two columns supplied
C                     and altered data input for arbitrary matrix format.
C                     Also options for alternative curve-fitting weights.
C          06/08/1999 added log odds plot
C          23/01/2000 added all possible diferences
C          28/01/2000 added NKTEMP, ATEMP and NTEMP to make sure that
C                     maximum dimensions are not exceeded and that all
C                     data are correct and not overwritten by the call
C                     to G01AFF. Also added code for log odds ratios and
C                     correcting for zero entry cells.
C          07/02/2001 added CHOP80
C          14/06/2001 introduced AGAIN and rearranged menus
C          21/05/2002 redefined x as y to agree with GLIM convention
C          21/12/2004 added overall p and confidence limits to plots
C          10/01/2005 made graph title arrays for call to gkshb4
C          06/06/2005 extensive revision to delete analysis of proportions
C          10/01/2013 added INTENTS
C          18/08/2014 made log_10 the default 
C          02/02/2021 simplified the interface by removing the options to change ILIM,
C                     BASE10, and SUPRC. Also simplified the call to META03 
C          29/08/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ILIM
      INTEGER,             INTENT (IN)    :: NGRAF, NIN, NOUT, NRMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NOBS(NRMAX,3),
     +                                       NROW, NTEMP(NRMAX,3)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,3), ATEMP(NRMAX,4),
     +                                       PBOT(NRMAX), PBOT1(NGRAF),
     +                                       PHAT(NRMAX), PHAT1(NGRAF),
     +                                       PTOP(NRMAX), PTOP1(NGRAF),
     +                                       T(NRMAX), T1(NGRAF),
     +                                       X(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Locals
C
      INTEGER    I, J, JCOLOR
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ICOUNT, NROW2, NUMN, NUMX
      INTEGER    IFAIL, ITYPE, NDF1, NDF2
      INTEGER    L1, L2, L3, L4, M1, M2, M3, M4, N2, N3
      PARAMETER (L1 = 0, L3 = 0, M2 = 0, M4 = 0, N2 = 2)
      INTEGER    NPLOTS
      DOUBLE PRECISION X2(N2), X3(N2), X4(N2)
      DOUBLE PRECISION Y2_T(N2), Y3_T(N2), YH3_T(N2), YL3_T(N2),
     +                 Y4_T(N2)
      DOUBLE PRECISION CHISQ1, CHISQ2, PBIG, PLOW, PHIGH, P1, P2
      DOUBLE PRECISION AMU, A11, A12, A13, A21, A22, A23, A31, A32, A33,
     +                 A33SQD
      DOUBLE PRECISION CMH, CMH1, CMH2, CMH3, CMH4, PCMH
      DOUBLE PRECISION BOT, DIFF, RATIO, SDIFF, TOP, VAR, VDIFF, ZVAL
      DOUBLE PRECISION BIGA11, BIGA12, BIGA21, BIGA22, BIGBOT, BIGRAT,
     +                 BIGSUM, BIGTOP
      DOUBLE PRECISION BOT1, BOT2A, BOT2B, BOT3, TOP1, TOP2, TOP3
      DOUBLE PRECISION POOBOT, POORAT, POOTOP
      DOUBLE PRECISION ADDON, ZERO, HALF, ONE, TWO, F100
      PARAMETER (ADDON = 0.01D+00, ZERO = 0.0D+00, HALF = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION G01ECF$, G01FAF$
      CHARACTER (LEN = 100) INFO(30), LINE, TEXT(30)
      CHARACTER (LEN = 80 ) CHOP80
      CHARACTER (LEN = 23 ) WORD1, WORD2, WORD3
      CHARACTER (LEN = 13 ) BLANK13, WORD13
      PARAMETER (BLANK13 = '             ', WORD13 = '     ...     ') 
      CHARACTER (LEN = 13 ) D13(3), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12 ) FORM12, WORD12_ICOUNT, WORD12_NROW,
     +                      WORD12_NROW2, WORD12_NUMX, WORD12_NUMN,
     +                      WORD12_NDF1, WORD12_NDF2
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
C
C ***********************************************************************
C Start of plot titles ..................................................
C
      CHARACTER (LEN = 30) XTITLE
C
C Plot titles for p(x) in call to GKSEB4
C
      PARAMETER (XTITLE = 'x (control variable)')
C
C Primary plot titles for Log Odds Ratios in call to GKSHB4
C
      CHARACTER (LEN = 30) PTITL2, YTITL3, YTITL4
      PARAMETER (PTITL2 = 'Log Odds Ratios and con. lims.',
     +           YTITL3 = 'log_e[Odds Ratios]',
     +           YTITL4 = 'log_10[Odds Ratios]')
C
C Secondary plot titles for Log Odds ratios in call to SMPLOT from GKSHB4
C
      CHARACTER (LEN = 30) PTITL4, YTITL6
      PARAMETER (PTITL4 = 'Odds Ratios and con. lims.',
     +           YTITL6 = 'Odds Ratios')
C
C Arrays for GKSHB4
C
      CHARACTER (LEN = 30) PTEXT(2), XTEXT(2), YTEXT(2)
C
C End of plot titles ..................................................
C *********************************************************************
C
      CHARACTER (LEN = 1) UPPER, TAIL
      PARAMETER (UPPER = 'U', TAIL = 'C')
      CHARACTER (LEN = 50) IWARNU
      PARAMETER (IWARNU =
     +'*** 0.01 added to all cells for next calculation')
      CHARACTER (LEN = 20) LTYPE
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FIRST5, FILED1, FILED2
      LOGICAL    REPEET, SUPRC
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, BASE10, NEWDAT
      LOGICAL    AXES, GSAVE, META
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE., META = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   G01ECF$, G01FAF$
      EXTERNAL   LBOX01, PUTFAT, PUTIFA, TABLE1, META03,
     +           PLEVEL, NX3FIL, GKSHB4, CHOP80, META00,
     +           METACL, REVPRO, FORM12 
      INTRINSIC  ABS, NINT, DBLE, LOG, SQRT, EXP
      SAVE       ICOUNT
      DATA       BASE10 / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      DATA       ICOUNT / 0 /
C
C Initialise the fixed plot titles
C
      XTEXT(1) = XTITLE
      XTEXT(2) = XTITLE
C
C Part 1: Read in the data matrix A
C ======
C
      WRITE (INFO,100)
      IF (SUPPLY) THEN
         NEWDAT = .FALSE.
      ELSE
         NEWDAT = .TRUE.
      ENDIF
      SUPRC = .FALSE.
      CALL META00 (ICOUNT, ILIM, NCOL, NDF1, NDF2, NIN, NOBS, NOUT,
     +             NRMAX, NROW, NTEMP, NUMN, NUMX,
     +             A, ATEMP, CHISQ1, CHISQ2, PBIG, PBOT, PHAT, PHIGH,
     +             PLOW, PTOP, P1, P2, T, X,
     +             FNAME, INFO, TITLE, WORD1, WORD2,
     +             ABORT, META, NEWDAT, SUPRC)
      IF (ABORT) RETURN

      E_NUMBERS = E_FORMATS()
        
      IF (WORD1.EQ.BLANK) THEN
         NUMBLD(13) = 0
      ELSE
         NUMBLD(13) = 1
      ENDIF
      IF (WORD2.EQ.BLANK) THEN
         NUMBLD(15) = 0
      ELSE
         NUMBLD(15) = 1
      ENDIF
C
C Set FIRST5 and FILED1/2 then output results to the log file
C
      FIRST5 = .TRUE.
      FILED1 = .FALSE.
      FILED2 = .FALSE.
      NROW2 = NROW/2
      ICOUNT = ICOUNT + 1
      WORD12_ICOUNT = FORM12(ICOUNT)
      WORD12_NROW = FORM12(NROW)
      WORD12_NROW2 = FORM12(NROW2)
      WORD12_NUMX = FORM12(NUMX)
      WORD12_NUMN = FORM12(NUMN)
      WORD12_NDF1 = FORM12(NDF1)
      WORD12_NDF2 = FORM12(NDF2)
      IF (E_NUMBERS) THEN
         WRITE (NOUT,500) WORD12_ICOUNT,
     +                    TITLE, WORD12_NROW2, WORD12_NROW, WORD12_NUMX,
     +                    WORD12_NUMN, PBIG, ILIM,
     +                    PLOW, ILIM, PHIGH, CHISQ1, WORD12_NDF1, P1, 
     +                    WORD1, CHISQ2, WORD12_NDF2, P2, WORD2
      ELSE
         D13(1) = SHOWLJ(CHISQ1)
         D13(2) = SHOWLJ(CHISQ2)
         WRITE (NOUT,550) WORD12_ICOUNT,
     +                    TITLE, WORD12_NROW2, WORD12_NROW, WORD12_NUMX,
     +                    WORD12_NUMN, PBIG, ILIM,
     +                    PLOW, ILIM, PHIGH, D13(1), WORD12_NDF1, P1, 
     +                    WORD1, D13(2), WORD12_NDF2, P2, WORD2
      ENDIF   
C
C Restore A(i,2) = N(i) = X(i)
C This is not really necessary since ATEMP now saves A (29/01/2000)
C
      DO I = 1, NROW
         A(I,2) = X(I)
      ENDDO
C
C Calculate Z_alpha/2
C
      DIFF = DBLE(ILIM)/F100
      IFAIL = 1
      ZVAL = G01FAF$(TAIL, DIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FAF/META02')
C
C Initialise all temporary variables
C
       L2 = 0
       L4 = 0
       M1 = 5
       M3 = 7
       DO I = 1, 2
          X2(I) = ZERO
          X3(I) = ZERO
          X4(I) = ZERO
          YH3_T(I) = ZERO
          YL3_T(I) = ZERO
          Y2_T(I) = ZERO
          Y3_T(I) = ZERO
          Y4_T(I) = ZERO
       ENDDO
C
C Part 2: main branch point to examine data, display table, file or plot
C ======================================================================
C
      REPEET = .TRUE.
      NUMDEC = 1
      DO WHILE (REPEET)
         IF (BASE10) THEN
            LTYPE = '(current base = 10)'
         ELSE
            LTYPE = '(current base = e)'  
         ENDIF    
         IF (E_NUMBERS) THEN 
            WRITE (TEXT,600) WORD12_ICOUNT,
     +                       CHOP80(TITLE), WORD12_NROW2, WORD12_NROW,
     +                       WORD12_NUMX, WORD12_NUMN, PBIG,
     +                       ILIM, PLOW, ILIM, PHIGH, CHISQ1,
     +                       WORD12_NDF1,
     +                       P1, WORD1, CHISQ2, WORD12_NDF2, P2, WORD2,
     +                       ILIM, LTYPE
         ELSE
           D13(1) = SHOWLJ(CHISQ1)
           D13(2) = SHOWLJ(CHISQ2)
           WRITE (TEXT,650) WORD12_ICOUNT,
     +                       CHOP80(TITLE), WORD12_NROW2, WORD12_NROW,
     +                       WORD12_NUMX, WORD12_NUMN, PBIG,
     +                       ILIM, PLOW, ILIM, PHIGH, D13(1),
     +                       WORD12_NDF1,
     +                       P1, WORD1, D13(2), WORD12_NDF2, P2, WORD2,
     +                       ILIM, LTYPE      
         ENDIF  
         NUMOPT = 7
         NSTART = 17
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 1
         NUMBLD(3) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(3) = 0 
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Meta analysis
C
            IF (2*(NROW/2).NE.NROW) THEN
               CALL PUTFAT (INFO(15))
            ELSE
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               LINE = INFO(16)
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               WRITE (LINE,1900)
               CALL TABLE1 (JCOLOR, LINE)
               IF (FIRST5) THEN
                  WRITE (NOUT,'(A)') BLANK
                  LINE = INFO(16)
                  WRITE (NOUT,'(A)') LINE
                  WRITE (NOUT,1900)
               ENDIF
               JCOLOR = 0
C
C Initialise the counters
C
               CMH1 = ZERO
               CMH2 = ZERO
               CMH3 = ZERO
               CMH4 = ZERO
               BIGA11 = ZERO
               BIGA12 = ZERO
               BIGA21 = ZERO
               BIGA22 = ZERO
               BOT1 = ZERO
               BOT2A = ZERO
               BOT2B = ZERO
               BOT3 = ZERO
               TOP1 = ZERO
               TOP2 = ZERO
               TOP3 = ZERO
C
C Loop over all cells and increment the counters
C
               J = 0
               DO I = 1, NROW/2
                  J = J + 1
                  A11 = ATEMP(J,1)
                  A12 = ATEMP(J,2)
                  J = J + 1
                  A21 = ATEMP(J,1)
                  A22 = ATEMP(J,2)
                  IF (A11.LT.ONE .OR. A12.LT.ONE .OR.
     +                A21.LT.ONE .OR. A22.LT.ONE) THEN
                      A11 = A11 + ADDON
                      A12 = A12 + ADDON
                      A21 = A21 + ADDON
                      A22 = A22 + ADDON
                      IF (FIRST5) WRITE (NOUT,'(A)') IWARNU
                      JCOLOR = 4
                      CALL TABLE1 (JCOLOR, IWARNU)
                      JCOLOR = 0
                  ENDIF
                  BIGA11 = BIGA11 + A11
                  BIGA12 = BIGA12 + A12
                  BIGA21 = BIGA21 + A21
                  BIGA22 = BIGA22 + A22
                  A13 = A11 + A12
                  A23 = A21 + A22
                  A31 = A11 + A21
                  A32 = A12 + A22
                  A33 = A13 + A23
                  A33SQD = A33*A33
C
C Do the sums for the statistics
C
                  TOP1 = TOP1 + (A11 + A22)*A11*A22/A33SQD
                  BOT1 = BOT1 + TWO*(A11*A22/A33)**2
                  TOP2 = ((A11 + A22)*A12*A21 +
     +                    (A12 + A21)*A11*A22)/A33SQD
                  BOT2A = BOT2A + TWO*A11*A22/A33
                  BOT2B = BOT2B + A12*A21/A33
                  TOP3 = TOP3 + (A12 + A21)*A12*A21/A33SQD
                  BOT3 = BOT3 + TWO*(A12*A21/A33)**2
                  AMU = A13*A31/A33
                  TOP = A13*A23*A31*A32
                  BOT = A33**2*(A33 - ONE)
                  VAR = TOP/BOT
                  CMH1 = CMH1 + A11 - AMU
                  CMH2 = CMH2 + VAR
                  CMH3 = CMH3 + A11*A22/A33
                  CMH4 = CMH4 + A12*A21/A33
                  RATIO = A11*A22/(A12*A21)
                  IF (FIRST5) THEN
                     IF (E_NUMBERS) THEN
                         WRITE (NOUT,2000) NTEMP(J - 1,1),
     +                                     NTEMP(J - 1,2),
     +                                     RATIO, AMU, VAR
                         WRITE (NOUT,2100) NTEMP(J,1), NTEMP(J,2),
     +                                     WORD13, WORD13, WORD13
                     ELSE
                         D13(1) = SHOWRJ(RATIO)
                         D13(2) = SHOWRJ(AMU)
                         D13(3) = SHOWRJ(VAR)
                         WRITE (NOUT,2100) NTEMP(J - 1,1),
     +                                     NTEMP(J - 1,2),
     +                                     D13(1), D13(2), D13(3)
                         WRITE (NOUT,2100) NTEMP(J,1), NTEMP(J,2),
     +                                     WORD13, WORD13, WORD13

                     ENDIF  
                  ENDIF
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,2000) NTEMP(J - 1,1), NTEMP(J - 1,2),
     +                                 RATIO, AMU, VAR
                  ELSE
                       D13(1) = SHOWRJ(RATIO)
                       D13(2) = SHOWRJ(AMU)
                       D13(3) = SHOWRJ(VAR)
                       WRITE (LINE,2100) NTEMP(J - 1,1), NTEMP(J - 1,2),
     +                                   D13(1), D13(2), D13(3)  
                  ENDIF  
                  CALL TABLE1 (JCOLOR, LINE)
                  WRITE (LINE,2100) NTEMP(J,1), NTEMP(J,2),
     +                              BLANK13, BLANK13, BLANK13
                  CALL TABLE1 (JCOLOR, LINE)
               ENDDO
C
C Calculate the Pooled Odds ratio
C
               BIGRAT = CMH3/CMH4
               BIGSUM = TOP1/BOT1 + TOP2/(BOT2A*BOT2B) + TOP3/BOT3
               SDIFF = ZVAL*SQRT(BIGSUM)
               BIGBOT = EXP(LOG(BIGRAT) - SDIFF)
               BIGTOP = EXP(LOG(BIGRAT) + SDIFF)
C
C calculate the pooled odds ratio
C
               POORAT = BIGA11*BIGA22/(BIGA12*BIGA21)
               BIGSUM = ONE/BIGA11 + ONE/BIGA12 +
     +                  ONE/BIGA21 + ONE/BIGA22
               SDIFF = ZVAL*SQRT(BIGSUM)
               POOBOT = EXP(LOG(POORAT) - SDIFF)
               POOTOP = EXP(LOG(POORAT) + SDIFF)
               CMH = (ABS(CMH1) - HALF)**2/CMH2
               IFAIL = 1
               PCMH = G01ECF$(UPPER, CMH, ONE, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01ECF/ANOVAP')
               CALL PLEVEL (PCMH, WORD3)
               IF (FIRST5) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,2300) CMH
                     WRITE (NOUT,2400) PCMH, WORD3
                     WRITE (NOUT,2500) BIGRAT, ILIM, BIGBOT, BIGTOP
                     WRITE (NOUT,2600) NINT(BIGA11), NINT(BIGA12),
     +                                 NINT(BIGA21), NINT(BIGA22),
     +                                 POORAT,
     +                                 ILIM, POOBOT, POOTOP
                  ELSE
                     D13(1) = SHOWLJ(CMH)                   
                     WRITE (NOUT,2350) D13(1)
                     WRITE (NOUT,2400) PCMH, WORD3
                     D13(1) = SHOWLJ(BIGRAT)
                     D13(2) = SHOWLJ(BIGBOT)
                     D13(3) = SHOWLJ(BIGTOP)
                     WRITE (NOUT,2550) TRIM(D13(1)), ILIM, TRIM(D13(2)),
     +                                 TRIM(D13(3))
                     D13(1) = SHOWLJ(POORAT)
                     D13(2) = SHOWLJ(POOBOT)
                     D13(3) = SHOWLJ(POOTOP)
                     WRITE (NOUT,2650) NINT(BIGA11), NINT(BIGA12),
     +                                 NINT(BIGA21), NINT(BIGA22),
     +                                 TRIM(D13(1)),
     +                                 ILIM, TRIM(D13(2)), TRIM(D13(3))
                  ENDIF
               ENDIF   
               WRITE (LINE,2200)
               CALL TABLE1 (JCOLOR, LINE)
               IF (E_NUMBERS) THEN
                  WRITE (LINE,2300) CMH
               ELSE
                  D13(1) = SHOWLJ(CMH)
                  WRITE (LINE,2350) D13(1) 
               ENDIF  
               CALL TABLE1 (JCOLOR, LINE)
               WRITE (LINE,2400) PCMH, WORD3
               IF (WORD3.NE.BLANK) JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = 0
               IF (E_NUMBERS) THEN
                  WRITE (LINE,2500) BIGRAT, ILIM, BIGBOT, BIGTOP
                  WRITE (TEXT,2600) NINT(BIGA11), NINT(BIGA12),
     +                              NINT(BIGA21), NINT(BIGA22),
     +                              POORAT,
     +                              ILIM, POOBOT, POOTOP
               ELSE
                     D13(1) = SHOWLJ(BIGRAT)
                     D13(2) = SHOWLJ(BIGBOT)
                     D13(3) = SHOWLJ(BIGTOP)
                     WRITE (LINE,2550) TRIM(D13(1)), ILIM, TRIM(D13(2)),
     +                                 TRIM(D13(3))
                     D13(1) = SHOWLJ(POORAT)
                     D13(2) = SHOWLJ(POOBOT)
                     D13(3) = SHOWLJ(POOTOP)
                     WRITE (TEXT,2650) NINT(BIGA11), NINT(BIGA12),
     +                                 NINT(BIGA21), NINT(BIGA22),
     +                                 TRIM(D13(1)),
     +                                 ILIM, TRIM(D13(2)), TRIM(D13(3))
               ENDIF  
               CALL TABLE1 (JCOLOR, LINE)
               DO I = 1, 6
                  CALL TABLE1(JCOLOR, TEXT(I))
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Set FIRST5 = .FALSE. to prevent second copy
C
               FIRST5 = .FALSE.
            ENDIF
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Plot Log Odds Ratios from meta analysis
C
            IF (2*(NROW/2).NE.NROW) THEN
               CALL PUTFAT (INFO(4))
            ELSEIF (FIRST5) THEN
               CALL PUTFAT (INFO(17))
            ELSE
               NPLOTS = 0
               J = 0
               DO I = 1, NROW/2
                  J = J + 1
                  A11 = ATEMP(J,1)
                  A12 = ATEMP(J,2)
                  J = J + 1
                  A21 = ATEMP(J,1)
                  A22 = ATEMP(J,2)
                  IF (A11.LT.ONE .OR. A12.LT.ONE .OR.
     +                A21.LT.ONE .OR. A22.LT.ONE) THEN
                      A11 = A11 + ADDON
                      A12 = A12 + ADDON
                      A21 = A21 + ADDON
                      A22 = A22 + ADDON
                  ENDIF
C
C Calculate Log Odds Ratio and confidence limits
C
                  TOP = ONE/A11 + ONE/A12
                  BOT = ONE/A21 + ONE/A22
                  VDIFF = TOP + BOT
                  SDIFF = ZVAL*SQRT(VDIFF)
                  TOP = A11*A22
                  BOT = A12*A21
                  RATIO = LOG(TOP/BOT)
C
C Take antilogs since plot transforms automatically
C
                  BOT = EXP(RATIO - SDIFF)
                  TOP = EXP(RATIO + SDIFF)
                  RATIO = EXP(RATIO)
C
C Generate plotting data
C
                  NPLOTS = NPLOTS + 1
                  T1(NPLOTS) = T(J - 1)
                  PHAT1(NPLOTS) = RATIO
                  PBOT1(NPLOTS) = BOT
                  PTOP1(NPLOTS) = TOP
               ENDDO
C
C Transformed and reversed axes
C
               IF (NPLOTS.GT.0) THEN
                  L2 = 2
                  PTEXT(1) = PTITL2
                  PTEXT(2) = PTITL4
                  IF (BASE10) THEN
                     ITYPE = 2
                     YTEXT(1) = YTITL4
                  ELSE
                     ITYPE = 1
                     YTEXT(1) = YTITL3
                  ENDIF
                  YTEXT(2) = YTITL6
                  X2(1) = T1(1) - ONE
                  X2(2) = T1(NPLOTS)
                  X3(1) = T1(1) - ONE
                  Y2_T(1) = ONE
                  Y2_T(2) = ONE
                  Y3_T(1) = BIGRAT
                  YH3_T(1) = BIGTOP
                  YL3_T(1) = BIGBOT
                  M3 = 7
                  N3 = 1
                  CALL GKSHB4 (ITYPE,
     +                         L1, L2, L3, L4,
     +                         M1, M2, M3, M4,
     +                         NPLOTS, N2, N3, N2,
     +                         T1, X2, X3, X4, PTOP1, YH3_T, PBOT1,
     +                         YL3_T, PHAT1, Y2_T, Y3_T, Y4_T,
     +                         PTEXT, XTEXT, YTEXT,
     +                         AXES, GSAVE)
               ENDIF
            ENDIF
            NUMDEC = 3
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Probability calculations
C
            CALL META03 (NOUT,
     +                   FNAME)
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.4 .OR. NUMDEC.EQ.5) THEN
C
C NUMDEC = 4 or 5: Curve fitting file if NCOL = 3 and .NOT.FILED
C
            IF (NUMDEC.EQ.4 .AND. FILED1) THEN
               CALL PUTFAT (INFO(18))
            ELSEIF (NUMDEC.EQ.5 .AND. FILED2) THEN
               CALL PUTFAT (INFO(18))
            ELSE
               IF (NUMDEC.EQ.4) THEN
                  FILED1 = .TRUE.
                  DO I = 1, NROW
                     X(I) = SQRT(PHAT(I)*(ONE - PHAT(I))/A(I,2))
                  ENDDO
               ELSEIF (NUMDEC.EQ.5) THEN
                  FILED2 = .TRUE.
                  DO I = 1, NROW
                     X(I) = ONE
                  ENDDO
               ENDIF
               CALL NX3FIL (NROW, T, PHAT, X)
            ENDIF
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
            I = ILIM
            CALL METACL (ISEND, ILIM, J)  
            IF (I.NE.ILIM) THEN 
               FIRST5 = .TRUE.
               FILED1 = .FALSE.
               FILED2 = .FALSE.
            ENDIF   
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO (NOUT)   
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Now input data formatted like meta.tf1 with an even no. of rows'
     +/'Note: GLM-type data sets (i.e. x,y,N,s) are also acceptable'
     +/'Data table must have either 2, 3 or 4 columns'
     +/'Must have an even number of rows for CMH meta analysis'
     +/'Maximum dimension exceeded in call to META02'
     +/'Sample size too large for array dimension'
     +/'Starting value required for X (i.e. plotting coordinates)'
     +/'s-values (i.e. weights) in column 4 have been ignored'
     +/'Singular data set ... No analysis possible'
     +/'Shrinkage of contingency table has taken place in G01AFF'
     +/'Be Careful ... Suppress complete 2 by 2 tables as adjacent rows'
     +/'...'
     +/'...'
     +/'Insufficient valid data'
     +/'Must have k pairs of values, i.e. even no. rows'
     +/'Cochran-Mantel-Haenszel 2 x 2 x k Meta Analysis'
     +/'First do the meta analysis test'
     +/'Data has already been saved to file')
  500 FORMAT (
     + ' '
     +/'***'
     +/' '   
     +/'Meta Analysis',1X,A
     +/'-----------------'
     +/A
     +/'To test H0: equal binomial parameters'
     +/'Number of 2 by 2 tables      =',1X,A
     +/'Sample-size (rows)           =',1X,A
     +/'Overall sum of Y             =',1X,A
     +/'Overall sum of N             =',1X,A
     +/'Estimated binomial parameter =',F10.6
     +/'Lower ',I2,'% con. limit         =',F10.6
     +/'Upper ',I2,'% con. limit         =',F10.6
     +/'-2 log[lambda] (-2LL)        =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL)       =',0P,F8.4,1X,A
     +/'chi-sq. test stat (C)        =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C)          =',0P,F8.4,1X,A)
  550 FORMAT (
     + ' '
     +/'***'
     +/' '   
     +/'Meta Analysis',1X,A
     +/'-----------------'
     +/A
     +/'To test H0: equal binomial parameters'
     +/'Number of 2 by 2 tables      =',1X,A
     +/'Sample-size (rows)           =',1X,A
     +/'Overall sum of Y             =',1X,A
     +/'Overall sum of N             =',1X,A
     +/'Estimated binomial parameter =',F10.6
     +/'Lower ',I2,'% con. limit         =',F10.6
     +/'Upper ',I2,'% con. limit         =',F10.6
     +/'-2 log[lambda] (-2LL)        =',1X,A13,'  NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL)       =',F8.4,1X,A
     +/'chi-sq. test stat (C)        =',1X,A13,'  NDOF:',1X,A
     +/'p = P(chi-sq. >= C)          =',F8.4,1X,A)   
  600 FORMAT (
     + 'Meta Analysis',1X,A
     +/
     +/A
     +/'To test H0: equal binomial parameters'
     +/'Number of 2 by 2 tables =',1X,A
     +/'Sample-size (rows)  =',1X,A
     +/'Overall sum of Y =',1X,A
     +/'Overall sum of N =',1X,A,
     +/'Estimated binomial parameter =',F10.6
     +/'Lower ',I2,'% con. limit =',F10.6
     +/'Upper ',I2,'% con. limit =',F10.6
     +/'-2 log[lambda] (-2LL) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',0P,F8.4,1X,A
     +/'chi-sq. test stat (C) =',1P,E13.5,', NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',0P,F8.4,1X,A
     +/
     +/'2x2xk Meta Analysis (Cochran-Mantel-Haenszel)'
     +/'2x2xk Plot Log-Odds-Ratios(x) +/- ',i2,'% cl'
     +/'2x2xk Probability estimates and plots'
     +/'Save a p(x) curve-fit file: s = sqrt(p(1-p)/N)'
     +/'Save a p(x) curve-fit file: s = 1'
     +/'Results'
     +/'Quit ... Exit meta analysis')
  650 FORMAT (
     + 'Meta Analysis',1X,A
     +/
     +/A
     +/'To test H0: equal binomial parameters'
     +/'Number of 2 by 2 tables =',1X,A
     +/'Sample-size (rows)  =',1X,A
     +/'Overall sum of Y =',1X,A
     +/'Overall sum of N =',1X,A,
     +/'Estimated binomial parameter =',F10.6
     +/'Lower ',I2,'% con. limit =',F10.6
     +/'Upper ',I2,'% con. limit =',F10.6
     +/'-2 log[lambda] (-2LL) =',1X,A13,'  NDOF:',1X,A
     +/'p = P(chi-sq. >= -2LL) =',F8.4,1X,A
     +/'chi-sq. test stat (C) =',1X,A13,'  NDOF:',1X,A
     +/'p = P(chi-sq. >= C) =',F8.4,1X,A
     +/
     +/'2x2xk Meta Analysis (Cochran-Mantel-Haenszel)'
     +/'2x2xk Plot Log-Odds-Ratios(x) +/- ',i2,'% cl'
     +/'2x2xk Probability estimates and plots'
     +/'Save a p(x) curve-fit file: s = sqrt(p(1-p)/N)'
     +/'Save a p(x) curve-fit file: s = 1'
     +/'Results'
     +/'Quit ... Exit meta analysis')     
 1900 FORMAT (
     +6X,'y',6X,'N    Odds Ratio     E[n(1,1)]   Var[n(1,1)]')
 2000 FORMAT (2I7,1P,3(1X,E13.5))
 2100 FORMAT (2I7,3(1X,A13))
 2200 FORMAT ('H0: conditional independence (all odds ratios = 1)')
 2300 FORMAT ('CMH Test Statistic    =',1P,E13.5)
 2350 FORMAT ('CMH Test Statistic    =',1X,A13)
 2400 FORMAT ('p = P(chi-sq. >= CMH) =',F7.4,1X,A)
 2500 FORMAT ('Pooled Odds Ratio     =',1P,E13.5,',',I3,
     +'%cl: (',E12.5,',',E12.5,')')
 2550 FORMAT ('Pooled Odds Ratio     =',1X,A,',',I3,
     +'%cl: (',A,',',1X,A,')')     
 2600 FORMAT (
     +/'Overall 2 by 2 table'
     +/'       y   (N-y)'
     +/2I8
     +/2I8
     +/'Overall Odds Ratio =',1P,E13.5,',',I3,
     +'%cl: (',E12.5,',',E12.5,')')
 2650 FORMAT (
     +/'Overall 2 by 2 table'
     +/'       y   (N-y)'
     +/2I8
     +/2I8
     +/'Overall Odds Ratio =',1X,A,',',I3,
     +'%cl: (',A,',',A,')')    
      END
C
C
