c      
c      
      subroutine meta03 (nout,
     +                   fname)
c
c action: new version calling m_meta01
c author: w.g.bardsley, university of manchester, uk, 02/02/2021
c     
      implicit none
c
c arguments
c      
      integer,             intent (in) :: nout
      character (len = *), intent (in) :: fname
c
c allocatable
c      
      double precision, allocatable :: a(:,:) 
c
c locals
c      
      integer    i, icount, ios, j, ntemp
      integer    ncmax, ncol, nrmax, nrow
      character (len = 80) trim80, line, title
      logical    op
      external   trim80, getnou, m_meta01, putadv
      intrinsic  max
c
c open, check, then read file supplied
c      
      inquire (file = fname, opened = op, iostat = ios)
      if (ios.ne.0 .or.op) then
         line = trim80(fname)
         call putadv ('Cannot open '//line)
         return
      endif
      call getnou (ntemp)
      open (unit = ntemp, file = fname, iostat = ios) 
      icount = 0
      if (ios.eq.0) then
         read (ntemp,'(a)',iostat=ios) title
         if (ios.eq.0) icount = icount + 1
      endif    
      if (ios.eq.0) then
         read (ntemp,*, iostat=ios) nrow, ncol
         if (ios.eq.0) icount = icount + 1
      endif     
      if (ncol.lt.2 .or. ncol.gt.3) then
         close (unit = ntemp)
         call putadv (
     +'Analysis of proportion files should have 2 or 3 columns')
         return
      endif   
      nrmax = nrow  + 2!always add a couple of extra rows for some blas/lapack routines 
      ncmax = 3 
      allocate (a(nrmax,ncmax))
      do i = 1, nrow
         if (ios.eq.0) read (ntemp,*,iostat=ios) (a(i,j), j = 1, ncol)
         if (ios.eq.0) icount = icount + 1  
      enddo
      close (unit = ntemp)  
      if (ios.eq.0) then
         call m_meta01 (ncmax, ncol, nout, nrmax, nrow,
     +                  a,
     +                  fname, title)   
      else
         write (line,100) icount 
         call putadv (line)
      endif  
      deallocate (a)
  100 format ('Cannot read file at line',i6)     
      end
c      
c       