c
c
      subroutine mftidy (fname)
c
c action: tidy up a Simfit data file so that there is a trailer with nxtra = nxtrue 
c author: w.g.bardsley, university of manchester, u.k., 16/03/2018
c
c The routine will return fname unchanged if: 
c
c 1) fname does not exist or is read_only
c 2) The number of columns is so large that len(line) is not wide enough for ncol values 
c
c A new default trailer counter and section is provided if there is none.
c Otherwise the trailer counter is checked and repaired in necessary
c      
      implicit none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c      
      character (len = 2048), allocatable :: array(:)
      double precision,       allocatable :: x(:)  
      integer    i, ios, l, ncol, nout, nlines, nrow, ntemp, nxtra,
     +           nxtrue
      integer    n2
      parameter (n2 = 2)
      character (len = 2048) line
      character (len = 32  ) word32
      character (len = 1   ) blank
      parameter (blank = ' ') 
      logical    exist, read_only
      external   isitmf, getnou, attrib, ymdhms
      intrinsic  len_trim
c
c check that fname exists and is not read_only
c      
      call attrib (fname,
     +             exist, read_only)
      if (.not.exist .or. read_only) return
c
c make sure it is a data file and calculate nlines
c       
      call isitmf (ncol, nrow,
     +             fname)
      if (ncol.lt.1 .or. nrow.lt.1) return
      allocate(x(ncol))  
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      nlines = 0
      do while (ios.eq.0)
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0) then
            nlines = nlines + 1
         endif   
         if (nlines.eq.3) then
            read (line,*,iostat=ios) (x(i), i = 1, ncol)
            if (ios.ne.0) then
               close (unit = nout)
               deallocate(x) 
               return
            endif   
         endif  
      enddo
      close (unit = nout)
      deallocate(x)
c
c allocate array and save the file contents to array
c        
      allocate (array(nlines + 3))
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      i = 0
      do while (ios.eq.0)
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0) then
            i = i + 1
            array(i) = line
         endif   
      enddo
      close (unit = nout)
c
c trim trailing blank lines  
c      
      ntemp = nlines
      do i = ntemp, 1, -1
         if (array(i).eq.blank) then
            nlines = nlines - 1
         else
            exit
         endif   
      enddo
c
c add a dummy trailer if required
c      
      if (nlines.eq.nrow + 2) then
         write (line,'(i6)',iostat=ios) n2
         if (ios.ne.0) then
            deallocate(array)
            return
         endif 
         nlines = nlines + 1  
         array(nlines) = line
         nlines = nlines + 1
         array(nlines) = 'Default line'
         call ymdhms (word32)
         nlines = nlines + 1
         array(nlines) = word32
      endif   
c
c read the trailer counter
c         
      line = array(nrow + 3) 
      l = len_trim(line) 
      read (line(1:l),*,iostat=ios) ntemp
      if (ios.ne.0) then
         nxtra = nlines - nrow - 3
         nlines = nlines + 1
         do i = nlines, nrow + 3, -1
            array(i) = array(i - 1) 
         enddo
         write (array(nrow + 3),'(i6)',iostat=ios) nxtra
         if (ios.ne.0) then
            deallocate(array)
            return
         endif  
         nxtrue = nlines - nrow - 3
      else
         nxtra = ntemp
         nxtrue = nlines - nrow - 3  
      endif   
c
c further action if nxtra .ne. nxtrue
c      
      if (nxtra.ne.nxtrue) then
         write (line,'(i6)',iostat=ios) nxtrue
         if (ios.ne.0) then
            deallocate(array)
            return
         endif    
         array(nrow + 3) = line  
      endif  
c
c return the tidied-up file
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.eq.0) then
         do i = 1, nlines
            write (nout,'(a)',iostat=ios) trim(array(i))
         enddo
      endif
      close (unit = nout)    
      deallocate(array)  
      end 
c
c        