C
C
      SUBROUTINE MMOODD (NIN, NMAX, NOUT, NUMX, NUMY,
     +                   X, Y, U, V,
     +                   TITLEX, TITLEY,
     +                   SUPPLY)
C
C ACTION : median, Mood and David tests
C AUTHOR : W.G.Bardsley, University of Manchester, U.K
C          Derived from TTESTS, 03/03/2005
C          21/08/2007 added SUPPLY
C          20/09/2012 edited to remove check for NAG and introduce FORM12
C          25/07/2022 added E_NUMBERS and E_FORMATS, etc.    
C
C          NIN: (input/unchanged) unconnected unit for file opening
C         NMAX: (input/unchanged) dimension
C         NOUT: (input/unchanged) unit connected for saving results
C         NUMX: (input/output) sample size for X
C         NUMY: (input/output) sample size for Y
C            X: (input/output) X-data
C            Y: (input/output) Y-data
C            U: workspace
C            v: workspace
C       TITLEX: (input/output) X-title
C       TITLEY: (input/output) Y-title
C       SUPPLY: (input/unchanged) if .true. data supplied 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NOUT
      INTEGER,             INTENT (INOUT) :: NUMX, NUMY
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), Y(NMAX), 
     +                                       U(2*NMAX), V(2*NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLEX, TITLEY
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Locals
C
      INTEGER    I, I1, I2, ICOUNT, IFAIL, J, N, N1, N2
      INTEGER    ITEST
      PARAMETER (ITEST = 0)
      INTEGER    K0, K1, K2
      PARAMETER (K0 = 0, K1 = 1, K2 = 2)
      DOUBLE PRECISION P, PV, PW, RTOL, VTEST, WTEST
      DOUBLE PRECISION PSIG(7)
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  CHOP80*80, LINE*100, XTITLE*80, YTITLE*80
      CHARACTER  SYMBOL(7)*30, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER (LEN = 12) FORM12, WORD12(5)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   PUTIFA, TABLE1, VECTWO, CHOP80, PUTFAT, PLEVEL, FORM12
      EXTERNAL   X02AMF$, G08ACF$, G08BAF$
      INTRINSIC  MIN
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      E_NUMBERS = E_FORMATS()
C
C First read in data ... Use a larger RTOL than usual
C
      RTOL = 1.0D+09*X02AMF$()
      RTOL = 1.0D+09*RTOL
      IF (.NOT.SUPPLY) THEN
         CALL VECTWO (NIN, NMAX, NUMX, NUMY,
     +                X, Y,
     +                TITLEX, TITLEY,
     +                ABORT, FIXNPT)
         IF (ABORT) RETURN
      ENDIF     
      IF (NUMX.LT.K2) NUMX = K0
      IF (NUMY.LT.K2) NUMY = K0
      IF (NUMX.LT.K2 .OR. NUMY.LT.K2) THEN
         WRITE (LINE,100) NUMX, NUMY
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Create the combined vector of observations
C
      N = K0
      N1 = NUMX
      N2 = NUMY
      DO I = K1, N1
         N = N + K1
         U(N) = X(I)
      ENDDO
      DO I = K1, N2
         N = N + K1
         U(N) = Y(I)
      ENDDO
      IFAIL = K1
      CALL G08ACF$(U, N, N1, V, I1, I2, P, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08ACF/MMOODD')
      IF (IFAIL.NE.K0) RETURN
      CALL G08BAF$(U, N, N1, V, ITEST, WTEST, VTEST, PW, PV, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08BAF/MMOODD')
      IF (IFAIL.NE.K0) RETURN
      PSIG(1) = P
      PSIG(2) = TWO*MIN(PW, ONE - PW)
      PSIG(3) = ONE - PW
      PSIG(4) = PW
      PSIG(5) = TWO*MIN(PV, ONE - PV)
      PSIG(6) = ONE - PV
      PSIG(7) = PV
      DO I = 1, 7
         CALL PLEVEL (PSIG(I), SYMBOL(I))
      ENDDO
      XTITLE = CHOP80(TITLEX)
      YTITLE = CHOP80(TITLEY)
      ICOUNT = ICOUNT + K1
      WORD12(1) = FORM12(ICOUNT)
      WORD12(2) = FORM12(NUMX)
      WORD12(3) = FORM12(NUMY)
      WORD12(4) = FORM12(I1)
      WORD12(5) = FORM12(I2)
      IF (E_NUMBERS) THEN
         WRITE (TEXT,200) WORD12(1), XTITLE, WORD12(2), YTITLE,
     +                    WORD12(3),
     +                    WORD12(4), WORD12(5), PSIG(1), SYMBOL(1),
     +                    WTEST, (PSIG(I), SYMBOL(I), I = 2, 4),
     +                    VTEST, (PSIG(I), SYMBOL(I), I = 5, 7)
      ELSE
         D13(1) = SHOWLJ(WTEST)
         D13(2) = SHOWLJ(VTEST)
         WRITE (TEXT,250) WORD12(1), XTITLE, WORD12(2), YTITLE,
     +                    WORD12(3),
     +                    WORD12(4), WORD12(5), PSIG(1), SYMBOL(1),
     +                    D13(1), (PSIG(I), SYMBOL(I), I = 2, 4),
     +                    D13(2), (PSIG(I), SYMBOL(I), I = 5, 7)
      ENDIF  
      WRITE (NOUT,'(A)') BLANK
      J = 15
      CALL TABLE1 (J, 'OPEN')
      DO I = 1, 27
         IF (I.EQ.1 .OR. I.EQ.7 .OR. I.EQ.12 .OR. I.EQ.20) THEN
            J = 4
         ELSEIF (I.EQ.3 .OR. I.EQ.5) THEN
            J = 1
         ELSE
            J = 0
         ENDIF
         CALL TABLE1 (J, TEXT(I))
         WRITE (NOUT,'(A)') TEXT(I)
      ENDDO
      CALL TABLE1 (J, 'CLOSE')
C
C Format statements
C
      
  100 FORMAT ('Nx =',I2,', Ny =',I2,' ... Sample size too small')
  200 FORMAT(
     + 1X,'Median, Mood and David tests number',1X,A
     +/1X,'Current data sets X and Y are:'
     +/A
     +/1X,'Number of X-values =',1X,A
     +/A
     +/1X,'Number of Y-values =',1X,A
     +/1X,'Results for median test:'
     +/1X,'H0: medians are the same'
     +/1X,'Number of X-scores < pooled median =',1X,A
     +/1X,'Number of Y-scores < pooled median =',1X,A
     +/1X,'Probability under H0               =',F8.4,2X,A
     +/1X,'Results for the Mood test'
     +/1X,'H0: dispersions are equal'
     +/1X,'H1: X-dispersion > Y-dispersion'
     +/1X,'H2: X-dispersion < Y-dispersion'
     +/1X,'The Mood test statistic          =',1P,E11.3
     +/1X,'Probability under H0             =',0P,F8.4,2X,A
     +/1X,'Probability under H1             ='   ,F8.4,2X,A
     +/1X,'Probability under H2             ='   ,F8.4,2X,A
     +/1X,'Results for the David test'
     +/1X,'H0: dispersions are equal'
     +/1X,'H1: X-dispersion > Y-dispersion'
     +/1X,'H2: X-dispersion < Y-dispersion'
     +/1X,'The David test statistic         =',1P,E11.3
     +/1X,'Probability under H0             =',0P,F8.4,2X,A
     +/1X,'Probability under H1             ='   ,F8.4,2X,A
     +/1X,'Probability under H2             ='   ,F8.4,2X,A)
  250 FORMAT(
     + 1X,'Median, Mood and David tests number',1X,A
     +/1X,'Current data sets X and Y are:'
     +/A
     +/1X,'Number of X-values =',1X,A
     +/A
     +/1X,'Number of Y-values =',1X,A
     +/1X,'Results for median test:'
     +/1X,'H0: medians are the same'
     +/1X,'Number of X-scores < pooled median =',1X,A
     +/1X,'Number of Y-scores < pooled median =',1X,A
     +/1X,'Probability under H0               =',F7.4,2X,A
     +/1X,'Results for the Mood test'
     +/1X,'H0: dispersions are equal'
     +/1X,'H1: X-dispersion > Y-dispersion'
     +/1X,'H2: X-dispersion < Y-dispersion'
     +/1X,'The Mood test statistic          =',1X,A
     +/1X,'Probability under H0             =',F7.4,2X,A
     +/1X,'Probability under H1             =',F7.4,2X,A
     +/1X,'Probability under H2             =',F7.4,2X,A
     +/1X,'Results for the David test'
     +/1X,'H0: dispersions are equal'
     +/1X,'H1: X-dispersion > Y-dispersion'
     +/1X,'H2: X-dispersion < Y-dispersion'
     +/1X,'The David test statistic         =',1X,A
     +/1X,'Probability under H0             =',F7.4,2X,A
     +/1X,'Probability under H1             =',F7.4,2X,A
     +/1X,'Probability under H2             =',F7.4,2X,A)     
      END
C
C
