c
c
      subroutine mvnor1 (ncmax, ncsav, nin, nout, nrmax, nrsav, nsmall,
     +                   a, b, w1, w2,
     +                   fname, fsav, title, tsav,
     +                   newdat, supply)
c
c action: multivariate normal analysis
c author: w.g.bardsley, university of manchester, u.k., 17/08/2001
c         14/06/2004 added isxedit and isxtyp, corrected output for s.e.means
c         10/01/2006 c and d changed to local allocatable arrays
c         07/02/2006 added supply to argument list
c         10/02/2006 added newdat to argument list
c         27/07/2006 added checks for nrows > ncols
c         09/05/2016 replaced dsplay by corcov and edited formats
c         17/08/2020 added mvplot1 to replace the call to mvplot which now does missing variable plots
c
c  ncmax: (input/unchanged) dimension
c  ncsav: (input/output) if matrix is supplied or installed then ncol = ncsav
c    nin: (input/unchanged) unconnected unit for reading in data
c   nout: (input/unchanged) preconnected unit for results
c  nrmax: (input/unchanged) dimension
c  nrsav: (input/output) if matrix is supplied or installed the nrow = nrsav
c nsmall: (input/unchanged) dimension
c      a: (input/output) if matrix a is supplied ncsav > 0 and nrsav > 0 are
c                        the dimensions and then ncol is set to ncsav and nrow
c                        to nrsav. When data are installed then ncsav is set to
c                        ncol and nrsav to nrow.
c b, w1, w2: workspace. At each analysis b is set equal to the active
c            columns of a so that matrix a is never changed.
c fname, fsav, title, tsav: (input/output) character variables
c                           fname and title refer to the file containing a
c newdat: (output) if supply = .true. then newdat can be returned as .true.
c                  or false o/w it is returned as .false.
c supply: (input/unchanged) if .true. then the matrix is supplied
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncsav, nin, nout, nrmax, nrsav, nsmall
      double precision a(nrmax,ncmax), b(nrmax,ncmax), w1(nrmax),
     +                 w2(nrmax)
      character  fname*(*), fsav(nsmall)*(*), title*(*),
     +           tsav(nsmall)*(*)
      logical    newdat, supply
c
c local allocatable arrays
c
      integer, allocatable :: isx(:)
      double precision, allocatable :: c(:,:), d(:,:)
      double precision, allocatable :: xmu(:), xmu1(:)
c
c locals
c
      integer    i, id, ierr, isend, itype, j, k, ncol, ndof, nrow,
     +           ntext, numneg, nvar
      integer    ifail, l_col, l_row, len200
      integer    icolor, ix, iy, lshade, numdec, nxmin
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, nxmin = 2)
      integer    ng, nstart, numopt, numtxt
      parameter (ng = 1, nstart = 9, numopt = 17,
     +           numtxt = nstart + numopt - 1)
      integer    n0, n1, n2, n3, n4
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4)
      integer    numbld(30), numpos(20)
      integer    nvmax
      parameter (nvmax = 100)
      integer    isxsav(nvmax)
      double precision det, df, root, t, temp
      double precision d1, d2, eg, eh, el, p, s, tsqd, wmauch
      double precision xmusav(nvmax)
      double precision g01fbf$
      double precision zero, pnt95, two
      parameter (zero = 0.0d+00, pnt95 = 0.95d+00, two = 2.0d+00)
      character (len = 12) form12, word12_col, word12_row
      character (len = 13) d13(4), showlj, showrj
      character  line*100, text(30)*100
      character  chop80*80, word80*80, header*80
      parameter (header = 'Hotelling T^2 reference vector')
      character  blank*1, tail*1
      parameter (blank = ' ', tail = 'S')
      logical    e_numbers, e_formats
      logical    abort, iwarnu, ready, repeet
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    frame, next, updown
      parameter (frame = .false., updown = .true.)
      logical    curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .false., weight = .false.)
      logical    fileit
      parameter (fileit = .true.)
      external   lbox01, statmt, chop80, putadv, putfat, len200,
     +           table1, putifa, tutor1, editor, revpro, hotel1, hotel2,
     +           spher1, spher2, spher3, corcov, isxedi, isxtyp, form12
      external   g02baf$, g01fbf$, f01abf$, f02aaf$, f03aef$
      external   mvplot1
      external   e_formats, showlj, showrj
      intrinsic  sqrt, dble, min
      save       isxsav, xmusav
      data       isxsav / nvmax*n1 /
      data       xmusav / nvmax*zero /
      data       numbld / 30*0 /
      data       numpos / 20*1 /
c
c initialise newdat
c
      newdat = .false.
c
c action if supply = .true.
c
      if (supply) then
         if (ncsav.lt.2 .or. nrsav.lt.2 ) then
            call putfat ('Must have no. rows >= 2 and no. columns >= 2')
            return   
         elseif (ncsav.ge.nrsav) then
            call putfat ('Must have no. rows > no. columns')
            return   
         else
            ready = .true.
         endif
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xmu)) deallocate(xmu, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xmu1)) deallocate(xmu1, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(d(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(xmu(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(xmu1(ncmax), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      e_numbers = e_formats()
      do i = n1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
            xmu(i) = xmusav(i)
         else
            isx(i) = n1
            xmu(i) = zero
         endif
      enddo
      ncol = ncsav
      nrow = nrsav
      nvar = n0
      word80 = chop80(title)
      iwarnu = .false.
      if (ncol.gt.n1 .and. nrow.gt.n1) then
         ready = .true.
         nvar = ncol
      else
         ready = .false.
         nvar = n0
      endif
c
c main loop ............................................................
c
      repeet = .true.
      do while (repeet)
         line = blank
         if (ncol.gt.n0) then
c
c Write numbers/stars for variables included/suppressed
c
            call isxtyp (isx, ncol, nvar, nxmin,
     +                   line,
     +                   iwarnu)
         endif
c
c set up the main menu
c
         word12_col = form12(ncol)
         word12_row = form12(nrow)
         l_col = len200(word12_col)
         l_row = len200(word12_row)
         write (text,100) word12_row(1:l_row), word12_col(1:l_col), 
     +                    word80, line
         numdec = numopt - n2
         numbld(1) = n4
         numbld(4) = n1
         numbld(7) = n1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = n0
         numbld(4) = n0
         numbld(7) = n0
c
c check current data if analysis has been requested
c
         if (numdec.gt.1 .and. numdec.le.13) then
            if (.not.ready) then
               call putfat ('First read in some data')
               numdec = n0
            else
               nvar = n0
               do i = n1, ncol
                  if (isx(i).gt.n0) nvar = nvar + n1
               enddo
               if (nvar.lt.n1) then
                  call putfat ('No current data columns to analyse')
                  numdec = n0
               endif
c
c copy data from matrix a into matrix b to ensure no overwriting of matrix a
c
               k = n0
               do j = n1, ncol
                  if (isx(j).gt.n0) then
                     k = k + n1
                     do i = n1, nrow
                        b(i,k) = a(i,j)
                     enddo
                  endif
               enddo
            endif
         endif
c
c warn user if variables have been suppressed
c
         if (iwarnu) then
            if (numdec.eq.3 .or. (numdec.ge.5 .and. numdec.le.13)) then
               write (nout,'(a)') blank
               write (nout,'(a)') text(3)
               write (nout,'(a)') text(4)
            endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data...matrix a will not be changed from now on
c
            if (supply) then
               newdat = .true.
               return
            else
               ready = .false.
               call statmt (ncmax, ncsav, nout, nin, nrmax, nrsav,
     +                      nsmall,
     +                      a, b, w1,
     +                      fname, fsav, title, tsav)
               ncol = ncsav
               nrow = nrsav
               if (ncsav.gt.n0 .and. nrsav.gt.n0) then
                  abort = .false.
               else
                  abort = .true.
               endif
               if (.not.abort .and. ncol.lt.n2) then
                  abort = .true.
                  call putfat ('Must have at least 2 columns')
               endif
               if (.not.abort .and. nrow.lt.n2) then
                  abort = .true.
                  call putfat ('Must have at least 2 rows')
               endif 
               if (.not.abort .and. ncol.ge.nrow) then
                  abort = .true.
                  call putfat ('Must have no. rows > no. columns')
               endif   
               if (abort) then
                  nvar = n0
                  ready = .false.
                  word80 = 'No current data'
                  numdec = n1
               else
                  ready = .true.
                  nvar = ncol
                  do i = n1, ncol
                     if (isx(i).eq.n0) nvar = nvar - n1
                  enddo
                  if (nvar.lt.n2) then
                     isx(1) = n1
                     isx(2) = n1
                     nvar = n0
                     do i = n1, ncol
                        if (isx(i).gt.n0) nvar = nvar + n1
                     enddo
                     call putadv ('Variables 1 and 2 are now restored')
                  endif
                  word80 = chop80(title)
                  numdec = n2
               endif
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: diagnostic plot ... mvplot is now called mvplot1 to distinguish from mvplot which does missing value plots
c
            call mvplot1 (nvar, nout, nrmax, nrow,
     +                    b)
         elseif (numdec.eq.3) then
c
c numdec = 3: display means
c
             ifail = n1
             call g02baf$(nrow, nvar, b, nrmax, w1, w2, c, nrmax, d,
     +                    nrmax, ifail)
             call putifa (ifail, nout, 'G02BAF/MVNOR1')
             if (ifail.eq.n0) then
                root = sqrt(dble(nrow))
                df = dble(nrow - n1)
                t = g01fbf$(tail, pnt95, df, ifail)
                write (line,200)
                write (nout,200)
                j = 15
                call table1 (j, 'OPEN')
                j = 4
                call table1 (j, line)
                j = 0
                k = 0
                do i = n1, ncol
                   if (isx(i).gt.n0) then
                      k = k + 1
                      w2(k) = w2(k)/root
                      if (e_numbers) then
                         write (line,300) i, w1(k), w2(k),
     +                                     w1(k) - t*w2(k),
     +                                     w1(k) + t*w2(k)
                      else
                         d13(1) = showrj(w1(k))
                         d13(2) = showrj(w2(k))
                         temp = w1(k) - t*w2(k)
                         d13(3) = showrj(temp)
                         temp = w1(k) + t*w2(k)
                         d13(4) = showrj(temp)
                         write (line,350) i, d13(1), d13(2), d13(3),
     +                                    d13(4)	
                      endif  
                      write (nout,'(a)') line
                      call table1 (j, line)
                   endif
                enddo
                call table1 (j, 'CLOSE')
             endif
         elseif (numdec.eq.4) then
c
c numdec = 4: edit reference vector
c
            isend = n2
            itype = n1
            call editor (isend, itype, n1, ncmax, ncol,
     +                   xmu,
     +                   header,
     +                   curve, fixcol, fixrow, label, order, weight)
         elseif (numdec.eq.5) then
c
c numdec = 5: Hotelling 1 test
c
            j = n0
            do i = n1, ncol
               if (isx(i).gt.n0) then
                  j = j + n1
                  xmu1(j) = xmu(i)
               endif
            enddo
            isend = n3
            call hotel1 (isend, nvar, nout, nrmax, nrow,
     +                   b, c, d, d1, d2, p, s, tsqd, xmu1, w1, w2,
     +                   abort)
         elseif (numdec.eq.6) then
c
c numdec = 6: Hotelling 2 test
c
            isend = n3
            call hotel2 (isend, nvar, nout, nrmax, nrow,
     +                   b, c, d, d1, d2, p, s, tsqd, w1, w2,
     +                   abort)
         elseif (numdec.eq.7) then
c
c numdec = 7: display covariance matrix
c
             ifail = n1
             call g02baf$(nrow, nvar, b, nrmax, w1, w2, c, nrmax, d,
     +                    nrmax, ifail)
             call putifa (ifail, nout, 'G02BAF/MVNOR1')
             if (ifail.eq.n0) then
                df = dble(nrow - n1)
                do j = n1, nvar
                   do i = n1, nvar
                      c(i,j) = c(i,j)/df
                   enddo
                enddo
                line = 'Covariance matrix'
                itype = -1
                call corcov (itype, nvar, nrmax, nout,
     +                       c,
     +                       line,
     +                       fileit)
                line = 'Correlation matrix'  
                itype = -2
                call corcov (itype, nvar, nrmax, nout,
     +                       d,
     +                       line,
     +                       fileit)
                             
             endif

         elseif (numdec.eq.8) then
c
c numdec = 8: eigenvalues
c
             ifail = n1
             call g02baf$(nrow, nvar, b, nrmax, w1, w2, c, nrmax, d,
     +                    nrmax, ifail)
             call putifa (ifail, nout, 'G02BAF/MVNOR1')
             if (ifail.eq.n0) then
                 df = dble(nrow - n1)
                do j = n1, nvar
                   do i = n1, nvar
                      c(i,j) = c(i,j)/df
                      d(i,j) = c(i,j)
                   enddo
                enddo
                call f02aaf$(c, nrmax, nvar, w1, w2, ifail)
                call putifa (ifail, nout, 'F02AAF/MVNOR1')
                if (ifail.eq.n0) then
                   call f03aef$(nvar, d, nrmax, w1, det, id, ifail)
                   call putifa (ifail, nout, 'F03AEF/MVNOR1')
                   if (ifail.eq.n0) then
                      det = det*(two**id)
                      line = 'CV matrix eigenvalues'
                      j = 15
                      call table1 (j, 'OPEN')
                      j = 4
                      call table1 (j, line)
                      write (nout,'(a)') blank
                      write (nout,'(a)') line
                      j = 0
                      do i = n1, nvar
                         if (e_numbers) then
                            write (line,400) w1(i)
                         else
                            d13(1) = showlj(w1(i))
                            write (line,450) d13(1)
                         endif      
                         write (nout,'(a)') line
                         call table1 (j, line)
                      enddo
                      if (e_numbers) then
                         write (line,500) det
                      else
                         d13(1) = showlj(det)
                         write (line,550) d13(1)  
                      endif    
                      write (nout,'(a)') line
                      j = 1
                      call table1 (j, line)
                      call table1 (j, 'CLOSE')
                   endif
                endif
             endif
         elseif (numdec.eq.9) then
c
c numdec = 9: sphericity 3 ... compound symmetry
c
            isend = n3
            itype = n1
            call spher3 (isend, itype, nvar, nout, nrmax, nrow, ng,
     +                   b, c, d, d1, p, s, w1, w2,
     +                   abort)
         elseif (numdec.eq.10) then
c
c numdec = 10: sphericity 1 ... overall sphericity
c
            isend = n3
            itype = n1
            call spher1 (isend, itype, nvar, nout, nrmax, nrow, numneg,
     +                   b, c, d, d1, p, s, w1, w2,
     +                   abort)
         elseif (numdec.eq.11) then
c
c numdec = 11: sphericity 2 ... sphericity of orthonormal contrasts
c
            isend = n3
            itype = n1
            ndof = nrow - n1
            call spher2 (isend, itype, nvar, ndof, ng, nout, nrmax,
     +                   nrow, numneg,
     +                   b, c, d, d1, eg, eh, el, p, s, wmauch, w1, w2,
     +                   abort)
         elseif (numdec.eq.12) then
c
c numdec = 12: display covariance matrix inverse
c
             ifail = n1
             call g02baf$(nrow, nvar, b, nrmax, w1, w2, c, nrmax, d,
     +                    nrmax, ifail)
             call putifa (ifail, nout, 'G02BAF/MVNOR1')
             if (ifail.eq.n0) then
                df = dble(nrow - n1)
                do j = n1, nvar
                   do i = n1, nvar
                      c(i,j) = c(i,j)/df
                   enddo
                enddo
                call f01abf$(c, nrmax, nvar, d, nrmax, w1, ifail)
                call putifa (ifail, nout, 'F01ABF/MVNOR1')
                if (ifail.eq.n0) then
                   line = 'Covariance matrix inverse'
                   itype = -1
                   call corcov (itype, nvar, nrmax, nout,
     +                          d,
     +                          line,
     +                          fileit)
                endif
             endif
         elseif (numdec.eq.13) then
c
c numdec = 13: eigenvalues of inverse
c
             ifail = n1
             call g02baf$(nrow, nvar, b, nrmax, w1, w2, c, nrmax, d,
     +                    nrmax, ifail)
             call putifa (ifail, nout, 'G02BAF/MVNOR1')
             if (ifail.eq.n0) then
                df = dble(nrow - n1)
                do j = n1, nvar
                   do i = n1, nvar
                      c(i,j) = c(i,j)/df
                   enddo
                enddo
                call f01abf$(c, nrmax, nvar, d, nrmax, w1, ifail)
                call putifa (ifail, nout, 'F01ABF/MVNOR1')
                if (ifail.eq.n0) then
                   do j = n1, nvar
                      do i = n1, nvar
                         c(i,j) = d(i,j)
                      enddo
                   enddo
                   call f02aaf$(c, nrmax, nvar, w1, w2, ifail)
                   call putifa (ifail, nout, 'F02AAF/MVNOR1')
                   if (ifail.eq.n0) then
                     call f03aef$(nvar, d, nrmax, w1, det, id, ifail)
                     call putifa (ifail, nout, 'F03AEF/MVNOR1')
                      if (ifail.eq.n0) then
                         det = det*(two**id)
                         line = 'CV matrix inverse eigenvalues'
                         j = 15
                         call table1 (j, 'OPEN')
                         j = 4
                         call table1 (j, line)
                         write (nout,'(a)') blank
                         write (nout,'(a)') line
                         j = 0
                         do i = n1, nvar
                            if (e_numbers) then
                               write (line,400) w1(i)
                            else
                               d13(1) = showlj(w1(i))
                               write (line,450) d13(1)
                            endif      
                            write (nout,'(a)') line
                            call table1 (j, line)
                         enddo
                         if (e_numbers) then
                            write (line,500) det
                         else
                            d13(1) = showlj(det)  
                            write (line,550) d13(1) 
                         endif   
                         write (nout,'(a)') line
                         j = 1
                         call table1 (j, line)
                         call table1 (j, 'CLOSE')
                      endif
                   endif
                endif
             endif
         elseif (numdec.eq.14) then
c
c numdec = 14: select to suppress/restore
c
            call isxedi (isx, ncol, nvar, nxmin)
            numdec = n2
         elseif (numdec.eq.numopt - n2) then
c
c numdec = numopt - 2: help
c
             write (text,600)
             ntext = 21
             numbld(1) = 1
             numbld(10) = 1
             numbld(19) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(10) = 0
             numbld(19) = 0
             write (text,700)
             ntext = 21
             next = .true.
             numbld(1) = 1
             numbld(5) = 1
             numbld(11) = 1
             numbld(17) = 1
             numbld(20) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(5) = 0
             numbld(11) = 0
             numbld(17) = 0
             numbld(20) = 0
             next = .false.
             write (text,800)
             ntext = 21
             numbld(1) = 1
             numbld(4) = 1
             numbld(9) = 1
             numbld(13) = 1
             numbld(16) = 1
             numbld(19) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(4) = 0
             numbld(9) = 0
             numbld(13) = 0
             numbld(16) = 0
             numbld(19) = 0
             numdec = 2
         elseif (numdec.eq.numopt - n1) then
c
c numdec = numopt - 1: review progress
c
            call revpro (nout)
            numdec = 2
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c
            repeet = .false.
         endif
      enddo
c
c store counters and means
c
      do i = n1, min(nvmax,ncmax)
         isxsav(i) = isxsav(i)
         xmusav(i) = xmu(i)
      enddo
c
c deallocate workspace
c
      deallocate(isx, stat = ierr)
      deallocate(c, stat = ierr)
      deallocate(d, stat = ierr)
      deallocate(xmu, stat = ierr)
      deallocate(xmu1, stat = ierr)
c
c format statements
c      
  100 format (
     + 'Analysis of a',1x,a,1x,'by',1x,a,1x,'multivariate normal matrix'
     +/
     +/'Title for supposed multivariate normal data:'
     +/A
     +/
     +/'Variables included:'
     +/A
     +/
     +/'Data: New/Edit/transform/View'
     +/'Multivariate normal distribution plot'
     +/'Means: display/file'
     +/'Means: edit reference vector'
     +/'Means: test if equal to reference vector'
     +/'Means: test if all are equal'
     +/'CV matrix: display/file/correlations'
     +/'CV matrix: eigenvalues/determinant'
     +/'CV matrix: compound symmetry test'
     +/'CV matrix: likelihood ratio sphericity test (Mauchly W)'
     +/'CV matrix: test Helmert orthonormal contrasts (Mauchly W, etc.)'
     +/'CV matrix inverse: display/file'
     +/'CV matrix inverse: eigenvalues/determinant'
     +/'Suppress/Restore variables'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit multivariate normal matrix options')
  200 format (
     +'Variable        Mean         Std.err.    lower95%cl',
     +'    upper95%cl')
  300 format (i6,3x,1p,4(1x,e13.5))
  350 format (i6,3x,4(1x,a13))
  400 format (1p,e13.5)
  450 format (1x,a13)
  500 format ('Determinant =',1p,e13.5)
  550 format ('Determinant =',1x,a13)
  600 format (
     + 'Overview of multivariate normal options'
     +/
     +/'It is supposed that m variables have been measured for n cases'
     +/'and the data have been formatted as a matrix file with n rows'
     +/'(n > 1) and m columns (m > 1), e.g. using program Makmat.'
     +/'You select variables (columns) to include/exclude then various'
     +/'options are possible to explore the data assuming multivariate'
     +/'normality. Note: most of these only work reliably when n >> m.'
     +/
     +/'Multivariate normal distribution diagnostic plot'
     +/'If a sample is from a multivariate normal distribution the plot'
     +/'should be approximately linear if the number of rows is much'
     +/'greater than the number of columns. It calculates transforms'
     +/'y = [n(n - m)](x - x_bar)^T(S^{-1})(x - x_bar)/[m(n^2 - 1)],'
     +/'puts them in order, and then plots them against the quantiles'
     +/'of a F(m, n - m) distribution. Many other plots are possible'
     +/'with the exhaustive analysis of an arbitrary matrix procedure.'
     +/
     +/'Means: display/file'
     +/'The means, standard errors, and 95 percent confidence limits'
     +/'are calculated for all selected columns.')
  700 format (
     + 'Means: edit reference vector'
     +/'You can edit the mean vector to be used in a Hotelling 1-sample'
     +/'T-squared test (see next).'
     +/
     +/'Means: test if equal to the reference vector'
     +/'This performs a Hotelling 1-sample T-squared test for'
     +/'H0: mean vector equals reference vector'
     +/'against the alternative hypothesis'
     +/'H1: at least one mean does not equal a reference mean.'
     +/
     +/'Means: test if all are equal'
     +/'This performs a Hotelling 1-sample T-squared test for'
     +/'H0: all means are equal'
     +/'against the alternative hypothesis'
     +/'H1: at least one mean is not equal to the rest.'
     +/
     +/'CV matrix: display/file'
     +/'This allows you examine the covariance matrix.'
     +/
     +/'CV matrix: eigenvalues/determinant'
     +/'This calculates covariance matrix eigenvalues and determinant.')
  800 format (
     + 'CV matrix: sphericity test'
     +/'This tests if the CV matrix is a multiple of the identity.'
     +/
     +/'CV matrix: sphericity test on contrasts'
     +/'This tests if the covariance matrix of Helmert orthonormal'
     +/'contrasts is a multiple of the identity. This test should be'
     +/'done to check the validity of repeat measures ANOVA.'
     +/
     +/'CV matrix: test for compond symmetry'
     +/'Tests if diagonal elements equal sigma^2 and off-diagonals'
     +/'equal rho*sigma^2 for some rho >= 0.'
     +/
     +/'CV matrix inverse: display/file'
     +/'Allows you to examine CV^{-1}'
     +/
     +/'CV matrix: eigenvalues/determinant'
     +/'Allows you to examine eigenvalues and determinant of CV^{-1}.'
     +/
     +/'Suppressing and restoring variables'
     +/'These options allow you to temporarily alter the active columns'
     +/'in the data matrix.')
      end
c
c------------------------------------------------------------------------------
c
      subroutine mvplot1 (ncol, nout, nrmax, nrow,
     +                    x)
c
c action: multivariate normal diagnosis plot
c author: w.g.bardsley, university of manchester, u.k., 13/10/2003
c         20/06/2006 introduced allocatable arrays
c
c         Krzanowski W J: Principles of Multivariate Analysis Oxford 1988, p213
c
c         nrmax: (input/unchanged) ...leading dimension of x 
c          ncol: (input/unchanged) ...column dimension of x 
c          nout: (input/unchanged) ...pre-connected unit for errors 
c          nrow: (input/unchanged) ...row dimension of x 
c             x: (input/unchanged) ...data matrix 
c
      implicit   none
c
c arguments
c      
      integer    ncol, nout, nrmax, nrow 
      double precision x(nrmax,ncol)
c
c local allocatable arrays
c                 
      double precision, allocatable :: ssp(:,:), r(:,:), std(:),
     +                                 xbar(:), xvec(:)
      double precision, allocatable :: xgraf(:), ygraf(:)
c
c locals
c      
      integer    ia, ib, ix, m, n
      integer    i, ierr, ifail, issp, ir, j, ngraf
      integer    isend, nmaxc, nmaxr
      parameter (isend = 1)
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n0, n1, n2
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0, m2 = 0, m3 = 0,
     +           m4 = 0, n0 = 0, n1 = 1, n2 = 2)
      double precision a, b, res(20), s
      double precision d1, d2, denom, dncol, dngraf, p, ratio, rtol,
     +                 rval, t
      double precision x2(2), x3(2), x4(2)
      double precision y2(2), y3(2), y4(2)
      double precision half, one, two, pnt05
      parameter (half = 0.5d+00, one = 1.0d+00, two = 2.0d+00,
     +           pnt05 = 0.05d+00)
      double precision x02amf$, g01fdf$, g01ebf$
      character  line*100, ptitle*50, tail*1, xtitle*40, ytitle*30
      parameter (xtitle = 'F-quantiles',
     +           ytitle = 'Ranked Transforms')
      logical    abort
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   putfat, putifa, nxsort, gks004, xtrnax
      external   g02baf$, f01abf$, g02caf$, x02amf$, g01fdf$, g01ebf$
      intrinsic  dble, sqrt
c
c check input data
c
      if (ncol.lt.n2) then
         write (line,100)
         call putfat (line)
         return
      endif  
      if (nrow.lt.n2) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (nrow.le.ncol + n1) then
         write (line,300)
         call putfat (line)
         return
      endif    
      nmaxc = ncol + 2
      nmaxr = nrow + 2
      ierr = 0
      if (allocated(ssp)) deallocate(ssp, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(std)) deallocate(std, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xbar)) deallocate(xbar, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xvec)) deallocate(xvec, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
      if (ierr.ne.0) return
      allocate(ssp(nmaxc,nmaxc), stat = ierr)
      if (ierr.ne.0) return
      allocate(r(nmaxc,nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(std(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xbar(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xvec(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xgraf(nmaxr), stat = ierr)
      if (ierr.ne.0) return  
      allocate(ygraf(nmaxr), stat = ierr)
      if (ierr.ne.0) return 
c
c form the sum of squares matrix
c
      ifail = n1
      ir = nmaxc
      issp = nmaxc
      ix = nrmax
      m = ncol
      n = nrow
      call g02baf$(n, m, x, ix, xbar, std, ssp, issp, r, ir, ifail)
      call putifa (ifail, nout, 'G02BAF/MVPLOT1')
      if (ifail.ne.n0) return
c
c form the covariance matrix
c
      denom = dble(nrow - n1)
      do j = n1, ncol
         do i = n1, ncol
            ssp(i,j) = ssp(i,j)/denom
         enddo
      enddo
c
c invert the covariance matrix
c
      ia = nmaxc
      ib = nmaxc
      ifail = n1
      n = ncol
      call f01abf$(ssp, ia, n, r, ib, std, ifail)
      call putifa (ifail, nout, 'F01ABF/MVPLOT1')
      if (ifail.ne.n0) return
c
c fill in the upper triangle
c
      do i = n1, ncol - n1
         do j = i + n1, ncol
            r(i,j) = r(j,i)
         enddo
      enddo
c
c form the transforms
c
      ngraf = n0
      do i = n1, nrow
         do j = n1, ncol
            xvec(j) = x(i,j) - xbar(j)
         enddo
         call xtrnax (isend, nout, nmaxc, ncol, r, s, xvec, abort)
         if (.not.abort) then
            ngraf = ngraf + n1
            ygraf(ngraf) = s
         endif
      enddo
      dngraf = dble(ngraf)
      dncol = dble(ncol)
      d1 = dngraf*(dngraf - dncol)
      d2 = dncol*(dngraf*dngraf - one)
      ratio = d1/d2
      do i = n1, ngraf
         ygraf(i) = ratio*ygraf(i)
      enddo
      call nxsort (ngraf, ygraf)
c
c form the F inverses
c
      d1 = dncol
      d2 = dngraf - dncol
      do i = n1, ngraf
         s = (dble(i) - half)/dngraf
         ifail = n1
         xgraf(i) = g01fdf$(s, d1, d2, ifail)
         call putifa (ifail, nout, 'G01DFD/MVPLOT1')
         if  (ifail.ne.0) return
      enddo
c
c best fit line
c
      ifail = n1
      call g02caf$(ngraf, xgraf, ygraf, res, ifail)
      call putifa (ifail, nout, 'G02CAF/MVPLOT1')
      if (ifail.ne.n0) return
      a = res(6)
      b = res(7)
      x2(1) = xgraf(1)
      y2(1) = a*x2(1) + b
      x2(2) = xgraf(ngraf)
      y2(2) = a*x2(2) + b
c
c correlation
c
      rtol = 1.0d+09*x02amf$()
      rval = res(5)
      a = dngraf - two
      b = one - rval*rval
      if (b.lt.rtol) b = rtol
      t = rval*sqrt(a/b)
      tail = 'S'
      ifail = n1
      p = g01ebf$(tail, t, a, ifail)
      call putifa (ifail, nout, 'G01EBF/MVPLOT1')
      if (p.ge.pnt05) then
         write (ptitle,400) rval, p
      else
         write (ptitle,500) rval
      endif
      if (ngraf.le.20) then
         m1 = 5
      elseif (ngraf.le.50) then
         m1 = 4
      else
         m1 = 1
      endif
      call gks004 (l1, l2, l3, l4, m1, m2, m3, m4,
     +             ngraf, n2, n2, n2,
     +             xgraf, x2, x3, x4, ygraf, y2, y3, y4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
      deallocate(ssp, stat = ierr)  
      deallocate(r, stat = ierr) 
      deallocate(std, stat = ierr)
      deallocate(xbar, stat = ierr)
      deallocate(xvec, stat = ierr)
      deallocate(xgraf, stat = ierr)
      deallocate(ygraf, stat = ierr)
  100 format ('Too few columns ... must be > 1')  
  200 format ('Too few rows ... must be > 1')
  300 format ('Must have no. rows > no. columns + 1')
  400 format ('Multivariate Plot: r =',f6.3,', p =',f6.3)
  500 format ('Multivariate Plot: r =',f6.3)
      end
c
c


