c
c
      subroutine mvplot (ncol, nout, nrmax, nrow,
     +                   x)
c
c action: multivariate normal diagnosis plot
c author: w.g.bardsley, university of manchester, u.k., 13/10/2003
c         20/06/2006 introduced allocatable arrays
c
c         Krzanowski W J: Principles of Multivariate Analysis Oxford 1988, p213
c
c         nrmax: (input/unchanged) ...leading dimension of x 
c          ncol: (input/unchanged) ...column dimension of x 
c          nout: (input/unchanged) ...pre-connected unit for errors 
c          nrow: (input/unchanged) ...row dimension of x 
c             x: (input/unchanged) ...data matrix 
c
      implicit   none
c
c arguments
c      
      integer    ncol, nout, nrmax, nrow 
      double precision x(nrmax,ncol)
c
c local allocatable arrays
c                 
      double precision, allocatable :: ssp(:,:), r(:,:), std(:),
     +                                 xbar(:), xvec(:)
      double precision, allocatable :: xgraf(:), ygraf(:)
c
c locals
c      
      integer    ia, ib, ix, m, n
      integer    i, ierr, ifail, issp, ir, j, ngraf
      integer    isend, nmaxc, nmaxr
      parameter (isend = 1)
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n0, n1, n2
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0, m2 = 0, m3 = 0,
     +           m4 = 0, n0 = 0, n1 = 1, n2 = 2)
      double precision a, b, res(20), s
      double precision d1, d2, denom, dncol, dngraf, p, ratio, rtol,
     +                 rval, t
      double precision x2(2), x3(2), x4(2)
      double precision y2(2), y3(2), y4(2)
      double precision half, one, two, pnt05
      parameter (half = 0.5d+00, one = 1.0d+00, two = 2.0d+00,
     +           pnt05 = 0.05d+00)
      double precision x02amf$, g01fdf$, g01ebf$
      character  line*100, ptitle*50, tail*1, xtitle*40, ytitle*30
      parameter (xtitle = 'F-quantiles',
     +           ytitle = 'Ranked Transforms')
      logical    abort
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   putfat, putifa, nxsort, gks004, xtrnax
      external   g02baf$, f01abf$, g02caf$, x02amf$, g01fdf$, g01ebf$
      intrinsic  dble, sqrt
c
c check input data
c
      if (ncol.lt.n2) then
         write (line,100)
         call putfat (line)
         return
      endif  
      if (nrow.lt.n2) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (nrow.le.ncol + n1) then
         write (line,300)
         call putfat (line)
         return
      endif    
      nmaxc = ncol + 2
      nmaxr = nrow + 2
      ierr = 0
      if (allocated(ssp)) deallocate(ssp, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(std)) deallocate(std, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xbar)) deallocate(xbar, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xvec)) deallocate(xvec, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
      if (ierr.ne.0) return
      allocate(ssp(nmaxc,nmaxc), stat = ierr)
      if (ierr.ne.0) return
      allocate(r(nmaxc,nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(std(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xbar(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xvec(nmaxc), stat = ierr)
      if (ierr.ne.0) return 
      allocate(xgraf(nmaxr), stat = ierr)
      if (ierr.ne.0) return  
      allocate(ygraf(nmaxr), stat = ierr)
      if (ierr.ne.0) return 
c
c form the sum of squares matrix
c
      ifail = n1
      ir = nmaxc
      issp = nmaxc
      ix = nrmax
      m = ncol
      n = nrow
      call g02baf$(n, m, x, ix, xbar, std, ssp, issp, r, ir, ifail)
      call putifa (ifail, nout, 'G02BAF/MVPLOT')
      if (ifail.ne.n0) return
c
c form the covariance matrix
c
      denom = dble(nrow - n1)
      do j = n1, ncol
         do i = n1, ncol
            ssp(i,j) = ssp(i,j)/denom
         enddo
      enddo
c
c invert the covariance matrix
c
      ia = nmaxc
      ib = nmaxc
      ifail = n1
      n = ncol
      call f01abf$(ssp, ia, n, r, ib, std, ifail)
      call putifa (ifail, nout, 'F01ABF/MVPLOT')
      if (ifail.ne.n0) return
c
c fill in the upper triangle
c
      do i = n1, ncol - n1
         do j = i + n1, ncol
            r(i,j) = r(j,i)
         enddo
      enddo
c
c form the transforms
c
      ngraf = n0
      do i = n1, nrow
         do j = n1, ncol
            xvec(j) = x(i,j) - xbar(j)
         enddo
         call xtrnax (isend, nout, nmaxc, ncol, r, s, xvec, abort)
         if (.not.abort) then
            ngraf = ngraf + n1
            ygraf(ngraf) = s
         endif
      enddo
      dngraf = dble(ngraf)
      dncol = dble(ncol)
      d1 = dngraf*(dngraf - dncol)
      d2 = dncol*(dngraf*dngraf - one)
      ratio = d1/d2
      do i = n1, ngraf
         ygraf(i) = ratio*ygraf(i)
      enddo
      call nxsort (ngraf, ygraf)
c
c form the F inverses
c
      d1 = dncol
      d2 = dngraf - dncol
      do i = n1, ngraf
         s = (dble(i) - half)/dngraf
         ifail = n1
         xgraf(i) = g01fdf$(s, d1, d2, ifail)
         call putifa (ifail, nout, 'G01DFD/MVPLOT')
         if  (ifail.ne.0) return
      enddo
c
c best fit line
c
      ifail = n1
      call g02caf$(ngraf, xgraf, ygraf, res, ifail)
      call putifa (ifail, nout, 'G02CAF/MVPLOT')
      if (ifail.ne.n0) return
      a = res(6)
      b = res(7)
      x2(1) = xgraf(1)
      y2(1) = a*x2(1) + b
      x2(2) = xgraf(ngraf)
      y2(2) = a*x2(2) + b
c
c correlation
c
      rtol = 1.0d+09*x02amf$()
      rval = res(5)
      a = dngraf - two
      b = one - rval*rval
      if (b.lt.rtol) b = rtol
      t = rval*sqrt(a/b)
      tail = 'S'
      ifail = n1
      p = g01ebf$(tail, t, a, ifail)
      call putifa (ifail, nout, 'G01EBF/MVPLOT')
      if (p.ge.pnt05) then
         write (ptitle,400) rval, p
      else
         write (ptitle,500) rval
      endif
      if (ngraf.le.20) then
         m1 = 5
      elseif (ngraf.le.50) then
         m1 = 4
      else
         m1 = 1
      endif
      call gks004 (l1, l2, l3, l4, m1, m2, m3, m4,
     +             ngraf, n2, n2, n2,
     +             xgraf, x2, x3, x4, ygraf, y2, y3, y4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
      deallocate(ssp, stat = ierr)  
      deallocate(r, stat = ierr) 
      deallocate(std, stat = ierr)
      deallocate(xbar, stat = ierr)
      deallocate(xvec, stat = ierr)
      deallocate(xgraf, stat = ierr)
      deallocate(ygraf, stat = ierr)
  100 format ('Too few columns ... must be > 1')  
  200 format ('Too few rows ... must be > 1')
  300 format ('Must have no. rows > no. columns + 1')
  400 format ('Multivariate Plot: r =',f6.3,', p =',f6.3)
  500 format ('Multivariate Plot: r =',f6.3)
      end
c
c

