C
C
      SUBROUTINE MWUTST (IWRK, NIN, NMAX, NOUT, NX, NY,
     +                   RANKS, WRK, X, Y,
     +                   TITLEX, TITLEY)
C
C ACTION : Mann-Whitney U test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 1/12/94
C          04/02/1997 Edited to remove COMMON
C          05/05/1997 WIN32 version
C          07/02/2001 added CHOP80
C          27/09/2002 replaced patch1 by table1
C          17/04/2004 edited to add Wilcoxon, increased LWORK to maximum,
C                     and corrected large sample upper/lower tail p-values
C          20/04/2004 better approximate 1-tail values
C
C          IWRK: workspace
C           NIN: (input/unchanged) unconnected unit for input
C          NMAX: (input/unchanged) array dimension
C          NOUT: (input/unchanged) preconnected unit for output
C            NX: (input/output) X-dimension
C            NY: (input/output) Y-dimension
C         RANKS: workspace
C           WRK: workspace
C             X: (input/output) X-data
C             Y: (input/output) Y-data
C        TITLEX: (input/output) X-title
C        TITLEY: (input/output) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NIN, NMAX, NOUT, NX, NY
      INTEGER    IWRK(4*NMAX + 2)
      DOUBLE PRECISION RANKS(2*NMAX), WRK(2*NMAX), X(NMAX), Y(NMAX)
      CHARACTER  TITLEX*(*), TITLEY*(*)
C
C Locals
C
      INTEGER    I, ICOUNT, IFAIL, KWRK, LWRK, N, NSUM
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 18)
      DOUBLE PRECISION PROB, P1, P2, P3, U1, U2, U3, Z1
      DOUBLE PRECISION DNX, DNY, S, UL, UNORL, UNORU, UU
      DOUBLE PRECISION S15ABF$
      DOUBLE PRECISION PNT5, EPSI
      PARAMETER (PNT5 = 0.5D+00, EPSI = 1.0D-10)
      CHARACTER  TAIL*1
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP60*60, TEXT(30)*100
      LOGICAL    ABORT, EXACT, TIES
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP60, VECTWO
      EXTERNAL   G08AHF$, G08AJF$, G08AKF$, S15ABF$
      INTRINSIC  ABS, MIN, MAX, DBLE
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Get data or use data supplied depending on NX, NY
C
      CALL VECTWO (NIN, NMAX, NX, NY, X, Y, TITLEX, TITLEY, ABORT,
     +             FIXNPT)
      IF (ABORT) RETURN
C
C Calculate U, Z, and P with TAIL = 'T'
C
      IFAIL = 1
      TAIL = 'T'
      CALL G08AHF$(NX, X, NY, Y, TAIL, U1, Z1, P1, TIES, RANKS, WRK,
     +             IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08AHF/MWUTST')
      IF (IFAIL.NE.0) RETURN
C
C Copy U and set approximate significance levels in case of future errors
C
      U2 = U1
      U3 = U1
      P2 = PNT5
      P3 = PNT5

C
C Calculate exact significance levels for small samples
C
      IFAIL = 1
      LWRK = 2*NMAX
      IF (MAX(NX,NY).LT.30 .OR. (NX + NY).LT.40) THEN
         IF (.NOT.TIES) THEN
C
C Note: the academic version needs more workspace than the NAG one
C
            KWRK = NX*NY + 1
         ELSE
            N = MIN(NX,NY)
            NSUM = NX + NY
            KWRK = N + N*(N + 1)*NSUM - N*(N + 1)*(2*N + 1)/3 + 1
         ENDIF
         IF (KWRK.LE.LWRK) THEN
            EXACT = .TRUE.
         ELSE
            EXACT = .FALSE.
         ENDIF
      ELSE
         EXACT = .FALSE.
      ENDIF
      IF (EXACT) THEN
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U1, P1, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U1, P1, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) RETURN
      ENDIF
      IF (EXACT) THEN
C
C TAIL = 'L' p value to test using H1: x < y, F(x) > G(y)
C
         TAIL = 'L'
         IFAIL = 1
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U2, P2, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U2, P2, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) RETURN
C
C TAIL = 'U' p value to test using H1: x > y, F(x) < G(y)
C
         TAIL = 'U'
         IFAIL = 1
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U3, P3, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U3, P3, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) RETURN
      ELSEIF(ABS(Z1).GT.EPSI) THEN
C
C probabilities if .NOT.EXACT
C
         DNX = DBLE(NX)
         DNY = DBLE(NY)
         IF (U2.GT.PNT5*DNX*DNY) THEN
            S = (U2 - PNT5*DNX*DNY - PNT5)/Z1
         ELSE
            S = (U2 - PNT5*NX*NY + PNT5)/Z1
         ENDIF
C
C Lower tail test: reject H0 if p < alpha in favour of F(x) > G(y) i.e. x < y
C
         IF (S.GT.EPSI) THEN
            UL = U2
            UNORL = (UL - DNX*DNY*PNT5 + PNT5)/S
            I = 1
            PROB = S15ABF$(UNORL, I)
            P2 = PROB
C
C Upper tail test: reject H0 if p < alpha in favour of F(x) < G(y) i.e. x > y
C
            UU = DNX*DNY - U3
            I = 1
            UNORU = (UU - DNX*DNY*PNT5 + PNT5)/S
            PROB = S15ABF$(UNORU, I)
            P3 = PROB
         ENDIF
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      WRITE (NOUT,100) ICOUNT, TITLEX, TITLEY, NX, NY, U1, Z1, P1,
     +                 P1TYPE, P2, P2TYPE, P3, P3TYPE
      WRITE (TEXT,200) ICOUNT, CHOP60(TITLEX), CHOP60(TITLEY), NX, NY,
     +                 U1, Z1, P1, P1TYPE, P2, P2TYPE, P3, P3TYPE
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.6 .OR. I.EQ.11 .OR.
     +       I.EQ.13 .OR. I.EQ.15 .OR. I.EQ.17) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
  100 FORMAT (
     +/1X,'Wilcoxon-Mann-Whitney U test',I4
     +/1X,'================================'
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'Size of X-data =',I6
     +/1X,'Size of Y-data =',I6
     +/1X,'U =',1P,E11.3
     +/1X,'z =',1P,E11.3
     +/1X,'H0: F(x) is equal to G(y) (x and y are comparable)'
     +/1X,'    as null hypothesis against the alternatives:-'
     +/1X,'H1: F(x) not equal to G(y) (x and y not comparable)'
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H2: F(x) > G(y) (x tend to be smaller than y)'
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H3: F(x) < G(y) (x tend to be larger than y)'
     +/1X,'p =',0P,F8.4,4X,A)
  200 FORMAT (
     + 'Wilcoxon-Mann-Whitney U test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of X-data =',I6
     +/'Size of Y-data =',I6
     +/'U =',1P,E11.3
     +/'z =',1P,E11.3
     +/'H0: F(x) is equal to G(y) (x and y are comparable)'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: F(x) not equal to G(y) (x and y not comparable)'
     +/'p =',0P,F8.4,4X,A
     +/'H2: F(x) > G(y) (x tend to be smaller than y)'
     +/'p =',0P,F8.4,4X,A
     +/'H3: F(x) < G(y) (x tend to be larger than y)'
     +/'p =',0P,F8.4,4X,A)
      END
C
C
