C
C
      SUBROUTINE NDTES1 (NBONF, NOUT, NUM, 
     +                   X, XMU, XSIGMA, Y,
     +                   USEHAT)
C
C action: Chi-square test for normal distribution on X-values supplied
C author: w.g.bardsley, university of manchester, u.k., 22/08/2007
C         23/06/2021 introduced E_NUMBERS and E_FORMATS. etc. 
C         16/08/2021 corrected the output formats   
C
C Note: this version does not assume that all X are in increasing order
C       and could be very inefficient for large samples or large numbers
c       of bins.  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NBONF, NOUT, NUM
      DOUBLE PRECISION, INTENT (IN)    :: X(NUM), XMU, XSIGMA
      DOUBLE PRECISION, INTENT (INOUT) :: Y(NUM) 
      LOGICAL,          INTENT (IN)    :: USEHAT 
C
C Locals
C      
      INTEGER    NBIG, NMIN, N0, N1, N2, N4, N15
      PARAMETER (NBIG = 500, NMIN = 10, N0 = 0, N1 = 1, N2 = 2, 
     +           N4 = 4, N15 = 15)
      INTEGER    ICOUNT(NBIG)
      INTEGER    NBP1
      INTEGER    I, IFAIL, J
      INTEGER    ISUM, NBINS, NDOF, NHELP, NSMALL, NTOP
      INTEGER    NUMTXT
      DOUBLE PRECISION BOUND(0:NBIG), EXPECT(NBIG), OBSERV(NBIG)
      DOUBLE PRECISION ZERO, ONE, FIVE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, FIVE = 5.0D+00)
      DOUBLE PRECISION PNT01, PNT05, PNT4
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT4 = 0.4D+00)
      DOUBLE PRECISION DNBP1, RNPNT4, RNUM
      DOUBLE PRECISION DELTA, CHISQ, RNBINS, XPECT, Z
      DOUBLE PRECISION PGCHI, P95, P99
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION G01EAF$
      CHARACTER  RESUL(4)*30
      CHARACTER  LINE*100, TEXT(30)*100, TYPE1*50
      CHARACTER (LEN = 13) D13(5), SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12 
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   G01EAF$
      EXTERNAL   PUTFAT, PUTWAR, PUTADV, CHISQD, GETJM1, TABLE1, XSTAT2
      INTRINSIC  NINT, DBLE, MIN, TRIM
C
C Check sample size
C
      IF (NBONF.LT.N0 .OR. NBONF.GT.N2) THEN
         CALL PUTFAT ('NBONF out of range in call to NDTES1')
         RETURN
      ELSE
         NBP1 = NBONF + N1
         DNBP1 = DBLE(NBP1)   
      ENDIF   
      IF (NUM.LT.NMIN) THEN
         CALL PUTFAT ('N < 10: sample too small for a meaninigful test') 
         RETURN
      ENDIF   
C      
C Set up parameters for chi-square test if appropriate
C
      E_NUMBERS = E_FORMATS()
      DO I = 1, NUM
         IFAIL = 1
         Z = (X(I) - XMU)/XSIGMA
         Y(I) = G01EAF$(TAIL, Z, IFAIL)
         IF (IFAIL.NE.0) RETURN
      ENDDO   
      RNUM = DBLE(NUM)
      RNPNT4 = RNUM**PNT4
      NHELP = NINT(RNPNT4)
      NSMALL = N2
      IF (USEHAT) NSMALL = NSMALL + N2
      IF (NHELP.LT.NSMALL) NHELP = NSMALL
      IF (NHELP.GT.NBIG) NHELP = NBIG
      WRITE (LINE,100) NHELP
      NBINS = NHELP
      NTOP = MIN(NUM, NHELP, NBIG) 
      CALL GETJM1 (NSMALL, NBINS, NTOP,
     +             LINE)
      RNBINS = DBLE(NBINS)
      XPECT = RNUM/RNBINS
      IF (XPECT.LT.FIVE) THEN
         WRITE (LINE,200) XPECT
         WRITE (NOUT,200) XPECT
         CALL PUTADV (LINE)
      ENDIF
      DELTA = ONE/RNBINS
      BOUND(N0) = ZERO
      DO I = N1, NBINS - N1
         BOUND(I) = BOUND(I - N1) + DELTA
      ENDDO
      BOUND(N0) = - PNT05
      BOUND(NBINS) = ONE + PNT05
C
C Now chi-square test on transforms
C
      DO I = N1, NBINS
         ICOUNT(I) = N0
      ENDDO
      DO I = N1, NUM
         YES = .TRUE.
         J = N0
         DO WHILE (YES .AND. J.LT.NBINS)
            J = J + N1
            IF (Y(I).GE.BOUND(J - N1) .AND.
     +          Y(I).LT.BOUND(J)) THEN
               ICOUNT(J) = ICOUNT(J) + N1
               YES = .FALSE.
            ENDIF
         ENDDO
      ENDDO
      ISUM = N0
      DO I = N1, NBINS
         OBSERV(I) = ICOUNT(I)
         EXPECT(I) = XPECT
         ISUM = ISUM + ICOUNT(I)
      ENDDO
      NDOF = NBINS - N1
      IF (USEHAT) NDOF = NDOF - N2
      IF (NDOF.LT.N1) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         WRITE (NOUT,300)
         RETURN
      ELSE
         CALL CHISQD (NBINS, NDOF, NOUT,
     +                CHISQ, EXPECT, OBSERV, PGCHI, P95, P99)
         IF (PGCHI.LT.PNT01/DNBP1) THEN
            RESUL(4) = 'Reject H0 at 1% '
         ELSEIF (PGCHI.LT.PNT05/DNBP1) THEN
            RESUL(4) = 'Reject H0 at 5% '
         ELSE
            RESUL(4) = 'Do not reject H0'
         ENDIF
      ENDIF
      IF (E_NUMBERS) THEN
         WRITE (TEXT,400) NBP1, XMU, XSIGMA, 
     +                    NBINS, NDOF, CHISQ, PGCHI, RESUL(4), P95, P99
         WRITE (NOUT,400) NBP1, XMU, XSIGMA,
     +                    NBINS, NDOF, CHISQ, PGCHI, RESUL(4), P95, P99
      ELSE
         D13(1) = SHOWLJ(XMU)
         D13(2) = SHOWLJ(XSIGMA)
         D13(3) = SHOWLJ(CHISQ)
         D13(4) = SHOWLJ(P95)
         D13(5) = SHOWLJ(P99)
         I12(1) = FORM12(NBINS)
         I12(2) = FORM12(NDOF)
         WRITE (TEXT,450) NBP1, TRIM(D13(1)), TRIM(D13(2)), 
     +                    I12(1), I12(2), D13(3),
     +                    PGCHI, RESUL(4),
     +                    D13(4), D13(5)
         WRITE (NOUT,450) NBP1, TRIM(D13(1)), TRIM(D13(2)), 
     +                    I12(1), I12(2), D13(3),
     +                    PGCHI, RESUL(4),
     +                    D13(4), D13(5)
      ENDIF  
      J = N15
      NUMTXT = 12
      CALL TABLE1 (J, 'OPEN')
      DO I = N2, NUMTXT
         IF (I.EQ.N2) THEN
            J = N4
         ELSE
            J = N0
         ENDIF
         CALL TABLE1 (J, TEXT(I))
      ENDDO
      CALL TABLE1 (J, 'CLOSE')
      IF (ISUM.NE.NUM) THEN
         I12(1) = FORM12(ISUM)
         I12(2) = FORM12(NUM)
         WRITE (LINE,500) TRIM(I12(1)), TRIM(I12(2))
         WRITE (NOUT,500) TRIM(I12(1)), TRIM(I12(2))
         CALL PUTWAR (LINE)
      ENDIF
C
C Further chi-square options
C    
      D13(1) = SHOWLJ(XMU)
      TEMP = XSIGMA**2
      D13(2) = SHOWLJ(TEMP)  
      WRITE (TYPE1,600) TRIM(D13(1)), TRIM(D13(2))
      CALL XSTAT2 (NBINS, NUM,
     +             EXPECT, OBSERV, Y,
     +             TYPE1) 
C
C Format statements
C     
  100 FORMAT (
     +'Number of cells (bins) for chi-sq. test: Recommended =',I4)
  200 FORMAT ('Expected per bin =',F5.2,
     +'... Too small for a chi-sq. test ?')
  300 FORMAT (
     +'Not enough degrees of freedom for a chi-sq. test')
  400 FORMAT (
     +/'Chi-square test for normality (Bonferroni n =',I2,')'
     +/
     +/'H0: Sample is normally distributed with'
     +/'mu =',1p,e11.3,', sigma = ',1p,e10.3
     +/
     +/'Number of chi-square bins     =',I8
     +/'Number of degrees of freedom  =',I8
     +/'The Chi-sq. test statistic: C =',1P,E11.3
     +/'p = P(chi-square >= C)        =',0P,F8.4,4X,A
     +/'Upper tail 5% critical point  =',1P,E11.3
     +/'Upper tail 1% critical point  =',E11.3)
  450 FORMAT (
     +/'Chi-square test for normality (Bonferroni n =',I2,')'
     +/
     +/'H0: Sample is normally distributed with'
     +/'mu =',1X,A,', sigma =',1X,A
     +/
     +/'Number of chi-square bins     =',1X,A
     +/'Number of degrees of freedom  =',1X,A
     +/'The Chi-sq. test statistic: C =',1X,A
     +/'p = P(chi-square >= C)        =',F7.4,4X,A
     +/'Upper tail 5% critical point  =',1X,A
     +/'Upper tail 1% critical point  =',1X,A)
     
  500 FORMAT ('Sum of bins =',1X,A,', Number of items =',1X,A,' ?')
  600 FORMAT ('U(0,1) from N(mu=',A,',sig^2=',A,')')  
      END
C
C