C
C
      SUBROUTINE NDTEST (NGRAF, NIN, NMAX, NOUT, NZ, U, V, W,
     +                   XGRAF, YGRAF, Z, TITLEZ)
C
C ACTION : Kolmogorov-Smirnov and Shapiro-Wilks tests for a normal distribution
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from KS1SAM 27/03/2003
C          Note that some decision code for normal distribution, estimated
C          from sample, etc. is left in for possible future development.
C
      IMPLICIT   NONE
      INTEGER    NGRAF, NIN, NMAX, NOUT, NZ
      INTEGER    I, ICOUNT, IFAIL, NDIST, NTYPE
      INTEGER    NSWMAX
      PARAMETER (NSWMAX = 2000)
      INTEGER    ICOLOR, IX, IY, NUMTXT
      PARAMETER (IX = 4, IY = 4)
      INTEGER    NUMDEC, NUMOPT, N1, N2, NMIN, NUMPAR
      PARAMETER (N1 = 1, N2 = 2, NMIN = 3, NUMPAR = 2)
      INTEGER    NUMPOS(20)
      INTEGER    NGRAF1
      DOUBLE PRECISION U(2*NMAX), V(2*NMAX), W(2*NMAX)
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      DOUBLE PRECISION Z(NMAX)
      DOUBLE PRECISION PAR(NUMPAR), STDERR(NUMPAR)
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      DOUBLE PRECISION ZBAR, ZVAR
      DOUBLE PRECISION PL95(2), PU95(2), T95
      DOUBLE PRECISION CHIL95, CHIU95, RTOL, XTOL
      DOUBLE PRECISION PW, SW
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT975
      PARAMETER (PNT025 = 0.025D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION X02AMF$, G01FCF$, G01FBF$
      CHARACTER  TITLEZ*(*)
      CHARACTER  TITLE*80
      CHARACTER  DIST*2, DNAME*20, EST*1
      CHARACTER  PTYPE*100, PTYPE1*100, PTYPE2*100, PTYPE3*100
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  PTITLE*40
      CHARACTER  ANSWER*40, CHOP80*80, TEXT(30)*100
      CHARACTER  TEMP(3)*100
      LOGICAL    ABORT, CALWTS, ESTIM, REPEET
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   PLEVEL, PUTIFA, PUTFAT, TABLE1, LBOX02,
     +           GETD01, GETDGE, NXXBAR, PUTCAU, CHOP80, NXSORT
      EXTERNAL   VECONE, CDFOUT, PDFOUT, HNPLOT
      EXTERNAL   G08CBF$, X02AMF$, G01FCF$, G01FBF$, G01DDF$
      INTRINSIC  DBLE, SQRT
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      XTOL = SQRT(RTOL)
      PAR(1) = ONE
      PAR(2) = ONE
C
C Get some data
C
      CALL VECONE (NIN, NMAX, NZ, Z, TITLEZ, ABORT, FIXNPT)
      TITLE = CHOP80(TITLEZ)
      IF (ABORT) RETURN
      IF (NZ.LT.NMIN) THEN
         CALL PUTFAT ('Insufficient data for meaningful test')
         RETURN
      ENDIF
C
C Call NXXBAR for sample mean and standard deviation
C
      CALL NXXBAR (NZ, Z, ZBAR, ZVAR)
      IF (ZVAR.LE.RTOL) THEN
         CALL PUTFAT ('Singular data (all identical ?)')
         RETURN
      ENDIF
C
C Specify the distribution and method to use, i.e. NUMDEC = 2 for normal
C distribution and ESTIM = .TRUE. for parameters estimated from sample
C
      EST = 'E'
      ESTIM = .TRUE.
      NUMDEC = 2
C
C Estimate parameters or set them by hand
C
      IF (NUMDEC.EQ.2) THEN
         IF (ESTIM) THEN
            EST = 'E'
            PTYPE = 'Parameters estimated from sample are:'
            PTYPE3 = ' '
         ELSE
            RETURN
         ENDIF
         DIST = 'N'
         DNAME = 'Normal(mu,sigma^2)'
         IF (.NOT.ESTIM) THEN
            PAR(1) = ZBAR
            PAR(2) = SQRT(ZVAR)
            CALL GETD01 (PAR(1), 'The mean, mu')
            CALL GETDGE (PAR(2), ZERO,
     +                  'The standard deviation, sigma > 0')
            IF (PAR(2).LT.XTOL) PAR(2) = XTOL
            PAR(2) = PAR(2)**2
         ENDIF
      ELSE
         RETURN
      ENDIF
C
C The KS tests
C
      IFAIL = 1
      NTYPE = 1
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D1, Z1, P1, U, IFAIL)
      IF (IFAIL.GT.4 .AND. IFAIL.LT.9) THEN
          CALL PUTFAT ('Data inconsistent with distribution selected')
          RETURN
      ENDIF
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      NTYPE = 2
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D2, Z2, P2, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      NTYPE = 3
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D3, Z3, P3, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
C
C Write the parameters to PTYPE1 and PTYPE2
C
      IF (NUMDEC.EQ.2) THEN
C
C Normal
C
         IF (ESTIM) THEN
            STDERR(1) = SQRT(PAR(2)/DBLE(NZ))
            IFAIL = 0
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - 1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/KS1SAM')
            PL95(1) = PAR(1) - T95*STDERR(1)
            PU95(1) = PAR(1) + T95*STDERR(1)
            WRITE (PTYPE1,100) PAR(1), STDERR(1), PL95(1), PU95(1)
            IFAIL = 0
            CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            IFAIL = 0
            CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            PL95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIU95
            PU95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIL95
            WRITE (PTYPE2,200) SQRT(PAR(2)), PAR(2), PL95(2), PU95(2)
         ELSE
            RETURN
         ENDIF
         IF (NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks if NZ sufficiently small
C
            CALWTS = .TRUE.
            CALL NXSORT (NZ, Z)
            IFAIL = 1
            CALL G01DDF$(Z, NZ, CALWTS, W, SW, PW, IFAIL)
            IF (IFAIL.NE.0) THEN
               CALL PUTIFA (IFAIL, NOUT, 'G01DDF/KS1SAM')
               RETURN
            ENDIF
            IF (PW.LT.0.01D+00) THEN
               ANSWER = 'Reject normality at 1% sig.level'
            ELSEIF (PW.LT.0.05D+00) THEN
               ANSWER = 'Reject normality at 5% sig.level'
            ELSE
               ANSWER = 'Tentatively accept normality'
            ENDIF
         ELSE
            SW = ZERO
            PW = ONE
            ANSWER = 'ERROR: sample size too large'
         ENDIF
      ELSE
         RETURN
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + N1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      WRITE (NOUT,300) ICOUNT, DNAME, TITLE, PTYPE, PTYPE1, PTYPE2,
     +                 NZ, PTYPE3, D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      WRITE (TEXT,350) ICOUNT, DNAME, CHOP80(TITLE), CHOP80(PTYPE),
     +                 CHOP80(PTYPE1), CHOP80(PTYPE2),
     +                 NZ, CHOP80(PTYPE3), D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      NUMTXT = 22
      IF (NUMDEC.EQ.2 .AND. NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks results if NZ sufficiently small
C
         WRITE (NOUT,325) SW, PW, ANSWER
         WRITE (TEMP,375) SW, PW, ANSWER
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(1)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(2)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(3)
      ENDIF
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.10 .OR. I.EQ.11 .OR.
     +       I.EQ.15 .OR. I.EQ.19 .OR. I.EQ.23) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Plot just IFAIL points for the theoretical CDF
C
      IFAIL = 100
      IF (IFAIL.GT.NGRAF) THEN
         IFAIL = NGRAF
         CALL PUTCAU ('Sample too large to plot all values')
      ENDIF
      IF (NUMDEC.EQ.2) THEN
         WRITE (PTITLE,400) PAR(1), SQRT(PAR(2))
      ELSE
         RETURN
      ENDIF
C
C Set NDIST = NUMDEC and plot if required
C
      IF (NZ.GT.2) THEN
         NDIST = NUMDEC
         REPEET = .TRUE.
         NUMDEC = 1
         NUMOPT = 5
         WRITE (TEXT,500)
      ELSE
         REPEET = .FALSE.
      ENDIF
      DO WHILE (REPEET)
         ICOLOR = 7
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Plot CDF (IFAIL points) and sample CDF: U must be Z in ascending order
C
            NGRAF1 = IFAIL
            CALL CDFOUT (NGRAF1, NZ, NDIST, NUMPAR, PAR, U, XGRAF, V,
     +                   YGRAF, W, PTITLE)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot PDF (IFAIL points) and sample PDF: U must be Z in ascending order
C
            NGRAF1 = IFAIL
            CALL PDFOUT (NDIST, NGRAF1, NMAX, NUMPAR, NZ, PAR, XGRAF,
     +                   V(1), V(NMAX + 1), YGRAF, W(1), W(NMAX + 1), U)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Half normal plot
C
            IFAIL = N1
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Normal plot
C
            IFAIL = N2
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT ('mu =',1P,E11.3,', se =',E11.3,', 95%cl = (',
     +E11.3,',',E11.3,')')
  200 FORMAT ('sigma =',1P,E10.3,', sigma^2 =',E10.3,', 95%cl = (',
     +E9.3,',',E9.3,')')
  300 FORMAT (
     +/1X,'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/1X,'=============================================='
     +/1X,'Data: ',A
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,'Sample size =',I6,', i.e. no. of x-values'
     +/1X,A
     +/1X,'H0: F(x) equals G(y) (x & theory are comparable) against'
     +/1X,'H1: F(x) not equal to G(y) (x & theory not comparable)'
     +/1X,'D =',1P,E11.3
     +/1X,'z =',1P,E11.3
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H2: F(x) > G(y) (x tend to be smaller than theoretical)'
     +/1X,'D =',1P,E11.3
     +/1X,'z =',1P,E11.3
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H3: F(x) < G(y) (x tend to be  larger than theoretical)'
     +/1X,'D =',1P,E11.3
     +/1X,'z =',1P,E11.3
     +/1X,'p =',0P,F8.4,4X,A)
  325 FORMAT (
     + 1X,'Shapiro-Wilks normality test:'
     +/1X,'W statistic =',1P,E11.3
     +/1X,'Sign. level =',0P,F8.4,5X,A)
  350 FORMAT (
     + 'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/
     +/'Data:'
     +/A
     +/A
     +/A
     +/A
     +/'Sample size =',I6, ', i.e. no. of x-values'
     +/A
     +/'H0: F(x) equals G(y)(x & theory are comparable) against'
     +/'H1: F(x) not equal to G(y)(x & theory not comparable)'
     +/'D =',1P,E11.3
     +/'z =',1P,E11.3
     +/'p =',0P,F8.4,4X,A
     +/'H2: F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D =',1P,E11.3
     +/'z =',1P,E11.3
     +/'p =',0P,F8.4,4X,A
     +/'H3: F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D =',1P,E11.3
     +/'z =',1P,E11.3
     +/'p =',0P,F8.4,4X,A)
  375 FORMAT (
     + 'Shapiro-Wilks normality test:'
     +/'W statistic =',1P,E11.3
     +/'Sign. level =',0P,F8.4,5X,A)
  400 FORMAT ('Normal:mu =',1P,E10.2,',sigma =',E9.2)
  500 FORMAT (
     + 'Plot cdf and sample cumulative'
     +/'Plot pdf and sample histogram'
     +/'Plot normal scores (half)'
     +/'Plot normal scores (full)'
     +/'Quit ... Exit these plotting options')
      END
C
C
