c
c
      subroutine nmscal (iwk, liwk, lwk, n, ncmax, nout, nrmax,
     +                   d, dfit, wk, x,
     +                   wordx)
c
c action: non-metric scaling
c author: w.g.bardsley, university of manchester, u.k., 12/04/2005
c         10/11/2005 changed pltbal to lbplot 
c         12/07/2006 changed test for workspace size and edited error messages 
c         04/11/2006 added intents
c         01/01/2008 added nwmax, no_labels, and too_many
c         27/09/2012 replaced call to g05ccf$ by call to rseeds
c         14/04/2013 provided extra options
c         31/12/2021 added e_numbers and e_formats, etc.
c
c     iwk: workspace
c    liwk: (input/unchanged) dimension >= max(5*n, n*(n - 1)/2 + n*ndim + 5)
c     lwk: (input/unchanged) dimension >= max(2n(n - 1), 15*n*ndim,
c                                             n + n*(n + 17)/2 - 1) 
c       n: (input/unchanged) effective sample size > 1
c   ncmax: (input/unchanged) dimension
c    nout: (input/unchanged) preconnected unit for results
c   nrmax: (input/unchanged) dimension
c       d: (input/unchanged) distance matrix packed as lower triangle by rows
c    dfit: workspace
c      wk: workspace
c       x: workspace
c   wordx: (input/unchanged) labels
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: liwk, lwk
      integer,             intent (in)    :: n, ncmax, nout, nrmax
      integer,             intent (inout) :: iwk(liwk)
      double precision,    intent (in)    :: d(n*(n - 1)/2)
      double precision,    intent (inout) :: dfit(lwk), wk(lwk),
     +                                       x(nrmax,ncmax)
      character (len = *), intent (inout) :: wordx(*)
c
c locals
c
      integer    isend, l, m, ntype, numopt
      parameter (isend = 0, l = 0, ntype = 3)
      integer    icolor, ix, iy, lshade, numtxt, nwmax
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 23,
     +           nwmax = 2000)
      integer    numbld(numtxt)
      integer    i, ifail, iopt, iter, j, jseed, ktype, nbot, ndim,
     +           nswap, ntop, numdec
      integer    nbig, npcent, nrand
      integer    nx, ny, nz
      integer    ksav, k1, k2, k3, k4, k5
      double precision stress
      double precision a, b, frac, f100, temp
      parameter (f100 = 100.0d+00)
      double precision g05daf$, g05ddf$
      character (len = 13) d13, showlj
      character  line*100, text(30)*100
      character  ptitle*60, xtitle*50, ytitle*50
      parameter (ptitle = 'Non-Metric Scaling')
      character  rtype*10
      character  blank*1, type1*1, stype*8
      parameter (blank = ' ')
      character  no_labels*11, too_many*80
      parameter (no_labels = '%no_labels%',
     +too_many = 'Too many labels requested ... maxmimum = 2000')  
      logical    e_numbers, e_formats    
      logical    again, ok, repeet
      logical    border
      parameter (border = .false.)
      external   e_formats, showlj
      external   putfat, listbx, putifa, putadv, getjm1,
     +           gks001, lbplot, patch1, viewit
      external   space5
      external   g03faf$, g03fcf$, g05daf$, g05ddf$, rseeds
      intrinsic  min, dble, max, trim
      save       ndim, nx, ny, nz
      save       npcent, nrand
      save       type1
      save       nswap
      data       ndim, nx, ny, nz / 2, 1, 2, 3 /
      data       npcent, nrand / 0, 1 /
      data       type1 / 'T' /
      data       numbld / numtxt*0 /
      data       nswap / 1 /
c
c check
c
      call rseeds (isend, jseed, ktype)
      if (n.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif                         
      nbig = max(5*n, n*(n - 1)/2 + n*ndim + 5) 
      if (liwk.lt.nbig) then
         write (line,200)
         call putfat (line)
         return
      endif           
      nbig = max(2*n*(n - 1), n + n*(n + 17)/2 - 1, 15*n*ndim)
      if (lwk.lt.nbig) then
         write (line,300)
         call putfat (line)
         return
      endif
c
c main loop
c
      e_numbers = e_formats()
      ntop = min(n, ncmax)
      if (ndim.gt.ntop) ndim = ntop
      numdec = 1
      ok = .false.
      repeet = .true.
      do while (repeet)
         if (type1.eq.'T') then
            stype = 'STRESS'
         else
            stype = 'S-STRESS'
         endif
         if (nrand.eq.1) then
            rtype = 'Metric'
         elseif (nrand.eq.2) then
            rtype = 'Uniform'
         else
            rtype = 'Normal'
         endif
         write (text,400) stype, ndim, stype, rtype, npcent
         numopt = 10
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = 1
         call listbx (numdec, numopt, 
     +                text)
c
c check if choice is consistent
c
         if (numdec.eq.1) then
            k1 = n*(n - 1)/2 + n*ndim + 5
            k2 = 15*n*ndim
            if (liwk.lt.k1 .or. lwk.lt.k2) then
               write (line,500)
               call putfat (line)
               ndim = 2
            endif
         endif
         if (numdec.ge.2 .and. numdec.le.6 .and. .not.ok) then
            write (line,600)
            call putfat (line)
            numdec = 0
         endif
         if (numdec.eq.3) then
            if (n.gt.nwmax .or. wordx(1).eq.no_labels) then
               call putfat (too_many)
               numdec = 0
            endif   
         endif  
         if (numdec.eq.1) then
c
c numdec = 1: analysis
c
            ifail = 1
            call g03faf$('L', n, d, ndim, x, nrmax, wk, wk(n + 1), iwk,
     +                   ifail)
            if (ifail.eq.0) then
               frac = dble(npcent)/f100
               if (nrand.eq.2) then
                  do j = 1, ndim
                     do i = 1, n
                        temp = frac*x(i,j)
                        a = x(i,j) - temp
                        b = x(i,j) + temp
                        x(i,j) = g05daf$(a, b)
                     enddo
                  enddo
               elseif (nrand.eq.3) then
                  do j = 1, ndim
                     do i = 1, n
                        a = x(i,j)
                        b = frac*x(i,j)
                        x(i,j) = g05ddf$(a, b)
                     enddo
                  enddo
               endif
               iter = - 1
               iopt = 0
               ifail = 1
               call g03fcf$(type1, n, ndim, d, x, nrmax, stress, dfit,
     +                      iter, iopt, wk, iwk, ifail)
               if (ifail.eq.0) then
                  ok = .true.
                  if (e_numbers) then
                     write (line,700) trim(stype), stress, rtype, npcent
                  else  
                     d13 = showlj(stress)      
                     write (line,750) trim(stype), trim(d13), rtype,
     +                                npcent
                  endif  
                  write (nout,'(a)') blank
                  write (nout,'(a)') line
                  call putadv (line)
                  numdec = 2
               elseif (ifail.ge.3 .and. ifail.le.5) then
                  ok = .true.
                  write (line,700) stype, stress, rtype, npcent
                  write (nout,'(a)') blank
                  write (nout,'(a)') line
                  call putadv (line)
                  call putadv (
     +'Solution dubious ... random starts may locate a better mimimum')
                  numdec = 9
               else
                  ok = .false.
                  call putifa (ifail, nout, 'G03FCF/NMSCAL')
                  numdec = 9
               endif
            else
               ok = .false.
               call putifa (ifail, nout, 'G03FAF/NMSCAL')
            endif
         elseif (numdec.eq.2 .or. numdec.eq.3) then
c
c numdec = 2 or 3: 2D plots
c
            if (.not.ok .or. ndim.lt.2 .or. lwk.lt.2*n) then
               write (line,1200) stype, 2
               call putfat (line)
            else
               if (ndim.eq.2) then
                  nx = 1
                  ny = 2
               else
                  nbot = 1
                  ntop = ndim
                  if (nx.gt.ntop) nx = ntop
                  if (ny.gt.ntop) ny = ntop
                  write (line,1300) 'x'
                  call getjm1 (nbot, nx, ntop, line)
                  write (line,1300) 'y'
                  call getjm1 (nbot, ny, ntop, line)
               endif
               write (xtitle,1400) nx
               write (ytitle,1400) ny
               do i = 1, n
                  wk(i) = x(i,nx)
                  wk(n + i) = x(i,ny)
               enddo
               k1 = 1
               k2 = n + 1
               if (numdec.eq.2) then
                  if (n.le.50) then
                     m = 5
                  elseif (n.le.100) then
                     m = 4
                  else
                     m = 1
                  endif
                  call gks001 (l, m, n,
     +                         wk(k1), wk(k2),
     +                         ptitle, xtitle, ytitle)
                  numdec = 3
               else
                  call lbplot (n,
     +                         wk(k1), wk(k2),
     +                         ptitle, wordx, xtitle, ytitle)
                  numdec = 6
               endif
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: 3D plot
c
            if (.not.ok .or. ndim.lt.3 .or. lwk.lt.5*n) then
               write (line,1200) stype, 3
               call putfat (line)
            else
               if (ndim.eq.3) then
                  nx = 1
                  ny = 2
                  nz = 3
               else
                  nbot = 1
                  ntop = ndim
                  if (nx.gt.ntop) nx = ntop
                  if (ny.gt.ntop) ny = ntop
                  if (nz.gt.ntop) nz = ntop
                  write (line,1300) 'x'
                  call getjm1 (nbot, nx, ntop,
     +                         line)
                  write (line,1300) 'y'
                  call getjm1 (nbot, ny, ntop,
     +                         line)
                  write (line,1300) 'z'
                  call getjm1 (nbot, ny, ntop, 
     +                         line)
               endif
               do i = 1, n
                  wk(i) = x(i,nx)
                  wk(2*n + i) = x(i,ny)
                  wk(4*n + i) = x(i,nz)
               enddo
               k1 = 1
               k2 = n + 1
               k3 = 2*n + 1
               k4 = 3*n + 1
               k5 = 4*n + 1
               call space5 (n, n,
     +                      wk(k1), wk(k2), wk(k3), wk(k4), wk(k5))
            endif
            numdec = 6
         elseif (numdec.eq.5) then
c
c numdec = 5: view calculated matrix
c         
            line = 'Calculated non-metric (ordinal) matrix'   
            call viewit (ndim, nrmax, n, ntype,
     +                   x,
     +                   line)  
            numdec = 6          
         elseif (numdec.eq.6) then
c
c numdec = 6: change sign of a column
c         
             i = 1
             j = ndim
             if (nswap.gt.ndim) nswap = 1
             call  getjm1 (i, nswap, j,
     +                    'Number of column to multiply by -1')
             do i = 1, n
                x(i,nswap) = - x(i,nswap)
             enddo   
             write (line,'(a,i3)') 'Sign reversed for column', nswap 
             call putadv (line)   
             numdec = 2
         elseif (numdec.eq.7) then
c
c numdec = 7: change dimension
c
             ksav = ndim
             write (line,1500)
             nbot = 1
             ntop = min(n, ncmax)
             call getjm1 (nbot, ndim, ntop, 
     +                    line)
             if (ksav.ne.ndim) ok = .false.
             numdec = 1  
         elseif (numdec.eq.8) then
c
c numdec = 8: change stress
c
            if (type1.eq.'T') then
               type1 = 'S'
            else
               type1 = 'T'
            endif
            ok = .false.
            numdec = 1
         elseif (numdec.eq.9) then
c
c numdec = 9: change starting estimate type
c
            numopt = 4
            again = .true.
            nrand = numopt
            do while (again)
               write (text,1600)
               call listbx (nrand, numopt,
     +                      text)
               again = .false.
               if (nrand.eq.1) then
                  npcent = 0
               elseif (nrand.lt.4) then
                  write (line,1700)
                  nbot = 0
                  ntop = 1000
                  call getjm1 (nbot, npcent, ntop,
     +                         line)
                  if (npcent.eq.0) nrand = 1
               else
                  again = .true.
                  write (text,1800)
                  numbld(1) = 1
                  call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                         text,
     +                         border)
                  numbld(1) = 0
               endif
            enddo
            ok = .false.
            numdec = 1
         elseif (numdec.eq.numopt) then
c
c numdec = 10: cancel
c
            repeet = .false.
         endif
      enddo
  100 format ('Sample size too small (n < 2) in call to NMSCAL')
  200 format ('Workspace dimension LIWK too small in NMSCAL/G03FCF')
  300 format ('Workspace dimension LWK too small in NMSCAL/G03FCF')
  400 format (
     + 'Calculate:',1x,a
     +/'Result: Plot in 2D (simple)'
     +/'Result: Plot in 2D (advanced)'
     +/'Result: Plot in 3D'
     +/'Result: View/Print/Save As...'
     +/'Result: Change sign of a column'
     +/'Dimension: change (current =',i3,')'
     +/'Stress type: change (current =',1x,a,')'
     +/'Starting type: change (current =',1x,a,i4,'%)'
     +/'Quit ... Exit these options')
  500 format ('Insufficient workspace, dimension now = 2')
  600 format ('First analyse the distance matrix')
  700 format (a,1x,'=',1p,e12.4,1x,'(start =',1x,a,i4,'%)')
  750 format (a,1x,'=',1x,a,1x,'(start =',1x,a,i4,'%)')
 1200 format (a,1x,'not yet calculated for dimension >=', i2)
 1300 format ('Number of the component to be plotted as',1x,a)
 1400 format ('Component',i3)
 1500 format ('Number of dimensions required (usually 2 or 3)')
 1600 format (
     + 'Metric-scaling only'
     +/'Uniform distribution'
     +/'Normal distribution'
     +/'Help')
 1700 format ('Percentage to be used for random start')
 1800 format (
     + 'Perturbing the starting estimates for non-metric scaling'
     +/
     +/'Non-metric scaling uses an iterative optimisation technique, so'
     +/'only a local minimum can be returned. To check for a global'
     +/'minimum it is necessary to start the optimisation from several'
     +/'different points until a stable STRESS value is returned.'
     +/
     +/'The default method is to use coordinates from a metric scaling'
     +/'analysis, and this should be sufficient for well defined data'
     +/'sets, and requests for low dimensions. In other cases, new'
     +/'starting estimates can be generated by randomly perturbing the'
     +/'coordinates from the preliminary metric scaling procedure. You'
     +/'will be advised if this seems necessary due to an ill-defined'
     +/'minimum or if the maxmimum number of iterations have been used.'
     +/
     +/'Suppose:`A(i) = starting estimates from metric scaling, and'
     +/'        `B(i) = percentage*A(i)/100, for i = 1, 2,..., n.'
     +/
     +/'You can then choose new starting estimates A_new(i) from either'
     +/'A_new(i) = U(A(i) - B, A(i) + B), for a uniform distribution or'
     +/'A_new(i) = N(A(i), B(i)^2) for a normal distribution.'
     +/
     +/'You then select the percentage if a random start is requested')
      end
c
c
