C
C
      SUBROUTINE NONCEN (NOUT, MTYPE)
C
C ACTION: Non-central distributions
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 17/12/99
C         03/02/2001 now displays defaults in edit boxes
C         22/02/2005 edited and corrected arguments to g01gbf$
C         12/12/2021 added E_NUMBERS and E_FORMATS, etc.
C
C         NOUT: (input/unchanged) preconnected unit for results
C        MTYPE: (input/unchanged) set defaults as follows:
C               MTYPE = 1: t
C               MTYPE = 2: chi-square
C               MTYPE = 3: beta
C               MTYPE = 4: F
C               Otherwise default to t distribution
C
      IMPLICIT   NONE
      INTEGER    NOUT, MTYPE
      INTEGER    I, ICOUNT, IFAIL, NDEC, NPTS, NTYPE
      INTEGER    MAXIT
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NTEXT, NSTART, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 0, NTEXT = 22,
     +           NSTART = 12, NUMOPT = 11)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N3, N4, N50, N100, N500, N1000, N5000
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, N50 = 50, N100 = 100,
     +           N500 = 500, N1000 = 1000, N5000 = 5000)
      DOUBLE PRECISION A, B, DELTA, DFC, DFT, DF1, DF2, RLAMDA, RMAX, 
     +                 TMIN, TOL, X, Y, Z
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, EPSI, FIVE, TEN, BIG, SMALL
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, EPSI =  1.0d-05, FIVE = 5.0D+00, 
     +           TEN = 10.0D+00, BIG = 1.0D+05, SMALL = 1.0D-03)
      DOUBLE PRECISION M_TEN, O_SMALL
      PARAMETER (M_TEN = - TEN, O_SMALL = ONE - SMALL) 
      DOUBLE PRECISION X1(N1000), X2(N1), X3(N1), X4(N1), XTEMP(N1000)
      DOUBLE PRECISION Y1(N1000), Y2(N1), Y3(N1), Y4(N1)
      DOUBLE PRECISION XSTART(4), XSTOP(4)
      DOUBLE PRECISION XBOT(4), XTOP(4)
      DOUBLE PRECISION G01GBF$, G01GCF$, G01GDF$, G01GEF$, X02AMF$,
     +                 X02AJF$
      CHARACTER (LEN = 13) D13(10), SHOWLJ 
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 10) D10(2), FORMGR
      CHARACTER  LINE*100, NAME(4)*30, OPTS(4)*100, TEXT(NTEXT)*120
      CHARACTER  XTITLE*28,YTITLE*24
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN, AGAIN1
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   PUTIFA, LBOX01, GETDM1, GETDGE, PUTTXT, PUTFAT,
     +           LBOX02, GETJM1, GKS004, GETD01
      EXTERNAL   G01GBF$, G01GCF$, G01GDF$, G01GEF$, X02AMF$, X02AJF$
      INTRINSIC  LOG, DBLE, TRIM
      SAVE       A, B, DFC, DFC, DF1, DF2, RLAMDA, TOL, X
      SAVE       XSTART, XSTOP
      SAVE       MAXIT, NPTS
      DATA          A,   B,  DFT, DFC, DF1, DF2, RLAMDA,  TOL, X
     +          / ONE, TWO, FIVE, TEN, TEN, TEN, ONE, EPSI, HALF /
      DATA       XSTART / M_TEN, SMALL,    SMALL, SMALL /
      DATA       XSTOP  /   TEN,   TEN,  O_SMALL,   TEN /
      DATA       MAXIT, NPTS / N500, N100 /
      DATA       NAME / 'Non-central t',
     +                  'Non-central chi-sq',
     +                  'Non-central beta',
     +                  'Non-central F' /
      DATA       NUMBLD / NTEXT*N0 /
      DATA       NUMPOS / NUMOPT*N1 /
C
C Check MTYPE
C
      IF (MTYPE.LT.N1 .OR. MTYPE.GT.N4) THEN
         NTYPE = N1
      ELSE
         NTYPE = MTYPE
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Define extreme parameters
C
      RMAX = - LOG(X02AMF$())
      TMIN =  TEN*X02AJF$()
      XBOT(1) = - BIG
      XBOT(2) = SMALL
      XBOT(3) = SMALL
      XBOT(4) = SMALL
      XTOP(1) = BIG
      XTOP(2) = BIG
      XTOP(3) = ONE - SMALL
      XTOP(4) = BIG
      XSTART(1) = - TWO
      XSTART(2) = SMALL
      XSTART(3) = SMALL
      XSTART(4) = SMALL
      XSTOP(1) = TWO
      XSTOP(2) = TWO*TEN
      XSTOP(3) = ONE - SMALL
      XSTOP(4) = TWO*TEN
C
C Main loop
C
      AGAIN = .TRUE.
      NUMDEC = NUMOPT
      DO WHILE (AGAIN)
         IF (NTYPE.GT.1 .AND. RLAMDA.LT.ZERO) THEN
            CALL PUTFAT ('Lambda can only be < 0 for non-central t')
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) NAME(NTYPE), A, B, DFT, DFC, DF1, DF2,
     +                       RLAMDA, TOL, MAXIT, X, TRIM(NAME(NTYPE)),
     +                       TRIM(NAME(NTYPE))
         ELSE
            D13(1) = SHOWLJ(A)
            D13(2) = SHOWLJ(B)
            D13(3) = SHOWLJ(DFT)
            D13(4) = SHOWLJ(DFC)
            D13(5) = SHOWLJ(DF1)
            D13(6) = SHOWLJ(DF2)
            D13(7) = SHOWLJ(RLAMDA)
            D13(8) = SHOWLJ(TOL)
            D13(9) = SHOWLJ(X)
            I12 = FORM12(MAXIT)
            WRITE (TEXT,150) NAME(NTYPE), TRIM(D13(1)), TRIM(D13(2)),
     +                       TRIM(D13(3)), TRIM(D13(4)), TRIM(D13(5)),
     +                       TRIM(D13(6)), TRIM(D13(7)), TRIM(D13(8)),
     +                       TRIM(I12), TRIM(D13(9)), TRIM(NAME(NTYPE)), 
     +                       TRIM(NAME(NTYPE))
         ENDIF
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C Change distribution
C
            WRITE (OPTS,200)
            CALL LBOX02 (ICOLOR, IX, IY, NTYPE, N4, NUMPOS, OPTS)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Change A, B
C
            CALL GETDM1 (ZERO, A, BIG, 'Non-central beta parameter A')
            CALL GETDM1 (ZERO, B, BIG, 'Non-central beta parameter B')
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change DOF
C
            IF (NTYPE.EQ.1) THEN
               CALL GETDGE (DFT, ZERO, 'Non-central t DOF')
            ELSEIF (NTYPE.EQ.2) THEN 
               CALL GETDGE (DFC, ZERO, 'Non-central chi-square DOF')
            ENDIF   
         ELSEIF (NUMDEC.EQ.4) THEN
              
C
C Change DF1, DF2
C
            CALL GETDM1 (EPSI, DF1, BIG, 'Non-central F NDOF (num)')
            CALL GETDM1 (EPSI, DF2, BIG, 'Non-central F NDOF (denom)')
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Change lambda
C
            IF (NTYPE.EQ.1) THEN
               CALL GETD01 (RLAMDA, 'Non-centrality parameter')
            ELSE
               CALL GETDM1 (ZERO, RLAMDA, RMAX,
     +                     'Non-centrality parameter')
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Change TOL
C
            CALL GETDM1 (TMIN, TOL, ONE, 'TOL value required')
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Change MAXIT
C
            CALL GETJM1 (N50, MAXIT, N5000, ' MAXIT required')
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Change X
C
            IF (X.LT.XBOT(NTYPE) .OR. X.GT.XTOP(NTYPE))
     +          X = HALF*(XBOT(NTYPE) + XTOP(NTYPE))
            CALL GETDM1 (XBOT(NTYPE), X, XTOP(NTYPE),
     +                  'X value required')
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Calculate
C
            IF (X.LT.XBOT(NTYPE) .OR. X.GT.XTOP(NTYPE)) THEN
               CALL PUTFAT ('X out of range for chosen distribution')
            ELSE
               IFAIL = 1
               IF (NTYPE.EQ.1) THEN
                  Y = G01GBF$(X, DFT, RLAMDA, TOL, MAXIT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01GBF/NONCEN')
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,300) DFT, RLAMDA, X, Y
                     ELSE
                        D13(1) = SHOWLJ(DFT)
                        D13(2) = SHOWLJ(RLAMDA)
                        D13(3) = SHOWLJ(X)
                        WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2)), 
     +                                   TRIM(D13(3)), Y
                     ENDIF  
                     WRITE (NOUT,'(A)') LINE
                     CALL PUTTXT (LINE)
                  ENDIF
               ELSEIF (NTYPE.EQ.2) THEN
                  Y = G01GCF$(X, DFC, RLAMDA, TOL, MAXIT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01GCF/NONCEN')
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,400) DFC, RLAMDA, X, Y
                     ELSE
                        D13(1) = SHOWLJ(DFC)
                        D13(2) = SHOWLJ(RLAMDA)
                        D13(3) = SHOWLJ(X)
                        WRITE (LINE,450) TRIM(D13(1)), TRIM(D13(2)),
     +                                   TRIM(D13(3)), Y   
                     ENDIF  
                     WRITE (NOUT,'(A)') LINE
                     CALL PUTTXT (LINE)
                  ENDIF
               ELSEIF (NTYPE.EQ.3) THEN
                  Y = G01GEF$(X, A, B, RLAMDA, TOL, MAXIT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01GEF/NONCEN')
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,500) A, B, RLAMDA, X, Y
                     ELSE
                        D13(1) = SHOWLJ(A)
                        D13(2) = SHOWLJ(B)
                        D13(3) = SHOWLJ(RLAMDA)
                        D13(4) = SHOWLJ(X)
                        WRITE (LINE,550) TRIM(D13(1)), TRIM(D13(2)), 
     +                                   TRIM(D13(3)), TRIM(D13(4)), Y
                     ENDIF  
                     WRITE (NOUT,'(A)') LINE
                     CALL PUTTXT (LINE)
                  ENDIF
               ELSEIF (NTYPE.EQ.4) THEN
                  Y = G01GDF$(X, DF1, DF2, RLAMDA, TOL, MAXIT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01GDF/NONCEN')
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,600) DF1, DF2, RLAMDA, X, Y
                     ELSE
                        D13(1) = SHOWLJ(DF1)
                        D13(2) = SHOWLJ(DF2)
                        D13(3) = SHOWLJ(RLAMDA)
                        D13(4) = SHOWLJ(X)
                        WRITE (LINE,650) TRIM(D13(1)), TRIM(D13(2)),
     +                                   TRIM(D13(3)), TRIM(D13(3)), Y                        
                     ENDIF  
                     WRITE (NOUT,'(A)') LINE
                     CALL PUTTXT (LINE)
                  ENDIF
               ENDIF
            ENDIF
         ELSEIF(NUMDEC.EQ.10) THEN
C
C Plot
C
            AGAIN1 = .TRUE.
            NDEC = N3
            DO WHILE (AGAIN1)
               IF (E_NUMBERS) THEN
                  WRITE (OPTS,700) XSTART(NTYPE), XSTOP(NTYPE), NPTS
               ELSE
                  D10(1) = FORMGR(XSTART(NTYPE))
                  D10(2) = FORMGR(XSTOP(NTYPE))
                  I12 = FORM12(NPTS)
                  WRITE (OPTS,750) TRIM(D10(1)), TRIM(D10(2)),
     +                   TRIM(I12)
               ENDIF
                 
               CALL LBOX02 (ICOLOR, IX, IY, NDEC, N4, NUMPOS, OPTS)
               IF (NDEC.EQ.1) THEN
                  IF (XSTART(NTYPE).LT.XBOT(NTYPE) .OR.
     +                XSTART(NTYPE).GT.XTOP(NTYPE))
     +                XSTART(NTYPE) = XBOT(NTYPE)
                  CALL GETDM1 (XBOT(NTYPE), XSTART(NTYPE), XTOP(NTYPE),
     +                        'First X-value')
                  IF (XSTOP(NTYPE).GT.XTOP(NTYPE) .OR.
     +                XSTOP(NTYPE).LT.XSTART(NTYPE))
     +                XSTOP(NTYPE) = XTOP(NTYPE)
                  CALL GETDM1 (XSTART(NTYPE), XSTOP(NTYPE),
     +                         XTOP(NTYPE), 'Last X-value')
                  AGAIN1 = .TRUE.
               ELSEIF (NDEC.EQ.2) THEN
                  CALL GETJM1 (N4, NPTS, N1000,
     +                        'Number of points required')
                  AGAIN1 = .TRUE.
               ELSEIF (NDEC.EQ.3) THEN
                  DELTA = (XSTOP(NTYPE) - XSTART(NTYPE))/
     +                    (DBLE(NPTS) - ONE)
                  XTEMP(1) = XSTART(NTYPE)
                  DO I = 2, NPTS - 1
                     XTEMP(I) = XTEMP(I - 1) + DELTA
                  ENDDO
                  XTEMP(NPTS) = XSTOP(NTYPE)
                  ICOUNT = N0
                  DO I = N1, NPTS
                     IFAIL = N1
                     Z = XTEMP(I)
                     IF (NTYPE.EQ.1) THEN
                        Y = G01GBF$(Z, DFT, RLAMDA, TOL, MAXIT, IFAIL)
                     ELSEIF (NTYPE.EQ.2) THEN
                        Y = G01GCF$(Z, DFC, RLAMDA, TOL, MAXIT, IFAIL)
                     ELSEIF (NTYPE.EQ.3) THEN
                        Y = G01GEF$(Z, A, B, RLAMDA, TOL, MAXIT, IFAIL)
                     ELSEIF (NTYPE.EQ.4) THEN
                        Y = G01GDF$(Z, DF1, DF2, RLAMDA, TOL, MAXIT,
     +                              IFAIL)
                     ENDIF
                     IF (IFAIL.EQ.N0) THEN
                        ICOUNT = ICOUNT + N1
                        X1(ICOUNT) = Z
                        Y1(ICOUNT) = Y
                     ENDIF
                  ENDDO
                  DELTA = X1(ICOUNT) - X1(N1)
                  IF (ICOUNT.LE.N1 .OR. DELTA.LE.SMALL) THEN
                     CALL PUTFAT ('Insufficient data for plotting')
                  ELSE
                     IF (E_NUMBERS) THEN
                        WRITE (YTITLE,800) RLAMDA
                     ELSE
                        D13(1) = SHOWLJ(RLAMDA)
                        WRITE (YTITLE,850) TRIM(D13(1))
                     ENDIF       
                     IF (NTYPE.LE.2) THEN
                        IF (E_NUMBERS) THEN
                           IF (NTYPE.EQ.1) THEN
                              WRITE (XTITLE,900) DFT
                           ELSE 
                              WRITE(XTITLE,900) DFC
                           ENDIF      
                        ELSE
                           IF (NTYPE.EQ.1) THEN
                              D10(1) = FORMGR(DFT)
                           ELSE
                              D10(1) = FORMGR(DFC)
                           ENDIF      
                           WRITE (XTITLE,950) TRIM(D10(1))
                        ENDIF      
                     ELSEIF (NTYPE.EQ.3) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (XTITLE,1000) A, B
                        ELSE
                           D10(1) = FORMGR(A)
                           D10(2) = FORMGR(B)   
                           WRITE (XTITLE,1050) TRIM(D10(1)), 
     +                                         TRIM(D10(2))
                        ENDIF   
                     ELSE
                        IF (E_NUMBERS) THEN
                           WRITE (XTITLE,1100) DF1, DF2
                        ELSE
                           D10(1) = FORMGR(DF1)
                           D10(2) = FORMGR(DF2)
                           WRITE (XTITLE,1150) TRIM(D10(1)),
     +                                         TRIM(D10(2)) 
                        ENDIF    
                     ENDIF
                     CALL GKS004 (N1, N0, N0, N0, N0, N0, N0, N0,
     +                            ICOUNT, N1, N1, N1,
     +                            X1, X2, X3, X4,
     +                            Y1, Y2, Y3, Y4,
     +                            NAME(NTYPE), XTITLE, YTITLE,
     +                            LOGIC1, LOGIC2)
                  ENDIF
                  AGAIN1 = .TRUE.
               ELSE
                  AGAIN1 = .FALSE.
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Non-central distributions'
     +/
     +/'Current distribution =',2X,A
     +/'A, B (beta distribution) =',1P,E11.3,',', E11.3
     +/'DOF (t and chi-sq distributions) =',E11.3,',', E11.3
     +/'DF1, DF2 (F distribution) =',E11.3,',', E11.3
     +/'lambda (noncentrality parameter) =',E11.3
     +/'TOL (tolerance) =',E11.3
     +/'MAXIT (maximum number of iterations) =',I8
     +/'X value (current argument for p given x) =',E11.3
     +/
     +/'Change: current Non-central distribution'
     +/'Change: A, B'
     +/'Change: DOF'
     +/'Change: DF1, DF2'
     +/'Change: lambda'
     +/'Change: TOL'
     +/'Change: MAXIT'
     +/'Change: x (for p given x)'
     +/'Calculate for the',1X,A,1X,'distribution'
     +/'Plot for the',1X,A,1X,'distribution'
     +/'Quit ... Exit Non-central distributions options')
  150 FORMAT (
     + 'Non-central distributions'
     +/
     +/'Current distribution =',2X,A
     +/'A, B (beta distribution) =',1X,A,',',A
     +/'DOF (t and chi-sq distributions) =',1X,A,',',1X,A
     +/'DF1, DF2 (F ditribution) =',1X,A,',',A
     +/'lambda (noncentrality parameter) =',1X,A
     +/'TOL (tolerance) =',1X,A
     +/'MAXIT (maximum number of iterations) =',1X,A
     +/'X value (current argument for p given x) =',1X,A
     +/
     +/'Change: current Non-central distribution'
     +/'Change: A, B'
     +/'Change: DOF'
     +/'Change: DF1, DF2'
     +/'Change: lambda'
     +/'Change: TOL'
     +/'Change: MAXIT'
     +/'Change: x (for p given x)'
     +/'Calculate for the',1X,A,1X,'distribution'
     +/'Plot for the',1X,A,1X,'distribution'
     +/'Quit ... Exit Non-central distributions options')   
  200 FORMAT (
     + 'Non-central t'
     +/'Non-central chi-square'
     +/'Non-central beta'
     +/'Non-central F')
  300 FORMAT ('Non-central t: D0F = ',1P,E8.2,', lambda =',E9.2, 
     +' X =',E10.2,' P(NCT=<X) =',0P,F7.4)
  350 FORMAT ('Non-central t: DOF = ',A,', lambda = ',A,', X = ',A,
     +', P(NCT=<X) =',F7.4)   
  400 FORMAT ('Non-central chi-sq: DOF = ',1P,E8.2,', lambda =',E9.2,
     + ', X =',E10.2,', P(NCC=<X) =',0P,F7.4)
  450 FORMAT ('Non-central chi-sq: DOF = ',A,', lambda = ',A,', X = ',A,
     +', P(NCC=<X) =',F7.4)     
  500 FORMAT ('Non-central beta: A,B = ',1P,E8.2,',',E8.2,', lambda =',
     +E9.2,', X =',0P,F6.3,', P(NCB=<X) =',F7.4)
  550 FORMAT ('Non-central beta: A,B = ',A,',',A,', lambda = ',A,
     +', X = ',A,', P(NCB=<X) =',F7.4)     
  600 FORMAT ('Non-central F: DOF = ',1P,E8.2,',',E8.2,', lambda =',
     +E9.2,', X =',E10.2,', P(NCF=<X) =',0P,F7.4)
  650 FORMAT ('Non-central F: DOF = ',A,',',A,', lambda = ',A,
     +', X = ',A,', P(NCF=<X) =',F7.4)     
  700 FORMAT (
     + 'Change X-range (',1P,E11.3,',',E11.3,')'
     +/'Change number of points (',I4,')'
     +/'Plot current data'
     +/'Quit ... Exit these non-central plotting options')
  750 FORMAT (
     + 'Change X-range (',A,',',A,')'
     +/'Change number of points (',A,')'
     +/'Plot current data'
     +/'Quit ... Exit these non-central plotting options')   
  800 FORMAT ('P(x) (lambda=',1P,E9.3,')')
  850 FORMAT ('P(x) (lambda=',A,')')
  900 FORMAT ('x (DOF=',1P,E9.3,')')
  950 FORMAT ('x (DOF=',1X,A,')')
 1000 FORMAT ('x (A,B=',1P,E9.3,',',E9.3,')')
 1050 FORMAT ('x (A,B=',A,',',A,')')
 1100 FORMAT ('x (DOF=',1P,E9.3,',',E9.3,')')
 1150 FORMAT ('x (DOF=',A,',',A,')')
      END
C
C

