C
C
      SUBROUTINE NORDIS (ISEND, N, NOUT,
     +                   X, Y, Z,
     +                   TEXT, TITLE)
C
C ACTION : Sort then Shapiro and Wilks test
C          The values of X are returned unordered and as supplied
C          Y and Z are work spaces
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 17/6/93
C          07/02/2001 added CHOP80
C          25/09/2002 replaced patch1 by table1 and added icount
C          25/03/2003 checked maximum dimension NMAX to agree with G01DDF$
C                     and replaced CHOP80 by CHOP60
C          19/06/2006 increased NMAX from 2000 (true NAG) to 10000 (my NAG)
C          25/11/2013 added INTENTs, ISEND, and TEXT and restored CHOP80
C          10/08/2014 increased PAGE to (LEN = 100) 
C          03/11/2018 increased number of significant figures
C
C ISEND: ISEND = 1, just write output to TEXT
C        ISEND = 2, just write output to NOUT 
C        ISEND = 3: write output to TEXT   and NOUT (new ttest version)
C        ISEND = 4: write output to TABLE1 and NOUT (original  version)
C     N: dimension
C  NOUT: unit opened fopr writing
C     X: data
C  Y, Z: workspace
C  TEXT: results
C TITLE: data title
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, N, NOUT
      DOUBLE PRECISION,    INTENT (IN)    :: X(N)
      DOUBLE PRECISION,    INTENT (INOUT) :: Y(N), Z(N)
      CHARACTER (LEN = *), INTENT (OUT)   :: TEXT(4)
      CHARACTER (LEN = *), INTENT (IN)    :: TITLE
C
C Locals
C      
      INTEGER    I, ICOLOR, ICOUNT, IFAIL, NTEMP
      INTEGER    NMAX, NUMTXT
      PARAMETER (NMAX = 10000, NUMTXT = 4)
      DOUBLE PRECISION PW, W
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      CHARACTER (LEN = 100) PAGE(4)
      CHARACTER (LEN = 80 ) CHOP80, HEADER
      CHARACTER (LEN = 50 ) ANSWER
      CHARACTER (LEN = 8  ) WORD8
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')           
      LOGICAL    CALWTS
      PARAMETER (CALWTS = .TRUE.)
      EXTERNAL   G01DDF$
      EXTERNAL   PUTIFA, NXSORT, CHOP80, TRIML1, PUTFAT
      EXTERNAL   TABLE1
      INTRINSIC  MIN
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Initialise
C  
      DO I = 1, 4
        TEXT(I) = BLANK
      ENDDO      
C
C Check
C      
      IF (ISEND.LT.1 .OR. ISEND.GT.4) THEN
         CALL PUTFAT ('ISEND out of range in call to NORDIS')
         RETURN
      ENDIF 
      IF (N.LT.2) THEN
         CALL PUTFAT ('Sample size too small in call to NORDIS') 
         RETURN
      ENDIF    
C
C Define NTEMP in case N > NMAX then copy and sort
C
      NTEMP = MIN(N,NMAX)
      DO I = 1, NTEMP
         Y(I) = X(I)
      ENDDO
      CALL NXSORT (NTEMP,
     +             Y)
C
C Shapiro-Wilks test
C
      IFAIL = 1
      CALL G01DDF$(Y, NTEMP, CALWTS, Z, W, PW, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01DDF/NORDIS')
      IF (IFAIL.NE.0) RETURN
C
C Assign significance level
C
      IF (PW.LT.PNT01) THEN
         ANSWER = 'Reject normality at 1% sig. level'
      ELSEIF (PW.LT.PNT05) THEN
         ANSWER = 'Reject normality at 5% sig. level'
      ELSE
         ANSWER = 'Tentatively accept normality'
      ENDIF
C
C Redefine ANSWER if N > NMAX
C
      IF (NTEMP.LT.N) THEN
         WRITE (WORD8,'(I8)') N
         CALL TRIML1 (WORD8)
         ANSWER = 'No. data points analysed = '//WORD8
      ENDIF
C
C Output results
C
      ICOUNT = ICOUNT + 1
      WRITE (WORD8,'(I8)') ICOUNT
      CALL TRIML1 (WORD8)
      HEADER = CHOP80(TITLE)
      IF (ISEND.EQ.1) THEN
         WRITE (TEXT,100) WORD8, HEADER, W, PW, ANSWER
      ELSEIF (ISEND.EQ.2) THEN   
         WRITE (NOUT,200) ICOUNT, HEADER, W, PW, ANSWER
      ELSEIF (ISEND.EQ.3) THEN   
         WRITE (TEXT,100) WORD8, HEADER, W, PW, ANSWER
         WRITE (NOUT,200) ICOUNT, HEADER, W, PW, ANSWER
      ELSEIF (ISEND.EQ.4) THEN   
         WRITE (PAGE,100) WORD8, HEADER, W, PW, ANSWER
         WRITE (NOUT,200) ICOUNT, HEADER, W, PW, ANSWER
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = 1, NUMTXT
            IF (I.EQ.2) THEN
               ICOLOR = 4
             ELSE
                ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, PAGE(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF   
C
C Format statements
C
         
  100 FORMAT (
     + 'Normal distribution test',1X,A
     +/'Data:',1X,A
     +/'Shapiro-Wilks statistic W =',F9.5
     +/'Significance level for  W =',F9.5,2X,A)
  200 FORMAT (
     +/'Normal distribution test',I4
     +/'----------------------------'
     +/'Data:',1X,A
     +/'Shapiro-Wilks statistic W =',F9.5
     +/'Significance level for  W =',F9.5,2X,A)
      END
C
C
