C  
C
      SUBROUTINE NPCORR (KWORKA, KWORKB, NCMAX, NCOL, NF, NIN, NRMAX,
     +                   NROW, NSMALL,
     +                   A,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Nonparametric correlation analysis
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 3/3/95
C         28/10/1996 Corrected mistake with USE(1) not defined/lib-file
C                    and dividing by zero
C         14/12/1996 Derived from RSTEST version
C         26/04/1997 win32 version
C         09/09/1999 Added call to VECCHK to check libary file vectors
C                    and parameter ICMAX to control overflow. Also
C                    added VECCPY to copy vector files into matrix A
C         Note: This version always copies the current matrix A into Y
C               before analysis and never alters A except for new data.
C         12/08/1999 Altered code so that it can be called with existing A
C                    by adding NCOL and NROW to argument list and MATCOR
C                    In this version A is only changed when new data is read in.
C         30/01/2001 introduced STATMT
C         10/01/2006 moved B, W, X, Y, CORR from argument list to allocatables
C         04/03/2006 added NEWDAT and SUPPLY to arguments and ISXEDI/DAT
C         27/06/2006 introduced NBIG and extensive editing to allow for M > N
C         03/11/2006 edited and added REVPRO and EOFINT
C         11/11/2006 added ALLPOS in call to EOFINT
C         17/04/2011 edited main menu
C         11/12/2016 increased len(corr) from 7 to 9 and format 600 to f9.5
C         15/01/2022 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NRMAX,
     +                                       NSMALL 
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      INTEGER,             INTENT (INOUT) :: KWORKA(NRMAX),
     +                                       KWORKB(NRMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NSMALL),
     +                                       TITLE, TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: SUPPLY 
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C Local allocatable arrays
C
      INTEGER,             ALLOCATABLE :: ISX(:)
      DOUBLE PRECISION,    ALLOCATABLE :: A1(:,:), B(:), W(:,:), X(:)
      CHARACTER (LEN = 9), ALLOCATABLE :: CORR(:,:)
C
C Locals
C
      INTEGER    ITYPE, N0, N1, N2, N3
      PARAMETER (ITYPE = 0, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, IERR, J, IFAIL, NDOF, NVAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 6,
     +           NSTART = 13)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT, ISIZE, JSIZE, NBIG
      INTEGER    NISX
      PARAMETER (NISX = 100)
      INTEGER    ISXSAV(NISX)
      DOUBLE PRECISION ONE, TWO, FOUR, NINE, TEN
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00,
     +           NINE = 9.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION DNDOF, PVAL, RTOL, STAT, TEMP
      DOUBLE PRECISION G01EBF$, S15ABF$, X02AMF$
      CHARACTER  (LEN = 100) LINE, TEXT(30), TEXT3(3)
      CHARACTER  CIPHER*4 
      CHARACTER  CHOP80*80, WORD80*80
      CHARACTER  NUMC*8, NUMR*8, NUMS*8
      CHARACTER  AVAIL*4, BLANK*1, NOTAV*4, SYMBOL*9
      PARAMETER (AVAIL = '    ', BLANK = ' ', NOTAV = '(NA)',
     +           SYMBOL = '    .....')
      LOGICAL    FIRST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, FILEIT, IWARNU, REPEET
      PARAMETER (FILEIT = .TRUE.)
      LOGICAL    ALLPOS
      PARAMETER (ALLPOS = .TRUE.)
      EXTERNAL   PUTFAT, PUTIFA, LBOX01, STATMT, MATCOR, CHOP80, REVPRO,
     +           PATCH1, TRIML1, ISXEDI, PUTADV, ISXDAT, ISXTYP, EOFINT
      EXTERNAL   G01EBF$, G02BNF$, S15ABF$, X02AMF$
      INTRINSIC  MIN, SQRT, DBLE, MAX
      SAVE       ICOUNT      
      SAVE       ISXSAV
      DATA       ICOUNT / 0 /
      DATA       ISXSAV / NISX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
C
C Initialise NEWDAT and check if SUPPLY = .TRUE.
C
      FIRST = .TRUE.
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCOL.LT.N2 .OR. NCOL.GT.NCMAX .OR.
     +       NROW.LT.N3 .OR. NROW.GT.NRMAX) RETURN
      ELSE            
         NCOL = N0
         NROW = N0
         FNAME = 'No File'
         TITLE = 'No Data'
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(CORR)) DEALLOCATE(CORR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ISX(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN          
      ALLOCATE(A1(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      NBIG = MAX(NCMAX, NRMAX)
      ALLOCATE(B(NBIG), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(W(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NBIG), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(CORR(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise IWARNU, NVAR, and ISX
C
      IWARNU = .FALSE.
      NVAR = N0
      DO I = N1, NCMAX
         IF (I.LE.NISX) THEN
            ISX(I) = ISXSAV(I)
         ELSE   
            ISX(I) = N1
         ENDIF   
      ENDDO
      IF (SUPPLY) CALL EOFINT (ISX, NCOL,
     +                         FNAME, 
     +                         ABORT, ALLPOS) 
C
C Define RTOL for error trapping and initialise NDEC
C
      RTOL = 1.0D+09*X02AMF$()
      NDEC = NOPT - N1
      WORD80 = CHOP80(TITLE)
C
C Main loop
C ========
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NDEC.EQ.N0) NDEC = N1
         IF (NCOL.GT.N1 .AND. NROW.GT.N2) THEN  
            CALL ISXTYP (ISX, NCOL, NVAR, N2,
     +                   LINE,
     +                   IWARNU) 
            CIPHER = AVAIL
         ELSE    
            LINE = BLANK
            CIPHER = NOTAV
         ENDIF
         WRITE (NUMC,'(I8)') NCOL
         WRITE (NUMR,'(I8)') NROW
         WRITE (NUMS,'(I8)') NCOL - NVAR
         CALL TRIML1 (NUMC)
         CALL TRIML1 (NUMR)
         CALL TRIML1 (NUMS)
         WRITE (TEXT,100) LINE, WORD80, NUMR, NUMC, NUMS, CIPHER
         TEXT3(1) = BLANK
         TEXT3(2) = TEXT(3)
         TEXT3(3) = TEXT(4)
         IF (IWARNU) TEXT(5) = '* = suppressed variable'
         NUMTXT = NSTART + NOPT - N1
         NUMBLD(1) = 4
         NUMBLD(4) = 1  
         NUMBLD(7) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         NUMBLD(7) = 0
         IF (FIRST .AND. NDEC .EQ.N2) THEN
            FIRST = .FALSE.
            ICOUNT = ICOUNT + 1
            WRITE (NF,400) BLANK
            WRITE (NF,'(A,I3)') ' Nonparametric correlation:',ICOUNT
            WRITE (NF,'(A)') ' -----------------------------'
            WRITE (NF,400) BLANK
            DO I = 6, 10 
               WRITE (NF,400) TEXT(I)
            ENDDO
         ENDIF   
C             
C Check that DATA are available if 2 or 3 are requested
C
         IF (NDEC.GE.N2 .AND. NDEC.LE.N3) THEN
            IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
               CALL PUTFAT ('First input your current data')
               NDEC = N0
            ELSEIF (NCOL.LT.N2 .OR. NROW.LT.N3) THEN
               CALL PUTFAT ('Must have at least 3 rows and 2 columns')
               NDEC = N0
            ENDIF
         ENDIF
C
C Read in data if NDEC = 1
C
         IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN
               DO I = N1, MIN(NCMAX, NISX)
                  ISXSAV(I) = ISX(I)
               ENDDO   
               NEWDAT = .TRUE.
               DEALLOCATE(ISX, STAT = IERR)
               DEALLOCATE(A1, STAT = IERR) 
               DEALLOCATE(B, STAT = IERR)
               DEALLOCATE(W, STAT = IERR)
               DEALLOCATE(X, STAT = IERR)
               DEALLOCATE(CORR, STAT = IERR)
               RETURN
            ENDIF
            CALL STATMT (NCMAX, NCOL, NF, NIN, NRMAX, NROW, NSMALL,
     +                   A, B, X,
     +                   FNAME, FSAV, TITLE, TSAV)
            WORD80 = CHOP80(TITLE)
            IF (NCOL.LT.N2 .OR. NROW.LT.N3) THEN
               NCOL = N0
               NROW = N0
               FNAME = 'No File'
               TITLE = 'No Data'
               NDEC = N1
            ELSE 
               CALL EOFINT (ISX, NCOL,
     +                      FNAME, 
     +                      ABORT, ALLPOS) 
               NDEC = N2
            ENDIF
         ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Analysis of data ... First read data into A1
C =========
C
            ISIZE = NROW
            JSIZE = NCOL
            IF (ISIZE*JSIZE.GT.N0) THEN
C
C Blank out the correlation matrix
C
               DO I = N1, NCMAX
                  DO J = N1, NCMAX
                     CORR(J,I) = BLANK
                  ENDDO
               ENDDO
C
C Copy A into temporary matrix A1
C
               DO I = N1, JSIZE
                  DO J = N1, ISIZE
                     A1(J,I) = A(J,I)
                  ENDDO
               ENDDO
C
C Roll data matrix according to ISX and redfine JSIZE if required
C
               IF (NVAR.NE.NCOL) THEN
                  CALL ISXDAT (ISX, NCOL, NRMAX, NROW,
     +                         A1,
     +                         ABORT)
                  JSIZE = NVAR
               ENDIF
               IFAIL = N1
               CALL G02BNF$(ISIZE, JSIZE, A1, NRMAX, ITYPE, W, NCMAX,
     +                      KWORKA, KWORKB, B, X, IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G02BNF/NPCORR')
C
C Matrix A1 has now been overwritten by the ranks ... Output coefficients
C
               WRITE (LINE,500)
               DO I = 1, 3
                  WRITE(NF,400) TEXT3(I)
               ENDDO   
               DO I = N1, JSIZE
                  DO J = N1, JSIZE
                     IF (J.EQ.I) THEN
                        CORR(J,I) = SYMBOL
                     ELSE
                        WRITE (CORR(J,I),600) W(J,I)
                     ENDIF
                  ENDDO
               ENDDO
               CALL MATCOR (NCMAX, JSIZE, NF,
     +                      CORR, LINE,
     +                      FILEIT)
C
C Now overwrite W with the probabilities
C
               NDOF = ISIZE - N2
               DNDOF = DBLE(NDOF)
               TEMP = SQRT(DNDOF)
               DO I = N1, JSIZE
                  DO J = I + N1, JSIZE
                     PVAL = W(I,J)
                     STAT = PVAL*TEMP/SQRT(MAX(ONE - PVAL**2, RTOL))
                     IFAIL = N1
                     PVAL = G01EBF$('S', STAT, DNDOF, IFAIL)
                     STAT = PVAL
                     W(I,J) = STAT
                     WRITE (CORR(I,J),600) W(I,J)
                  ENDDO
                ENDDO
                TEMP = DBLE(ISIZE)
                STAT = (FOUR*TEMP + TEN)/(NINE*TEMP*(TEMP - ONE))
                TEMP = SQRT(STAT)
                DO I = N2, JSIZE
                   DO J = N1, I - N1
                      STAT = W(I,J)/TEMP
                      IFAIL = N1
                      PVAL = S15ABF$(STAT, IFAIL)
                      STAT = TWO*MIN(PVAL, ONE - PVAL)
                      W(I,J) = STAT
                      WRITE (CORR(I,J),600) W(I,J)
                   ENDDO
               ENDDO
               WRITE (LINE,700)
               CALL MATCOR (NCMAX, JSIZE, NF,
     +                      CORR, LINE,
     +                      FILEIT)
            ENDIF
            NDEC = NOPT
         ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Suppress/restore variables
C =========
C
            CALL ISXEDI (ISX, NCOL, NVAR, N2)
            IWARNU = .FALSE.
            IF (NCOL.NE.NVAR) THEN
               IWARNU = .TRUE.
               WRITE (LINE,800)
               CALL PUTADV (LINE)
            ENDIF                     
         ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: Results               
C =========
C                  
            CALL REVPRO (NF)
         ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NOPT - 1: Help
C ================
C         
            WRITE (TEXT,900)
            NUMTXT = 21
            NUMBLD(1) = 1
            NUMBLD(20) = 1
            NUMBLD(21) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = 0 
            NUMBLD(20) = 0
            NUMBLD(21) = 0
            NDEC = 1
         ELSEIF (NDEC.EQ.NOPT) THEN       
C
C NDEC = NOPT: Cancel
C ============
C         
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO 
C
C Save ISX
C      
      DO I = N1, MIN(NCMAX, NISX)
         ISXSAV(I) = ISX(I)
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(ISX, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(W, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(CORR, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + ' Nonparametric correlation'
     +/                           
     +/' Current variables:'
     +/1X,A
     +/
     +/' Title of current data:'
     +/1X,A
     +/
     +/' Number of rows =',1x,a
     +/' Number of columns =',1x,a
     +/' Number of variables suppressed =',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse the current data',2X,A
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit nonparametric correlation options')
  400 FORMAT (1X,A)
  500 FORMAT (
     +' Upper triangle = Spearman''s rank r, Lower = Kendall''s tau')
  600 FORMAT (F9.5)
  700 FORMAT (' Two tail p-values')
  800 FORMAT ('Variables have been re-numbered')
  900 FORMAT (
     + 'Non parameteric correlation analysis'
     +/
     +/'This technique is used when the variables are not normally-'
     +/'distributed and a correlation based only on ranks is required.'
     +/'Whereas the Pearson correlation tests to see if a linear'
     +/'relationship exists between variates, rank correlation only'
     +/'attempts to detect monotonic (possibly nonlinear) correlations.'
     +/
     +/'Non-parametric rank correlation needs m columns of length n'
     +/'for m variables observed in n related cases, e.g. antibodies'
     +/'A, B and C in the same set of 127 patients would require 3'
     +/'columns of length 127.'
     +/
     +/'Simfit calculates all of the non-parametric correlation'
     +/'coefficients and outputs a matrix with Spearman coefficients'
     +/'in the upper and Kendall tau values in the lower triangle.'
     +/'Then it shows a matrix with corresponding two tail p-values for'
     +/'the appropriate t and z statistics (with ..... for diagonals)'
     +/
     +/'Warning:`only analyse relatively small data sets, as the'
     +/'        `calculation will be very slow with large matrices.')
      END
C
C
