C
C
      SUBROUTINE NPROWS (NCMAX, NCOL, NF, NIN, NMAX, NROW, 
     +                   A,
     +                   FNAME, TITLE, 
     +                   NEWDAT, SUPPLY)
C
C ACTION: nonparametric tests on rows with groups defined by indicators
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         10/08/2008 derived from TTEST3
C         07/05/2011 introduced FORM12 and LEN200
C         02/02/2017 added calls to FDRVEC
C         13/07/2021 added E_NUMBERS and E_formats, etc.
C
C         NCMAX: (input/unchanged) maximum column dimension
C          NCOL: (input/output) column size
C            NF: (input/unchanged) preconnected unit for results
C           NIN: (input/unchanged) unconnected unit for file opening
C          NMAX: (input/unchanged) maximum row dimension
C          NROW: (input/output) row size
C             A: workspace except that A may contain the data
C                on entry or exit as follows:
C                If the routine is called with A, NROW and NCOL defined then A may be
C                used as such. If A is changed then NROW and NCOL may be changed.
C        FNAME: (output) data file name (if new data)
C        TITLE: (output) data title (if new data)
C       NEWDAT: (output) if .TRUE. then new data is requested
C       SUPPLY: (input/unchanged) if .TRUE. then A is supplied
C
C Note: If A is already stored then NCOL and NROW will be the dimensions on
C       entry. If A is filled during subroutine execution then it is returned
C       unchanged, i.e. A = ASAV, NCOL = NCSAV and NROW = NRSAV in SIMSTAT
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C Local allocatable arrays
C
      INTEGER,              ALLOCATABLE :: ISZ(:), IWRK(:)
      DOUBLE PRECISION,     ALLOCATABLE :: B(:,:), X(:), Y(:)
      DOUBLE PRECISION,     ALLOCATABLE :: V(:), W(:)
C
C Locals
C
      INTEGER    ICMAX, N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N15
      PARAMETER (ICMAX = 100, N0 = 0, N1 = 1, N2 = 2,
     +           N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8, 
     +           N9 = 9, N10 = 10, N15 = 15)
      INTEGER    ISZSAV(ICMAX)
      INTEGER    LEN200, L_KX, L_KY, L_KZ, L_NCOL, L_NROW, L_ZIN, L_ZOUT
      INTEGER    I, IADD1, IERR, IFAIL, IROW, J, JADD1, JCOLOR, K, KX, 
     +           KY, KZ, LWRK, NBOT, NSUM, NTOP, NTEST1, NTEST2, NX, NY
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 13)
      INTEGER    KTYPE, MAXROW
      PARAMETER (MAXROW = 100)
      INTEGER    ISEND, NTYPE 
      PARAMETER (ISEND = 2, NTYPE = 3)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT, MTYPE
      DOUBLE PRECISION D, P, P1, UMW, UNOR, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 12) FORM12, WORD12_KX, WORD12_KY, WORD12_KZ,
     +                             WORD12_NCOL, WORD12_NROW,
     +                             WORD12_ZIN, WORD12_ZOUT 
      CHARACTER (LEN = 13) D13(4), SHOWRJ
      CHARACTER  CIPHER*4, HEADER*(ICMAX), LINE*100, TEXT(30)*100,
     +           TITLE1*100
      CHARACTER  FLAGB*4, FLAGK*4, FLAGM*4  
      CHARACTER  CHOP80*80, PTAIL*1, WORD80*80, METHODS(3)*15, TAIL*1,
     +           TAILS(3)*15, TEXT2(2)*100, TEXT7(7)*100
      CHARACTER  AVAIL*4, BLANK*1, DOTS*3, NODATA*10, NOTAV*4
      PARAMETER (AVAIL = '    ', BLANK = ' ', DOTS = '...',
     +           NODATA = 'No data', NOTAV = '(NA)')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FILEIT
      PARAMETER (FILEIT = .TRUE.)
      LOGICAL    ALLPOS
      PARAMETER (ALLPOS = .FALSE.)
      LOGICAL    ABORT, OK, READY, REPEET, USEIT(2)
      LOGICAL    KTEST, MTEST, TIES
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTFAT, MATTIN, LBOX01, DSPLAY, PATCH1, CHOP80, LISTBX,
     +           PUTADV, EOFINT, REVPRO, ISZEDI, PUTWAR, TABLE1, CHKBOX,
     +           FORM12, LEN200, FDRVEC 
      EXTERNAL   G08AHF$, G08AJF$, G08AKF$, G08CDF$
      INTRINSIC  MAX
      SAVE       ICOUNT, ISZSAV
      SAVE       KTYPE, MTYPE
      SAVE       TAIL
      DATA       ICOUNT / 0 /
      DATA       ISZSAV / ICMAX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
      DATA       KTYPE, MTYPE / 1, 3 /
      DATA       TAIL / 'U' /
      DATA       TAILS / 'Two-tail',
     +                   'Lower-tail',
     +                   'Upper-tail' /
      DATA       METHODS / 'MW_U only',
     +                     'KS_D only',
     +                     'MW_U and KS_D' / 
C
C Initialise NEWDAT then check dimensions if SUPPY = .TRUE.
C
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCOL.LT.N4 .OR. NCOL.GT.NCMAX .OR.
     +       NROW.LT.N1 .OR. NROW.GT.NMAX) RETURN
      ENDIF
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(ISZ)) DEALLOCATE(ISZ, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN        
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ISZ(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IWRK(200), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      I = NMAX
      J = N6  
      ALLOCATE(B(I,J), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise B and D13
C        
      DO I = 1, NMAX
         DO J = 1, N6
            B(I,J) = ZERO   
         ENDDO
      ENDDO 
      DO I = N1, N4
         D13(I) = BLANK
      ENDDO        
      LWRK = MAX(NCMAX + N1,1000)   
      ALLOCATE(V(LWRK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(W(LWRK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      I = MAX(NMAX,NCMAX)  
      ALLOCATE(X(I), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      E_NUMBERS = E_FORMATS()  
C
C Initialise ISZ, NDEC, and WORD80
C Note that only ICMAX elements of ISZ are stored between calls
C
      IF (SUPPLY) THEN
         CALL EOFINT (ISZ, NCOL,
     +                FNAME,
     +                ABORT, ALLPOS)
         IF (ABORT) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
         ENDIF
      ELSE
         TITLE = NODATA
         ABORT = .TRUE.
      ENDIF
      IF (ABORT) THEN
         DO I = N1, NCMAX
            IF (I.LE.ICMAX) THEN
               ISZ(I) = ISZSAV(I)
            ELSE
               ISZ(I) = N1
            ENDIF
         ENDDO
      ENDIF
      NDEC = NOPT - N1
      WORD80 = CHOP80(TITLE)
      READY = .FALSE.
C
C Main loop
C =========
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         KX = N0
         KY = N0
         KZ = N0
         HEADER = BLANK
C
C Set up the main menu
C
         IF (NCOL.GT.N3 .AND. NROW.GT.N0) THEN
            OK = .TRUE.
            CIPHER = AVAIL
            DO I = N1, NCOL
               IF (ISZ(I).GT.N0) THEN
                  ISZ(I) = N1
                  KX = KX + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'x'
               ELSEIF (ISZ(I).EQ.N0) THEN
                  IF (I.LE.ICMAX) HEADER(I:I) = '0'
                  KZ = KZ + N1
               ELSE
                  ISZ(I) = - N1
                  KY = KY + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'y'
               ENDIF
            ENDDO
            IF (NCOL.GT.ICMAX) HEADER(ICMAX - N2:ICMAX) = DOTS
         ELSE
            OK = .FALSE.
            CIPHER = NOTAV
         ENDIF
        
         IF (.NOT.READY) THEN
            FLAGB = NOTAV
            FLAGK = NOTAV
            FLAGM = NOTAV
         ENDIF
  
         IF (MTYPE.EQ.N1) THEN
            KTEST = .FALSE. 
            MTEST = .TRUE.
         ELSEIF (MTYPE.EQ.N2) THEN
            KTEST = .TRUE.
            MTEST = .FALSE.
         ELSE
            KTEST = .TRUE.
            MTEST = .TRUE.
         ENDIF    
         WORD12_NCOL = FORM12(NCOL)
         WORD12_NROW = FORM12(NROW)
         L_NCOL = LEN200(WORD12_NCOL)     
         L_NROW = LEN200(WORD12_NROW)     
         WORD12_KX = FORM12(KX)          
         WORD12_KY = FORM12(KY)          
         WORD12_KZ = FORM12(KZ)
         L_KX = LEN200(WORD12_KX)          
         L_KY = LEN200(WORD12_KY)          
         L_KZ = LEN200(WORD12_KZ)          
         WRITE (TEXT,200) WORD12_NROW(1:L_NROW),
     +                    WORD12_NCOL(1:L_NCOL),
     +                    WORD80, 
     +                    HEADER, 
     +                    WORD12_KX(1:L_KX),
     +                    WORD12_KY(1:L_KY), 
     +                    WORD12_KZ(1:L_KZ), 
     +                    CIPHER, FLAGB, FLAGM, FLAGK, FLAGM, FLAGK, 
     +                    TAILS(KTYPE), METHODS(MTYPE)
     
         IF (KTYPE.EQ.1) THEN
            PTAIL = '2'
         ELSEIF (KTYPE.EQ.2) THEN
            PTAIL = 'L'
         ELSE
            PTAIL = 'U'
         ENDIF
         
         DO I = N1, N6
            TEXT7(I) = TEXT(I)
         ENDDO
         
         NSTART = N10
         NUMTXT = NSTART + NOPT - N1
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         IF (NDEC.EQ.N0) THEN
            IF (.NOT.OK) THEN
               NDEC = N1
            ELSEIF (READY) THEN
               NDEC = N2
            ELSE
               NDEC = NOPT - N1
            ENDIF
         ENDIF
C
C The main menu
C         
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
C
C Check that DATA are ready if NDEC = 2, etc. is selected
C
         IF (NDEC.GE.N2 .AND. NDEC.LE.N5) THEN
            IF (.NOT.OK) THEN
               CALL PUTFAT ('First input your current data')
               READY = .FALSE.
               NDEC = N0
            ELSEIF (NCOL.LT.N4 .OR. NROW.LT.N1) THEN
               CALL PUTFAT ('Must have at least 2 rows and 4 columns')
               NDEC = N0
            ELSEIF (NDEC.GE.N3 .AND. NDEC.LE.N5 .AND. .NOT.READY) THEN
               CALL PUTFAT ('First analyse the data')
               NDEC = N0
            ENDIF
         ENDIF
         IF (NDEC.EQ.N2) THEN
            IF (KX.LT.N2 .OR. KY.LT.N2) THEN
               CALL PUTFAT ('Must have no. of X > 1 and no. of Y > 1')
               NDEC = N0
            ENDIF
         ENDIF
C
C The main options
C           
         IF (NDEC.EQ.N1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DO I = N1, MIN(NCOL,ICMAX)
                  ISZSAV(I) = ISZ(I)
               ENDDO
               DEALLOCATE (ISZ, STAT = IERR)
               DEALLOCATE (IWRK, STAT = IERR)
               DEALLOCATE (B, STAT = IERR)
               DEALLOCATE (V, STAT = IERR)
               DEALLOCATE (W, STAT = IERR)
               DEALLOCATE (X, STAT = IERR)
               DEALLOCATE (Y, STAT = IERR)
               RETURN
            ENDIF
            OK = .FALSE.
            READY = .FALSE.
            CLOSE (UNIT = NIN)
            CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NMAX, NROW,
     +                   A, X,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)         
            CLOSE (UNIT = NIN)
            WORD80 = CHOP80(TITLE)
            IF (NCOL.GT.N3 .AND. NROW.GT.N0) THEN
               CALL EOFINT (ISZ, NCOL,
     +                      FNAME,
     +                      ABORT, ALLPOS)
               OK = .TRUE.
               IF (ABORT) THEN
                  WRITE (LINE,100)
                  CALL PUTADV (LINE)
                  NDEC = N6
               ELSE
                  NDEC = N2
               ENDIF
            ELSE
               OK = .FALSE.
               NDEC = N1
            ENDIF
         ELSEIF (NDEC.EQ.N2) THEN
C
C NDEC = 2: Analysis of data 
C =========                   
C
            ICOUNT = ICOUNT + N1
            IADD1 = N0
            JADD1 = N0
            NBOT = MIN(KX,KY)
            NTOP = MAX(KX,KY)
            NSUM = KX + KY
            NTEST1 = NBOT + NBOT*(NBOT + N1)*NSUM - NBOT*(NBOT + N1)*
     +              (N2*NBOT + N1)/N3 + N1
            NTEST2 = KX*KY + N1

            FLAGB = AVAIL
            IF (MTYPE.EQ.N1) THEN
               K = N3
               FLAGK = NOTAV
               FLAGM = AVAIL
               KTEST = .FALSE.
               MTEST = .TRUE.
            ELSEIF (MTYPE.EQ.N2) THEN
               K = N3
               FLAGK = AVAIL
               FLAGM = NOTAV
               KTEST = .TRUE.
               MTEST = .FALSE.
            ELSE
               MTYPE = N3
               FLAGK = AVAIL
               FLAGM = AVAIL
               K = N6
               KTEST = .TRUE.
               MTEST = .TRUE.
            ENDIF 

C
C Loop through all the rows
C
            IROW = N0
            DO I = N1, NROW
              IROW = IROW + N1
C
C Define KX, X, KY, and Y
C              
               KX = N0
               KY = N0
               DO J = N1, NCOL
                  IF (ISZ(J).GT.N0) THEN
                     KX = KX + N1
                     X(KX) = A(IROW,J)
                  ELSEIF (ISZ(J).LT.N0) THEN
                     KY = KY + N1
                     Y(KY) = A(IROW,J)
                  ENDIF
               ENDDO 

               IF (MTEST) THEN
C
C Mann Whitney U test
C
                  NX = KX
                  NY = KY
                  IFAIL = N1

                  CALL G08AHF$(NX, X, NY, Y, TAIL, UMW, UNOR, P, TIES,
     +                         V, W, IFAIL)
                  IF (IFAIL.EQ.N0) THEN
                     
                     IF (NTOP.LT.30 .AND. NSUM.LT.40) THEN
                        IFAIL = N1
                        NX = KX
                        NY = KY
                        IF (TIES) THEN
                           IF (LWRK.GE.NTEST1) CALL G08AKF$(NX, NY,
     +                                                      TAIL,
     +                                                      V, UMW, P1,
     +                                                      W,
     +                                                      LWRK, IWRK,
     +                                                      IFAIL)
                        ELSE
                           IF (LWRK.GE.NTEST2) CALL G08AJF$(NX, NY,
     +                                                      TAIL,
     +                                                      UMW, P1, W,
     +                                                      LWRK, IFAIL)
                        ENDIF
                        IF (IFAIL.EQ.N0) P = P1 
                     ENDIF
C
C Assign B(I,J) for J = 1, 3 if success 
C                     
                     IADD1 = IADD1 + N1
                     B(IROW,1) = UMW
                     B(IROW,2) = UNOR
                     B(IROW,3) = P
                  ELSE
C
C Assign B(I,J) for J = 1, 3 if failure 
C                    
                     JADD1 = JADD1 + N1
                     B(IROW,1) = - ONE
                     B(IROW,2) = - ONE
                     B(IROW,3) = - ONE   
                  ENDIF   
               ENDIF
               
               IF (KTEST) THEN
C
C Kolomogorov Smirnov 2 sample
C
                  IFAIL = N1
                  NX = KX
                  NY = KY
                  D = ZERO
                  Z = ZERO
                  P1 = ZERO  
                  CALL G08CDF$(NX, X, NY, Y, KTYPE, D, Z, P1, V, W,
     +                         IFAIL)
C
C Check for sample with zero variance
C     
                  IF (V(N1).GE.V(NX) .OR. W(N1).GE.W(NY)) IFAIL = N1
                  IF (IFAIL.EQ.N0) THEN
C
C Assign B(I,J) for J = 1 to 3 or 4 to 6 if success
C                    
                     IADD1 = IADD1 + N1
                     IF (MTEST) THEN
                        B(IROW,4) = D
                        B(IROW,5) = Z
                        B(IROW,6) = P1
                     ELSE   
                        B(IROW,1) = D
                        B(IROW,2) = Z
                        B(IROW,3) = P1
                     ENDIF   
                  ELSE
C
C Assign B(I,J) for J = 1 to 3, or 3 to 6 if failure
C                    
                     JADD1 = JADD1 + N1
                     IF (MTEST) THEN
                        B(IROW,4) = - ONE
                        B(IROW,5) = - ONE
                        B(IROW,6) = - ONE
                     ELSE 
                        B(IROW,1) = - ONE
                        B(IROW,2) = - ONE
                        B(IROW,3) = - ONE 
                     ENDIF    
                  ENDIF      
               ENDIF                
               
            ENDDO

            WRITE (TEXT7(7),300) ICOUNT, WORD12_KX(1:L_KX),
     +                                   WORD12_KY(1:L_KY)            
            USEIT(1) = .TRUE.
            USEIT(2) = .TRUE.
            IF (NROW.GT.MAXROW) THEN
C
C Decide output required for large samples
C              
               USEIT(1) = .FALSE.
               USEIT(2) = .FALSE.
               WRITE (LINE,400) WORD12_NROW
               WRITE (TEXT2,500) 
               CALL CHKBOX (N2,
     +                      TEXT2, LINE,
     +                      USEIT)
            ENDIF
            
            IF (USEIT(1)) THEN
C
C Display results table
C              
               JCOLOR = N15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = N1, N7
                  IF (I.EQ.N1) THEN
                     JCOLOR = N4
                  ELSEIF (I.EQ.N4 .OR. I.EQ.N6) THEN
                     JCOLOR = N1
                  ELSE
                     JCOLOR = N0
                  ENDIF         
                  CALL TABLE1 (JCOLOR, TEXT7(I))
               ENDDO  
               JCOLOR = N4
               IF (MTYPE.EQ.1) THEN
                  WRITE (LINE,600) PTAIL
               ELSEIF (MTYPE.EQ.2) THEN   
                  WRITE (LINE,700) PTAIL
               ELSE   
                  WRITE (LINE,800) PTAIL, PTAIL
               ENDIF   
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = N0
               DO I = N1, NROW
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,900) (B(I,J), J = N1, K)
                  ELSE
                     DO J = N1, N2
                        D13(J) = SHOWRJ(B(I,J))
                     ENDDO
                     IF (K.GT.N3) THEN
                        DO J = N4, N5
                           D13(J - N1) = SHOWRJ(B(I,J))
                        ENDDO 
                     ELSE
                        D13(3) = BLANK
                        D13(4) = BLANK
                     ENDIF   
                     IF (K.EQ.N3) THEN
                         WRITE (LINE,950) D13(1), D13(2), B(I,3)
                     ELSE  
                        WRITE (LINE,950) D13(1), D13(2), B(I,3), D13(3),
     +                                   D13(4), B(I,6) 
                     ENDIF  
                  ENDIF  
                  CALL TABLE1 (JCOLOR, LINE)
               ENDDO 
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ENDIF   
            IF (USEIT(2)) THEN
C
C Write results table to log file
C              
               WRITE (NF,'(A)') BLANK
               DO I = N1, N7
                  WRITE (NF,'(A)') TEXT7(I)
               ENDDO  
               IF (MTYPE.EQ.1) THEN
                  WRITE (NF,600) PTAIL
               ELSEIF (MTYPE.EQ.2) THEN   
                  WRITE (NF,700) PTAIL
               ELSE   
                  WRITE (NF,800) PTAIL, PTAIL
               ENDIF   
               DO I = N1, NROW
                  IF (E_NUMBERS) THEN
                     WRITE (NF,900) (B(I,J), J = N1, K)
                  ELSE
                     DO J = N1, N2
                        D13(J) = SHOWRJ(B(I,J))
                     ENDDO
                     IF (K.GT.N3) THEN
                        DO J = N4, N5
                           D13(J - N1) = SHOWRJ(B(I,J))
                        ENDDO 
                     ELSE
                        D13(3) = BLANK
                        D13(4) = BLANK
                     ENDIF 
                     IF (K.EQ.N3) THEN  
                        WRITE (NF,950) D13(1), D13(2), B(I,3)
                     ELSE   
                        WRITE (NF,950) D13(1), D13(2), B(I,3), D13(3),
     +                                 D13(4), B(I,6)   
                     ENDIF
                  ENDIF  
               ENDDO 
            ENDIF
            IF (JADD1.GT.N0) THEN
C
C Warn about singular data
C              
               WORD12_ZIN = FORM12(IADD1)
               WORD12_ZOUT = FORM12(JADD1)
               L_ZIN = LEN200(WORD12_ZIN)
               L_ZOUT = LEN200(WORD12_ZOUT)
               WRITE (LINE,1000) WORD12_ZIN(1:L_ZIN),
     +                           WORD12_ZOUT(1:L_ZOUT)
               CALL PUTWAR (LINE)
            ENDIF
            
            READY = .TRUE.  
            NDEC = N3
         ELSEIF (NDEC.EQ.N3) THEN
C
C NDEC = 3: View all
C =========
C
            IF (OK .AND. READY) THEN
               IF (MTYPE.EQ.1) THEN
                  WRITE (TITLE1,650) PTAIL
               ELSEIF (MTYPE.EQ.2) THEN   
                  WRITE (TITLE1,750) PTAIL
               ELSE   
                  WRITE (TITLE1,850) PTAIL, PTAIL
               ENDIF
               CALL DSPLAY (K, K, NF, NMAX, NROW, NTYPE,
     +                      B,
     +                      TITLE1,
     +                      FILEIT)
            ENDIF
         ELSEIF (NDEC.EQ.N4) THEN
C
C NDEC = 4: View MWU P
C =========
C
            IF (MTEST .AND. OK .AND. READY) THEN
               DO I = N1, NROW
                  X(I) = B(I,N3)
               ENDDO   
               WRITE (TITLE1,1100) PTAIL, WORD12_KX(1:L_KX),
     +                                    WORD12_KY(1:L_KY)
               CALL DSPLAY (N1, N1, NF, NROW, NROW, N2,
     +                      X,
     +                      TITLE1,
     +                      FILEIT)
            ELSE
               CALL PUTFAT ('Not calculated')
            ENDIF
         ELSEIF (NDEC.EQ.N5) THEN
C
C NDEC = 5: View KS p
C =========
C
            IF (KTEST .AND. OK .AND. READY) THEN
               IF (MTEST) THEN 
                  DO I = N1, NROW
                     X(I) = B(I,N6)
                  ENDDO   
               ELSE
                  DO I = N1, NROW
                     X(I) = B(I,N3)
                  ENDDO    
               ENDIF     
               WRITE (TITLE1,1200) PTAIL, WORD12_KX(1:L_KX),
     +                                    WORD12_KY(1:L_KY)
               CALL DSPLAY (N1, N1, NF, NROW, NROW, N2,
     +                      X,
     +                      TITLE1,
     +                      FILEIT)
            ELSE
               CALL PUTFAT ('Not calculated')
            ENDIF
         ELSEIF (NDEC.EQ.N6) THEN
C
C NDEC = 6: False discovery rate MW_U
C =========
C            
            IF (MTEST .AND. OK .AND. READY) THEN
               DO I = N1, NROW
                  X(I) = B(I,N3)
               ENDDO   
               WRITE (TITLE1,1100) PTAIL, WORD12_KX(1:L_KX),
     +                                    WORD12_KY(1:L_KY)
               CALL FDRVEC (NROW, NF, 
     +                      X,
     +                      TITLE1)               
            ELSE
               CALL PUTFAT ('Not calculated')
            ENDIF            
         ELSEIF (NDEC.EQ.N7) THEN
C
C NDEC = 7: False discovery rate KS
C =========
C
            IF (KTEST .AND. OK .AND. READY) THEN
               IF (MTEST) THEN 
                  DO I = N1, NROW
                     X(I) = B(I,N6)
                  ENDDO   
               ELSE
                  DO I = N1, NROW
                     X(I) = B(I,N3)
                  ENDDO    
               ENDIF     
               WRITE (TITLE1,1200) PTAIL, WORD12_KX(1:L_KX),
     +                                    WORD12_KY(1:L_KY)
               CALL FDRVEC (NROW, NF,
     +                      X,
     +                      TITLE1)               
            ELSE
               CALL PUTFAT ('Not calculated')
            ENDIF            
         ELSEIF (NDEC.EQ.N8) THEN
C
C NDEC = 8: Edit ISZ
C =========
C
            IF (NCOL.GT.N1) THEN   
               CALL ISZEDI (ISZ, NCOL)
               NDEC = N2
               READY = .FALSE.
            ENDIF
         ELSEIF (NDEC.EQ.N9) THEN
C
C NDEC = 9: Change tails
C ========
C         
            CALL LISTBX (KTYPE, N3,
     +                   TAILS)
            READY = .FALSE.
            IF (KTYPE.EQ.1) THEN
               TAIL = 'T'
            ELSEIF (KTYPE.EQ.2) THEN
               TAIL = 'L'
            ELSE
               TAIL = 'U'
            ENDIF  
         ELSEIF (NDEC.EQ.N10) THEN
C
C NDEC = 10: Change method
C ========
C         
            CALL LISTBX (MTYPE, N3,
     +                   METHODS)
            READY = .FALSE.
         ELSEIF (NDEC.EQ.NOPT - N2) THEN
C
C NDEC = NOPT - 2: Results
C ===============
C
            CALL REVPRO (NF)
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NUMOPT - 1: Help
C ==================
C
            WRITE (TEXT,2000)
            NUMTXT = 22
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = N0
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NUMOPT: Cancel
C ==============
C
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Store ISZ then deallocate workspace
C
      DO I = N1, MIN(NCOL,ICMAX)
         ISZSAV(I) = ISZ(I)
      ENDDO
      DEALLOCATE (ISZ, STAT = IERR)
      DEALLOCATE (IWRK, STAT = IERR)
      DEALLOCATE (B, STAT = IERR)
      DEALLOCATE (V, STAT = IERR)
      DEALLOCATE (W, STAT = IERR)
      DEALLOCATE (X, STAT = IERR)
      DEALLOCATE (Y, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +'No x,y indicators were found ... consult test file g03adf.tf1')
  200 FORMAT (
     + 'Mann-Whitney (MW_U) and/or Kolmogorov-Smirnov (KS_D) tests'
     +/
     +/'Title of',1X,A,1X,'by',1X,A,1X,'data matrix:'
     +/A
     +/
     +/'Variables'
     +/A
     +/'Number of x =',1X,A,', Number of y =',1X,A,', Number unused =',
     +1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse the current data',2X,A
     +/'View/Print/Save all values',2X,A
     +/'View/Print/Save MW_U p values',2X,A
     +/'View/Print/Save KS_D p values',2X,A
     +/'View/Print/Save False discovery rate MW_U',2X,A
     +/'View/Print/Save False discovery rate KS_D',2X,A
     +/'Define data columns as X or Y'
     +/'Change tail probabilities, current =',1X,A
     +/'Change method, current =',1X,A
     +/'Results'
     +/'Help'
     +/'Quit ... Exit MW_U or KS_D options')
  300 FORMAT ('Analysis number',I3,', NX =',1X,A,', NY =',1X,A,
     +' (-1 => failure)')
  400 FORMAT ('Note: tables are large: NROWS =',1X,A)
  500 FORMAT (
     + 'Display table of results'
     +/'Write results to log file')
  600 FORMAT ('     MW_U          MW_Z       MW_',A1,
     +'-tail_p (-1 =>failure)')
  650 FORMAT ('MW_U, MW_Z, and  MW_',A1,'-tail_p (-1 => failure)')
  700 FORMAT ('     KS_D          KS_Z       KS_',A1,
     +'-tail_p (-1 => failure)')      
  750 FORMAT ('KS_D, KS_Z, and KS_',A1,'-tail_p (-1 => failure)')      
  800 FORMAT ('     MW_U          MW_Z       MW_',A1,'-tail_p     KS_D',
     +'          KS_Z       KS_',A1,'-tail_p (-1 => failure)') 
  850 FORMAT ('MW_U, MW_Z, MW_',A1,'-tail_p, KS_D,',
     +'KS_Z, and KS_',A1,'-tail_p (-1 => failure) ')              
  900 FORMAT (1P,2(1X,E13.5),0P,F13.6,1P,2(1X,E13.5),0P,F13.6)
  950 FORMAT (2(1X,A13),F13.6,2(1X,A13),F13.6)
 1000 FORMAT ('Number of successes =',1X,A,', Number of failures =',
     +1X,A)   
 1100 FORMAT (A1,
     +'-tail MW_U p for NX =',1X,A,', NY =',1X,A,1X,'(-1 => failure)')
 1200 FORMAT (A1,
     +'-tail KS_D p for NX =',1X,A,', NY =',1X,A,1X,'(-1 => failure)')
 2000 FORMAT (
     + 'MW_U and KS_D tests on groups within rows of a matrix'
     +/
     +/'This technique is used when the columns of a matrix represent'
     +/'variables of at least two types, say X and Y, and it is wished'
     +/'to do nonparametric tests on the X and Y groups for all rows.'
     +/
     +/'There are conventions to be observed as follows.'
     +/
     +/'1)`Across the rows there must be at least two X and two Y'
     +/'  `values, preferably more ( > 10 for MW_U, > 20 for KS_D ? ).'
     +/'2)`Columns representing X and Y variables can be specifed at'
     +/'  `the end of the data file by using the code'
     +/'  `begin{indicators}'
     +/'  ` a b c d ...'
     +/'  `end{indicators}'
     +/'  `where a b c d ... must be 1 for X, 0 for omit, or -1 for Y'
     +/'3)`If this technique is not used, or if it wished to vary the'
     +/'  `group membership, an interactive technique is provided.'
     +/'4)`If a group has singular data so a test cannot be done, a'
     +/'  `warning is issued, and results for the row are set to -1.'
     +/'5)`Use Bonferroni corrections if both tests are done, and note'
     +/'  `that the MW_U test may be more powerful than the KS_D test.') 
      END
C
C
