C
C NUMRAN
C RANNUM_PARAMS
C RANNUM_OUTPUT
C RANNUM_SAMPLE 
C
      SUBROUTINE NUMRAN (NOUT)
C
C ACTION : Generate random numbers
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          21/05/2003 extensively edited
C          20/06/2006 introduced allocatable arrays
C          16/03/2019 added call to PDFSAM and BETARVG in NAGSUB2
C          22/03/2019 added NOUT (must be connected) and calls to GETDMN and GETJMN  
C          31/05/2022 added E_NUMBERS and E_FORMATS, etc. 
C
      IMPLICIT   NONE
C
C Argument
C      
      INTEGER, INTENT (IN) :: NOUT 
C
C Allocatable arrays
C
      INTEGER,          ALLOCATABLE :: INUM(:)
      DOUBLE PRECISION, ALLOCATABLE :: ANUM(:), R(:)      
C
C Locals
C      
      INTEGER    NMAX, NTMAX
      PARAMETER (NMAX = 1000000, NTMAX = 1000)
      INTEGER    NA, NI, NIN, NOUT_20
      PARAMETER (NA = 20, NI = 20, NIN = 3, NOUT_20 = 20)
      INTEGER    NADD, N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10,
     +           N12, N13, N14, N15, N16 
      PARAMETER (NADD = 100, N0 = 0, N1 = 1, N2 = 2, N3 = 3,
     +           N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8, N9 = 9, 
     +           N10 = 10, N12 = 12, N13 = 13, N14 = 14, N15 = 15,
     +           N16 = 16)
      INTEGER    ICOUNT, IERR, IFAIL, ISEED, ISEND, KTYPE, LOOP
      INTEGER    NDIST, NR, NUM, NUMDEC, NSAV, NTEMP
      INTEGER    I(NI), JSEND
      INTEGER    COLOUR
      INTEGER    NUMOPT, NSTART, NUMTXT
      INTEGER    NUMBLD(30)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION A(NA), DN, P, T
      DOUBLE PRECISION ZERO, ONE, TWENTY
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWENTY = 20.0D+00)
      CHARACTER  FNAME*1024, FTEMP*1024, PTEMP*80, TITLE*80
      CHARACTER  CIPHER*100, LINE*100, TEXT(30)*100
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER (LEN = 13) D13, SHOW13
      CHARACTER (LEN = 15) WORD15, LABEL15
      CHARACTER (LEN = 25) WORD25
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, AGAIN, FIRST, REPEET
      LOGICAL    DONE, READY
      LOGICAL    FILEIT
      INTRINSIC  DBLE, NINT, SQRT
      EXTERNAL   G05EDF$, G05ECF$
      EXTERNAL   GETJM1, PUTADV, FNAMES, OFILES, TABLE5, LSTBOX
      EXTERNAL   RSEEDS, RANNUM_OUTPUT, RANNUM_PARAMS, FORM12, SHOW13,
     +           E_FORMATS, RANNUM_HELP
      EXTERNAL   VECEXH, PDFSAM, CDFSAM
      SAVE       I, NDIST, NUM, NR, A, FIRST, READY, REPEET, TITLE
      DATA       FIRST / .TRUE. /
      DATA       ISEED, NUM, NR / 1, 100, 1000 /
      DATA       TITLE / 'No current distribution' / 
      DATA       NUMBLD / 30*0 /
C
C First time initialise to make sure a distribution is selected
C
      E_NUMBERS = E_FORMATS() 
      IF (FIRST) THEN
         FIRST = .FALSE.
         READY = .FALSE.
         NDIST = N7
         A(1) = ZERO
         A(2) = ONE
         TITLE = 'Normal Distribution: A = 0, B = 1.0'
      ENDIF 
      ISEND = N0
      CALL RSEEDS (ISEND, ISEED, KTYPE)
      IF (KTYPE.EQ.N0) THEN
         REPEET = .FALSE.
         CIPHER = 'Non-repeatable seed'
      ELSE
         ICOUNT = 0
         REPEET = .TRUE.
         WORD12 = FORM12(ISEED)
         CIPHER = 'Repeatable seed = '//WORD12
      ENDIF      
C
C Make sure workspaces are allocated
C                                           
      IERR = N0
      IF (ALLOCATED(INUM)) DEALLOCATE(INUM, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(ANUM)) DEALLOCATE(ANUM, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.N0) RETURN   
      ALLOCATE (INUM(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN  
      ALLOCATE (ANUM(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (R(NR), STAT = IERR)
      IF (IERR.NE.N0) RETURN   
C
C Main loop
C                  
      NUMDEC = N9
      JSEND = NUMDEC
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (NDIST.LT.N1 .OR. NDIST.GT.N16) READY = .FALSE.
         WORD12 = FORM12(NUM)
         IF (READY) THEN
            WORD15 = ' ' 
            IF (NDIST.GT.N12) THEN
               LABEL15 = '[Not possible]'
            ELSE
               LABEL15 = WORD15
            ENDIF      
         ELSE
            WORD15 = '[Not available]'
            LABEL15 = WORD15 
         ENDIF 
         WRITE (TEXT,100) WORD12, TITLE, CIPHER, WORD15, WORD15, WORD15,
     +                    LABEL15, LABEL15
         NUMOPT = N10
         NSTART = N7
         NUMTXT = NSTART + NUMOPT - N1
         NUMBLD(1) = N4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NSTART, NUMTXT,
     +                TEXT)
         NUMBLD(1) = N0         
         IF (NUMDEC.GE.N3 .AND. NUMDEC.LE.N8) THEN
C
C Make sure the requested action is consistent
C
            IF (NUMDEC.EQ.N3 .AND. 
     +         (NDIST.LT.N1 .OR. NDIST.GT.N16)) THEN
               CALL PUTADV ('First choose a distribution')
               NUMDEC = N0
               JSEND = 1
            ELSEIF (NUMDEC.GE.N4 .AND. NUMDEC.LE.N8 .AND. 
     +             .NOT.READY) THEN
               CALL PUTADV ('First generate a sample')
               NUMDEC = N0
               JSEND = 3
            ENDIF
         ENDIF
C
C NUMDEC = 0: Not ready for option selected
C ==========
C         
         IF (NUMDEC.EQ.N0) THEN
            NUMDEC = JSEND 
         ELSEIF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: New distribution
C ===========
C                            
            IF (NDIST.EQ.N0) NDIST = N7
            READY = .FALSE.
            WRITE (TEXT,200)
            NUMOPT = N16
            NSTART = N3
            NUMTXT = NSTART + NUMOPT - N1
            NUMBLD(1) = N4
            CALL LSTBOX (NUMBLD, NDIST, NUMOPT, NSTART, NUMTXT,
     +                   TEXT)
            NUMBLD(1) = N0       
            CALL RANNUM_PARAMS (I, NA, NDIST, NI, 
     +                          A, RTOL, TITLE)
            IF (NDIST.EQ.N13 .OR. NDIST.EQ.N16) THEN 
C
C Check R(NR) if binomial distribution
C            
               DN = DBLE(I(1))
               P = A(1)
               NTEMP = NADD + NINT(TWENTY + TWENTY*SQRT(DN*P*(ONE - P)))
               IF (NTEMP.GT.NR) THEN
                  NR = NTEMP                  
                  IERR = N0
                  IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
                  IF (IERR.NE.N0) RETURN
                  ALLOCATE(R(NR), STAT = IERR)
                  IF (IERR.NE.N0) RETURN
               ENDIF   
               IFAIL = N0
               CALL G05EDF$(I(1), A(1), R, NR, IFAIL)
            ELSEIF (NDIST.EQ.N14) THEN 
C
C Check R(NR) if Poisson distribution
C                           
               T = A(1)
               NTEMP = NADD + NINT(TWENTY + TWENTY*SQRT(T))
               IF (NTEMP.GT.NR) THEN
                  NR = NTEMP                  
                  IERR = N0
                  IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
                  IF (IERR.NE.N0) RETURN
                  ALLOCATE(R(NR), STAT = IERR)
                  IF (IERR.NE.N0) RETURN
               ENDIF   
               IFAIL = N0
               CALL G05ECF$(A(1), R, NR, IFAIL)
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: New sample size
C ===========
C
             NSAV = NUM
             CALL GETJM1(N2, NUM, NMAX, 'The sample size required')
             IF (NUM.NE.NSAV) THEN
                READY = .FALSE.
                NUMDEC = N3
                IERR = 0
                IF (ALLOCATED(INUM)) DEALLOCATE(INUM, STAT = IERR)
                IF (IERR.NE.0) RETURN
                IF (ALLOCATED(ANUM)) DEALLOCATE(ANUM, STAT = IERR)
                IF (IERR.NE.0) RETURN
                ALLOCATE(INUM(NUM), STAT = IERR)
                IF (IERR.NE.0) RETURN
                ALLOCATE(ANUM(NUM), STAT = IERR)
                IF (IERR.NE.0) RETURN
            ENDIF  
C
C--------------------------------------------------------------------------Start of OPTIONS 3, 4, 5, 6, 7 
C              
         ELSEIF (NUMDEC.GE.N3 .AND. NUMDEC.LE.N6) THEN
            IF (NUMDEC.GT.N3 .AND. .NOT.READY) NUMDEC = N3
                
            IF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Generate
C =========== 
C
               READY = .FALSE.
               DONE = .FALSE.
               DO LOOP = N1, NUM
C
C Generate the numbers
C            
                  CALL RANNUM_OUTPUT (I, INUM(LOOP), NA, NDIST, NI, NR,
     +                                A, ANUM(LOOP), R, RTOL)
               ENDDO
               READY = .TRUE.
               IF (REPEET) THEN
                  ICOUNT = ICOUNT + 1
                  IF (ICOUNT.EQ.1) THEN
                     WORD12 = FORM12(ISEED)
                     WRITE (LINE,300) WORD12
                     CALL PUTADV (LINE)
                  ENDIF
               ENDIF    
            ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: View
C ===========
C
               COLOUR = N15
               CALL TABLE5 (COLOUR, 'OPEN')
               COLOUR = N4
               CALL TABLE5 (COLOUR, TITLE)
               IF (NUM.GT.NTMAX) THEN
                  CALL TABLE5 (COLOUR,
     +'For convenience only the first 1000 values will be shown')  
               ENDIF
               COLOUR = N0
               DO LOOP = 1, MIN(NUM, NTMAX)
                  IF (NDIST.LT.N13) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (WORD25,1000) ANUM(LOOP)
                     ELSE
                        D13 = SHOW13(ANUM(LOOP))
                        WRITE (WORD25,400) D13
                     ENDIF      
                     CALL TABLE5 (COLOUR, WORD25)
                  ELSE
                     WRITE (WORD12,1100) INUM(LOOP)
                     CALL TABLE5 (COLOUR, WORD12)
                  ENDIF
               ENDDO
               CALL TABLE5 (COLOUR, 'CLOSE')
            ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: Save As ...
C ===========
C
               IF (DONE) THEN
                  CALL PUTADV ('This sample has been Saved As ...')
               ELSE   
                  ISEND = N1
                  CLOSE (UNIT = NOUT_20)
                  CALL OFILES (ISEND, NOUT_20,
     +                         FNAME,
     +                         ABORT)
                  IF (ABORT) THEN
                     CLOSE (UNIT = NOUT_20)
                  ELSE   
                     WRITE (NOUT_20,400) TITLE
                     WRITE (NOUT_20,500) NUM, N1
                     DO LOOP = 1, NUM
                        IF (NDIST.LT.N13) THEN
                           IF (E_NUMBERS) THEN
                              WRITE (WORD25,1000) ANUM(LOOP)
                              WRITE (NOUT_20,400) WORD25
                           ELSE
                              D13 = SHOW13(ANUM(LOOP))
                              WRITE (WORD25,400) D13
                              WRITE (NOUT_20,400) D13 
                           ENDIF  
                        ELSE
                           WRITE (WORD12,1100) INUM(LOOP)
                           WRITE (NOUT_20,400) WORD12
                        ENDIF
                     ENDDO
                     WRITE (NOUT_20,600) N2                  
                     IF (REPEET) THEN
                        WORD12 = FORM12(ISEED)
                        WRITE (NOUT_20,700) WORD12
                     ELSE
                        WRITE (NOUT_20,800)
                     ENDIF
                     WRITE (NOUT_20,900)
                     CLOSE (UNIT = NOUT_20)
                     IFAIL = 2
                     CALL FNAMES (IFAIL, FNAME)
                     DONE = .TRUE.
                  ENDIF
               ENDIF   
            ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: exhaustive analysis
C         	 
               IF (NDIST.LE.14) THEN  
                  ISEND = N0 
                  FILEIT = .TRUE.
                  PTEMP = TITLE  
                  CALL VECEXH (ISEND, NOUT_20, NIN, NUM, NOUT, NUM, 
     +                         ANUM, 
     +                         FTEMP, PTEMP,
     +                         FILEIT)
               ELSE
                  CALL PUTADV ('Not -1, 1 integers')
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C NUMDEC = 7: Plot PDF on histogram
C 
            CALL PDFSAM (I, NA, NDIST, NI, NUM,
     +                   A, ANUM,
     +                   TITLE)     
         ELSEIF (NUMDEC.EQ.N8) THEN
C
C NUMDEC = 8: Plot CDF on cumulative
C 
            CALL CDFSAM (I, NA, NDIST, NI, NUM,
     +                   A, ANUM,
     +                   TITLE)                             
C
C------------------------------------------------------------------------------end of OIPTIONs 3, 4, 5, 6
C                 
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = 8: Help
C ===========
C
            CALL RANNUM_HELP
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = 9: Cancel
C ===========
C
            AGAIN = .FALSE.
            DEALLOCATE(INUM, STAT = IERR)
            DEALLOCATE(ANUM, STAT = IERR)
            DEALLOCATE(R, STAT = IERR)
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Random number generating options'
     +/
     +/'Sample size =',1X,A 
     +/A
     +/A
     +/
     +/'Select a distribution and parameters'
     +/'Change the sample size'
     +/'Generate a new sample'
     +/'View the current sample',4X,A
     +/'Save the current sample As ...',4X,A
     +/'Do exhaustive analysis of the current sample',4X,A
     +/'Plot pdf overlayed on current sample histogram',4X,A
     +/'Plot cdf overlayed on current sample cumulative',4X,A
     +/'Help'
     +/'Quit ... Exit number generating options')
  200 FORMAT (
     + 'Distributions available in this version'
     +/
     +/'Cauchy'
     +/'Chi-square'
     +/'Negative exponential'
     +/'Gamma'
     +/'Logistic'
     +/'Lognormal'
     +/'Normal'
     +/'Uniform'
     +/'Weibull'
     +/'F'
     +/'t'
     +/'Beta'
     +/'Binomial (integers)'
     +/'Poisson (integers)'
     +/'Uniform (integers)'
     +/'+1 or -1 (integers)')
  300 FORMAT ('Repeatable initial state: seed =',1X,A)
  400 FORMAT (1X,A)
  500 FORMAT (I12,I6)
  600 FORMAT (I6)
  700 FORMAT (
     +'Numbers from RANNUM with repeatable initial state, SEED =',1X,A)
  800 FORMAT (
     +'Numbers from RANNUM with non-repeatable (random) initial state')
  900 FORMAT (
     +'File format: title, dimensions, data, then further details')
 1000 FORMAT (1P,E19.11)
 1100 FORMAT (I12)
      END
C
C------------------------------------------------------------------------------
C
      SUBROUTINE RANNUM_OUTPUT (I, INUM, NA, NDIST, NI, NR, 
     +                          A, ANUM, R, RTOL)
C
C Generate the output 
C
C     I: (input/unchanged) integer parameters
C  INUM: (output) integer random number
C    NA: (input/unchanged) dimension
C NDIST: (input/unchanged) number of the distribution
C    NI: (input/unchanged) dimension
C    NR: (input/unchanged) dimension
C     A: (input/output) double precision parameters
C  ANUM: (output) double precision random number
C     R: (input/unchanged) reference vector for binomial and Poisson
C  RTOL: (input/unchanged) tolerance parameter
C
      IMPLICIT   NONE         
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NA, NDIST, NI, NR
      INTEGER,          INTENT (IN)    :: I(NI) 
      INTEGER,          INTENT (OUT)   :: INUM
      DOUBLE PRECISION, INTENT (IN)    :: R(NR), RTOL
      DOUBLE PRECISION, INTENT (INOUT) :: A(NA)
      DOUBLE PRECISION, INTENT (OUT)   :: ANUM
C
C Locals
C      
      INTEGER    IFAIL, ITEMP
      INTEGER    G05DYF$, G05EYF$
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION DUMMY, X(1)
      DOUBLE PRECISION G05CAF$, G05DBF$, G05DCF$, G05DDF$, G05DEF$,
     +                 G05DFF$, G05DHF$, G05DPF$
      LOGICAL    ABORT
      EXTERNAL   G05CAF$, G05DBF$, G05DCF$, G05DDF$, G05DEF$, G05DFF$,
     +           G05DHF$, G05DPF$, G05FFF$
      EXTERNAL   G05DYF$, G05EYF$
      EXTERNAL   BETARVG
      INTRINSIC  SQRT
      IFAIL = 0
      IF (NDIST.EQ.1) THEN
         ANUM = G05DFF$(A(1), A(2))
      ELSEIF (NDIST.EQ.2) THEN
         ANUM = G05DHF$(I(1), IFAIL)
      ELSEIF (NDIST.EQ.3) THEN
         ANUM = G05DBF$(A(1))
      ELSEIF (NDIST.EQ.4) THEN
         ITEMP = 1
         CALL G05FFF$(A(1), A(2), ITEMP, X, IFAIL)
         ANUM = X(1)
      ELSEIF (NDIST.EQ.5) THEN
         ANUM = G05DCF$(A(1), A(2))
      ELSEIF (NDIST.EQ.6) THEN
         ANUM = G05DEF$(A(1), A(2))
      ELSEIF (NDIST.EQ.7) THEN
         ANUM = G05DDF$(A(1), A(2))
      ELSEIF (NDIST.EQ.8) THEN
         ANUM = A(3)*G05CAF$(DUMMY) + A(1)
      ELSEIF (NDIST.EQ.9) THEN
         ANUM = G05DPF$(A(1), A(2), IFAIL)
      ELSEIF (NDIST.EQ.10) THEN
   20    CONTINUE
         A(3) = G05DHF$(I(1), IFAIL)/A(1)
         A(4) = G05DHF$(I(2), IFAIL)/A(2)
         IF (A(4).LE.RTOL) GOTO 20
         ANUM = A(3)/A(4)
      ELSEIF (NDIST.EQ.11) THEN
   40    CONTINUE
         A(2) = G05DDF$(ZERO, ONE)
         A(3) = SQRT(G05DHF$(I(1), IFAIL)/A(1))
         IF (A(3).LE.RTOL) GOTO 40
         ANUM = A(2)/A(3)
      ELSEIF (NDIST.EQ.12) THEN
         CALL BETARVG (A(1), A(2), ANUM,
     +                 ABORT) 
         IF (ABORT) ANUM = - ONE            
      ELSEIF (NDIST.EQ.13) THEN
         INUM = G05EYF$(R, NR)
      ELSEIF (NDIST.EQ.14) THEN
         INUM = G05EYF$(R, NR)
      ELSEIF (NDIST.EQ.15) THEN
         INUM = G05DYF$(I(1), I(2))
      ELSEIF (NDIST.EQ.16) THEN
         ANUM = G05CAF$(DUMMY)
         IF (ANUM.LE.A(1)) THEN
            INUM = 1
         ELSE
            INUM = -1
         ENDIF   
      ENDIF
      END
C
C------------------------------------------------------------------
C
      SUBROUTINE RANNUM_PARAMS (I, NA, NDIST, NI,  
     +                          A, RTOL, 
     +                          TITLE)
C
C Set parameters and title
C  
C     I: (input/output) integer parameters
C    NA: (input/unchanged) dimension 
C NDIST: (input/output) number of the distribution
C    NI: (input/unchanged) dimension
C  NMAX: (input/unchanged) dimension of R in calling program
C     A: (input/output) double precision parameters
C  RTOL: (output) tolerance parameter
C TITLE: (input/output) details of distribution
C    
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NA, NDIST, NI 
      INTEGER,             INTENT (INOUT) :: I(NI) 
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NA)
      DOUBLE PRECISION,    INTENT (OUT)   :: RTOL
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
C
C Locals
C      
      INTEGER    IBIG, M1, N2
      PARAMETER (IBIG = 10000, M1 = 1, N2 = 2)
      INTEGER    J, K, NTEMP
      INTEGER    I1SAV(20), I2SAV(20)
      DOUBLE PRECISION XBOT(N2), XMID(N2), XTOP(N2)
      DOUBLE PRECISION XMAX, XMIN
      PARAMETER (XMAX = 1.0D+300, XMIN = - XMAX)
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION A1SAV(20), A2SAV(20)
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, TEN
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION BETA_U, BETA_L, RBIG, RSMALL
      PARAMETER (BETA_U = 200.0D+00, BETA_L = 0.01D+00, 
     +           RBIG = 1.0D+07, RSMALL = 1.0D-07)
      CHARACTER (LEN = 80) TEXT(2)
      CHARACTER (LEN = 13) A13, B13, FORM13
      CHARACTER (LEN = 8 ) A8, B8
      EXTERNAL   X02AMF$
      EXTERNAL   GETDM1, GETJ01, GETDG2, TRIML1, GETJGE, GETDGT,
     +           FORM13
      EXTERNAL   GETDMN
      INTRINSIC  DBLE, TRIM
      SAVE       I1SAV, I2SAV, A1SAV, A2SAV
      DATA       I1SAV /  0, 10,  0,  0,  0,
     +                    0,  0,  0,  0,  2,
     +                   10,  0, 10,  0,  1,
     +                   10,  0,  0,  0,  0 /
      DATA       I2SAV /  0,  0,  0,  0,  0,
     +                    0,  0,  0,  0, 10,
     +                    0,  0,  0,  0, 10, 
     +                    0,  0,  0,  0,  0 /
      DATA       A1SAV / ZERO, ZERO,  ONE,  TWO,  ONE,
     +                    ONE, ZERO, ZERO,  ONE, ZERO,
     +                   ZERO, TWO,  HALF,  TWO, ZERO,
     +                   HALF, ZERO, ZERO, ZERO, ZERO /
      DATA       A2SAV /  ONE, ZERO, ZERO,  TEN,  ONE,
     +                    ONE,  ONE,  ONE,  ONE, ZERO,
     +                   ZERO,  TWO, ZERO, ZERO, ZERO,
     +                   ZERO, ZERO, ZERO, ZERO, ZERO /
C
C Initialise parameters to previous choice
C
      RTOL = 1.0D+09*X02AMF$()
      A(1) = A1SAV(NDIST)
      A(2) = A2SAV(NDIST)
      I(1) = I1SAV(NDIST)
      I(2) = I2SAV(NDIST)
      DO J = 1, N2
         XBOT(J) = XMIN
         XMID(J) = A(J)
         XTOP(J) = XMAX
      ENDDO
C
C Assign new parameters for distribution NDIST
C
      IF (NDIST.EQ.1) THEN
C
C NDIST = 1: Cauchy
C        
         XBOT(2) = RSMALL
         XTOP(2) = RBIG 
         TEXT(1) = 'Median (A) for Cauchy distribution'
         TEXT(2) = 'Semi-interquartile range'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO    
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))   
         WRITE (TITLE,100) TRIM(A13), B13
      ELSEIF (NDIST.EQ.2) THEN
C
C NDIST = 2: Chi-square
C      
         CALL GETJGE (I(1), M1,
     +  'No. degrees of freedom for chi-square distribution (N >= 1)')
         IF (I(1).GT.IBIG) I(1) = IBIG
         WRITE (A8,'(I8)') I(1)
         CALL TRIML1 (A8)
         WRITE (TITLE,200) A8
      ELSEIF (NDIST.EQ.3) THEN
C
C NDIST = 3: negative exponential
C      
         CALL GETDGT (A(1), ZERO,
     +  'Mean value for negative exponential distribution (A > 0)')
         IF (A(1).LE.RTOL) THEN
            A(1) = RTOL
         ELSEIF (A(1).GE.RBIG) THEN
            A(1) = RBIG
         ENDIF   
         A13 = FORM13(A(1))   
         WRITE (TITLE,300) A13
      ELSEIF (NDIST.EQ.4) THEN
C
C NDIST = 4: gamma
C      
         DO J = 1, N2
            XBOT(J) = RSMALL
            XTOP(J) = RBIG
         ENDDO   
         TEXT(1) = 
     +  'A for gamma distribution (where E(x) = A*B)'
         TEXT(2) = 
     +  'B for gamma distribution (where V(x) = A*B^2)'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))    
         WRITE (TITLE,400) TRIM(A13), B13
      ELSEIF (NDIST.EQ.5) THEN
C
C NDIST = 5: logistic
C
         XBOT(2) = RSMALL
         XTOP(2) = RBIG
         TEXT(1) = 'A for logistic distribution'
         TEXT(2) = 'B for logistic distribution'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))     
         WRITE (TITLE,500) TRIM(A13), B13
      ELSEIF (NDIST.EQ.6) THEN
C
C NDIST = 6: lognormal
C
         XBOT(2) = RSMALL
         XTOP(2) = RBIG
         TEXT(1) = 
     +  'Mean A for lognormal distribution'
         TEXT(2) =
     +  'Standard deviation B'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)  
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO   
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))    
         WRITE (TITLE,600) TRIM(A13), B13
      ELSEIF (NDIST.EQ.7) THEN
C
C NDIST = 7: normal
C
         XBOT(2) = RSMALL
         XTOP(2) = RBIG
         TEXT(1) = 
     +  'Mean A for the normal distribution'
         TEXT(2) = 
     +  'Standard deviation B'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT) 
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO          
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))  
         WRITE (TITLE,700) TRIM(A13), B13
      ELSEIF (NDIST.EQ.8) THEN
C
C NDIST = 8: uniform
C      
         CALL GETDG2 (A(1), A(2),
     +  'A and B for uniform distribution (B > A)')
         A(3) = A(2) - A(1)
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))  
         WRITE (TITLE,800) TRIM(A13), B13
      ELSEIF (NDIST.EQ.9) THEN
C
C NDIST = 9: Weibull
C      
          DO J = 1, N2
            XBOT(J) = ZERO
         ENDDO   
         TEXT(1) = 'A for Weibull distribution'
         TEXT(2) = 'B for Weibull distribution'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO         
         IF (A(1).LE.RTOL) THEN
            A(1) = RTOL
         ELSEIF (A(1).GE.RBIG) THEN
            A(1) = RBIG
         ENDIF  
         IF (A(2).LE.RTOL) THEN
            A(2) = RTOL
         ELSEIF (A(2).GE.RBIG) THEN
            A(2) = RBIG
         ENDIF 
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))    
         WRITE (TITLE,900) TRIM(A13), B13
      ELSEIF (NDIST.EQ.10) THEN
C
C NDIST = 10: F
C      
         CALL GETJGE (I(1), M1,
     +  'Numerator degrees of freedom for F distribution (M > 0)')
         IF (I(1).GT.IBIG) I(1) = IBIG
         CALL GETJGE (I(2), M1,
     +  'Denominator degrees of freedom for F distribution (N > 0)')
         IF (I(2).GT.IBIG) I(2) = IBIG
         WRITE (A8,'(I8)') I(1)
         WRITE (B8,'(I8)') I(2)
         CALL TRIML1 (A8)
         K = LEN_TRIM(A8)
         CALL TRIML1 (B8)
         WRITE (TITLE,1000) A8(1:K), B8
         A(1) = DBLE(I(1))
         A(2) = DBLE(I(2))
      ELSEIF (NDIST.EQ.11) THEN
C
C NDIST = 11: t
C      
         CALL GETJGE (I(1), M1,
     +  'Degrees of freedom for t distribution (N > 0)')
         A(1) = DBLE(I(1))
         IF (I(1).GT.IBIG) I(1) = IBIG
         WRITE (A8,'(I8)') I(1)
         CALL TRIML1 (A8)
         WRITE (TITLE,1100) A8
      ELSEIF (NDIST.EQ.12) THEN
C
C NDIST = 12: BETA
C
         DO J = 1, N2
            XBOT(J) = BETA_L
            XTOP(J) = BETA_U
         ENDDO   
         TEXT(1) = 'Shape parameter A for beta distribution'
         TEXT(2) = 'Shape parameter B for beta distribution'
         CALL GETDMN (N2,
     +                XBOT, XMID, XTOP,
     +                TEXT)
         DO J = 1, N2
            A(J) = XMID(J)
         ENDDO         
         A13 = FORM13(A(1))
         B13 = FORM13(A(2))
         WRITE (TITLE,1200) TRIM(A13), B13    
      ELSEIF (NDIST.EQ.13) THEN
C
C NDIST = 13: binomial
C      
         CALL GETJGE (I(1), M1, 
     +  'Binomial N (N > 0)')
         IF (I(1).GT.IBIG) I(1) = IBIG
         CALL GETDM1 (ZERO, A(1), ONE,
     +  'Binomial p (0 =< p =< 1)')
         WRITE (A8,'(I8)') I(1)
         WRITE (B8,'(F8.4)') A(1)
         CALL TRIML1 (A8)
         K = LEN_TRIM(A8)
         CALL TRIML1 (B8)
         WRITE (TITLE,1300) A8(1:K), B8
      ELSEIF (NDIST.EQ.14) THEN
C
C NDIST = 14: Poisson
C      
         CALL GETDGT (A(1), ZERO,
     +  'Poisson parameter T (mean = T > 0)')
         IF (A(1).LE.RTOL) THEN
            A(1) = RTOL
         ELSEIF (A(1).GE.RBIG) THEN
            A(1) = RBIG
         ENDIF 
         A13 = FORM13(A(1))    
         WRITE (TITLE,1400) TRIM(A13)
      ELSEIF (NDIST.EQ.15) THEN
C
C NDIST = 15: integer uniform
C      
         CALL GETJ01 (I(1), 'Integer M for uniform distribution')
         NTEMP = I(1) + 1
         CALL GETJGE (I(2), NTEMP,
     +  'Integer N for uniform distribution (N > previous M)')
         WRITE (A8,'(I8)') I(1)
         WRITE (B8,'(I8)') I(2)
         CALL TRIML1 (A8)
         K = LEN_TRIM(A8)
         CALL TRIML1 (B8)
         WRITE (TITLE,1500) A8(1:K), B8
      ELSEIF (NDIST.EQ.16) THEN
C
C NDIST = 16: p for +1 or -1
C      
         CALL GETDM1 (ZERO, A(1), ONE, 
     +  '0 =< p =< 1: so that P(X = 1) = p, and P(X = -1) = (1 - p).')
         WRITE (B8,'(F8.4)') A(1)
         CALL TRIML1 (B8)
         WRITE (TITLE,1600) B8
      ENDIF
C
C Store the current parameter choices
C
      A1SAV(NDIST) = A(1)
      A2SAV(NDIST) = A(2)
      I1SAV(NDIST) = I(1)
      I2SAV(NDIST) = I(2)
C
C Format statements
C      
  100 FORMAT ('Cauchy distribution: A =',1X,A,', B =',1X,A)
  200 FORMAT ('Chi-square distribution: degrees of freedom = ',A)
  300 FORMAT ('Negative exponential distribution: A =',1X,A)
  400 FORMAT ('Gamma distribution: A =',1X,A,', B =',1X,A)
  500 FORMAT ('Logistic distribution: A =',1X,A,', B =',1X,A)
  600 FORMAT ('Lognormal distribution: A =',1X,A,', B =',1X,A)
  700 FORMAT ('Normal distribution: A =',1X,A,', B =',1X,A)
  800 FORMAT ('Uniform distribution: A =',1X,A,', B =',1X,A)
  900 FORMAT ('Weibull distribution: A =',1X,A,', B =',1X,A)
 1000 FORMAT ('F distribution: M = ',A,', N = ',A)
 1100 FORMAT ('t distribution: degrees of freedom = ',A)
 1200 FORMAT ('Beta distribution: A =',1X,A,', B =',1X,A)
 1300 FORMAT ('Binomial distribution: N = ',A,', p = ',A)
 1400 FORMAT ('Poisson distribution: parameter T =',1X,A)
 1500 FORMAT ('Integer uniform distribution: M = ',A,', N = ',A)
 1600 FORMAT ('+1 with probability ',A,', -1 otherwise')
      END
C
C----------------------------------------------------------------------------------
C
C
C
      SUBROUTINE RANNUM_SAMPLE (NOUT, NUM, 
     +                           ANUM,
     +                           CIPHER)
C
C ACTION : Analyse a sample of random or experimental observations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          28/03/2019 developed from RANNUM
C
C NOUT must be connected to save results from exhaustive analysis
C

      IMPLICIT   NONE
C
C Argument
C      
      INTEGER,             INTENT (IN) :: NOUT, NUM 
      DOUBLE PRECISION,    INTENT (IN) :: ANUM(NUM)
      CHARACTER (LEN = *), INTENT (IN) :: CIPHER 
C
C Locals
C      
      INTEGER    NTMAX
      PARAMETER (NTMAX = 1000)
      INTEGER    NA, NI, NIN, NOUT_20
      PARAMETER (NA = 20, NI = 20, NIN = 3, NOUT_20 = 20)
      INTEGER    NADD, N0, N1, N2, N3, N4, N5, N6, N7, N8,  
     +           N12, N13, N14, N15, N16 
      INTEGER    INUM
      PARAMETER (NADD = 100, N0 = 0, N1 = 1, N2 = 2, N3 = 3,
     +           N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8,  
     +           N12 = 12, N13 = 13, N14 = 14, N15 = 15,
     +           N16 = 16)
      INTEGER    IFAIL, ISEND, LOOP
      INTEGER    NDIST, NR, NUMDEC, NTEMP
      INTEGER    I(NI)
      INTEGER    COLOUR
      INTEGER    NUMOPT, NSTART, NUMTXT
      INTEGER    NUMBLD(30)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION R(NTMAX)
      DOUBLE PRECISION A(NA), DN, P, T
      DOUBLE PRECISION ZERO, ONE, TWENTY
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWENTY = 20.0D+00)
      CHARACTER (LEN = 1024) FTEMP
      CHARACTER (LEN = 100 ) TEXT(30)
      CHARACTER (LEN = 80  ) PTEMP, TITLE
      CHARACTER (LEN = 25  ) WORD25
      CHARACTER (LEN = 15  ) WORD15, LABEL15
      CHARACTER (LEN = 13  ) D13, SHOW13
      CHARACTER (LEN = 12  ) FORM12, WORD12
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN, FIRST
      LOGICAL    READY(2)
      LOGICAL    FILEIT
      INTRINSIC  DBLE, NINT, SQRT
      EXTERNAL   G05EDF$, G05ECF$
      EXTERNAL   PUTADV, TABLE5, LSTBOX, PATCH2	
      EXTERNAL   RANNUM_PARAMS, E_FORMATS, FORM12, SHOW13
      EXTERNAL   VECEXH, PDFSAM, CDFSAM
      SAVE       I, NDIST, NR, A, FIRST, TITLE
      DATA       FIRST / .TRUE. /
      DATA       READY / .TRUE., .FALSE. /
      DATA       NDIST, NR / 7, 1000 /
      DATA       TITLE / 'Normal distribution: A = 0, B = 1' /
      DATA       NUMBLD / 30*0 /
C
C First time initialise to make sure a distribution is selected
C
      E_NUMBERS = E_FORMATS()
      IF (FIRST) THEN
         FIRST = .FALSE.
         A(1) = ZERO
         A(2) = ONE
         I(1) = N5
         I(2) = N5
      ENDIF 
      READY(2) = .TRUE.
C
C Main loop
C                  
      NUMDEC = N7
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (NDIST.LT.N1 .OR. NDIST.GT.N16) READY(1) = .FALSE.
         WORD12 = FORM12(NUM)
         IF (READY(1)) THEN
            IF (NDIST.GT.N12) THEN
               LABEL15 = '[Not possible]'
            ELSE
               IF (READY(2)) THEN
                  LABEL15 = ' '
               ELSE
                  LABEL15 = '[No sample]'  
               ENDIF    
            ENDIF      
         ELSE
            LABEL15 = '[No pdf/cdf]'
            NUMDEC = N1
         ENDIF 
         IF (READY(2)) THEN
            WORD15 = ' '
         ELSE
            WORD15 = '[No sample]'
            NUMDEC = N7
         ENDIF       
         WRITE (TEXT,100) WORD12, TITLE, CIPHER, WORD15, WORD15, 
     +                    LABEL15, LABEL15
         NUMOPT = N8
         NSTART = N7
         NUMTXT = NSTART + NUMOPT - N1
         IF (.NOT.READY(1)) NUMDEC = N1
         IF (.NOT.READY(2)) NUMDEC = N2
         NUMBLD(1) = N4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NSTART, NUMTXT,
     +                TEXT)
         NUMBLD(1) = N0         
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: New distribution
C ===========
C               
            READY(1) = .FALSE.             
            IF (NDIST.EQ.N0) NDIST = N7
            WRITE (TEXT,200)
            NUMOPT = N16
            NSTART = N3
            NUMTXT = NSTART + NUMOPT - N1
            NUMBLD(1) = N4
            CALL LSTBOX (NUMBLD, NDIST, NUMOPT, NSTART, NUMTXT,
     +                   TEXT)
            IF (NDIST.GT.12) THEN
               CALL PUTADV ('Not available in this version')
               NDIST = N7
            ENDIF    
            NUMBLD(1) = N0       
            CALL RANNUM_PARAMS (I, NA, NDIST, NI, 
     +                          A, RTOL, TITLE)
            IF (NDIST.EQ.N13 .OR. NDIST.EQ.N16) THEN 
C
C Check R(NR) if binomial distribution
C            
               DN = DBLE(I(1))
               P = A(1)
               NTEMP = NADD + NINT(TWENTY + TWENTY*SQRT(DN*P*(ONE - P)))
               IF (NTEMP.GT.NR) THEN
                  NR = NTEMP                  
               ENDIF   
               IFAIL = N0
               CALL G05EDF$(I(1), A(1), R, NR, IFAIL)
            ELSEIF (NDIST.EQ.N14) THEN 
C
C Check R(NR) if Poisson distribution
C                           
               T = A(1)
               NTEMP = NADD + NINT(TWENTY + TWENTY*SQRT(T))
               IF (NTEMP.GT.NR) THEN
                  NR = NTEMP                  
               ENDIF   
               IFAIL = N0
               CALL G05ECF$(A(1), R, NR, IFAIL)
            ENDIF
            NUMDEC = N6
            READY(1) = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Estimate parameters
C =========== 
C
            NUMDEC = N1 
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: View
C ===========
C
               COLOUR = N15
               CALL TABLE5 (COLOUR, 'OPEN')
               COLOUR = N4
               CALL TABLE5 (COLOUR, TITLE)
               IF (NUM.GT.NTMAX) THEN
                  CALL TABLE5 (COLOUR,
     +'For convenience only the first 1000 values will be shown')  
               ENDIF
               COLOUR = N0
               DO LOOP = 1, MIN(NUM, NTMAX)
                  IF (NDIST.LT.N13) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (WORD25,400) ANUM(LOOP)
                     ELSE
                        D13 = SHOW13(ANUM(LOOP))
                        WRITE (WORD25,450) D13  
                     ENDIF  
                     CALL TABLE5 (COLOUR, WORD25)
                  ELSE
                     INUM = NINT(ANUM(LOOP))
                     WRITE (WORD12,500) INUM
                     CALL TABLE5 (COLOUR, WORD12)
                  ENDIF
               ENDDO
               CALL TABLE5 (COLOUR, 'CLOSE')
               NUMDEC = N1
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: exhaustive analysis
C ===========
C         	 
               IF (NDIST.LE.14) THEN  
                  ISEND = N0 
                  FILEIT = .TRUE.
                  PTEMP = TITLE  
                  CALL VECEXH (ISEND, NOUT_20, NIN, NUM, NOUT, NUM, 
     +                         ANUM, 
     +                         FTEMP, PTEMP,
     +                         FILEIT)
               ELSE
                  CALL PUTADV ('Not -1, 1 integers')
               ENDIF
               NUMDEC = N1
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: Plot PDF on histogram
C ===========
C 
            CALL PDFSAM (I, NA, NDIST, NI, NUM,
     +                   A, ANUM,
     +                   TITLE)  
            NUMDEC = N1   
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: Plot CDF on cumulative
C ===========
C 
            CALL CDFSAM (I, NA, NDIST, NI, NUM,
     +                   A, ANUM,
     +                   TITLE)   
            NUMDEC = N1                          
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = 7: Help
C ===========
C
            WRITE (TEXT,300)
            NUMTXT = 25
            NUMBLD(1) = 1
            NUMBLD(10) = 1
            NUMBLD(20) = 1
            CALL PATCH2 (NUMBLD, NUMTXT,
     +                   TEXT)  
            NUMBLD(1) = 0
            NUMBLD(10) = 0
            NUMBLD(20) = 0
            NUMDEC = N1
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = 8: Cancel
C ===========
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Displaying a sample with PDF or CDF overlay'
     +/
     +/'Sample size =',1X,A 
     +/A
     +/A
     +/
     +/'Select a distribution and parameters'
     +/'Estimate parameters [Not yet implemented]'
     +/'View the current sample',4X,A
     +/'Do exhaustive analysis of the current sample',4X,A
     +/'Plot pdf overlayed on current sample histogram',4X,A
     +/'Plot cdf overlayed on current sample cumulative',4X,A
     +/'Help'
     +/'Quit ... Exit sample displaying options')
  200 FORMAT (
     + 'Distributions available in this version'
     +/
     +/'Cauchy'
     +/'Chi-square'
     +/'Negative exponential'
     +/'Gamma'
     +/'Logistic'
     +/'Lognormal'
     +/'Normal'
     +/'Uniform'
     +/'Weibull'
     +/'F'
     +/'t'
     +/'Beta'
     +/'Binomial (integers) [Not yet implemented]'
     +/'Poisson (integers) [Not yet implemented]'
     +/'Uniform (integers) [Not yet implemented]'
     +/'+1 or -1 (integers) [Not yet implemented]')
  300 FORMAT (
     + 'Comparing a sample of observations with a known distribution'   
     +/
     +/'The purpose of this procedure is to compare a sample with an'
     +/'assumed probability distribution (PDF), or the cumulative'
     +/'distribution function (CDF), in order to determine how closely' 
     +/'the distribution fits the data, by visual inspection of the PDF'
     +/'superimposed on a histogram of binned frequencies, or the CDF'
     +/'superimposed on the sample cumulative.'
     +/
     +/'Choosing a probability distribution and parameters'
     +/
     +/'It is presumed that the distribution is known and parameters' 
     +/'available. For instance, the default is a normal distribution'
     +/'with mean = 0 and standard deviation = 1, so these parameters'
     +/'could then be replaced by the sample mean and standard'
     +/'deviation which can be obtained along with other sample moments' 
     +/'using the exhaustive analysis of a sample procedure. In some'
     +/'versions the parameters can be estimated automatically.'   
     +/
     +/'Testing the goodness of fit'
     +/
     +/'Note that there are dedicated Simfit programs to fit assumed'
     +/'distributions, such as the Poisson or Beta distributions, by'
     +/'special techniques that perform statistical tests for goodness'
     +/'of fit as described in the reference manual and tutorials.')
  400 FORMAT (1P,E19.11)
  450 FORMAT (1X,A)
  500 FORMAT (I12)     
      END
C
C
     