C
C
      SUBROUTINE NXYR2P (N, P, R, RSQD, X, Y, ABORT)
C
C ACTION: Calculate R, R-squared and P
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 06/06/2000
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    I, IFAIL
      DOUBLE PRECISION P, R, RSQD, X(N), Y(N)
      DOUBLE PRECISION DENOM, DN, DOF, RTOL, SX, SY, T, TOP, XBAR, YBAR
      DOUBLE PRECISION ZERO, ONE, TWO, RBOT, RTOP
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           RBOT = - ONE, RTOP = ONE)
      DOUBLE PRECISION G01EBF$, X02AMF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'S')
      LOGICAL    ABORT
      EXTERNAL   G01EBF$, X02AMF$
      INTRINSIC  DBLE, SQRT
      ABORT = .TRUE.
      P = ONE
      R = ZERO
      RSQD = ZERO
      IF (N.LT.3) RETURN
C
C Calculate XBAR, YBAR, SX and SY
C
      XBAR = ZERO
      YBAR = ZERO
      DO I = 1, N
         XBAR = XBAR + X(I)
         YBAR = YBAR + Y(I)
      ENDDO
      DN = DBLE(N)
      XBAR = XBAR/DN
      YBAR = YBAR/DN
      SX = ZERO
      SY = ZERO
      DO I = 1, N
         SX = SX + (XBAR - X(I))**2
         SY = SY + (YBAR - Y(I))**2
      ENDDO
      DENOM = SQRT(SX*SY)
      RTOL = 1.0D+09*X02AMF$()
      IF (DENOM.LE.RTOL) RETURN
C
C R and R-squared
C
      TOP = ZERO
      DO I = 1, N
         TOP = TOP + (X(I) - XBAR)*(Y(I) - YBAR)
      ENDDO
      R = TOP/DENOM
      IF (R.LT.RBOT) THEN
         R = RBOT
      ELSEIF (R.GT.RTOP) THEN
         R = RTOP
      ENDIF
      RSQD = R*R
      DENOM = ONE - RSQD
      IF (DENOM.GT.RTOL) THEN
         DOF = DN - TWO
         T = R*SQRT(DOF/DENOM)
         IFAIL = 1
         P = G01EBF$(TAIL, T, DOF, IFAIL)
         ABORT = .FALSE.
      ENDIF
      END
C
C
