C
C
      SUBROUTINE OEBINS (IX, N, NBINS, NOUT, NUM,
     +                   E, EBINS, O, OBINS,
     +                   TITLES)
C
C ACTION: Output of data from BDTEST and PDTEST
C AUTHOR: W.G.Bardsley, University of manchester, U.K.
C         24/09/2007 derived from EOIOUT of program BINOMIAL.   
C
C     IX: (input/unchanged) ordered sample
C      N: (input/unchanged) number of bins
C   NOUT: (input/unchanged) unit connected for results file
C    NUM: (input/unchanged) sample size
C      E: (input/unchanged) all expected values
C  EBINS: (input/unchanged) expected bins after conflation
C      O: (input/unchanged) all observed frequencies
C  OBINS: (input/unchanged) observed bins after conflation 
C TITLES: (input/unchanged) main-plot, x-legend, y-legend, z-legend
C
C Note: In this version O(I) can be changed to only plot nonzero O(I)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: N, NBINS, NOUT, NUM
      INTEGER,             INTENT (IN) :: IX(NUM)
      DOUBLE PRECISION,    INTENT (IN) :: E(N), EBINS(NBINS), O(N),
     +                                    OBINS(NBINS)
      CHARACTER (LEN = *), INTENT (IN) :: TITLES(7)
C
C Local allocatable arrays
C     
      DOUBLE PRECISION,    ALLOCATABLE :: A(:,:), OBS(:), XGRAF(:),
     +                                    XZERO(:), YGRAF(:)
      CHARACTER (LEN = 5), ALLOCATABLE :: LABELS(:)
C
C Locals
C      
      INTEGER    I, IERR, J, K, L, L1, L2, M1, M2, NGRAF, NPLOT
      INTEGER    NRMAX, NROW, NUMDEC
      INTEGER    ICOLOR, IXL, IYL, JCOLOR
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    ISEND, NCOL, NUMOPT 
      PARAMETER (ISEND = 2, NCOL = 2, NUMOPT = 5)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  TEXT(NUMOPT)*100
      CHARACTER  PTITLE*45, XTITLE*45, YTITLE*45
      CHARACTER  LINE*100
      LOGICAL    AXES
      PARAMETER (AXES = .FALSE.)
      LOGICAL    DONE, REPEET, YES
      EXTERNAL   GKS004, YESNO2, TABLE1, BCPLOT, LISTBX, PUTADV
      IF (N.LT.1 .OR. NBINS.LT.1) RETURN
      DONE = .FALSE.
      REPEET = .TRUE.
      NUMDEC = 1
      DO WHILE (REPEET)
         NUMDEC = 1
         WRITE (TEXT,100) N, NBINS
         CALL LISTBX (NUMDEC, NUMOPT,
     +                TEXT)
     
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Display tables
C        
            JCOLOR = 15
            CALL TABLE1 (JCOLOR, 'OPEN')
            JCOLOR = 4
            WRITE (LINE,200)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            J = - 8
            K = 0
            DO I = 1, NUM/9 + 1
               J = J + 9
               K = K + 9
               IF (K.GT.NUM) K = NUM
               IF (J.LE.NUM) THEN
                  WRITE (LINE,300) (IX(L), L = J, K)
                  CALL TABLE1 (JCOLOR, LINE)
               ENDIF
            ENDDO
            JCOLOR = 4
            WRITE (LINE,400)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            J = - 6
            K = 0
            DO I = 1, N/7 + 1
               J = J + 7
               K = K + 7
               IF (K.GT.N) K = N
               IF (J.LE.N) THEN
                  WRITE (LINE,500) (O(L), L = J, K)
                  CALL TABLE1 (JCOLOR, LINE)
               ENDIF
            ENDDO
            JCOLOR = 4
            WRITE (LINE,600)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            J = - 6
            K = 0
            DO I = 1, N/7 + 1
               J = J + 7
               K = K + 7
               IF (K.GT.N) K = N
               IF (J.LE.N) THEN
                  WRITE (LINE,500) (E(L), L = J, K)
                  CALL TABLE1 (JCOLOR, LINE)
               ENDIF
            ENDDO
            JCOLOR = 4
            WRITE (LINE,700)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            J = - 6
            K = 0
            DO I = 1, NBINS/7 + 1
               J = J + 7
               K = K + 7
               IF (K.GT.NBINS) K = NBINS
               IF (J.LE.NBINS) THEN
                  WRITE (LINE,500) (OBINS(L), L = J, K)
                  CALL TABLE1 (JCOLOR, LINE)
               ENDIF
            ENDDO
            JCOLOR = 4
            WRITE (LINE,800)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            J = - 6
            K = 0
            DO I = 1, NBINS/7 + 1
               J = J + 7
               K = K + 7
               IF (K.GT.NBINS) K = NBINS
               IF (J.LE.NBINS) THEN
                  WRITE (LINE,500) (EBINS(L), L = J, K)
                  CALL TABLE1 (JCOLOR, LINE)
               ENDIF
            ENDDO
            CALL TABLE1 (JCOLOR, 'CLOSE')
      
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Write tables to results file
C
            IF (DONE) THEN
                CALL PUTADV ('Already done')
            ELSE            
               IF (N.GT.100) THEN
                  WRITE (LINE,900)
                  YES = .FALSE.
                  CALL YESNO2 (ICOLOR, IXL, IYL, LINE,
     +                         YES)
               ELSE
                  YES = .TRUE.
               ENDIF    
               IF (YES) THEN
                  WRITE (NOUT,250)
                  WRITE (NOUT,300) (IX(J), J = 1, NUM)
                  WRITE (NOUT,450)
                  WRITE (NOUT,500) (O(J), J = 1, N)
                  WRITE (NOUT,650)
                  WRITE (NOUT,500) (E(J), J = 1, N)
                  WRITE (NOUT,750)
                  WRITE (NOUT,500) (OBINS(J), J = 1, NBINS)
                  WRITE (NOUT,850)
                  WRITE (NOUT,500) (EBINS(J), J = 1, NBINS)
                  DONE = .TRUE.
                  CALL PUTADV (
     +'Tables have been written to the results file')
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Plot the samples
C           
            IERR = 0
            IF (ALLOCATED(OBS)) DEALLOCATE(OBS, STAT = IERR)
            IF (IERR.NE.0) RETURN 
            IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
            IF (IERR.NE.0) RETURN   
            IF (ALLOCATED(XZERO)) DEALLOCATE(XZERO, STAT = IERR)
            IF (IERR.NE.0) RETURN  
            IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
            IF (IERR.NE.0) RETURN      
            NGRAF = 3*N
            ALLOCATE(OBS(N), STAT = IERR)
            IF (IERR.NE.0) RETURN  
            ALLOCATE(XGRAF(NGRAF), STAT = IERR)
            IF (IERR.NE.0) RETURN    
            ALLOCATE(XZERO(N), STAT = IERR)
            IF (IERR.NE.0) RETURN 
            ALLOCATE(YGRAF(NGRAF), STAT = IERR)
            IF (IERR.NE.0) RETURN                

            J = 0
            NPLOT = 0
            DO I = 1, N
               XZERO(I) = I - 1
               J = J + 1
               XGRAF(J) = XZERO(I)
               YGRAF(J) = ZERO
               J = J + 1
               XGRAF(J) = XZERO(I)
               YGRAF(J) = E(I)
               J = J + 1
               XGRAF(J) = XZERO(I)
               YGRAF(J) = ZERO
C
C THIS NEXT CODE IS TO ONLY PLOT O(I) IF O(I) > 0, O(I) IS CHANGED
C
               IF (O(I).GT.ZERO) THEN
                  NPLOT = NPLOT + 1
                  XZERO(NPLOT) = XZERO(I)
                  OBS(NPLOT) = O(I)
               ENDIF
            ENDDO
            L1 = 0
            L2 = 1
            M1 = 3
            M2 = 0
            PTITLE = TITLES(5)
            XTITLE = TITLES(6)
            YTITLE = TITLES(7)
            YES = .TRUE.
            CALL GKS004 (L1, L2, L1, L1, M1, M2, M2, M2,
     +                   NPLOT, NGRAF, NGRAF, NGRAF,
     +                   XZERO, XGRAF, XGRAF, XGRAF,
     +                   OBS, YGRAF, YGRAF, YGRAF,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, YES)
            DEALLOCATE(XGRAF, STAT = IERR)
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(YGRAF, STAT = IERR)
         
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: bar chart
C         
            IERR = 0
            IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
            IF (IERR.NE.0) RETURN 
            IF (ALLOCATED(LABELS)) DEALLOCATE(LABELS, STAT = IERR)
            IF (IERR.NE.0) RETURN   
            NRMAX = NBINS
            NROW = NBINS
            ALLOCATE(A(NRMAX,NCOL), STAT = IERR)
            IF (IERR.NE.0) RETURN  
            ALLOCATE(LABELS(NROW), STAT = IERR)
            IF (IERR.NE.0) RETURN
            DO I = 1, NROW
               A(I,1) = OBINS(I)
               A(I,2) = EBINS(I)
               WRITE (LABELS(I),'(I5)') I
            ENDDO
            CALL BCPLOT (ISEND, NCOL, NRMAX, NROW,
     +                   A,
     +                   LABELS, TITLES)                
            DEALLOCATE(A, STAT = IERR)
            DEALLOCATE(LABELS, STAT = IERR)
         ELSE
C
C NUMDEC = 5: Quit
C           
            REPEET = .FALSE.       
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Display tables'
     +/'Write tables to results file'
     +/'Plot',I5,1X,'sample values and theoretical pmf'
     +/'Plot',I5,1X,'observed and expected chi-sq.bins'
     +/'Quit ... Exit these options')
  200 FORMAT ('Sorted x-values')
  250 FORMAT (/1X,'Sorted x-values')
  300 FORMAT (1X,9I8)
  400 FORMAT ('Partition of observed x-values')
  450 FORMAT (/1X,'Partition of observed x-values')
  500 FORMAT (7F11.1)
  600 FORMAT ('Partition of expected x-values')
  650 FORMAT (/1X,'Partition of expected x-values')
  700 FORMAT ('Partition of observed x-values into chi-sq. bins')
  750 FORMAT (/1X,'Partition of observed x-values into chi-sq. bins')
  800 FORMAT ('Partition of expected x-values into chi-sq. bins')
  850 FORMAT (/1X,'Partition of expected x-values into chi-sq. bins')
  900 FORMAT ('File such large tables ?')
      END
C
C