C
C
      SUBROUTINE ORDERS (N, X, Y, E, ORDER)
C
C ACTION : Restore order within replicates after call to HPSORT
C ADVICE : The X-values must be in increasing order
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Date of this version 24/3/97
C
      IMPLICIT  NONE
      INTEGER   N
      INTEGER   I, ICOUNT, J, NDIST, NREPS
      DOUBLE PRECISION E(N), ORDER(N), X(N), Y(N)
      DOUBLE PRECISION EPSI, X02AJF$
      CHARACTER LINE*100, VALUE*6
      EXTERNAL  HPSORT, PUTFAT, PUTTXT, TRIML1
      EXTERNAL  X02AJF$
      INTRINSIC ABS
      LOGICAL  DOSUMS
      IF (N.LT.2) RETURN
      DO I = 2, N
         IF (X(I).LT.X(I - 1)) THEN
            CALL PUTFAT ('Data to ORDERS not in increasing order')
            RETURN
         ENDIF
      ENDDO
      EPSI = X02AJF$()*(X(N) - X(1))
      NDIST = 1
      NREPS = 1
      DO I = 2, N
         IF (ABS(X(I) - X(I - 1)).LE.EPSI) THEN
            DOSUMS = .FALSE.
            NREPS = NREPS + 1
            IF (I.EQ.N) THEN
               DOSUMS = .TRUE.
               ICOUNT = 0
            ENDIF
         ELSE
            NDIST = NDIST + 1
            IF (NREPS.EQ.1) THEN
               DOSUMS = .FALSE.
            ELSE
               DOSUMS = .TRUE.
               ICOUNT = 1
            ENDIF
         ENDIF
         IF (DOSUMS) THEN
            J = I - NREPS + 1 - ICOUNT
            CALL HPSORT (NREPS, ORDER(J), E(J), X(J), Y(J))
            NREPS = 1
         ENDIF
      ENDDO
      WRITE (VALUE,'(I6)') NDIST
      CALL TRIML1 (VALUE)
      WRITE (LINE,100) VALUE
      CALL PUTTXT (LINE)
  100 FORMAT ('Number of distinct x-values in current data set = ',A)
      END
C
C
