c
c
      subroutine orot01 (ncol, nin, nout, nrmax, nrow,
     +                   a,
     +                   title)
c
c action: write matrix a to a temporary file then call orotat
c author: w.g.bardsley, university of manchester, u.k., 16/06/2005
c         14/07/2006 introduced allocatable arrays
c
c     Note: The arguments are not changed by this routine
c     ncol = no. columns of matrix a, ncol >= 1
c     nin = unconnected unit for data input
c     nout = preconnected unit for results
c     nrmax = leading dimension of matrix a
c     nrow = no. rows of matrix a, nrow > = 1
c     a = matrix
c     title = title of matrix a
c
      implicit    none
c
c arguments
c
      integer     ncol, nin, nout, nrmax, nrow
      double precision a(nrmax,ncol)
      character   title*(*) 
c
c local allocatable arrays
c                         
      double precision, allocatable :: r(:,:), w(:), y(:,:), yhat(:,:)
c
c locals
c
      integer    i, ierr, ifail, ios, j, nwmax
      integer    isend
      parameter (isend = 2)
      character  fname*1024, line*100
      logical    abort, askif, there
      parameter (askif = .false.)
      external   orotat, putfat, gettmp, deleet
c
c check dimensions
c
      if (nrow.gt.nrmax .or. nrow.lt.1 .or. ncol.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif     
      ierr = 0
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(yhat)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return
      allocate(r(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return  
      nwmax = 2*nrmax + ncol*ncol + 5*(ncol - 1)
      allocate(w(nwmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return
      allocate(yhat(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return
c
c write the temporary file
c
      call gettmp (ifail,
     +             fname)
      close (unit = nin)
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) then   
         call deleet (fname,
     +                askif, there)
         close (unit = nin)
         return
      endif
      write (nin,'(a)',iostat=ios) title
      if (ios.ne.0) then  
         call deleet (fname,
     +                askif, there)
         close (unit = nin)
         return
      endif
      write (nin,'(2i8)',iostat=ios) nrow, ncol
      if (ios.ne.0) then
         call deleet (fname,
     +                askif, there)
         close (unit = nin)
         return
      endif
      do i = 1, nrow
         write (nin,200,iostat=ios) (a(i,j), j = 1, ncol)
         if (ios.ne.0) then
            call deleet (fname,
     +                   askif, there) 
            close (unit = nin)
            return
         endif
      enddo
      ifail = 1
      write (nin,'(i6)') ifail
      write (nin,300)
      close (unit = nin)
c
c rotate
c
      call orotat (isend, ncol, nin, nout, nrmax,
     +             r, w, y, yhat,
     +             fname,
     +             abort)
c
c delete temporary file
c
      call deleet (fname,
     +             askif, there)
      close (unit = nin)
      deallocate(r, stat = ierr)  
      deallocate(w, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(yhat, stat = ierr)
  100 format ('Dimension exceeded in call to OROT01')
  200 format (1p,50e13.5)
  300 format ('Default line')
      end
c
c
