c
c
      subroutine orotat (isend, ncmax, nin, nout, nrmax,
     +                   r, w, y, yhat,
     +                   fname,
     +                   abort)
c
c action: orthomax rotation
c author: w.g.bardsley, university of manchester, u.k., 14/06/2005
c         14/07/2006 increased w dimension
c         01/08/2006 altered exit for new data when isend = 3
c         20/09/2006 replaced mtplot by matplt 
c         07/11/2006 added intents
c         09/01/2013 added extra options for gamma
c         09/01/2022 deleted form15 but added yesno2 and form09
c
c         isend: (input/unchanged) procedure indicator as follows:
c                 isend = 1: stand alone version
c                 isend = 2: data supplied in fname from another program
c                            but no exit for new data allowed
c                 isend = 3: as for 2 but sets abort = .false. if new
c                            data are requested
c         ncmax: (input/unchanged) dimension
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) dimension
c         r, w, y, yhat: workspaces except that on
c         successful exit (abort = .false.) they contain the data
c         and current results
c         fname: if isend = 1 this is workspaces
c                if isend = 2 this must be the file containing
c                             the matrix to be analysed
c                if isend = 3 as for isend = 2 but silent exit with
c                             abort = .false. when new data are requested
c         abort: (input/output) error indicator unless isend = 3 when
c                 it indicates if new data are requested
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, ncmax, nin, nout,
     +                                       nrmax
      double precision,    intent (inout) :: r(nrmax,ncmax),
     +                                       w(2*nrmax + ncmax*ncmax +
     +                                         5*(ncmax - 1)),
     +                                       y(nrmax,ncmax),
     +                                       yhat(nrmax,ncmax)
      character (len = *), intent (inout) :: fname
      logical,             intent (inout) :: abort
c
c locals
c
      integer    i, ifail, icount, ios, iter, j, k, l, maxit, ncol,
     +           nrow, nvar
      integer    iscale, itype
      integer    jsend, ksend, ntype, n2, n5
      parameter (jsend = 2, ksend = 4, ntype = 3, n2 = 2, n5 = 5)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext,
     +           numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 13,
     +           nstart = 11, ntext = numopt + nstart - 1, numtxt = 21)
      integer    numbld(30), numpos(30)
      double precision acc, g
      double precision zero, one, half
      parameter (zero = 0.0d+00, one = 1.0d+00, half = 0.5d+00)
      character (len = 9  ) cipher, form09
      character (len = 12 ) form12, word12(2)
      character (len = 20 ) nodata
      character (len = 25 ) scale1(5), type1(2)
      character (len = 40 ) scale2(5)
      character (len = 80 ) ptitle, title
      character (len = 100) line, text(30)
      character (len = 1  ) blank, pscale, pscal1(5), stand, stand1(2)
      parameter (blank = ' ', nodata = 'No data')
      logical    done1, done2, done3, ok, fileit, ready, repeet, yes
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   putfat, mattin, revpro, lbox01, table1, putifa, dsplay,
     +           matplt, listbx, patch1, putadv, form12, getdge, form09,
     +           yesno2
      external   g03baf$
      save       title
      save       icount, iscale, itype, maxit
      save       acc, g
      data       icount, iscale, itype, maxit / 0, 1, 1, 30 /
      data       scale1 / 'Varimax',
     +                    'Quartimax',
     +                    'Equamax',
     +                    'Parsimax',
     +                    'User-defined' /
      data       scale2 / 'Varimax, gamma = 1',
     +                    'Quartimax, gamma = 0',
     +                    'Equamax, gamma = k/2',
     +                    'Parsimax, gamma = p(k-1)/(p+k+2)',
     +                    'User-defined, gamma = ?' /
      data       type1 / 'Unstandardised loadings',
     +                   'Row standardised loadings' /
      data       pscal1 / 'V', 'Q', 'E', 'P', 'U' /
      data       stand1 / 'U', 'S' /
      data       acc, g / 0.00001d+00, 1.0d+00 /
      data       numbld / 30*0 /
      data       numpos / 30*1 /
c
c check isend
c
      if (isend.lt.1 .or. isend.gt.3) then
         abort = .true.
         write (line,100)
         call putfat (line)
         return
      else
         abort = .false.
      endif
      if (isend.eq.2 .or. isend.eq.3) then
c
c isend = 2 or 3: attempt to open the Y file
c
         close (unit = nin)
         open (unit = nin, file = fname, iostat = ios)
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,'(a)',iostat=ios) title
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,*,iostat=ios) nrow, ncol
         if (ios.ne.0) abort = .true.
         do i = 1, nrow
            if (.not.abort) read (nin,*,iostat=ios) (y(i,j),
     +                                               j = 1, ncol)
            if (ios.ne.0) abort = .true.
         enddo
         close (unit = nin)
         if (abort .or. ncol.lt.2 .or. nrow.lt.2) then
            write (line,200)
            call putfat (line)
            return
         endif
         close (unit = nin)
      else
c
c otherwise initialise
c
         ncol = 0
         nrow = 0
         title = nodata
      endif
c
c main loop
c
      numdec = numopt - 1
      done1 = .true.
      done2 = .true.
      done3 = .true.
      ok = .false.
      repeet = .true.
      do while (repeet)
         pscale = pscal1(iscale)
         if (pscale.eq.'V') then
            g = one
         elseif (pscale.eq.'Q') then
            g = zero
         elseif (pscale.eq.'E') then
            g = half*dble(k)  
         elseif (pscale.eq.'P') then
            g = dble(nvar*(k - 1))/dble(nvar + k - 2)     
         endif
         cipher = form09(g)
         word12(1) = form12(nrow)
         word12(2) = form12(ncol)
         l = len_trim(word12(1))
         write (text,300) title, word12(1)(1:l), word12(2),
     +                    type1(itype), scale1(iscale), cipher
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = numopt - 1
         numbld(1) = 1
         numbld(4) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         if (isend.eq.2 .and. numdec.eq.1) then
c
c isend = 2 and numdec = 1: prevent re-definition of fname
c
            write (line,400)
            call putadv (line)
            numdec = 0
         endif
         if (isend.eq.3 .and. numdec.eq.1) then
c
c isend = 3 and numdec = 1: silent exit with abort = .false.
c
            abort = .false.
            return
         endif
c
c check if ncol > 1 and nrowx > 1
c
         if (ncol.gt.1 .and. nrow.gt.1) then
            abort = .false.
            ready = .true.
         else
            title = nodata
            abort = .true.
            ready = .false.
         endif
         if (.not.ready) then
c
c warn user to read in data
c
            if (numdec.ge.2 .and.numdec.le.8) then
               numdec = 0
               write (line,500)
               call putfat (line)
            endif
         endif
         if (.not.ok) then
c
c warn user if not analysed
c
            if (numdec.ge.4 .and. numdec.ne.6 .and. numdec.le.8) then
               numdec = 0
               write (line,600)
               call putfat (line)
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: read in Y-data
c
            j = jsend
            close (unit = nin)
            call mattin (j, ncmax, ncol, nin, nrmax, nrow,
     +                   y, w,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncol = 0
               nrow = 0
               title = nodata
               ready = .false.
            else
               close (unit = nin)
               open (unit = nin, file = fname)
               read (nin,'(a)') title
               read (nin,*) nrow, ncol
               do i = 1, nrow
                  read (nin,*) (y(i,j), j = 1, ncol)
               enddo
               close (unit = nin)
            endif
            ok = .false.
         elseif (numdec.eq.2) then
c
c numdec = 2: call g03baf
c
            stand = stand1(itype)
            k = ncol
            nvar = nrow
            ifail = 1
            call g03baf$(stand, g, nvar, k, y, nrmax, yhat,
     +                   r, nrmax, acc, maxit, iter, w, ifail)
            if (ifail.eq.0) then
               icount = icount + 1
               abort = .false.
               done1 = .false.
               done2 = .false.
               done3 = .false.
               ok = .true.
               write (text,700) icount, title,
     +                          word12(1)(1:l), word12(2),
     +                          type1(itype), scale1(iscale),
     +                          cipher
               write (nout,'(a)') blank
               j = 15
               call table1 (j, 'OPEN')
               do i = 1, 9
                  if (i.eq.1) then
                     j = 4
                  elseif (i.eq. 5) then
                     j = 1
                  else
                     j = 0
                  endif
                  if (i.ne.2) call table1 (j, text(i))
                  write (nout,'(a)') text(i)
               enddo
               call table1 (j, 'CLOSE')
            else
               abort = .true.
               call putifa (ifail, nout, 'G03BAF/OROTAT')
            endif
c
c restore the data in case it has been standardised
c
            if (stand.eq.'S') then
               close (unit = nin)
               open (unit = nin, file = fname)
               read (nin,'(a)') title
               read (nin,*) nrow, ncol
               do i = 1, nrow
                  read (nin,*) (y(i,j), j = 1, ncol)
               enddo
               close (unit = nin)
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: view original matrix
c
            if (nrow.le.50 .and. ncol.le.20) then
               fileit = .true.
            else
               fileit = .false.
               yes = .false.
               call yesno2 (icolor, ix, iy,
     +'Save original matrix to the results file', yes)
               fileit = yes
            endif
            if (done1) fileit = .false.
            call dsplay (ncmax, ncol, nout, nrmax, nrow, ntype,
     +                   y,
     +                   title,
     +                   fileit)
            done1 = .true.

         elseif (numdec.eq.4) then
c
c numdec = 4: view y-hat matrix
c
            write (ptitle,900) scale1(iscale)
            if (nrow.le.50 .and. ncol.le.20) then
               fileit = .true.
            else
               fileit = .false.
               yes = .false.
               call yesno2 (icolor, ix, iy,
     +'Save rotated matrix to the results file', yes)
               fileit = yes
            endif
            if (done3) fileit = .false.
            call dsplay (ncmax, ncol, nout, nrmax, nrow, ntype,
     +                   yhat,
     +                   ptitle,
     +                   fileit)
            done3 = .true.
         elseif (numdec.eq.5) then
c
c numdec = 5: view rotation matrix
c
            write (ptitle,800) scale1(iscale)
            if (k.le.20) then
               fileit = .true.
            else
               fileit = .false.
               yes = .false.
               call yesno2 (icolor, ix, iy,
     +'Save rotation matrix to the results file', yes)
               fileit = yes
            endif
            if (done2) fileit = .false.
            call dsplay (ncmax, k, nout, nrmax, k, ntype,
     +                   r,
     +                   ptitle,
     +                   fileit)
            done2 = .true.            
         elseif (numdec.eq.6) then
c
c numdec = 6: plot original matrix
c
            call matplt (ksend, ncmax, ncol, nout, nrmax, nrow,
     +                   y)

         elseif (numdec.eq.7) then
c
c numdec = 7: plot yhat matrix
c
            call matplt (ksend, ncmax, k, nout, nrmax, nvar,
     +                   yhat)
         elseif (numdec.eq.8) then
c
c numdec = 8: plot rotation matrix
c
            call matplt (ksend, ncmax, k, nout, nrmax, k,
     +                   r)     
         elseif (numdec.eq.9) then
c
c change type of scaling required
c
            call listbx (itype, n2,
     +                   type1)
            numdec = 2
         elseif (numdec.eq.10) then
c
c change g for, Varimax, Quartimax
c
            call listbx (iscale, n5,
     +                   scale2)   
            if (iscale.eq.n5) then
               call getdge (g, zero,
     +                     'Gamma value required')
            endif
            numdec = 2
         elseif (numdec.eq.numopt - 2) then
c
c results
c
            call revpro (nout)
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,1000)
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
         elseif (numdec.eq.numopt) then
c
c quit
c
            if (isend.eq.3) abort = .true.
            repeet = .false.
         endif
      enddo
c
c format statements
c
  100 format ('ISEND out of range in call to OROTAT')
  200 format ('Error opening loading matrix file in OROTAT')
  300 format (
     + ' Generalised orthomax rotation'
     +/
     +/' Title for data to be rotated:'
     +/1x,a
     +/' Number of rows',1x,a,', Number of columns',1x,a
     +/
     +/' Scaling type:',1x,a
     +/' Rotation type:',1x,a
     +/' Gamma:',1x,a
     +/
     +/'Data: New/Edit/Transform/view'
     +/'Calculate: rotated loading matrix'
     +/'View/File/Save/Print: matrix before rotation'
     +/'View/File/Save/Print: matrix after rotation'
     +/'View/File/Save/Print: the k by k rotation matrix'
     +/'Plot: loading matrix before rotation'
     +/'Plot: loading matrix after rotation'
     +/'Plot: the k by k rotation matrix'
     +/'Change: standardisation type'
     +/'Change: orthomax rotation type'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit orthomax rotation options')
  400 format ('Not available in this mode')
  500 format ('First read in some data')
  600 format ('First do the calculation')
  700 format (
     + ' Generalised Orthomax rotation:',i3
     +/' ---------------------------------'
     +/
     +/' Data for rotation:'
     +/1x,a
     +/' Number of rows:',1x,a,', Number of columns:',1x,a
     +/' Scaling:',1x,a
     +/' Rotation:',1x,a
     +/' gamma =',1x,a)
  800 format ('Rotation matrix ...',1x,a)
  900 format ('Rotated matrix ...',1x,a)
 1000 format (
     + 'Generalised orthomax rotation (0 =< gamma)'
     +/
     +/'Given a loading matrix from PCA, factor, or canonical variate'
     +/'analysis, it is useful to rotate the loadings according to the'
     +/'Varimax (gamma = 1), Quartimax (gamma = 0), or other methods as'
     +/'loadings are only unique up to rotation. Here is the procedure.'
     +/
     +/'1.`First analyse a data set with n rows (cases) and m columns'
     +/'  `(variables) using p active variables (so that p =< m) and'
     +/'  `k factors (where k =< p) to obtain a loading matrix.'
     +/'2.`Input the loading matrix with p rows and k columns where'
     +/'  `p = the number of active variables in the original data, and'
     +/'  `k = the number of derived variates or factors.'
     +/'3.`Choose to standardise rows to unit length before rotation or'
     +/'  `leave them in the the original unstandardised state.'
     +/'4.`Set Varimax, Quartimax, Equamax, Parismax, or User rotation.'
     +/'5.`Rotate.'
     +/'6.`View/File/Save/Plot the results.'
     +/'As the rotated loading matrix will have values that are either'
     +/'relatively small or large, it may be easier to spot important'
     +/'contributions from the original variables to the factors')
      end
c
c
