c
c
      subroutine pacorr (ncmax, nin, nout, nrmax, nsamp, nvar,
     +                   a, b, corr, x, y,
     +                   fname, title,
     +                   query, supply)
c
c action: partial correlations
c author: w.g.bardsley, university of manchester, u.k., 13/04/2004
c         27/07/2006 redimensioned b, corr, x, and y to allow ncol > nrow
c         02/11/2006 edited to improve help and added call to G02BYF$
c         11/11/2006 added allpos in call to eofint   
c         24/11/2006 removed editor and replaced by call to iszedi
c         11/05/2010 introduced NKLCFG to switch on/off the test file advice 
c         30/04/2011 introduced call to TFILEQ
c         24/12/2021 added e_numbers and e_formats, etc.
c         31/12/2021 initialised xtra = .true.
c
c      ncmax: (input/unchanged) second dimension for a, b, corr
c        nin: (input/unchanged) unconnected unit for file opening
c       nout: (input/unchanged) preconnected unit for results
c      nrmax: (input/unchanged) leading dimension for a, b, corr
c      nsamp: supply = .true. (input/unchanged) sample size
c             supply = .false. (output if successful)
c       nvar: supply = .true. (input/unchanged) number of variables
c             supply = .false. (output if successful)
c          a: supply = .true. (not referenced)
c             supply = .false. (workspace)
c          b: supply = .true. (not referenced)
c             supply = .false. (workspace)
c       corr: supply = .true. (input/unchanged) correlation matrix
c             supply = .false. (output if successful)
c          x: supply = .true. (not referenced)
c             supply = .false.(workspace)
c          y: supply = .true. (not referenced)
c             supply = .false.(workspace)
c      fname: supply = .true. (input unchanged) data file
c             supply = .false. (output if successful)
c      title: supply = .true. (input unchanged) data title
c             supply = .false. (output if successful)
c      query: (input/unchanged) request action only if supply = .true.
c     supply: (input/unchanged) if true then corr is supplied
c             o/w corr is read in or calculated from data
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmax, nin, nout, nrmax
      integer,             intent (inout) :: nsamp, nvar
      double precision,    intent (inout) :: a(nrmax,ncmax),
     +                                       b(ncmax,ncmax),
     +                                       corr(ncmax,ncmax),
     +                                       x(ncmax), y(ncmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: query, supply
c
c local allocatable workspaces
c
      integer,             allocatable :: isx(:)
      double precision,    allocatable :: pcm(:,:), wk(:)
      character (len = 9), allocatable :: pcv(:,:)
c
c locals
c
      integer    i, i1, ierr, ifail, isend, j, j1, k1, l, m,
     +           ncol, ndof, nrow, nx, ny, nz
      integer    kval9, nklcfg
      integer    n0, n1, n2, n3, n4, n5, n6, n8, n10, n15, n21
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n8 = 8, n10 = 10, n15 = 15, n21 = 21)
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numsta = 14)
      integer    numbld(30), numpos(10)
      integer    icmax, nisx
      parameter (icmax = 100, nisx = 100)
      integer    icount, isxsav(nisx)
      double precision bot, dof, p, r, rij, rik, rjk, rl1, rl2, t, t95,
     +                 top, w
      double precision rtol
      double precision g01ebf$, g01fbf$, x02amf$
      double precision one, pnt975, rmin, rmax
      parameter (one = 1.0d+00, pnt975 = 0.975d+00, rmin = -0.999d+00,
     +           rmax = 0.999d+00)
      character (len = 12) i12(3), form12, word12_nx, word12_ny,
     +                     word12_nz, word12_nsamp, word12_i1,
     +                     word12_j1, word12_k1   
      character (len = 13) d13, showlj   
      character  header*(icmax)
      character  line*100, text(30)*100, chop80*80, word80*80
      character  tail*1, symbol*40
      character  blank*1, blank4*4, dots*5
      parameter (blank = ' ', blank4 = '    ', dots = '.....')
      logical    xtra
      logical    e_numbers, e_formats
      logical    abort, border, fileit, flash, high, repeet, yesno
      parameter (border = .false., fileit = .true., flash = .false.,
     +           high = .true.)
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    allpos
      parameter (allpos = .false.)
      external   e_formats, showlj
      external   lbox01, getjm1, putadv, table1, plevel, patch1, putifa,
     +           mattin, getigt, chop80, lbox02, matcor, revpro,
     +           yesno2, eofint, iszedi, form12
      external   nklcfg, tfileq
      external   g01ebf$, g01fbf$, g02baf$, x02amf$, g02byf$
      intrinsic  sqrt, dble, abs, trim
      save       icount, isxsav
      data       icount, isxsav / 0, 100*1 /
      data       numpos / 10*1 /
      data       numbld / 30*0 /
c
c initialise abort = .false. and xtra = .true.
c
      abort = .false.
      xtra = .true.
      e_numbers = e_formats()
      rtol = 1.0d+09*x02amf$()
      if (supply) then
         if (nvar.le.n2) return
         if (query) then
            yesno = .false.
            call yesno2 (icolor, ix, iy,
     +                   'Calculate partial correlations',
     +                   yesno)
            if (.not.yesno) return
         endif
      else
c
c part 1: data input if supply = .false.
c =======
c
         repeet = .true.
         xtra = .true.
         do while (repeet)
            ncol = n0
            nrow = n0
            nvar = n0
            nsamp = n0
            write (text,100)
            numdec = n3
            numopt = n5
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.eq.n1) then
c
c read in an arbitrary data matrix then calculate the correlation matrix
c
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then 
                  write (line,200)
                  call tfileq (line)
               endif   
               abort = .true.
               close (unit = nin)
               isend = n3
               call mattin (isend, ncmax, ncol, nin, nrmax, nrow,
     +                      a, x,
     +                      fname, title,
     +                      abort, fixcol, fixrow, label)
               close (unit = nin)
               if (abort .or. nrow.le.ncol .or. ncol.le.n2) then
                  ncol = n0
                  nrow = n0
                  write (line,300)
                  call putadv (line)
               else
                  ifail = n0
                  call g02baf$(nrow, ncol, a, nrmax, x, y, b, ncmax,
     +                         corr, ncmax, ifail)
                  if (ifail.eq.n0) then
                     nsamp = nrow
                     nvar = ncol
                     repeet = .false.
                  else
                     call putifa (ifail, nout, 'G02BAF/PACORR')
                  endif
               endif
            elseif (numdec.eq.n2) then
c
c read in a correlation matrix
c
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then 
                  write (line,400)
                  call tfileq (line)
               endif   
               abort = .true.
               close (unit = nin)
               isend = n3
               call mattin (isend, ncmax, ncol, nin, ncmax, nrow,
     +                      corr, x,
     +                      fname, title,
     +                      abort, fixcol, fixrow, label)
               close (unit = nin)
               if (abort .or. nrow.ne.ncol .or. ncol.le.n2) then
                  abort = .true.
                  ncol = n0
                  nrow = n0
                  write (line,500)
                  call putadv (line)
               else
c
c check that -1 corr(i,j) < 1 in strict upper triangle
c
                  do l = n1, nvar
                     do m = l + n1, nvar
                        if (.not.abort) then
                           if (corr(l,m).ge.one .or.
     +                         corr(l,m).le. -one) then
                              abort = .true.
                              write (line,600) l, m
                              call putadv (line)
                           endif
                        endif
                     enddo
                  enddo
                  if (.not.abort) then
                     nvar = ncol
                     write (line,700) ncol
                     call getigt (nsamp, ncol,
     +                            line)
                     if (nsamp.gt.nvar) repeet = .false.
                  endif
               endif
            elseif (numdec.eq.numopt - n2) then
c
c help on data formats
c
               write (text,800)
               numtxt = 20
               numbld(1) = n1
               numbld(3) = n1
               numbld(8) = n1
               numbld(14) = n1
               call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                      text,
     +                      border)
               numbld(1) = n0
               numbld(3) = n0
               numbld(8) = n0
               numbld(14) = n0
            elseif (numdec.eq.numopt - n1) then
c
c help on partial correlations
c
               write (text,900)
               numtxt = 20
               numbld(1) = n1
               call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                      text,
     +                      border)
               numbld(1) = n0
            else
               abort = .true.
               repeet = .false.
            endif
         enddo
      endif
c
c part 2: analysis
c =======
c
      if (abort) return
      if (nvar.le.n2 .or. nvar.gt.ncmax) then
         call putadv ('NVAR < 2, or NVAR > NCMAX in call to PACORR')
         return
      endif
      if (nsamp.le.nvar) then
         call putadv ('Must have sample size > number of variables')
         return
      endif
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pcm)) deallocate(pcm, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pcv)) deallocate(pcv, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(nvar), stat = ierr)
      if (ierr.ne.0) return
      allocate(pcm(nvar,nvar), stat = ierr)
      if (ierr.ne.0) return
      allocate(wk(nvar*nvar + nvar*(nvar + 1)/2), stat = ierr)
      if (ierr.ne.0) return
      allocate(pcv(nvar,nvar), stat = ierr)
      if (ierr.ne.0) return
c
c defaults for isx
c
      do i = n1, nvar
         if (i.le.nisx) then
            isx(i) = isxsav(i)
         else
            isx(i) = n1
         endif
      enddo
c
c fine tune isx from data file
c
      call eofint (isx, nvar,
     +             fname,
     +             abort, allpos)
      word80 = chop80(title)
      i1 = n1
      j1 = n2
      k1 = n3
      icount = icount + n1
      write (nout,'(a)') blank
      write (nout,'(a,i3)') ' Partial correlation analysis', icount
      write (nout,'(a)')    ' -------------------------------'
      repeet = .true.
      do while (repeet)
         nx = n0
         ny = n0
         nz = n0
         header = blank
         do i = n1, nvar
            if (isx(i).gt.n0) then
               isx(i) = n1
               nx = nx + n1
               if (i.le.icmax) header(i:i) = 'x'
            elseif (isx(i).eq.n0) then
               if (i.le.icmax) header(i:i) = '0'
               nz = nz + n1
            else
               isx(i) = -n1
               ny = ny + n1
               if (i.le.icmax) header(i:i) = 'y'
            endif
         enddo
         if (nvar.gt.icmax) header(icmax - n4:icmax) = dots
         word12_nx = form12(nx)   
         word12_ny = form12(ny)   
         word12_nz = form12(nz)   
         word12_nsamp = form12(nsamp)   
         word12_i1 = form12(i1)   
         word12_j1 = form12(j1)   
         word12_k1 = form12(k1)   
         write (text,1100) word80, header, word12_nx, word12_ny,
     +                     word12_nz, word12_nsamp, word12_i1,
     +                     word12_j1, word12_k1
         numopt = n10
         numdec = numopt - n1
         numtxt = numsta + numopt - n1
         numbld(1) = 4
         numbld(4) = 1
         numbld(7) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, numsta, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         numbld(7) = 0
         if (xtra .and. nvar.gt.n3 .and. numdec.le.n4) then
            xtra = .false.
            write (line,1200)
            call putadv (line)
         endif

         if (numdec.eq.n1) then
c
c numdec = 1: choose i
c
            call getjm1 (n1, i1, nvar,
     +                   'Column to use for variable i')
         elseif (numdec.eq.n2) then
c
c numdec = 2: choose j
c
            call getjm1 (n1, j1, nvar,
     +                   'Column to use for variable j')
         elseif (numdec.eq.n3) then
c
c numdec = 3: choose k
c
            call getjm1 (n1, k1, nvar,
     +                   'Column to use for variable k')
         elseif (numdec.eq.n4) then
c
c numdec = 4: calculate
c
            l = (i1 - j1)*(j1 - k1)*(i1 - k1)
            if (l.eq.n0) then
               call putadv ('i, j, k must be distinct')
            else
               if (i1.gt.j1) then
                  rij = corr(j1,i1)
               else
                  rij = corr(i1,j1)
               endif
               if (i1.gt.k1) then
                  rik = corr(k1,i1)
               else
                  rik = corr(i1,k1)
               endif
               if (j1.gt.k1) then
                  rjk = corr(k1,j1)
               else
                  rjk = corr(j1,k1)
               endif
               top = rij - rik*rjk
               bot = (one - rik**2)*(one - rjk**2)
               ndof = nsamp - (nvar - n2) - n2
               if (ndof.gt.n0 .and. bot.gt.rtol) then
                  bot = sqrt(bot)
                  r = top/bot
                  dof = dble(ndof)
                  tail = 'L'
                  ifail = n0
                  t95 = g01fbf$(tail, pnt975, dof, ifail)
                  call putifa (ifail, nout, 'G01FBF/PACORR')
                  w = sqrt(t95**2/(t95**2 + dof))
                  if (abs(one - r*w).gt.rtol .and.
     +                abs(one + r*w).gt.rtol .and.
     +                (one - r**2).gt.rtol) then

                     rl1 = (r - w)/(one - r*w)
                     rl2 = (r + w)/(one + r*w)
                     top = r*sqrt(dof)
                     bot = sqrt(one - r**2)
                     t = top/bot
                     ifail = n0
                     tail = 'S'
                     p = g01ebf$(tail, t, dof, ifail)
                     call putifa (ifail, nout, 'G01EBF/PACORR')
                     call plevel (p, symbol)
                     if (e_numbers) then
                        write (text,1300) word80, nvar, nsamp, i1, j1, 
     +                                    rij, i1, k1, rik, j1, k1, rjk,
     +                                    i1, j1, k1, r, rl1, rl2, t, 
     +                                    ndof, p, symbol
                     else
                        i12(1) = form12(nvar)
                        i12(2) = form12(nsamp)
                        i12(3) = form12(ndof) 
                        d13 = showlj(t)
                        write (text,1350) word80, 
     +                                    trim(i12(1)), trim(i12(2)),
     +                                    i1, j1, rij, i1, k1, rik, j1,
     +                                    k1, rjk, i1, j1, k1, r, rl1,
     +                                    rl2, trim(d13), trim(i12(3)), 
     +                                    p, symbol
                     endif 
                     call table1 (n15, 'OPEN')
                     write (nout,'(a)') blank
                     do l = n1, n8
                        if (l.eq.n1 .or. l.eq.n3) then
                           m = n4
                        elseif (l.eq.n2) then
                           m = n1
                        else
                           m = n0
                        endif
                        call table1 (m, text(l))
                        write (nout,'(a)') text(l)
                     enddo
                     call table1 (n0, 'CLOSE')
                  else
                     write (line,1400)
                     call putadv (line)
                  endif
               else
                  write (line,1400)
                  call putadv (line)
               endif
            endif
         elseif (numdec.eq.n5) then
c
c numdec = 5: partial correlation matrix
c
            if (ny.lt.2 .or. nx.lt.1 .or. nsamp.le.nx + n2) then
               write (line,1500)
               call putadv (line)
            else
               ifail = n1
               call g02byf$ (nvar, ny, nx, isx, corr, ncmax, pcm, nvar,
     +                       wk, ifail)
               if (ifail.ne.n0) then
                  call putifa (nout, ifail, 'G02BYF/PACORR')
               else
                  dof = dble(nsamp - nx - n2)
                  do j = n1, ny
                     do i = n1, ny
                        if (j.gt.i) then
                           write (pcv(i,j),'(f9.5)') pcm(i,j)
                        elseif (j.eq.i) then
                           pcv(i,j) = blank4//dots
                        else
                           r = pcm(j,i)
                           if (r.lt.rmin) then
                              r = rmin
                           elseif (r.gt.rmax) then
                              r = rmax
                           endif
                           t = r*sqrt(dof/(one - r**2))
                           P = g01ebf$('S', t, dof, ifail)
                           call putifa (ifail, nout, 'G01EBF/PACORR')
                           write (pcv(i,j),'(f9.5)') p
                        endif
                     enddo
                  enddo
                  write (nout,'(a)') 'Variables:'//blank//header
                  write (line,1600)
                  call matcor (nvar, ny, nout,
     +                         pcv, line,
     +                         fileit)
               endif
            endif
         elseif (numdec.eq.n6) then
c
c numdec = 6: assign variables
c                             
            call iszedi (isx, nvar)
         elseif (numdec.eq.numopt - n3) then
c
c numdec = numopt - 1: results
c
            call revpro (nout)
         elseif (numdec.eq.numopt - n2) then
c
c numdec = numopt - 2: data formats
c
            write (text,800)
            numtxt = 20
            numbld(1) = n1
            numbld(3) = n1
            numbld(8) = n1
            numbld(14) = n1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = n0
            numbld(3) = n0
            numbld(8) = n0
            numbld(14) = n0
         elseif (numdec.eq.numopt - n1) then
c
c numdec = numopt - 1: theory
c
            write (text,900)
            write (text(1),1000) nvar, nsamp
            numtxt = 20
            numbld(1) = n1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = n0
         else
c
c numdec = numopt: cancel
c
            repeet = .false.
         endif
      enddo
      deallocate(isx, stat = ierr)
      deallocate(pcm, stat = ierr)
      deallocate(wk, stat = ierr)
      deallocate(pcv, stat = ierr)
c
c format statements
c
  100 format (
     + 'Input a data matrix'
     +/'Input a correlation matrix'
     +/'Help: data input formats'
     +/'Help: partial correlation'
     +/'Quit ... Exit these options')
  200 format ('Now input a n by m data matrix with n >= m > 2')
  300 format ('Must have n >= m > 2')
  400 format (
     +'Now input a correlation matrix (m > 2, strict upper triangular)')
  500 format ('Must have n = m > 2')
  600 format ('r(',i3,',',i3,') out of range [-1, 1]')
  700 format ('Sample size used >',i3)
  800 format (
     + 'Three methods to calculate partial correlation coefficiants'
     +/
     +/'Method 1'
     +/'The usual way is first to perform a Pearson product-moment'
     +/'correlation analysis on a multivariate data set, when the'
     +/'opportunity will be provided if the number of variables > 2.'
     +/
     +/'Method 2'
     +/'The data can be input as a matrix with at least three variables'
     +/'(columns) and number of cases (rows, i.e. sample size) greater'
     +/'than the number of variables. The correlation matrix will then'
     +/'be calculated from the data matrix.'
     +/
     +/'Method 3'
     +/'The correlation matrix can be input directly as a m by m matrix'
     +/'as long as m > 2. Note: the program only uses the strict upper'
     +/'triangle of the matrix which is tested for -1 < (r(i,j) < 1 but'
     +/'the diagonals are not tested for r(i,i) = 1. This makes it easy'
     +/'to type in small correlation matrices, using the option to set'
     +/'uninitialised array elements to 1.')
  900 format (
     + 'The partial correlation matrix'
     +/
     +/'In a correlation matrix involving just three variables it is'
     +/'possible for correlations between two variables to be affected'
     +/'by correlations with the third variable, and it could be that'
     +/'correlation between two selected variables may be wanted after'
     +/'allowing for a third variable. For three variables i, j, and k'
     +/'with correlations r(ij), r(ik), r(jk), the correlation between'
     +/'i and j conditional on k, i.e. r(ij|k), can be estimated from'
     +/'the separate correlations using'
     +/
     +/'r(ij|k) = [r(ij)-r(ik)*r(jk)]/sqrt[{1-r(ik)^2}{1-r(jk)^2}].'
     +/
     +/'Assuming normality and linear correlation, r(ij|k) estimates'
     +/'the correlation between i and j when k is fixed, and confidence'
     +/'limits and t tests can then be used as for simple correlations.'
     +/
     +/'For more than three variables you must then calculate a partial'
     +/'correlation matrix, where some variables (Y) are regarded as'
     +/'correlated, conditional on the remaining fixed variables (X).')
 1000 format ('Partial correlations: current m =',i3,', n =',i6)
 1100 format (
     + 'Partial correlation coefficients'
     +/
     +/'Data:'
     +/a
     +/
     +/'Variables'
     +/a
     +/
     +/'Number of x-variables (NX) =',1x,a
     +/'Number of y-variables (NY) =',1x,a
     +/'Number of suppressed variables =',1x,a
     +/'Sample size (N) =',1x,a
     +/
     +/'New i: current value =',1x,a
     +/'New j: current value =',1x,a
     +/'New k: current value =',1x,a
     +/'Calculate: one partial correlation r(ij|k)'
     +/'Calculate: the partial correlation matrix'
     +/'Allocate variables as y, x, suppressed'
     +/'Results'
     +/'Help: data input formats'
     +/'Help: partial correlation'
     +/'Quit ... Exit partial correlation options')
 1200 format (
     +'The partial correlation matrix can be used for > 3 variables')
 1300 format (
     + 'Title of partial correlation data:'
     +/a
     +/'Number of variables =',i3,', sample size =',i6
     +/'r(',i3,',',i3,') =',f8.4
     +/'r(',i3,',',i3,') =',f8.4
     +/'r(',i3,',',i3,') =',f8.4
     +/'r(',i3,',',i3,'|',i3,') =',f8.4,' (95%c.l. =',f8.4,',',f8.4,')'
     +/'t =',1p,e11.3,', ndof =',i6,', p =',0p,f7.4,1x,a)
 1350 format (
     + ' Title of partial correlation data:'
     +/a
     +/' Number of variables =',1x,a,', sample size =',1x,a
     +/' r(',i3,',',i3,') =',f8.4
     +/' r(',i3,',',i3,') =',f8.4
     +/' r(',i3,',',i3,') =',f8.4
     +/' r(',i3,',',i3,'|',i3,') =',f8.4,' (95%c.l. =',f8.4,',',f8.4,')'
     +/' t =',1x,a,', ndof =',1x,a,', p =',f7.4,1x,a)     
 1400 format ('Singularity encountered  ...  calculation is impossible')
 1500 format ('Must have NY >= 2, NX >= 1, and N > NX + 2')
 1600 format (
     +'Upper triangle: partial r, Lower: corresponding 2-tail p values')
      end
c
c
