C
C
      SUBROUTINE PARLIM (ISEND, NIN, NPAR, NSET, NSMALL, NX,
     +                   BL, BU, P,
     +                   FSAV, TSAV,
     +                   ABORT)
C
C ACTION : save or set parameter limits
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/08/99
C         16/10/2006 extensive re-write and introduced allocatable for A
C         23/04/2020 made NSET INTENT (IN) instead of INTENT (INOUT) and initialised NSET = 0
C
C         ISEND: (input/unchanged) as follows:
C                 ISEND = 1: read a parameter file
C                 ISEND = 2: write a parameter file
C                 ISEND = 3: install a library file
C                 ISEND = 4: access a library file
C                 ISEND = 5: help 
C           NIN: (input/unchanged) unconnected unit for data input
C          NPAR: (input/unchanged) no. of parameters required
C          NSET: (output) no. of parameters set by this routine
C          FSAV: (input/output) filenames for library file
C          TSAV: (input/output) titles for library files 
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NPAR, NSMALL,
     +                                       NX  
      INTEGER,             INTENT (OUT)   :: NSET 
      DOUBLE PRECISION,    INTENT (INOUT) :: BL(NX), P(NX), BU(NX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NSMALL), TSAV(NSMALL)
      LOGICAL,             INTENT (OUT)   :: ABORT  
C
C Local allocatable array
C                        
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:)
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N5, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N21 = 21)
      INTEGER    NCMAX, NRMAX, NTEXT
      PARAMETER (NCMAX = 3, NTEXT = 50)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      INTEGER    NUMBLD(N21), NUMPOS(NTEXT)
      INTEGER    I, IERR, IOS, NCOL, NFILES, NREADY, NROW
      DOUBLE PRECISION B(NCMAX)
      CHARACTER  FNAME*1024, LINE*100, TEXT(NTEXT)*100, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .TRUE., QTITLE = .TRUE.)
      LOGICAL    FRAME, UPDOWN, NEXT
      PARAMETER (FRAME = .FALSE., UPDOWN = .FALSE.)
      LOGICAL    ADVICE, COPY, READY
      EXTERNAL   PUTFAT, LIBFIL, MATTIN, MATOUT, LBOX02, PUTWAR,
     +           TUTORS, PUTADV
      INTRINSIC  MAX, MIN
      SAVE       ADVICE, READY, NREADY
      DATA       ADVICE, READY / .FALSE., .FALSE. /
      DATA       NREADY / 0 /
      DATA       NUMPOS / NTEXT*1 /
      DATA       NUMBLD / N21*0 /
C
C Initialise ABORT, and COPY, then check ISEND, NPAR, and NX 
C
      ABORT = .TRUE.
      COPY = .FALSE.
      NSET = N0
      IF (ISEND.LT.N1 .OR. ISEND.GT.N5) THEN
         CALL PUTFAT ('ISEND out of range in call to PARLIM')
         RETURN
      ENDIF                    
      IF (NPAR.LT.N1 .OR. NPAR.GT.NX) THEN 
         CALL PUTFAT ('NPAR < 1, or NPAR > NX in call to PARLIM')
         RETURN
      ENDIF   
      IF (ISEND.LT.N5 .AND. .NOT.ADVICE) THEN
C
C Give advice if not yet requested
C
         ADVICE = .TRUE.
         NUMBLD(1) = 1
         NUMBLD(8) = 1
         NUMBLD(9) = 1
         NUMBLD(10) = 1
         WRITE (TEXT,100)
         CALL TUTORS (ICOLOR, NUMBLD, N21,
     +                TEXT,
     +                FRAME, NEXT, UPDOWN)
      ENDIF 
      IF (ISEND.NE.N3 .AND. ISEND.NE.N5) THEN    
C
C Allocate array A if ISEND is not 3 or 5
C  
         IERR = N0
         IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         NRMAX = MAX(NX,200)
         ALLOCATE (A(NRMAX,NCMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
      ENDIF   
      IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: Read in from a file
C =========
C                  
         NSET = N0 
         CALL PUTADV (
     +'Input a PLF file with P-low,P-start,P-high (like exfit-tf4.plf)')
         NCOL = N3
         CLOSE (UNIT = NIN)
         CALL MATTIN (N2, NCMAX, NCOL, NIN, NRMAX, NROW, 
     +                A, B, 
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            DEALLOCATE(A, STAT = IERR)
            RETURN
         ENDIF   
         IF (NROW.LT.N1) THEN
            ABORT = .TRUE.
            CALL PUTFAT ('Insufficient data in file supplied')
            DEALLOCATE (A, STAT = IERR)
            RETURN
         ELSEIF (NROW.GT.NPAR) THEN
            WRITE (LINE,200) NPAR, NROW
            CALL PUTWAR (LINE)
         ELSEIF (NROW.LT.NPAR) THEN
            WRITE (LINE,300) NPAR, NROW
            CALL PUTWAR (LINE)
         ENDIF
         DO I = N1, NROW
            IF (A(I,N1).GT.A(I,N2) .OR. A(I,N2).GT.A(I,N3)) THEN
               ABORT = .TRUE.
               WRITE (LINE,400) I
               CALL PUTFAT (LINE)
               DEALLOCATE (A, STAT = IERR)
               RETURN
            ENDIF
         ENDDO
         COPY = .TRUE.
      ELSEIF (ISEND.EQ.N2) THEN
C
C ISEND = 2: Write out to a file
C ==========
C
         IF (NPAR.GE.N1) THEN
            NCOL = N3
            NROW = NPAR
            DO I = N1, NROW
               A(I,N1) = BL(I)
               A(I,N2) = P(I)
               A(I,N3) = BU(I)
            ENDDO
            TITLE = 'Parameter Limits'
            CLOSE (UNIT = NIN) 
            CALL MATOUT (N1, NCOL, NIN, NRMAX, NROW, NTEXT,
     +                   A,
     +                   FNAME, TEXT, TITLE,
     +                   ABORT, HEADER, QTEXT, QTITLE)
            CLOSE (UNIT = NIN)
         ENDIF
         ABORT = .FALSE. 
         DEALLOCATE (A, STAT = IERR)
         RETURN
      ELSEIF (ISEND.EQ.N3) THEN
C
C ISEND = 3: Install a library file
C ==========
C
         CALL PUTADV (
     +'Specify a library file with names of PLF files (like qnfit.tfl)')
         CLOSE (UNIT = NIN)
         NCOL = N3
         CALL LIBFIL (NCOL, NFILES, NIN, NROW, NSMALL,
     +                FSAV, TSAV,
     +                ABORT, FIXCOL, FIXROW)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            NREADY = N0
            READY = .FALSE.
            DO I = N1, NSMALL
               FSAV(I) = BLANK
               TSAV(I) = BLANK
            ENDDO
         ELSE
            NREADY = NFILES
            READY = .TRUE.
         ENDIF 
         RETURN
      ELSEIF (ISEND.EQ.N4) THEN
C
C ISEND = 4: Access a library file
C ==========
C        
         IF (READY .AND. NREADY.GE.N1) THEN
            NSET = N0
            TEXT(N1) = 'Cancel'
            NUMDEC = N1
            NUMOPT = N1
            DO I = N2, MIN(NREADY + N1, NTEXT - N1)
               TEXT(I) = FSAV(I - N1)
               NUMOPT = NUMOPT + N1
            ENDDO
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IF (NUMDEC.GT.N1) THEN
C
C Check the file selected
C
               FNAME = FSAV(NUMDEC - N1)
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
               IF (IOS.NE.N0) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CALL PUTFAT ('File selected cannot be opened')
                  DEALLOCATE (A, STAT = IERR)
                  RETURN
               ENDIF
               READ (NIN,'(A)',IOSTAT=IOS) TITLE
               IF (IOS.NE.N0) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CALL PUTFAT ('Cannot read title ... incorrect format')
                  DEALLOCATE (A, STAT = IERR)
                  RETURN
               ENDIF
               READ (NIN,*,IOSTAT=IOS) NROW, NCOL
               IF (IOS.NE.N0) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CALL PUTFAT ('Cannot read header... incorrect format')
                  DEALLOCATE (A, STAT = IERR)
                  RETURN
               ENDIF
               IF (NCOL.NE.N3) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CALL PUTFAT ('Incorrect column dimension')
                  DEALLOCATE (A, STAT = IERR)
                  RETURN
               ENDIF
               IF (NROW.LT.N1) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CALL PUTFAT ('Insufficient data in file supplied')
                  DEALLOCATE (A, STAT = IERR)
                  RETURN
               ELSEIF (NROW.GT.NPAR) THEN
                  WRITE (LINE,200) NPAR, NROW
                  CALL PUTWAR (LINE)
               ELSEIF (NROW.LT.NPAR) THEN
                  WRITE (LINE,300) NPAR, NROW
                  CALL PUTWAR (LINE)
               ENDIF
C
C Title and Header check out so examine the data
C
               ABORT = .FALSE.
               IOS = N0
               I = N0
               DO WHILE (IOS.EQ.N0 .AND. I.LT.NROW)
                  I = I + N1
                  READ (NIN,*,IOSTAT=IOS) A(I,N1), A(I,N2), A(I,N3)
                  IF (IOS.NE.N0 .OR. A(I,N1).GT.A(I,N2) .OR.
     +                A(I,N2).GT.A(I,N3)) THEN
                     ABORT = .TRUE.
                     WRITE (LINE,400) I + N2
                     CALL PUTFAT (LINE)
                     I = NROW + N1
                  ENDIF
               ENDDO
               CLOSE (UNIT = NIN)
               IF (.NOT.ABORT) COPY = .TRUE.
            ENDIF
         ELSE
            ABORT = .TRUE.
            CALL PUTFAT (
     +'Library file not available  ...  Install one (like qnfit.tfl)')
            DEALLOCATE (A, STAT = IERR)
            RETURN
         ENDIF
      ELSEIF (ISEND.EQ.N5) THEN
C
C ISEND = 5: Help
C
         ABORT = .FALSE.
         ADVICE = .TRUE.
         NUMBLD(1) = 1
         NUMBLD(8) = 1
         NUMBLD(9) = 1
         NUMBLD(10) = 1
         WRITE (TEXT,100)
         CALL TUTORS (ICOLOR, NUMBLD, N21, 
     +                TEXT,
     +                FRAME, NEXT, UPDOWN)
         RETURN
      ENDIF
C
C If COPY = .TRUE. then define NSET and copy A into parameters and limits
C
      IF (COPY) THEN
         NSET = MIN(NROW, NPAR)
         DO I = N1, NSET
            BL(I) = A(I,N1)
            BU(I) = A(I,N3)
            P(I) = A(I,N2)
         ENDDO
      ENDIF
      CLOSE (UNIT = NIN)
      DEALLOCATE (A, STAT = IERR)
      ABORT = .FALSE.
  100 FORMAT (
     + 'Parameter-limits files (.plf) and library (.tfl) files'
     +/
     +/'Curve fitting requires 3 numbers: (P-low, P-start, P-high) for'
     +/'the lowest acceptable value, starting estimate and the highest'
     +/'acceptable value, so that P-low =< P-start =< P-high for each'
     +/'of the parameters to be estimated.'
     +/
     +/'Fitting will only succeed if these estimates are sensible, and'
     +/'this is particularly important with differential equations'
     +/'and models where some parameters occur as exponents.'
     +/
     +/'You can supply the appropriate constraints interactively, but'
     +/'the best way is to select values from a parameter/limits file.'
     +/'This is just a matrix file in Simfit format with three columns'
     +/'P-low, P-start and P-high. You can read from a file, write the'
     +/'current set to a file, or create a library file with a bank of'
     +/'parameter-limits files, so you can experiment by investigating'
     +/'the outcome of fitting from alternative starting estimates.'
     +/
     +/'Examine exfit-tf4.plf for an example of a parameter/limits file'
     +/'Examine qnfit.tfl for an example of a plf-type library file')
  200 FORMAT (
     +'Overdetermined ... no. parameters =',I5,', no. supplied =',I5)
  300 FORMAT (
     +'Underdetermined ... no. parameters =',I5,', no. supplied =',I5)
  400 FORMAT ('Limits out of order at line',I5,' ... process abandoned')
      END
C
C
