c
c
      subroutine pca001 (ncmax, ncsav, nin, nout, nrmax, nrsav, nsmall,
     +                   a, w,
     +                   fname, fsav, title, tsav,
     +                   newdat, supply)
c
c action: principal components analysis
c author: w.g.bardsley, university of mancheswrkter, u.k., 06/08/2001
c         28/09/2002 changed nisx from 300 to 500
c         07/10/2002 changed nisx from 500 to 1000 and introduced nvmax
c                    to dimension isx(nvmax) not isx(nisx) as originally
c         24/10/2002 introduced pcawts and pcatrn and allowed for w1(i) = 0
c         02/12/2002 added confidence ellipse and improved graphics
c         14/04/2004 added isxedi, isxtyp, and isxvec
c         20/07/2005 added getwrd, savwrd, getlbl, store, ffiles, orotat,
c                    gettmp, deleet, askif, there
c         09/01/2006 deleted v and x and added allocatable work space
C         11/01/2006 moved b, e, p, s, w1, w2, w3 to allocatables
c         07/03/2006 added newdat and supply to argument list
c         14/07/2006 made xgraf1, xgraf2, ygraf1 and ygraf2 allocatable
c         27/07/2006 set ngraf = 100 and better definitions for lde, ldp, ldv,
c                    nbig, etc.
c         18/08/2006 now uses ngraf = max(nbig, ngraf1)with ngraf1 = 100 for ellipses
c         22/09/2006 added calls to matplt for biplots, etc.
c         04/11/2006 corrected several errors, added intents, eofint, and viewit
c         11/11/2006 added allpos in call to eofint
c         19/12/2007 changed nisx to max(nrmax + ncmax,2000) and added nwmax
c         08/07/2008 added nlabel and now also extracts column labels
c         18/08/2016 added call to pcaplt to simplify plotting loadings and scores
c         07/01/2022 added e_numbers and e_formats, etc.
c                    also deleted ntemp and replaced viewit by dsplay
c                    also corrected a long-standing error if pcatrn  
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmax, nin, nout, nrmax,
     +                                       nsmall
      integer,             intent (inout) :: ncsav, nrsav
      double precision,    intent (inout) :: a(nrmax,ncmax), w(2*nrmax)
      character (len = *), intent (inout) :: fname, fsav(nsmall), title,
     +                                       tsav(nsmall)
      logical,             intent (in)    :: supply 
      logical,             intent (out)   :: newdat
c
c local allocatable arrays
c
      integer,              allocatable :: isx(:)
      double precision,     allocatable :: v(:,:), x(:,:)
      double precision,     allocatable :: b(:), e(:,:), p(:,:), s(:),
     +                                     w1(:), w2(:), w3(:)
      double precision,     allocatable :: r(:,:), y(:,:), yhat(:,:)
      double precision,     allocatable :: wrk(:)
      double precision,     allocatable :: xgraf1(:), xgraf2(:),
     +                                     ygraf1(:), ygraf2(:)
      character (len = 40), allocatable :: wordx(:)
c
c locals
c
      integer    icount, lde, ldp, ldv, nbig
      integer    i, ios, isend, j, k, ncol, nplot, nrow, ntotal, nvar
      integer    ierr, ifail, ldx, m, n, ngraf, nlabel, nptcol, nptrow
      integer    icolor, ix, iy, lshade, numdec, nstart, ntext, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    ngraf1, nisx, ntype, nvmax, nwmax, nxmin, n0, n1, n2,
     +           n5
      parameter (ngraf1 = 100, ntype = 3, nvmax = 100, nwmax = 2000,
     +           nxmin = 2, n0 = 0, n1 = 1, n2 = 2, n5 = 5)
      integer    isxsav(nvmax), itype(4), numbld(30), numpos(20)
      integer    ixcol, iycol, izcol, nptype
      double precision ax, by, delta, dn, df1, df2, fval, pi, ratio,
     +                 rtol, siglev, theta, thresh, xbar, xvar, ybar,
     +                 yvar
      double precision x_factor, y_factor
      double precision zero, one, two, sigmax, sigmin
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           sigmin = 0.001d+00, sigmax = one - sigmin)
      double precision x02amf$, g01fdf$, x01aaf$
      character (len = 200) word200
      character (len = 13 ) d13(50), showrj
      character (len = 10 ) formgr, word10
      character  matrix*1, std*1, weight*1
      character  filex*1024, line*100, text(30)*100
      character  chop80*80, word80*80
      character  cipher*30, type1(4)*60
      character  ptitle*80, xtitle*30, ytitle*30
      character  blank*1, no_labels*11, too_many*80
      parameter (blank = ' ',
     +       no_labels = '%no_labels%',     
     +        too_many = 'Too many labels to plot ... maxmimum = 2000')  
      logical    e_numbers, e_formats    
      logical    abort, again, ok, plotit, ready, repeet, showit, store,
     +           yes
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    axes, fileit, gsave
      parameter (axes = .true., gsave = .true.)
      logical    ffiles, frame, next, updown, yesno
      parameter (ffiles = .true., frame = .false., updown = .true.,
     +           yesno = .false.)
      logical    askif, there
      parameter (askif = .false.)
      logical    ellips, wtd 
      logical    allpos
      parameter (allpos = .true.)
      external   e_formats, formgr, showrj
      external   lbox01, lbox02, statmt, chop80, putadv, getjm1,
     +           table1, putifa, pcawts, yesno2, tutor1, dsplay, pca002,
     +           revpro, getwrd, pcatrn, getdm1, isxedi, isxtyp, isxvec,
     +           savwrd, getlbl, gettmp, orotat, deleet, matplt, eofint,
     +           pcaplt 
      external   gks004, space5
      external   g03aaf$, x02amf$, g01fdf$, x01aaf$
      intrinsic  sqrt, dble, nint, min, cos, sin, max
      save       isxsav
      save       ixcol, iycol, izcol
      save       x_factor, y_factor
      save       siglev
      save       ellips
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvmax*1 /
      data       ixcol, iycol, izcol / 1, 2, 3 /
      data       siglev / 0.05d+00 /
      data       ellips / .true. /
      data       x_factor, y_factor / one, one /
      data       icount / 0 /
c
c initialise newdat and check if supply = .true.
c
      newdat = .false.
      if (supply) then
         if (ncsav.lt.2 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return  
      else
         fname = 'No file'
         title = 'No data'
         ncsav = 0
         nrsav = 0
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(p)) deallocate(p, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w2)) deallocate(w2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w3)) deallocate(w3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wordx)) deallocate(wordx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xgraf1)) deallocate(xgraf1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xgraf2)) deallocate(xgraf2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ygraf1)) deallocate(ygraf1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ygraf2)) deallocate(ygraf2, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      if (ierr.ne.0) return
      ldv = nrmax
      allocate(v(ldv,ncmax), stat = ierr)
      if (ierr.ne.0) return
      ldx = nrmax
      allocate(x(ldx,ncmax), stat = ierr)
      if (ierr.ne.0) return
      nbig = max(ncmax, nrmax)
      allocate(b(nbig), stat = ierr)
      if (ierr.ne.0) return
      lde = ncmax
      allocate(e(lde,6), stat = ierr)
      if (ierr.ne.0) return
      ldp = ncmax
      allocate(p(ldp,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(s(nbig), stat = ierr)
      if (ierr.ne.0) return
      allocate(w1(nbig), stat = ierr)
      if (ierr.ne.0) return
      allocate(w2(nbig), stat = ierr)
      if (ierr.ne.0) return
      allocate(w3(nrmax), stat = ierr)
      if (ierr.ne.0) return
      nisx = min(nrmax + ncmax,nwmax)  
      allocate(wordx(nisx), stat = ierr)
      if (ierr.ne.0) return
      ngraf = max(nbig, ngraf1)
      allocate(xgraf1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(xgraf2(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(ygraf1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(ygraf2(ngraf), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      do i = 1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
           isx(i) = 1
         endif
      enddo
      itype(1) = 1
      itype(2) = 1
      itype(3) = 1
      itype(4) = 1
      type1(1) = 'None'
      type1(2) = 'Correlation matrix'
      type1(3) = 'Standardised scores'
      type1(4) = 'Unweighted for replicates'
      rtol = 1.0d+09*x02amf$()
      ncol = ncsav
      nrow = nrsav
      nvar = 0
      nptcol = 0
      nptrow = 0
      word80 = chop80(title)
      ptitle = word80
      if (ncol.gt.1 .and. nrow.gt.1) then
c
c data supplied so initialise labels
c
         ready = .true.
         call eofint (isx, ncol,
     +                fname,
     +                abort, allpos)         
         call isxvec (isx, ncol, nvar, nxmin)
         nlabel = ncol + nrow
         if (nlabel.gt.nwmax) then
            wordx(1) = no_labels
            i = 1
            store = .true.
            call savwrd (i,
     +                   wordx,
     +                   store)            
         else   
            isend = 3
            call getwrd (isend, ncol, nin, nrow, nisx,
     +                   fname, wordx)
            store = .true.
            call savwrd (nlabel,
     +                   wordx,
     +                   store)
         endif
      else
c
c no data supplied
c
         ready = .false.
         nvar = 0
      endif
      ok = .false.
      wtd = .false.
      do i = 1, ngraf
         xgraf1(i) = zero
         xgraf2(i) = zero
         ygraf1(i) = zero
         ygraf2(i) = zero
      enddo
c
c initialise weights w1(i) and standardisations s(i)
c
      do i = 1, nrmax
         w1(i) = one
      enddo
      do i = 1, ncmax
         s(i) = one
      enddo
c
c main loop ............................................................
c
      e_numbers = e_formats()
      numdec = 0
      repeet = .true.
      do while (repeet)
         if (ncol.gt.0) then
            call isxtyp (isx, ncol, nvar, nxmin, 
     +                   line,
     +                   showit)
         else
            line = blank
            showit = .false.
         endif
c
c set up the main menu
c
         write (text,100) word80, line, (type1(i), i = 1, 4)
         nstart = 10
         numopt = 17
         ntext = nstart + numopt - 1
         if (numdec.eq.0) numdec = numopt - 1
         if (numdec.eq.1) then
            if (ready .and. .not.ok) numdec = 2
         elseif (numdec.eq.2) then
            if (.not.ready .or. ok) numdec = 1
         endif
         numbld(2) = 1
         numbld(4) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(2) = 0
         numbld(4) = 0
c
c check current data if analysis has been requested
c
         if (numdec.eq.2) then
            if (.not.ready) then
               ok = .false.
               call putadv ('First read in some data')
               numdec = 0
            else
               if (itype(4).eq.2 .and. nptrow.lt.nrow) then
                  call putadv (
     +'Deficient r vector  ...  replicate weighting cancelled')
                  itype(4) = 1
                  type1(4) = 'Unweighted for replicates'
               endif
               if (itype(4).eq.2) then
                  wtd = .true.
               else
                  wtd = .false.
               endif
               nvar = 0
               do i = 1, ncol
                  if (isx(i).gt.0) nvar = nvar + 1
               enddo
               if (nvar.lt.1) then
                  ok = .false.
                  call putadv ('No current data columns to analyse')
                  numdec = 0
               endif
               if (itype(2).eq.2 .and. nptcol.lt.ncol) then
                  call putadv (
     +'Deficient s vector  ...  scaling cancelled')
                  itype(2) = 1
                  type1(2) = 'Correlation matrix'
               endif
               if (itype(2).eq.2) then
                  do i = 1, ncol
                     if (itype(2).eq.2) then
                        if (isx(i).gt.0 .and. s(i).le.rtol) itype(2) = 1
                     endif
                  enddo
                  if (itype(2).eq.1) then
                     type1(2) = 'Correlation matrix'
                     call putadv (
     +'Deficient s vector  ...  scaling cancelled')
                  endif
               endif
c
c the first tests have been passed so proceed to more searching tests
c
               if (numdec.eq.2) then
                  isend = 1
                  call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                         a, w1, s, x,
     +                         abort, wtd)
                  if (abort) numdec = 0
               endif
            endif
         endif
c
c Check the options that need data
c
         if (.not.ready) then
            if (numdec.ge.3 .and. numdec.le.14) then
               numdec = 0
               call putadv ('First read in some data')
            endif
         endif
c
c Now the output options
c
         if (.not.ok) then
            if (numdec.ge.7 .and. numdec.le.11) then
               numdec = 0
               call putadv ('Data not yet analysed  ...  analyse now')
            endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ===========
c
            if (supply) then
               newdat = .true.
c
c store isx then deallocate workspaces
c
               do i = 1, min(ncmax,nvmax)
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(v, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(e, stat = ierr)
               deallocate(p, stat = ierr)
               deallocate(s, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(w2, stat = ierr)
               deallocate(w3, stat = ierr)
               deallocate(wordx, stat = ierr)
               deallocate(xgraf1, stat = ierr)
               deallocate(xgraf2, stat = ierr)
               deallocate(ygraf1, stat = ierr)
               deallocate(ygraf2, stat = ierr)
               return
            endif
            ok = .false.
            ready = .false.
            call statmt (ncmax, ncsav, nout, nin, nrmax, nrsav, nsmall,
     +                   a, b, w1,
     +                   fname, fsav, title, tsav)
            ncol = ncsav
            nrow = nrsav
            if (ncsav.gt.0 .and. nrsav.gt.0) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.2) then
               abort = .true.
               call putadv ('Must have at least 2 columns')
            endif
            if (.not.abort .and. nrow.lt.2) then
               abort = .true.
               call putadv ('Must have at least 2 rows')
            endif
            if (ncol.gt.nvmax) then
               abort = .true.
               call putadv ('Dimension exceeded: ncol > nvmax')
            endif
            if (abort) then
c
c failure to read in data
c
               nvar = 0
               ready = .false.
               ok = .false.
               word80 = 'No data'
               numdec = 1
            else
c
c success so initialise labels
c
               ready = .true.
               call eofint (isx, ncol,
     +                      fname,
     +                      abort, allpos)                
               call isxvec (isx, ncol, nvar, nxmin)
               word80 = chop80(title)
               ptitle = word80
               nlabel = ncol + nrow
               if (nlabel.gt.nwmax) then
                  wordx(1) = no_labels
                  i = 1
                  store = .true.
                  call savwrd (i,
     +                         wordx,
     +                         store)      
               else   
                  isend = 3
                  call getwrd (isend, ncol, nin, nrow, nisx,
     +                         fname, wordx)
                  store = .true.
                  call savwrd (nlabel,
     +                         wordx,
     +                         store)
               endif
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: calculate the principal components
c ===========
c
            icount = icount + 1
            write (nout,'(a)') blank
            write (nout,'(a,i3)') ' Principal components analysis:',
     +                             icount
            write (nout,'(a)') ' ---------------------------------'
c
c step 1: transform depending on itype(1)
c ---------------------------------------
c

            isend = 2
            call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                   a, w1, s, x,
     +                   abort, wtd)
            if (abort) then
               ok = .false.
            else
               ok = .true.
            endif
c
c step 2: define MATRIX depending on itype(2)
c -------------------------------------------
c
            if (itype(2).eq.1) then
               matrix = 'C'
            elseif (itype(2).eq.2) then
               matrix = 'S'
            elseif (itype(2).eq.3) then
               matrix = 'U'
            elseif (itype(2).eq.4) then
               matrix = 'V'
            else
               itype(2) = 1
               matrix = 'C'
               type1(2) = 'Correlation matrix'
            endif
c
c step 3: define STD depending on itype(3)
c -----------------------------------------
c
            if (itype(3).eq.1) then
               std = 'S'
            elseif (itype(3).eq.2) then
               std = 'U'
            elseif (itype(3).eq.3) then
               std = 'Z'
            elseif (itype(3).eq.4) then
               std = 'E'
            else
               itype(3) = 1
               std = 'S'
               type1(3) = 'Standardised scores'
            endif
c
c step 4: define WEIGHT depending on itype(4)
c -------------------------------------------
c
            if (itype(4).eq.1) then
               weight = 'U'
            elseif (itype(4).eq.2) then
                weight = 'W'
            else
               itype(4) = 1
               weight = 'U'
               type1(4) = 'Unweighted for replicates'
            endif
            n = nrow
            m = ncol
c
c step 5: call g03aaf$ only if ifail = 0
c --------------------------------------
c
            if (nvar.lt.1 .or. nvar.gt. min(n - 1, m)) then
               ok = .false.
               ifail = 10
               call putadv (
     +'Must have 1 =< no. free variables =< min(n - 1, m)')
            endif
            if (ok) then
               if (matrix.eq.'S') then
                  do i = 1, ncol
                    b(i) = s(i)
                  enddo
               endif
               nvar = 0
               do i = 1, ncol
                  if (isx(i).gt.0) nvar = nvar + 1
               enddo
               ifail = 1
               call g03aaf$(matrix, std, weight, n, m, x, ldx, isx,
     +                      b, w1, nvar, e, lde, p, ldp, v, ldv,
     +                      w, ifail)
            else
               ifail = 10
            endif
            if (ifail.eq.0) then
c
c success so set ok = .true.
c
               call putadv (
     +'Principal Components have now been calculated')
               ok = .true.
               numdec = 7
            elseif (ifail.eq.10) then
c
c routine by-passed
c
               call putadv ('Singular data  ...  Calculation abandoned')
               ok = .false.
               numdec = numopt - 2
            else
c
c failure so set ok = .false.
c
               ok = .false.
               call putifa (ifail, nout, 'G03AAF/PCA001')
               numdec = numopt - 2
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: select a transformation
c ===========
c
            write (text,200)
            numdec = itype(1)
            numopt = 6
            nstart = 10
            ntext = nstart + numopt - 1
            numbld(1) = 4
            call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                   numpos, nstart, ntext,
     +                   text,
     +                   border, flash, high)
            numbld(1) = 0
            if (numdec.ne.itype(1)) then
               ok = .false.
               itype(1) = numdec
               type1(1) = text(numdec)(1:60)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: select a matrix type
c ===========
c
            write (text,300)
            numdec = itype(2)
            numopt = 4
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.ne.itype(2)) then
               ok = .false.
               itype(2) = numdec
               type1(2) = text(numdec)(1:60)
               if (numdec.eq.2) call putadv (
     +'This needs a scaling vector s, s(j) = std.dev. variable(j)')
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: select a standardisation type
c ===========
c
            write (text,400)
            numdec = itype(3)
            numopt = 4
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.ne.itype(3)) then
               ok = .false.
               itype(3) = numdec
               type1(3) = text(numdec)(1:60)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.6) then
c
c numdec = 6: select a weight type
c ===========
c
            write (text,500)
            numdec = itype(4)
            numopt = 2
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(4)) then
               ok = .false.
               itype(4) = numdec
               type1(4) = text(numdec)(1:60)
               if (numdec.eq.2) call putadv (
     +'This needs a replicates vector r, r(i) = no. reps. case(i)')
               numdec = 2
            else
               numdec = 1
            endif
            if (itype(4).eq.2) then
               wtd = .true.
            else
               wtd = .false.
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: output scores
c ===========
c
            if (ok) then
               if (nvar.le.100) then
                  fileit = .true.
               else
                  fileit = .false.   
               endif   
c
c output results
c
               write (text,600) word80, line, (type1(i), i = 1, 4)
               k = 15
               call table1 (k, 'OPEN')
               if (fileit) write (nout,'(a)') blank
               do i = 1, 9
                  if (i.eq.2 .or. i.eq.4 .or. i.eq.9) then
                     k = 4
                  else
                     k = 0
                  endif
                  call table1 (k,text(i))
                  if (fileit) write (nout,'(a)') text(i)
               enddo
               k = 0
               do i = 1, nvar
                  if (itype(2).eq.1) then
                     if (e_numbers) then
                        write  (word200,700) (e(i,j), j = 1, 4),
     +                                        nint(e(i,5))
                     else
                        d13(1) = showrj(e(i,1))
                        d13(2) = showrj(e(i,4))
                        write  (word200,725) d13(1),e(i,2),
     +                                       e(i,3), d13(2),
     +                                        nint(e(i,5))
                     endif  
                  else
                     if (e_numbers) then
                        write  (word200,750) (e(i,j), j = 1, 4),
     +                                        nint(e(i,5)), e(i,6)
                     else
                        d13(1) = showrj(e(i,1))
                        d13(2) = showrj(e(i,4))   
                        write  (word200,775) d13(1), e(i,2), 
     +                                       e(i,3), d13(2), 
     +                                        nint(e(i,5)), e(i,6)
                     endif  
                  endif
                  if (fileit) write (nout,'(a)') word200
                  call table1 (k, word200)
               enddo
               if (nrow.le.50 .and. nvar.le.9) then
                  word200 = 'Principal Component loadings (by column)'
                  k = 4
                  if (fileit) write (nout,'(a)') word200
                  call table1 (k, word200)
                  k = 0
                  do i = 1, nvar
                     if (nvar.gt.8) then
                        if (e_numbers) then
                           write (word200,800) (p(i,j), j = 1, nvar)
                        else
                           do j = 1, nvar
                              d13(j) = showrj(p(i,j))
                           enddo 
                            write (word200,825) (d13(j), j = 1, nvar)   
                        endif  
                     else  
                        if (e_numbers) then 
                           write (word200,850) (p(i,j), j = 1, nvar)
                        else
                           do j = 1, nvar
                              d13(j) = showrj(p(i,j))
                           enddo   
                           write (word200,875) (d13(j), j = 1, nvar)  
                        endif  
                     endif   
                     if (fileit) write (nout,'(a)') word200
                     call table1 (k, word200)
                  enddo
                  word200 = 'Principal Component scores (by column)'
                  k = 4
                  if (fileit) write (nout,'(a)') word200
                  call table1 (k, word200)
                  k = 0
                  do i = 1, nrow
                     if (nvar.gt.8) then
                        if (e_numbers) then
                          write (word200,800) (v(i,j), j = 1, nvar)
                        else
                           do j = 1, nvar
                             d13(j) = showrj(v(i,j))
                           enddo  
                           write (word200,825) (d13(j), j = 1, nvar) 
                        endif  
                     else 
                        if (e_numbers) then  
                           write (word200,850) (v(i,j), j = 1, nvar)
                        else
                           do j = 1, nvar
                              d13(j) = showrj(v(i,j))
                           enddo      
                           write (word200,875) (d13(j), j = 1, nvar)  
                        endif  
                     endif   
                     if (fileit) write (nout,'(a)') word200
                     call table1 (k, word200)
                  enddo
                  call table1 (k, 'CLOSE')
                  numdec = 10
               else
                  call putadv (
     +'You can use options 8 or 9 to display/save loadings and scores')
                  call table1 (k, 'CLOSE')
                  numdec = 8
               endif   
            endif                     
         elseif (numdec.eq.8) then 
C
C numdec = 8: loadings
C ==========
C         
            fileit = .false.
            yes = .false.
            call yesno2 (icolor, ix, iy,
     +'Also save principal component loadings to the results file', yes)
            fileit = yes
            word200 = 'Principal Component loadings (by column)'
            call dsplay (ncmax, nvar, nout, ldp, nvar, ntype,
     +                   p,
     +                   word200,
     +                   fileit) 
             numdec = 9
          elseif (numdec.eq.9) then 
C
C numdec = 9: scores
C ==========
C            
            fileit = .false.
            yes = .false.
            call yesno2 (icolor, ix, iy,
     +'Also save principal component scores to the results file', yes)
            fileit = yes
              word200 = 'Principal Component scores (by column)'
              call dsplay (ncmax, nvar, nout, ldv, nrow, ntype,
     +                     v,
     +                     word200,
     +                     fileit)
            numdec = 10
         elseif (numdec.eq.10) then
c
c numdec = 10: select to plot principal components and scree diagram
c============
c
            if (ok) then
               plotit = .true.
               nptype = 1
               do while (plotit)
c
c start of main plotting loop------------------------------------------
c
                  if (ixcol.gt.nvar) ixcol = 1
                  if (iycol.gt.nvar) iycol = 2
                  if (izcol.gt.nvar) izcol = min(3,nvar)
                  write (text,900)
                  numopt = 8
                  call lbox02 (icolor, ix, iy, nptype, numopt,
     +                         numpos,
     +                         text)
                  if (nptype.ge.3 .and. nptype.le.4 .and.
     +                nvar.lt.3) then
                     call putadv ('Insufficient number of variables')
                     nptype = numopt
                  endif
                  if (nptype.le.2) then
c
c ...nptype =< 2: start of 2-D plotting....................................
c
                     again = .true.
                     do while (again)
                        numopt = 19
                        if (nptype.eq.1) then
c
c ...just a simple x,y scores plot
c
                           nplot = 0
                           numdec = 1
                           ixcol = 1
                           iycol = 2
                        else
c
c ...advanced 2D options
c
                           if (ellips) then
                              cipher = '(current = Yes)'
                              nplot = ngraf1
                           else
                              cipher = '(current = No)'
                              nplot = 0
                           endif
                           write (text,1000) siglev, cipher
                           numdec = 1
                           numopt = 7
                           nstart = 13
                           ntext = nstart + numopt - 1
                           numbld(1) = 1
                           numbld(10) = 1
                           numbld(11) = 1
                           call lbox01 (icolor, ix, iy, lshade, numbld,
     +                                  numdec, numopt, numpos, nstart,
     +                                  ntext,
     +                                  text,
     +                                  border, flash, high)
                           numbld(1) = 0
                           numbld(10) = 0
                           numbld(11) = 0
                           numopt = 19! to correspond to the original version of format 1000
                           if (numdec.le.4) then
                              call pcaplt (nvar, ixcol, iycol,
     +                                     x_factor, y_factor)
c
c re-number the choice to correspond to the original scheme of format 1000 but 
c note that this involves re-numbering 1 to 4 as 1 to 16 and restoring numopt = 19
c     
                              if (numdec.eq.1) then
                                 if (x_factor.lt.zero .and.
     +                               y_factor.gt.zero) then
                                    numdec = 2
                                 elseif (x_factor.gt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 3
                                 elseif (x_factor.lt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 4
                                 endif                            
                              elseif (numdec.eq.2) then
                                 if (x_factor.gt.zero .and.
     +                               y_factor.gt.zero) then 
                                    numdec = 5                                   
                                 elseif (x_factor.lt.zero .and.
     +                               y_factor.gt.zero) then
                                    numdec = 6
                                 elseif (x_factor.gt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 7
                                 elseif (x_factor.lt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 8
                                 endif            
                              elseif (numdec.eq.3) then
                                 if (x_factor.gt.zero .and.
     +                               y_factor.gt.zero) then 
                                    numdec = 9                                   
                                 elseif (x_factor.lt.zero .and.
     +                               y_factor.gt.zero) then
                                    numdec = 10
                                 elseif (x_factor.gt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 11
                                 elseif (x_factor.lt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 12
                                 endif            
                              else
                                 if (x_factor.gt.zero .and.
     +                               y_factor.gt.zero) then 
                                    numdec = 13                                   
                                 elseif (x_factor.lt.zero .and.
     +                               y_factor.gt.zero) then
                                    numdec = 14
                                 elseif (x_factor.gt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 15
                                 elseif (x_factor.lt.zero .and.
     +                                   y_factor.lt.zero) then
                                     numdec = 16
                                 endif            
                              endif  
                           else
                              numdec = numdec + 12
                           endif  
                           if (numdec.ge.5 .and. numdec.le.8) then
                              if (nrow.gt.nwmax) then
                                 numdec = 1
                                 call putadv (too_many)
                              endif   
                           endif  
                           if (numdec.ge.13 .and. numdec.le.16) then
                              if (nvar.gt.nwmax) then
                                 numdec = 2
                                 call putadv (too_many)
                              endif   
                           endif  
                        endif
                        if (numdec.le.8) then
c
c ...load the scores into w2 and w3 then transform if required
c
                           ptitle = 'Principal Component Scores'
                           if (wtd) then
                              ntotal = 0
                              do i = 1, nrow
                                 if (w1(i).gt.zero) then
                                    ntotal = ntotal + 1
                                    w2(ntotal) = v(i,ixcol)
                                    w3(ntotal) = v(i,iycol)
                                    xgraf1(ntotal) = w2(ntotal)
                                    ygraf1(ntotal) = w3(ntotal)
                                 endif
                              enddo
                           else
                              ntotal = nrow
                              do i = 1, ntotal
                                 w2(i) = v(i,ixcol)
                                 w3(i) = v(i,iycol)
                                 xgraf1(i) = w2(i)
                                 ygraf1(i) = w3(i)
                              enddo
                           endif
                           if (nplot.gt.0) then
c
c ...calculate a confidence ellipse
c
                              xbar = zero
                              ybar = zero
                              do i = 1, ntotal
                                 xbar = xbar + xgraf1(i)
                                 ybar = ybar + ygraf1(i)
                              enddo
                              dn = dble(ntotal)
                              xbar = xbar/dn
                              ybar = ybar/dn
                              xvar = zero
                              yvar = zero
                              do i = 1, ntotal
                                 xvar = xvar + (xgraf1(i) - xbar)**2
                                 yvar = yvar + (ygraf1(i) - ybar)**2
                              enddo
                              xvar = xvar/(dn - one)
                              yvar = yvar/(dn - one)
                              delta = one - siglev
                              df1 = two
                              df2 = dn - two
                              ifail = 0
                              fval = g01fdf$(delta, df1, df2, ifail)
                              call putifa (ifail, nout, 'G01FDF/PCA001')
                              theta = one
                              pi = x01aaf$(theta)
                              ratio = fval*two*(dn**2 - one)/(dn*df2)
                              ax = sqrt(xvar*ratio)
                              by = sqrt(yvar*ratio)
                              delta = two*pi/dble(ngraf1 - 2)
                              theta = zero
                              do i = 1, ngraf1 - 1
                                 xgraf1(i) = ax*cos(theta)
                                 ygraf1(i) = by*sin(theta)
                                 theta = theta + delta
                              enddo
                              xgraf1(ngraf1) = xgraf1(1)
                              ygraf1(ngraf1) = ygraf1(1)
                           endif
                        elseif (numdec.le.16) then
c
c ...or the loadings
c
                           ptitle = 'Principal Component Loadings'
                           do i = 1, nvar
                              w2(i) = p(i,ixcol)
                              w3(i) = p(i,iycol)
                           enddo
                        endif
c
c ...write out the x-labels
c

                        if (numdec.eq.2 .or. numdec.eq.4 .or.
     +                      numdec.eq.6 .or. numdec.eq.8) then
                           write (xtitle,'(a,i3)') '- PC', ixcol
                           do i = 1, ntotal
                              w2(i) = - w2(i)
                           enddo
                        elseif (numdec.eq.1 .or. numdec.eq.3 .or.
     +                          numdec.eq.5 .or. numdec.eq.7) then
                           write (xtitle,'(a,i3)') 'PC', ixcol
                        elseif (numdec.eq.10 .or. numdec.eq.12 .or.
     +                          numdec.eq.14 .or. numdec.eq.16) then
                           write (xtitle,'(a,i3)') '- Loading', ixcol
                           do i = 1, nvar
                              w2(i) = - w2(i)
                           enddo
                        elseif (numdec.eq.9 .or. numdec.eq.11 .or.
     +                          numdec.eq.13 .or. numdec.eq.15) then
                           write (xtitle,'(a,i3)') 'Loading', ixcol
                        endif
c
c ...write out the y-labels
c
                        if (numdec.eq.3 .or. numdec.eq.4 .or.
     +                      numdec.eq.7 .or. numdec.eq.8) then
                           write (ytitle,'(a,i3)') '- PC', iycol
                           do i = 1, ntotal
                              w3(i) = - w3(i)
                           enddo
                        elseif (numdec.eq.1 .or. numdec.eq.2 .or.
     +                          numdec.eq.5 .or. numdec.eq.6) then
                           write (ytitle,'(a,i3)') 'PC', iycol
                        elseif (numdec.eq.11 .or.numdec.eq.12 .or.
     +                          numdec.eq.15 .or. numdec.eq.16) then
                           write (ytitle,'(a,i3)') '- Loading', iycol
                           do i = 1, nvar
                              w3(i) = - w3(i)
                           enddo
                        elseif (numdec.eq.9 .or. numdec.eq.10 .or.
     +                          numdec.eq.13 .or. numdec.eq.14) then
                           write (ytitle,'(a,i3)') 'Loading', iycol
                        endif
                        if (numdec.eq.numopt) then
c
c ...end 2D plotting
c
                           again = .false.
                        elseif (numdec.eq.numopt - 1) then
c
c ...ellipse yes/no
c
                           again = .true.
                           ellips = .not.ellips
                        elseif (numdec.eq.numopt - 2) then
c
c ...significance level
c
                           again = .true.
                           call getdm1 (sigmin, siglev, sigmax,
     +'significance level (e.g. 0.05 for 95% confidence region)')
                        elseif (numdec.le.4) then
                           again = .true.
                           call gks004 (n0, n1, n0, n0,
     +                                  n5, n0, n0, n0,
     +                                  ntotal, nplot, n0, n0,
     +                                  w2, xgraf1, xgraf2, xgraf2,
     +                                  w3, ygraf1, ygraf2, ygraf2,
     +                                  ptitle, xtitle, ytitle,
     +                                  axes, gsave)
                        elseif (numdec.le.8) then
c
c get row labels
c                        
                           again = .true.
                           store = .false.
                           call savwrd (nrow,
     +                                  wordx,
     +                                  store)
                           if (wtd) then
                              ntotal = 0
                              do i = 1, nrow
                                 if (w1(i).gt.zero) then
                                    ntotal = ntotal + 1
                                    wordx(ntotal) = wordx(i)
                                 endif
                              enddo  
                           else
                              ntotal = nrow    
                           endif
                           call pca002 (ngraf1, ntotal,
     +                                  xgraf1, ygraf1, w1, w2, w3,
     +                                  ptitle, wordx, xtitle,
     +                                  ytitle,
     +                                  ellips, wtd)
                        elseif (numdec.le.12) then
                           again = .true.
                           call gks004 (n0, n0, n0, n0,
     +                                  n5, n0, n0, n0,
     +                                  nvar, n0, n0, n0,
     +                                  w2, xgraf1, xgraf2, xgraf2,
     +                                  w3, ygraf1, ygraf2, ygraf2,
     +                                  ptitle, xtitle, ytitle,
     +                                  axes, gsave)
                        elseif (numdec.le.16) then
c
c get column labels
c                        
                           again = .true.
                           store = .false.
                           call savwrd (nlabel,
     +                                  wordx,
     +                                  store)
                           k = 0
                           do i = 1, ncol
                              if (isx(i).gt.0) then
                                 k = k + 1
                                 wordx(k) = wordx(nrow + i)
                              endif
                           enddo
                           call pca002 (ngraf1, nvar,
     +                                  xgraf1, ygraf1, w1, w2, w3,
     +                                  ptitle, wordx, xtitle,
     +                                  ytitle,
     +                                  yesno, yesno)
                        endif
                        if (nptype.eq.1) again = .false.
                     enddo
c
c end of 2D plotting.....................................................
c
                  elseif (nptype.le.4) then
c
c start of 3-D plotting...................................................
c
                     again = .true.
                     do while (again)
                        numopt = 9
                        if (nptype.eq.3) then
                           numdec = 1
                           ixcol = 1
                           iycol = 2
                           izcol = 3
                        else
                           write (text,1100)
                           numdec = 1
                           call lbox02 (icolor, ix, iy, numdec, numopt,
     +                                  numpos,
     +                                  text)
                           if (numdec.lt.numopt) then
                              i = 1
                              call getjm1 (i, ixcol, nvar,
     +                                    'Scores to be plotted as x')
                              call getjm1 (i, iycol, nvar,
     +                                    'Scores to be plotted as y')
                              call getjm1 (i, izcol, nvar,
     +                                    'Scores to be plotted as z')
                           endif
                        endif
c
c Load the scores into w2, w3 and b then transform if required
c
                        if (numdec.lt.numopt) then
                           if (wtd) then
                              ntotal = 0
                              do i = 1, nrow
                                 if(w1(i).gt.zero) then
                                    ntotal = ntotal + 1
                                    w2(ntotal) = v(i,ixcol)
                                    w3(ntotal) = v(i,iycol)
                                    b(ntotal) = v(i,izcol)
                                 endif
                              enddo
                           else
                              ntotal = nrow
                              do i = 1, ntotal
                                 w2(i) = v(i,ixcol)
                                 w3(i) = v(i,iycol)
                                 b(i) = v(i,izcol)
                              enddo
                           endif
                        endif
                        if (numdec.eq.2 .or. numdec.eq.4 .or.
     +                      numdec.eq.6 .or. numdec.eq.8) then
                           do i = 1, ntotal
                              w2(i) = - w2(i)
                           enddo
                        endif
                        if (numdec.eq.3 .or. numdec.eq.4 .or.
     +                      numdec.eq.7 .or. numdec.eq.8) then
                           do i = 1, ntotal
                              w3(i) = - w3(i)
                           enddo
                        endif
                        if (numdec.gt.4 .and. numdec.lt.numopt) then
                           do i = 1, ntotal
                              b(i) = - b(i)
                           enddo
                        endif
                        if (numdec.eq.numopt) then
                           again = .false.
                        else
                           call space5 (ntotal, nrmax,
     +                                  w2, w(1), w3, w(nrmax + 1), b)
                        endif
                        if (nptype.eq.3) again = .false.
                     enddo
c
c end of 3D plotting..................................................
c
                  elseif (nptype.eq.5) then
c
c comprehensive scores
c
                     isend = 4
                     call matplt (isend, nvar, nvar, nout, ldv, n,
     +                            v)
                  elseif (nptype.eq.6) then
c
c comprehensive loadings
c
                     isend = 4
                     call matplt (isend, nvar, nvar, nout, ldp, nvar,
     +                            p)
                  elseif (nptype.eq.numopt - 1) then
c
c start of scree diagram plotting.....................................
c
                     thresh = zero
                     do i = 1, nvar
                        thresh = thresh + e(i,1)
                     enddo
                     thresh = thresh/dble(nvar)
                     do i = 1, nvar
                        w2(i) = dble(i)
                        w3(i) = e(i,1)
                     enddo
                     xgraf1(1) = one
                     xgraf1(2) = dble(nvar)
                     ygraf1(1) = thresh
                     ygraf1(2) = thresh
                     if (e_numbers) then
                        write (ptitle,'(a,1p,e10.2)')
     +                 'Average eigenvalue =', thresh
                     else
                        word10 = formgr(thresh)
                         write (ptitle,'(a,a)')
     +                 'Average eigenvalue =', word10
                     endif
                     xtitle = 'Number'
                     write (ytitle,'(a,1pe10.2)')
                     ytitle = 'Eigenvalues and Average'
                     call gks004 (n1, n2, n0, n0,
     +                            n5, n0, n0, n0,
     +                            nvar, n2, n0, n0,
     +                            w2, xgraf1, xgraf2, xgraf2,
     +                            w3, ygraf1, ygraf2, ygraf2,
     +                            ptitle, xtitle, ytitle,
     +                            axes, gsave)
c
c end of scree diagram plotting
c
                  elseif (nptype.eq.numopt) then
c
c option to close down plotting loop has been selected
c
                      plotit = .false.
                  endif
                  nptype = 1
c
c end of main plotting loop---------------------------------------------
c
               enddo
               numdec = 8
            endif
         elseif (numdec.eq.11) then
c
c numdec = 11: copy the loadings to a temporary file then rotate loadings
c ===========
c
            call gettmp (isend,
     +                   filex)
            open (unit = nin, file = filex, iostat = ios)
            if (ios.eq.0) write (nin,'(a)',iostat=ios) 'Loadings'
            if (ios.eq.0) write (nin,'(2i8)',iostat=ios) nvar, nvar
            do i = 1, nvar
               if (ios.eq.0) write (nin,'(1p,50e13.5)',iostat=ios)
     +                             (p(i,j), j = 1, nvar)
            enddo
            close (unit = nin)
            if (ios.eq.0) then
               ierr = 0
               
               if (allocated(r)) deallocate(r, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(y)) deallocate(y, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(yhat)) deallocate(yhat, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(wrk)) deallocate(wrk, stat = ierr)
               if (ierr.ne.0) return   
c
c The data are read in from a temporary file holding the loadings so it is best to dimension
c using nvar = nrmax and nvar = ncmax which is what orotat anticipates for the square matrix
c r when it is read in. 
c
               allocate(r(nvar,nvar), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nvar,nvar), stat = ierr)
               if (ierr.ne.0) return
               allocate(yhat(nvar,nvar), stat = ierr)
               if (ierr.ne.0) return
               allocate(wrk(2*nvar + nvar*nvar + 5*(nvar - 1)),
     +                  stat = ierr)
               
               isend = 2
               call orotat (isend, nvar, nin, nout, nvar,
     +                      r, w, y, yhat,
     +                      filex,
     +                      abort)
                deallocate(r, stat = ierr)
                deallocate(y, stat = ierr)
                deallocate(yhat, stat = ierr)
                deallocate(wrk, stat = ierr)
             else
                call putadv ('Failure to rotate loadings')
             endif
             call deleet (filex,
     +                    askif, there)
         elseif (numdec.eq.12) then
c
c numdec = 12: select to suppress/restore variables
c ============
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
         elseif (numdec.eq.13) then
c
c numdec = 13: select to install/edit a weighting vector
c ============
c
            ok = .false.
            isend = 3
            call pcawts (isend, nin, nptrow, nptcol, nrow, ncol, nrmax,
     +                   w1, s, b)
            numdec = 2
         elseif (numdec.eq.14) then
c
c numdec = 14: install labels
c ============
c
            if (nrow.gt.nwmax) then
               call putadv (too_many)
            else     
               isend = 1
               call getlbl (isend, nrow,
     +                      wordx,
     +                      ffiles)
               store = .true.
               call savwrd (nrow,
     +                      wordx,
     +                      store)
            endif
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: review progress
c ====================
c
            call revpro (nout)
            numdec = 2
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
             write (text,1200)
             ntext = 21
             numbld(1) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             write (text,1300)
             ntext = 21
             next = .true.
             numbld(1) = 1
             numbld(6) = 1
             numbld(13) = 1
             numbld(19) = 1
             call tutor1 (icolor, numbld, ntext, 
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(6) = 0
             numbld(13) = 0
             numbld(19) = 0
             next = .false.
             write (text,1400)
             ntext = 21
             numbld(1) = 1
             numbld(6) = 1
             numbld(10) = 1
             numbld(19) = 1
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(6) = 0
             numbld(10) = 0
             numbld(19) = 0
             numdec = 2
         
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c store isx then deallocate workspaces
c
      do i = 1, min(ncmax,nvmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(e, stat = ierr)
      deallocate(p, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(w2, stat = ierr)
      deallocate(w3, stat = ierr)
      deallocate(wordx, stat = ierr)
      deallocate(xgraf1, stat = ierr)
      deallocate(xgraf2, stat = ierr)
      deallocate(ygraf1, stat = ierr)
      deallocate(ygraf2, stat = ierr)
c
c format statements
c
  100 format (
     + ' Title for current principal components data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Additional run-time transform:',1X,A
     +/' Matrix type:',1X,A
     +/' Score type:',1X,A
     +/' Replicates:',1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Change: transformation'
     +/'Change: matrix type'
     +/'Change: score type'
     +/'Change: replicate type'
     +/'View/File eigenvalue analysis'
     +/'View/Print/Save: loadings'
     +/'View/Print/Save: scores'
     +/'Plot scores/loadings/scree-diagram'
     +/'Rotate/Plot loading matrix'
     +/'Suppress/Restore variables'
     +/'Install/edit: weighting/scaling vectors'
     +/'Install/Edit: plot labels'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit principal components analysis')
  200 format (
     + 'Additional run-time data transformation'
     +/
     +/'In addition to any transformations that have been applied'
     +/'to the data before it was submitted to this routine for'
     +/'analysis, additional run-time transformations can be done'
     +/'but are seldom required. For instance, if a correlation'
     +/'matrix type is chosen there is no need to center and scale'
     +/'data as that will be done by the routine in any case.'
     +/
     +/'None'
     +/'Square root'
     +/'Fourth root'
     +/'Log(x)'
     +/'Log(1 + x)'
     +/'Normalised to mean = 0, st.dev. = 1')
  300 format (
     + 'Correlation matrix'
     +/'Scaled SSQ/cross-products matrix'
     +/'SSQ/cross-products matrix'
     +/'Variance-covariance matrix')
  400 format (
     + 'Standardised scores'
     +/'Unstandardised scores'
     +/'Unit variance scores'
     +/'Score variance = eigenvalue')
  500 format (
     + 'Unweighted for replicates'
     +/'Weighted for replicates')
  600 format (
     + ' Title for current principal components analysis data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Additional run-time transform:',1X,A
     +/' Matrix type:',1X,A
     +/' Score type:',1X,A
     +/' Replicates:',1X,A
     +/'  Eigenvalues Proportion Cumulative        chi-sq   DOF   p')
  700 format (1p,e13.5,0p,2f11.4,1p,1x,e13.3,i6,0p,'   *not valid')
  725 format (a13,2f11.4,1x,a13,i6,'   *not valid')
  750 format (1p,e13.5,0p,2f11.4,1p,1x,e13.3,i6,0p,f8.4)
  775 format (e13.5,2f11.4,1x,e13.3,i6,f8.4)
  800 format (1p,10(1x,e13.5))
  825 format (10(1x,a13))
  850 format (1p,10(1x,e13.5))
  875 format (10(1x,a13))
  900 format (
     + 'Simple 2D: scores 1 and 2'
     +/'Simple 2D: selected scores/loadings'
     +/'Simple 3D: scores: 1, 2, and 3'
     +/'Simple 3D: selected scores'
     +/'Advanced analysis: scores'
     +/'Advanced analysis: loadings'
     +/'Eigenvalue Scree Diagram'
     +/'Quit ... Exit these plotting options')
 1000 format (
     + 'Plotting selected scores and loadings'
     +/
     +/'You have to decide whether to plot symbols or labels,'
     +/'and also the index of the components to be plotted'
     +/'together with the orientation and reflection if any.'
     +/'Cross lines intersecting at (0,0) can then be added.'
     +/'Also, if required, a confidence ellipse can be added'
     +/'to be plotted at a chosen significance level'
     +/
     +/'Current significance level =',f6.3 
     +/'Add a confidence region',1x,a
     +/
     +/'Plot: Scores as symbols'
     +/'Plot: Scores as labels'
     +/'Plot: Loadings as symbols'
     +/'Plot: Loadings as labels'
     +/'Change: significance level'
     +/'Change: confidence region plotting'
     +/'Quit ... Exit these plotting options')
c 1000 format (
c     + 'Scores as symbols: (x, y)'
c     +/'Scores as symbols: (-x, y)'
c     +/'Scores as symbols: (x, -y)'
c     +/'Scores as symbols: (-x, -y)'
c     +/'Scores as labels: [x, y]'
c     +/'Scores as labels: [-x, y]'
c     +/'Scores as labels: [x, -y]'
c     +/'Scores as labels: [-x, -y]'
c     +/'Loadings as symbols: (x, y)'
c     +/'Loadings as symbols: (-x, y)'
c     +/'Loadings as symbols: (x, -y)'
c     +/'Loadings as symbols: (-x, -y)'
c     +/'Loadings as labels: [x, y]'
c     +/'Loadings as labels: [-x, y]'
c     +/'Loadings as labels: [x, -y]'
c     +/'Loadings as labels: [-x, -y]'
c     +/'Change sig. level. (current = ',f6.3,')'
c     +/'Plot conf. region',1x,a
c     +/'Quit ... Exit these plotting options')     
 1100 format (
     + 'x, y, z'
     +/'-x, y, z'
     +/'x, -y, z'
     +/'-x, -y, z'
     +/'x, y, -z'
     +/'-x, y, -z'
     +/'x, -y, -z'
     +/'-x, -y, -z'
     +/'Quit ... Exit these options')
 1200 format (
     + 'Overview of principal components analysis'
     +/'It is supposed that m variables have been measured for n cases'
     +/'and the data have been formatted as a matrix file with n rows'
     +/'(n > 1) and m columns (m > 1), e.g. using program MAKMAT.'
     +/'You select variables (columns) to include/exclude then a SVD is'
     +/'done to calculate eigenvalues, coefficient loadings and scores.'
     +/'Note that the sign of all such singular vectors is arbitrary.'
     +/'This analysis generates a linear transformation that projects'
     +/'the original m variables into an orthogonal m-dimensional sub-'
     +/'space by calculating a m by m matrix of coefficients together'
     +/'with an n by m matrix of scores, being the transforms of the'
     +/'original n variables. The extent to which the components in'
     +/'some sense capture the variance of the original data in a k-'
     +/'dimensional sub-space (k < m) can be seen by plotting a scree'
     +/'diagram and observing the elbow, or where the eigenvalues fall'
     +/'below the average value. Pricipal components are not unique, as'
     +/'they depend on the matrix used for the SVD, but note that, as'
     +/'long as the correlation matrix is not used, the choice of k can'
     +/'be made more objective by a chi-square test for the need to'
     +/'retain components of order > k. The scores can be examined by'
     +/'plotting 2D or 3D scattergrams.')
 1300 format (
     + 'Transformation'
     +/'Sometimes transformations are used before the SVD is done, but'
     +/'this is not necessary as the data can be scaled automatically'
     +/'and less ambigously by choosing the matrix to analyse or, if'
     +/'required, by applying various scaling procedures.'
     +/'The matrix'
     +/'Since the aim is to capture as much of the variance as possible'
     +/'in the smallest number of sub-dimensions it is usual to analyse'
     +/'either the sum-of-squares-and-cross-products or the variance-'
     +/'covariance matrix. If scaling is needed the correlation matrix'
     +/'can be calculated instead, or a scaling vector can be provided'
     +/'to scale the sum-of-squares-and-cross-products matrix.'
     +/'Standardised scores'
     +/'Various methods are available for standardising the scores but'
     +/'the main thing is to be consistent in the choice of matrix and'
     +/'standardisation used, so that results can be interpreted in a'
     +/'meaningful way. For that reason the sign of the scores can be'
     +/'chosen in scattergrams, which can have symbols or labels.'
     +/'Replicates'
     +/'You can install a replicates vector r, where r(i) is the number'
     +/'of replicates (e.g. 1, 2, 3...) to assume for case(i).')
 1400 format (
     + 'Plotting scores and loadings'
     +/'The default option is simply to plot the first two scores, but'
     +/'advanced options are provided to plot the principal components'
     +/'in several alternative formats with extra features. The loading'
     +/'matrix can also be plotted after Quartimax or Varimax rotation.'
     +/'Reversing the direction of scores and loading vectors'
     +/'The sign of related pairs of scores and loadings are arbitrary,'
     +/'so you can change signs as required. For instance, the symbol'
     +/'(-x,y) in the menus will reverse the direction of the x-axis.'
     +/'Plotting labels'
     +/'You can plot the scores and loadings as simple symbols, or as'
     +/'labelled symbols, using labels supplied on the data file (as in'
     +/'test file cluster.tf1), although such plots tend to become very'
     +/'crowded with large data sets. If row and column labels are not'
     +/'supplied, then default integer labels will be generated. Note'
     +/'that from advanced 2D plots, labels can be edited interactively'
     +/'but, for more permanent editing, it is possible to install a' 
     +/'labels file (formatted like labels.tf1) to over-ride defaults.'
     +/'Hotelling T-squared confidence regions'
     +/'Elliptical confidence regions can be added to score plots using'
     +/'F values with significance levels you can adjust if necessary.')
      end
c
c

