c
c
      subroutine pca002 (m, n,
     +                   ellx, elly, w, x, y,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips, weight)
c
c action: plot a principal components label type file
c author: w.g.bardsley, university of manchester, U.K, 11/08/2001
c         04/11/2006 extensive editing and introduced intents
c         25/12/2007 added nwmax and f$rotate.tmp labels file
c         20/12/2011 corrected files to len = 1024
c
c      m: (input/unchanged) ellipse dimension
c      n: (input/unchanged) data dimension
c   ellx: (input/unchanged) ellipse coordinates
c   elly: (input/unchanged) ellipse coordinates
c      w: (input/unchanged) weights
c      x: (input/unchanged) data coordinates
c      y: (input/unchanged) data coordinates
c ptitle: (input/unchanged) plot title
c  wordx: (input/unchanged) plot labels
c xtitle: (input/unchanged) x-legend
c ytitle: (input/unchanged) y-legend
c ellips: (input/unchanged) if .true. then plot an ellipse
c weight: (input/unchanged) if .true. then use weights  
c
c         nmax = maximum number of data files to plot
c
      implicit   none
c
c arguments
c      
      integer,             intent (in) :: m, n
      double precision,    intent (in) :: ellx(m), elly(m), w(n), x(n),
     +                                    y(n)
      character (len = *), intent (in) :: ptitle, wordx(n), xtitle,
     +                                    ytitle
      logical,             intent (in) :: ellips, weight
c
c locals
c      
      integer    i
      integer    ifail, nout, ntotal
      integer    nmax, nwmax, n0, n1, n2, n5
      parameter (nmax = 2, nwmax = 2000, n0 = 0, n1 = 1, n2 = 2, n5 = 5)
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      double precision zero
      parameter (zero = 0.0d+00) 
      character  fname*1024, sim256*1024
      character  filex*1024, filey*1024, labfil*12, rotate*12, title*80 
c                                                   
c-----------------------------------------------------------------
c labfil and rotate must not be edited as they are used by simplot
c      
      parameter (labfil = 'f$labels.tmp',
     +           rotate = 'f$rotate.tmp')           
c------------------------------------------------------------------      
      character  files(nmax)*1024, titles(4)*80
      logical    askif, there
      parameter (askif = .false.)
      external   getnou, gettmp, deleet, putfat, sim256
      external   smplot
      data       jfiles, lfiles, mfiles
     +         / nmax*0, nmax*0, nmax*1 /
c
c calculate ntotal
c
      if (weight) then
         ntotal = 0
         do i = 1, n
            if (w(i).gt.zero) ntotal = ntotal + 1
         enddo
      else
         ntotal = n
      endif
c
c check if user has requested too many labels
c      
      if (ntotal.gt.nwmax) then
         call putfat ('Too many labels to plot ... maximum = 2000')
         return
      endif   
c
c Open a temporary file and connect to a temporary unit
c
      call gettmp (ifail, 
     +             filex)
      call getnou (nout)
      open (unit = nout, file = filex)
c
c The file title identifies the file type to simplot
c THE NEXT LINE MUST NOT BE TRANSLATED
c *************************************
c
      write (title,100) '%simfitplotlabelsfile%'
      write (nout,100) title
      write (nout,200) ntotal, n2
      if (weight) then
         ntotal = 0
         do i = 1, n
            if (w(i).gt.zero) then
               ntotal = ntotal + 1
               write (nout,300) x(ntotal), y(ntotal)
            endif
         enddo
      else
         do i = 1, ntotal
            write (nout,300) x(i), y(i)
         enddo
      endif
      write (nout,400) n1
      write (nout,100) 'Default Line'
      close (unit = nout)
c
c create the rotate labels file
c
      fname = sim256(rotate)
      call deleet (fname,
     +             askif, there)
      if (there) then
         call putfat ('You must attrib -r f$rotate.tmp then delete')
      else   
         open (unit = nout, file = fname)
c
c The file title identifies the file type to simplot
c THE NEXT LINE MUST NOT BE TRANSLATED
c *************************************
c
         write (title,100) '%simfitrotatelabelsfile%'
         write (nout,100) title
         write (nout,200) ntotal, n5
         if (weight) then
            ntotal = 0
            do i = 1, n
               if (w(i).gt.zero) then
                  ntotal = ntotal + 1
                  write (nout,500) x(ntotal), zero, y(ntotal), zero,
     +                             zero
               endif
            enddo
         else
            do i = 1, ntotal
               write (nout,500) x(i), zero, y(i), zero, zero
            enddo
         endif
         write (nout,400) n1
         write (nout,100) 'Default Line'
         close (unit = nout)
      endif      
c
c Create the actual labels file
c                          
      fname = sim256(labfil)
      call deleet (fname,
     +             askif, there)
      if (there) then
         call putfat ('You must attrib -r f$labels.tmp then delete')
      else
         open (unit = nout, file = fname)
         if (weight) then
            do i = 1, n
               if (w(i).gt.zero) write (nout,100) wordx(i)
            enddo
         else
            do i = 1, ntotal
               write (nout,100) wordx(i)
            enddo
         endif
         close (unit = nout)
      endif
      nfiles = n1
      files(nfiles) = filex
      if (ellips) then
c
c Open a temporary file and connect to a temporary unit
c
         call gettmp (ifail,
     +                filey)
         call getnou (nout)
         open (unit = nout, file = filey)
         write (title,100) 'ellipse data'
         write (nout,100) title
         write (nout,200) m, n2
         do i = 1, m
            write (nout,300) ellx(i), elly(i)
         enddo
         write (nout,400) n1
         write (nout,100) 'Default Line'
         close (unit = nout)
         nfiles = nfiles + n1
         files(nfiles) = filey
         lfiles(nfiles) = n1
         mfiles(nfiles) = n0
      endif
      titles(1) = ptitle
      titles(2) = xtitle
      titles(3) = ytitle
      titles(4) = ' '
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      call deleet (filex,
     +             askif, there)
      if (ellips) call deleet (filey,
     +                         askif, there)
c
c format statements
c     
  100 format (a)
  200 format (2i6)
  300 format (1p,2e13.5)
  400 format (i3)
  500 format (1p,5e13.5)
      end
c
c
