c
c
      subroutine pcaplt (nmax, nx, ny,
     +                   x_factor, y_factor)
c
c action: manipulate multivariate plotting parameters
c author: w.g.bardsley, university of manchester, u.k., 15/07/2016
c  
c     nmax = maximum index
c     1 =< nx =< nmax ... index to plot as X
c     1 =< ny =< nmax ... index to plot as Y
c     x_factor = +/-1 ... multiplies X
c     y_factor = +/-1 ... multiplies Y
c   
      integer,          intent (in)    :: nmax
      integer,          intent (inout) :: nx, ny
      double precision, intent (inout) :: x_factor, y_factor
c
c locals
c       
      integer    nmin
      parameter (nmin = 1)
      integer    icolor, ixl, iyl, lshade, numopt, nstart, ntext
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, 
     +           numopt = 4, nstart = 15, ntext = nstart + numopt - 1)
      integer    ix_value, iy_value, kvalue(numopt), numbld(ntext),
     +           numpos(numopt) 
      double precision xvalue(numopt)
      double precision one
      parameter (one = 1.0d+00)
      character (len = 100) text(ntext)
      character (len = 12 ) form12, word1, word2
      character (len = 10 ) wordx, wordy
      character (len = 1  ) blank, svalue(numopt)
      parameter (blank = ' ')
      logical    repeet
      logical    tab_bot, tab_mid, tab_top      
      parameter (tab_bot = .false., tab_mid = .false., tab_top = .true.)
      external   get00n, form12, putadv, putwar
      intrinsic  nint
      data numbld / ntext*0 /
      data numpos / 1, 1, 4, 4 /
      data svalue / numopt*blank /
      data xvalue / numopt*0.0d+00 /
c
c check input
c      
      if (nmax.lt.1) then
         call putwar ('NMAX < 1 in call to PCAPLT')
         return
      endif   
      ix_value = nint(x_factor)
      iy_value = nint(y_factor)
      if (ix_value.ne.-1 .and. ix_value.ne.1) then
         call putwar ('X_factor must be -1 or 1 in call to PCAPLT')    
         return
      elseif (iy_value.ne.-1 .and. iy_value.ne.1) then
         call putwar ('Y_factor must be -1 or 1 in call to PCAPLT')    
         return
      endif
c
c define starting values
c      
      kvalue(1) = nx
      kvalue(2) = ny
      kvalue(3) = -ix_value
      kvalue(4) = -iy_value
      word1 = form12(nmin)
      word2 = form12(nmax)
c
c loop to make sure all values are declared properly
c
      repeet =.true.
      do while (repeet)
         if (kvalue(3).eq.1) then
            wordx = 'reversed'
         else
            wordx = 'normal'
         endif  
         if (kvalue(4).eq.1) then
            wordy = 'reversed'
         else
            wordy = 'normal'
         endif         
         write (text,100) word1, word2, wordx, wordy 
         numbld(1) = 4
         numbld(10) = 1
         numbld(11) = 1
         numbld(12) = 1
         numbld(13) = 1
         kvalue(1) = nx
         kvalue(2) = ny
         
         CALL GET00N (ICOLOR, IXL, IYL, KVALUE, LSHADE, NUMBLD,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                XVALUE,
     +                SVALUE, TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
     
         repeet = .false.
         if (kvalue(1).lt.nmin .or. kvalue(1).gt.nmax) then
             call putadv ('X index out of range')
             repeet = .true.
         elseif (kvalue(2).lt.nmin .or. kvalue(2).gt.nmax) then 
             call putadv ('Y index out of range')
             repeet = .true.   
         else    
            nx = kvalue(1)
            ny = kvalue(2)
            if (kvalue(3).eq.0) then
               x_factor = one
            else   
               x_factor = -one
            endif 
            if (kvalue(4).eq.0) then
               y_factor = one
            else   
               y_factor = -one
            endif
         endif   
      enddo     
c
c format statement 
c  
  100 format (
     + 'Options for plotting loadings and scores'
     +/ 
     +/'You have to choose which items to plot along the X, Y axes,'
     +/'and the direction of these axes can be reversed by plotting'
     +/'the selected items with opposite signs. This can be useful in'
     +/'order to control the orientation when plotting eigenvectors'
     +/'such as principal component scores, since these are only'
     +/'determined up to an arbitrary scalar factor, e.g., +/- 1.'
     +/
     +/'Minimum index:',1x,a
     +/'Maximum index:',1x,a 
     +/'X-axis orientation:',1x,a
     +/'Y-axis orientation:',1x,a
     +/     
     +/'Index of the item to plot horizontally (i.e. as X)'
     +/'Index of the item to plot vertically (i.e. as Y)'
     +/'Reflect the X-axis (i.e., plot -x instead of x)'
     +/'Reflect the Y-axis (i.e., plot -y instead of y)')
      end
c
c      