c
c
      subroutine pcatrn (isend, isx, itype, ncol, nrmax, nrow,
     +                   a, r, s, x,
     +                   abort, wtd)
c
c action: check or transform data before multivariate analysis
c author: w.g.bardsley, university of manchester, u.k., 24/10/2002
c         11/07/2004 revised to allow isend = 3 and store means and std. devs.
c         04/11/2006 added intents
c         08/01/2022 this code was omitting transformations with isx(j) = 0 but this seems to
c                    be unneccesary and causes problems with g03aaf which requires the whole
c                    matrix then uses isx internally and all the g03 routines probably behave
c                    in the same way so the loops involving if(isx.gt.0) have had this restriction
c                    removed, e.g. 158/180, 208/307, and 320/352 using c**************   
c
c         isend: (input/unchanged) as follows:
c                 isend = 1: check data supplied in a, x not referenced
c                 isend = 2: transform primary data from a to x
c                 isend = 3: transform secondary data from a to x
c           isx: (input/unchanged) as follows:
c                 isx = 0 to omit,
c                 isx = 1 to include a variable
c         itype: (input/unchanged) as follows:
c                 itype = 1, untransformed
c                 itype = 2, square root
c                 itype = 3, fourth root
c                 itype = 4, log
c                 itype = 5, log(1 + x)
c                 itype = 6, mean = 0, std. dev = 1
c                 itype = 7, x = x/s
c          ncol: (input/unchanged) no. columns
c         nrmax: (input/unchanged) leading dimension of a, x
c          nrow: (input/unchanged) no. rows
c             a: (input/unchanged) data .... returned unchanged
c             r: (input/unchanged) replicate weights >= 0
c             s: (input/unchanged) scaling weights > 0
c             x: (input/output) transformed data (but only if isend = 2 or 3)
c         abort: (output) .false. if successful, = .true. if failure
c           wtd: (input/unchanged) .false. = not use r, .true. then use r
c
c Note: arguments must be the same when called for isend = 2 after
c       checking with isend = 1 and isend = 3 after isend = 2. However,
c       checking for possible transformation to 0,1 is only done when
c       isend = 2 and itype = 6
c       x is only returned as follows:-
c       isend = 1: x is not returned
c       isend = 2: x is returned but, if weight = .true., then data are
c                  only checked/transformed where r > 0
c       isend = 3: is for transforming new variables in discriminant
c                  analysis or cluster centroids prior to K-means clustering.
c                  In this case variables that cannot be transformed are
c                  just left alone.
c
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: ncol, nrmax, nrow
      integer,          intent (in)    :: isend, isx(ncol), itype
      double precision, intent (in)    :: a(nrmax,ncol), r(nrow),
     +                                    s(ncol)
      double precision, intent (inout) :: x(nrmax,ncol)
      logical,          intent (in)    :: wtd  
      logical,          intent (out)   :: abort
c
c locals
c
      integer    i, j, k, ntotal, nvar
      integer    ncmax
      parameter (ncmax = 100)
      double precision dn, dnm1, refval, sigma, xbar, xvar
      double precision sisav(ncmax), xbsav(ncmax)
      double precision zero, one, pnt25, rtol
      parameter (zero = 0.0d+00, one = 1.0d+00, pnt25 = 0.25d+00)
      double precision x02amf$
      character  line*100
      save       sisav, xbsav
      external   putfat, x02amf$
      intrinsic  dble, sqrt, log
      data       xbsav / ncmax*zero /
      data       sisav / ncmax*one /
c
c initialise and check
c
      abort = .false.
      if (isend.lt.1 .or. isend.gt.3) then
         write (line,100)
         call putfat (line)
         abort = .true.
         return
      endif
      if (itype.lt.1 .or. itype.gt.7) then
         write (line,200)
         call putfat (line)
         abort = .true.
         return
      endif
      nvar = 0
      do i = 1, ncol
         if (isx(i).gt.0) nvar = nvar + 1
      enddo
      if (nvar.lt.1) then
         write (line,300)
         call putfat (line)
         abort = .true.
         return
      endif
c
c define rtol and refval
c
      rtol = 1.0d+09*x02amf$()
      if (itype.eq.4) then
         refval = rtol
      elseif (itype.eq.5) then
         refval = rtol - one
      else
         refval = zero
      endif
      if (isend.eq.1) then
c
c isend = 1: just check to see if transformation requested is going to be ok
c ==========
c
         if (wtd) then
            ntotal = 0
            do i = 1, nrow
               if (r(i).gt.zero) ntotal = ntotal + 1
            enddo
         else
            ntotal = nrow
         endif
         if (ntotal.lt.2) then
            write (line,400)
           call putfat (line)
            abort = .true.
            return
         endif
         if (itype.eq.1 .or. itype.eq.6) then
c
c itype = 1, or 6 not checked any further
c
            return
         elseif (itype.eq.7) then
c
c itype = 7 checked for s positive
c
            do i = 1, ncol
               if (isx(i).gt.0 .and. s(i).le.rtol) then
                  write (line,500)
                  call putfat (line)
                  abort = .true.
                  return
               endif
             enddo
             return
         endif
c
c itype = 2,3,4 or 5 so loop over a(i,j)
c
         do j = 1, ncol
c************if (isx(j).gt.0) then
               if (wtd) then
                  do i = 1, nrow
                     if (r(i).gt.zero) then
                        if (a(i,j).lt.refval) then
                           write (line,600)
                           call putfat (line)
                           abort = .true.
                           return
                        endif
                     endif
                  enddo
               else
                  do i = 1, nrow
                     if (a(i,j).lt.refval) then
                        write (line,600)
                        call putfat (line)
                        abort = .true.
                        return
                     endif
                  enddo
               endif
c***********endif
         enddo
      elseif (isend.eq.2) then
c
c isend = 2: return x = a (transformed if possible)
c ==========
c
         k = itype
         abort = .false.
         if (k.eq.6) then
c
c calculate ntotal
c
            if (wtd) then
               ntotal = 0
               do i = 1, nrow
                  if (r(i).gt.zero) ntotal = ntotal + 1
               enddo
            else
               ntotal = nrow
            endif
            dn = dble(ntotal)
            dnm1 = dn - one
         endif
c
c loop over all a(i,j) and transform to x(i,j) if possible/requested
c
         do j = 1, ncol
c***********if (isx(j).gt.0) then
c
c deal collectively with all cases except itype = 6
c
               if (k.ne.6) then
                  if (wtd) then
                     do i = 1, nrow
                        if (r(i).gt.zero) then
                           if (k.eq.1) then
c...unscaled
                              x(i,j) = a(i,j)
                           elseif (k.eq.2) then
c...sqrt
                              x(i,j) = sqrt(a(i,j))
                           elseif (k.eq.3) then
c...4'th root
                              x(i,j) = a(i,j)**pnt25
                           elseif (k.eq.4) then
c...log
                              x(i,j) = log(a(i,j))
                           elseif (k.eq.5) then
c...log(1 + x)
                              x(i,j) = log(one + a(i,j))
                           elseif (k.eq.7) then
c...x/s
                              x(i,j) = a(i,j)/s(j)
                           endif
                        endif
                     enddo
                  else
                     do i = 1, nrow
                        if (k.eq.1) then
c...unscaled
                           x(i,j) = a(i,j)
                        elseif (k.eq.2) then
c...sqrt
                           x(i,j) = sqrt(a(i,j))
                        elseif (k.eq.3) then
c...4'th root
                           x(i,j) = a(i,j)**pnt25
                        elseif (k.eq.4) then
c...log
                           x(i,j) = log(a(i,j))
                        elseif (k.eq.5) then
c...log(1 + x)
                           x(i,j) = log(one + a(i,j))
                        elseif (k.eq.7) then
c...x/s
                           x(i,j) = a(i,j)/s(j)
                        endif
                     enddo
                  endif
               else
c
c deal with the case itype = 6, normalise to (0,1)
c
                  xbar = zero
                  if (wtd) then
                     do i = 1, nrow
                        if (r(i).gt.zero) xbar = xbar + a(i,j)
                     enddo
                  else
                     do i = 1, nrow
                        xbar = xbar + a(i,j)
                     enddo
                  endif
                  xbar = xbar/dn
                  xvar = zero
                  if (wtd) then
                     do i = 1, nrow
                        if (r(i).gt.zero)
     +                  xvar = xvar + (a(i,j) - xbar)**2
                     enddo
                  else
                     do i = 1, nrow
                        xvar = xvar + (a(i,j) - xbar)**2
                     enddo
                  endif
                  if (xvar.le.rtol) then
c
c if failure set abort  = .true.
c
                     abort = .true.
                     write (line,700)
                     call putfat (line)
                     return
                  else
                     xvar = xvar/dnm1
                     sigma = sqrt(xvar)
                     do i = 1, nrow
                        x(i,j) = (a(i,j) - xbar)/sigma
                     enddo
c
c store xbar and sigma
c
                     xbsav(j) = xbar
                     sisav(j) = sigma
                  endif
               endif
c**********endif
         enddo
      elseif (isend.eq.3) then
c
c isend = 3: return x = a (transformed if possible)
c ==========
c
         k = itype
         abort = .false.
c
c loop over all a(i,j) and transform to x(i,j) if possible/requested
c
         do j = 1, ncol
c***********if (isx(j).gt.0) then
               do i = 1, nrow
c
c assign a to x in case k = 1 or transformation is impossible
c
                  x(i,j) = a(i,j)
c
c deal with cases requiring transformation
c
                  if (k.ge.2 .and. k.le.5 .and.a(i,j).gt.refval) then
                     if (k.eq.2) then
c...sqrt
                        x(i,j) = sqrt(a(i,j))
                     elseif (k.eq.3) then
c...4'th root
                        x(i,j) = a(i,j)**pnt25
                     elseif (k.eq.4) then
c...log
                        x(i,j) = log(a(i,j))
                     elseif (k.eq.5) then
c...log(1 + x)
                        x(i,j) = log(one + a(i,j))

                     endif
                  elseif (k.eq.6) then
c...normalise to 0,1
                     x(i,j) = (a(i,j) - xbsav(j))/sisav(j)
                  elseif (k.eq.7) then
c...x/s
                     x(i,j) = a(i,j)/s(j)
                  endif
               enddo
c***********endif   
         enddo
      endif                
c
c format statements
c      
  100 format ('ISEND out of range in call to PCATRN')
  200 format ('ITYPE out of range in call to PCATRN')
  300 format ('Insufficient variables (NVAR < 1)')
  400 format ('Insufficient data (NTOTAL < 2)')
  500 format ('Scaling vector has s(i) =< zero')
  600 format ('Negative value  ...  Transformation is impossible')
  700 format ('zero variance ... Transformation is impossible')
      end
c
c
