c
c
      subroutine pcawts (isend, nin, npr, nps, nr, ns, nw,
     +                   r, s, w)
c
c action: install/edit weights for multivariate analysis, e.g. pca
c author: w.g.bardsley, university of manchester, u.k., 23/10/2002
c         04/11/2006 edited and introduced intents
c       
c isend: (input/unchanged) as follows:
c         isend = 1: just replicates
c         isend = 2: just scaling
c         isend = 3: both possibilities
c   nin: (input/unchanged) unconnected input unit
c   npr: (output) number of r(i) assigned by this subroutine
c   nps: (output) number of s(i) assigned by this subroutine
c    nr: (input/unchanged) number of r supplied
c    ns: (input/unchanged) number of s supplied
c    nw: (input/unchanged) dimension of workspace
c     r: (input/output) replicate weight factors >= 0
c     s: (input/output) scaling weight factors > 0
c     w:  workspace
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: isend, nin, nr, ns, nw
      integer,          intent (inout) :: npr, nps
      double precision, intent (inout) :: r(nr), s(ns), w(nw)
c
c locals
c      
      integer    icolor, ix, iy, lshade, numdec, numtxt, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 8)
      integer    numbld(30), numpos(numopt)
      integer    i, jsend, npts
      integer    ksend, ktype, ncols
      parameter (ksend = 2, ktype = 1, ncols = 1)
      double precision rtol, x02amf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  line*100, text(30)*100
      character  word4(2)*4
      character  no*4, yes*4
      parameter (no = '(NA)', yes = '    ')
      character  fname*1024, title*80
      logical    abort, ok, repeet
      logical    border, fixrow, label
      parameter (border = .false., fixrow = .false., label = .false.)
      logical    fix1, fix2, fix3, fix4, fix5, fix6
      parameter (fix1 = .false., fix2 = .true., fix3 = .true.,
     +           fix4 = .true., fix5 = .false., fix6 = .false.)
      external   putadv, patch1, editor, putfat, vec1in, lbox02
      external   x02amf$
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c initialise and check isend
c
      abort = .false.
      if (isend.eq.1) then
         if (nr.lt.1) abort = .true.
         word4(1) = yes
         word4(2) = no
      elseif (isend.eq.2) then
         if (ns.lt.1) abort = .true.
         word4(1) = no
         word4(2) = yes
      elseif (isend.eq.3) then
         if (nr.lt.1) abort = .true.
         if (ns.lt.1) abort = .true.
         word4(1) = yes
         word4(2) = yes
      else
         call putfat ('ISEND out of range in call to PCAWTS')
         return
      endif
      if (abort) then
         write (line,100)
         call putfat (line)
         return
      endif
      rtol = 1.0d+09*x02amf$()
c
c main loop
c
      repeet = .true.
      do while (repeet)
         numdec = numopt - 1
         write (text,200) word4(1), word4(1), word4(1),
     +                    word4(2), word4(2), word4(2)
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                text)
         if (isend.eq.1) then
            if (numdec.ge.4 .and. numdec.le.6) numdec = 0
         elseif (isend.eq.2) then
            if (numdec.lt.4) numdec = 0
         endif
         if (numdec.eq.0) then
            write (line,300)
            call putfat (line)
         endif
         if (numdec.ge.1 .and. numdec.le.3) then
            write (title,400)
         elseif (numdec.ge.4 .and. numdec.le.6) then
            write (title,500)
         endif
         if (numdec.eq.1 .or. numdec.eq.4) then
c
c read in a vector of weights
c
            jsend = 3
            npts = 0
            close (unit = nin)
            call vec1in (jsend, nin, nw, npts,
     +                   w, 
     +                   fname, title,
     +                   abort, fixrow, label)
            close (unit = nin)
            if (abort) then
               npts = 0
            elseif (npts.lt.1) then
               npts = 0
               abort = .true.
            endif
            if (.not.abort) then
               if (numdec.eq.1) then
                  if (npts.ge.nr) then
                     npts = nr
                  else
                     npts = 0
                     abort = .true.
                  endif
               elseif (numdec.eq.4) then
                  if (npts.ge.ns) then
                     npts = ns
                  else
                     npts = 0
                     abort = .true.
                  endif
                endif
            endif
            if (.not.abort .and. numdec.eq.4) then
               abort = .true.
               ok = .true.
               do i = 1, npts
                  if (ok) then
                     if (w(i).lt.rtol) ok = .false.
                  endif
               enddo
               if (ok) abort = .false.
            endif
         elseif (numdec.eq.2 .or. numdec.eq.5) then
c
c edit the weights supplied
c
            if (numdec.eq.2) then
               npts = nr
               do i = 1, nr
                  w(i) = r(i)
               enddo
            else
               npts = ns
               do i = 1, ns
                  w(i) = s(i)
               enddo
            endif
            call editor (ksend, ktype, ncols, npts, npts,
     +                   w,
     +                   title,
     +                   fix1, fix2, fix3, fix4, fix5, fix6)
            if (numdec.eq.5) then
               abort = .true.
               ok = .true.
               do i = 1, npts
                  if (ok) then
                     if (w(i).lt.rtol) ok = .false.
                  endif
               enddo
               if (ok) abort = .false.
            endif
         elseif (numdec.eq.3 .or. numdec.eq.6) then
            abort = .false.
            if (numdec.eq.3) then
               npts = nr
            else
               npts = ns
            endif
            do i = 1, npts
               w(i) = one
            enddo
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,600)
            numbld(1) = 1
            numbld(7) = 1
            numbld(17) = 1
            numtxt = 20
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
         else
c
c cancel
c
            repeet = .false.
         endif
         if (numdec.ge.1 .and. numdec.le.6) then
            repeet = .false.
            if (abort) then
               write (line,700)
               call putfat (line)
               npts = 0
            elseif (numdec.le.3) then
               do i = 1, npts
                  r(i) = w(i)
                  if (r(i).lt.zero) r(i) = zero
               enddo
               npr = npts
            else
               do i = 1, npts
                 s(i) = w(i)
               enddo
               nps = npts
            endif
            if (npts.gt.0) then
               write (line,800) npts
               call putadv (line)
            endif
         endif
      enddo              
c
c format statements
c      
  100 format ('First read in a data set')
  200 format (
     + 'Replicate factors r: install',1x,a
     +/'Replicate factors r: edit',1x,a
     +/'Replicate factors r: set all = 1',1x,a
     +/'Scaling factors s: install',1x,a
     +/'Scaling factors s: edit',1x,a
     +/'Scaling factors s: set all = 1',1x,a
     +/'Help'
     +/'Apply')
  300 format ('Option not available for this procedure')
  400 format ('Replicates weighting vector, r(i) >= 0')
  500 format ('Scaling weighting vector, s(i) > 0')
  600 format (
     + 'Multivariate weighting factors for data matrices a(i,j)'
     +/'Weights can be used by advanced users in two circumstances:'
     +/'1) w(i) = r(i), to allow for replicates or arbitrary weights'
     +/'2) w(j) = 1/s(j), for scaling variables to unit variance.'
     +/'Inexperienced users should not attempt to employ weighting.'
     +/
     +/'Row (i.e. case) replicate factors r(i) >= 0'
     +/'These are used to calculate weighted column means m_j, such as'
     +/'m_j=[r(1)a(1,j)+r(2)a(2,j)+...+r(n)a(n,j)]/[r(1)+r(2)+...+r(n)]'
     +/'where the r(i) are integers 1,2,3,..., i.e. r(i) replicates'
     +/'have been used to calculate a(i,j). You can use r(i) = 0 to'
     +/'suppress case(i), but be careful as this technique can lead to'
     +/'confusion and is not recommended. Of course, the r(i) can also'
     +/'be used for arbitrary weighting, if some cases are thought to'
     +/'be more reliable than others and you want to allow for this.'
     +/
     +/'Column (i.e. variable) scaling factors s(j) > 0'
     +/'These are used to scale variables j to unit variance, as in'
     +/'b(i,j) = a(i,j)/s(j), and you have s(j) values that are more'
     +/'meaningful than the sample standard deviations.')
  700 format (
     +'New weights rejected (< 0)  ...  Existing weights are unchanged')
  800 format (i6,' weighting factors have been installed/edited')
      end
c
c
