c
c
      subroutine pcvtst (mode, nf, npar, npts, nrmax,
     +                   cv, p)
c
c action: store/test covariance matrix/parameters
c author: w.g.bardsley, university of manchester, uk, 13/05/2001
c
c         01/02/2003 revised calculations, error trapping and matrix inversion
c         24/02/2006 introduced allocatable arrays for local workspaces
c         16/05/2006 repaired error due to unallocated istate vector
c         17/10/2007 added INTENTS
c         01/11/2007 added jstate and check for same parameter fixed at different values
c         02/03/2009 corrected error calculating p values
c
c  mode: (input/unchanged) as follows:
c         mode = 1: supply data, test, can switch off (e.g. mmfit)
c         mode = 2: supply data, test, cannot switch off (e.g. qnfit)
c         mode = 3: no data, test, cannot switch off (e.g. simstat)
c                   but nrmax and npar must be defined as they are 
c                   used to dimension cv  and p
C 
c
c    nf: (input/unchanged) output unit for results
c  npar: (input/unchanged) no. of parameters (ignored if mode = 3 
c                          but must be set for dimension)
c  npts: (input/unchanged) no. data points (ignored if mode = 3)
c nrmax: (input/unchanged) leading dimension of covariance matrix
c    cv: (input/unchanged) covariance matrix (ignored if mode = 3)
c     p: (input/unchanged) parameter estimates (ignored if mode = 3)
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: mode, nf, nrmax
      integer,          intent (in) :: npar, npts
      double precision, intent (in) :: cv(nrmax,npar), p(npar)
c
c local allocatable arrays
c
      integer,          allocatable :: istate(:), jstate(:)
      double precision, allocatable :: a(:,:), b(:,:), c(:), d(:),
     +                                 diagv1(:), diagv2(:), e(:), f(:),
     +                                 temp1(:), temp2(:)
      logical,          allocatable :: accept(:), free(:)
c
c locals
c
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 0, numsta = 5)
      integer    numbld(30), numpos(10)
      integer    isend, itype, maxfil, mode1, ncol, nin, nmax, nout,
     +           nrow
      parameter (isend = 1, itype = 7, maxfil = 2, nmax = 10)
      integer    lda, ldb, lpar, nxtra
      parameter (lda = 100, ldb = lda + 1, nxtra = 11)
      integer    i, ierr, ifail, ios, iprev, j, k, l, nfree,
     +           nfree1, nfree2, nfree3, nfiles, npts1, npts2
      double precision abst, bot, chisqd, ci, cvii, cvij, cvji, di, dof,
     +                 dof1, dof2, pval, test, top, tval
      double precision g01ecf$, x02amf$, g01ebf$
      double precision zero, two, cvmin, epsi, rtol
      parameter (zero = 0.0d+00, two = 2.0d+00, cvmin = -1.0d-06, 
     +           epsi = 1.0d-06)
      character  cipher*5, files(nmax)*1024, fname*1024, line*100,
     +           text(30)*100, titles(nmax)*80, trim80*80, type1*40,
     +           select(nmax)*1024
      character  blank*1, fixed*5, tail*1
      parameter (blank = ' ', fixed = 'fixed', tail = 'U')
      logical    again, abort, done, ready, switch_off
      logical    askif, frame, next, updown
      parameter (askif = .true., frame = .false., updown = .true.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   lbox01, tutor1, ofiles, putfat, gettxt, pfile2, getnou,
     +           pfiles, putifa, trim80, lcase1, table1, plevel, putadv
      external   f01adf$, g01ecf$, x02amf$, g01ebf$
      intrinsic  dble, abs, nint, sqrt
      save       switch_off
      data       switch_off / .false. /
      data       numbld / 30*0 /
      data       numpos / 10*1 /
c
c copy mode so that mode itself cannot change then check mode and input parameters
c
      mode1 = mode
      if (mode1.eq.1) then
         if (switch_off) return
         if (npar.lt.1 .or. npts.le.npar) mode1 = 3
      elseif (mode1.eq.2) then
         switch_off = .false.
         if (npar.lt.1 .or. npts.le.npar) mode1 = 3
      elseif (mode1.eq.3) then
         switch_off = .false.
      else
         call putfat ('MODE out of range in call to PCVTST')
         return
      endif
      if (mode1.eq.1 .and. npar.gt.lda) then
         call putfat ('NPAR > LDA in call to PCVTST')
         return
      endif
      if (mode1.eq.1 .and. npar.gt.nrmax) then
         call putfat ('NPAR > NRMAX in call to PCVTST')
         return
      endif   
c
c define rtol
c
      rtol = 1.0d+09*x02amf$()
      
      if (mode1.lt.3) then
c
c check input data if mode1 < 3 
c
         if (npar.lt.1) then
            mode1 = 3
            call putfat ('NPAR < 1 in call to PCVTST')
         endif
         if (mode1.lt.3 .and. npar.ge.npts) then
            mode1 = 3
            call putfat ('NPAR >= NPTS in call to PCVTST')
         endif      
         nfree = 0
         i = 0
         do while(mode1.lt.3 .and. i.lt.npar)
            i = i + 1
            cvii = cv(i,i)
            if (cvii.gt.rtol) then
               nfree = nfree + 1
            elseif (cvii.lt.cvmin) then
               mode1 = 3
               call putfat ('CV(i,i) < 0 in call to PCVTST')
            endif
         enddo
         if (mode1.lt.3 .and. nfree.lt.1) then
            mode1 = 3
            call putfat ('NFREE < 1 in call to PCVTST')
         endif
         if (mode1.lt.3 .and. nfree.ge.npts) then
             mode1 = 3
             call putfat ('NFREE >= NPTS in call to PCVTST')
         endif    
         if (mode1.lt.3 .and. nfree.gt.1) then
            i = 1
            do while (mode1.lt.3 .and. i.lt.npar) 
               i = i + 1
               j = 0
               do while(mode1.lt.3 .and. j.lt. i - 2)
                  j = j + 1
                  cvij = cv(i,j)
                  cvji = cv(j,i)
                  test = abs(cvij - cvji)/(abs(cvij) + abs(cvji) + rtol) 
                  if (test.gt.epsi) then
                     mode1 = 3
                     call putfat ('CV unsymmetrical in call to PCVTST')
                  endif  
               enddo
            enddo
         endif
      endif

c
c allocate istate and jstate
c
      ierr = 0
      if (allocated(istate)) deallocate(istate, stat = ierr)
      if (ierr.ne.0) return
      allocate(istate(lda), stat = ierr)
      if (ierr.ne.0) return
      if (allocated(jstate)) deallocate(jstate, stat = ierr)
      if (ierr.ne.0) return
      allocate(jstate(lda), stat = ierr)
      if (ierr.ne.0) return        
      
c
c allocate remaining workspaces
c
      ierr = 0
      if (allocated(a)) deallocate(a, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(diagv1)) deallocate(diagv1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(diagv2)) deallocate(diagv2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(f)) deallocate(f, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(temp1)) deallocate(temp1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(temp2)) deallocate(temp2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(accept)) deallocate(accept, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(free)) deallocate(free, stat = ierr)
      if (ierr.ne.0) return
      allocate(a(lda,lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(ldb,ldb), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(d(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(diagv1(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(diagv2(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(e(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(f(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(temp1(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(temp2(lda), stat = ierr)
      if (ierr.ne.0) return
      allocate(accept(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(free(lda), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      iprev = 0
      nfiles = 0
      done = .false.
      again = .true.
c
c =========
c main menu --------------------------------------------------------------------
c =========
c
      do while (again)
c
c adjust menu depending on mode1
c
         
         write (text,100)
         if (mode1.eq.1) then
c
c mode1 = 1: 5 options
c           
            numopt = 5
            numdec = 4
         elseif (mode1.eq.2) then
c
c mode1 = 2: 4 options
c         
            text(7) = text(8)
            text(8) = text(9)
            numopt = 4
            numdec = 3
         elseif (mode1.eq.3) then
c
c mode1 = 3: 3 options
c         
            text(5) = text(6)
            text(6) = text(8)
            text(7) = text(9)
            numopt = 3
            numdec = 2
         endif
         numtxt = numsta + numopt - 1
         
         numbld(1) = 4
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, numsta, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
c
c adjust decision depending on mode1
c         
         if (mode1.eq.2 .and. numdec.gt.2) then
c
c mode1 = 1: so add 1 to miss out switching off
c           
            numdec = numdec + 1
         elseif (mode1.eq.3) then
c
c mode1 = 3: so add 1 to miss out saving or 2 to miss out switching off
c         
            if (numdec.eq.1) then
               numdec = numdec + 1
            else
                numdec = numdec + 2
            endif
         endif
         
         if (numdec.eq.1) then
c
c numdec = 1: store data ... At this stage npar, npts, and cv have not been 
c ===========                changed but istate must be now be calculated 
c 
            if (done) then
               call putfat ('Data have already been saved')
            elseif (mode1.lt.3) then
               call getnou (nout)
               close (unit = nout)
               call ofiles (isend, nout,
     +                      fname,
     +                      abort)
               if (.not.abort) then
                  call gettxt ('Title for these CV and p estimates',
     +                         titles(1))
                  write (nout,'(a)') titles(1)
                  write (nout,'(2i6)') npar + 4, npar
                  do i = 1, npar
                     write (nout,'(1p,50e11.3)') (cv(i,j), j = 1, npar)
                  enddo
                  write (nout,'(1p,50e11.3)') (p(i), i = 1, npar)
                  do i = 2, npar
                     istate(i) = 0
                  enddo
                  istate(1) = npts
                  write (nout,'(50i11)') (istate(i), i = 1, npar)
                  istate(1) = nfree
                  write (nout,'(50i11)') (istate(i), i = 1, npar)
                  do i = 1, npar
                     cvii = cv(i,i)
                     if (cvii.gt.rtol) then
                        istate(i) = 1
                     else
                        istate(i) = 0
                     endif
                  enddo
                  write (nout,'(50i11)') (istate(i), i = 1, npar)
                  write (nout,'(i6)') nxtra
                  write (nout,200)
                  close (unit = nout)
                  done = .true.
                  call pfile2 (itype,
     +                         fname,
     +                         askif)
               else
                  close (unit = nout)
               endif
            else
               call putfat ('Cannot save in analysis mode')
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: test data from archive
c ===========
c
            call getnou (nin)
            open (unit = nin, status = 'SCRATCH')
            call getnou (nout) 
            close (unit = nin)
            close (unit = nout)
            call pfiles (iprev, itype, nfiles, nin, nmax, nout,
     +                   files,
     +                   accept)
            close (unit = nin)
            close (unit = nout)
            ready = .false.
            if (nfiles.le.1) then
               call putfat ('Must have at least 2 files for the test')
            elseif (nfiles.gt.1) then
c
c check dimensions
c
               if (nfiles.gt.maxfil) then
                  call putadv ('Only the first 2 files can be analysed')
                  nfiles = maxfil
               endif   
               open (unit = nin, file = files(1))
               k = 0
               ncol = 0
               nrow = 0
               read (nin,'(a)',iostat=ios) titles(1)
               if (ios.eq.0) then
                  read (nin,*,iostat=ios) i, j
                  if (ios.eq.0) then
                     nrow = i
                     ncol = j
                     k = ncol
                  endif
               endif
               close (unit = nin)
               ready = .true.
               if (k.lt.1) ready = .false.
               if (nrow.ne.ncol + 4) ready = .false.
               if (.not.ready) call putfat ('Dimension error in file 1')
               do i = 2, nfiles
                  if (ready) then
                     open (unit = nin, file = files(i))
                     ncol = 0
                     nrow = 0
                     read (nin,'(a)',iostat=ios) titles(i)
                     if (ios.eq.0) then
                        read (nin,*,iostat=ios) j, l
                        if (ios.eq.0) then
                           nrow = j
                           ncol = l
                        endif
                     endif
                     close (unit = nin)
                     if (ncol.ne.k .or. nrow.ne.ncol + 4) then
                        ready = .false.
                        write (line,300) i - 1, k, i, ncol
                        call putfat (line)
                     endif
                  endif
               enddo
            endif
c
c check for identical files
c
            if (ready) then
               do i = 1, nfiles
                  select(i) = files(i)
                  call lcase1 (select(i))
               enddo
            endif
            do i = 1, nfiles - 1
               do j = i + 1, nfiles
                  if (ready) then
                     if (select(i).eq.select(j)) then
                        ready = .false.
                        write (line,400) i, j
                        call putfat (line)
                     endif
                  endif
               enddo
            enddo
            
            if (ready .and. nfiles.eq.2) then
c
c chi-square if ready and nfiles = 2
c
               lpar = ncol
               npts1 = 0
               npts2 = 0
               nfree1 = 0
               nfree2 = 0
c
c open files 1 and 2
c
               open (unit = nin, file = files(1))
               open (unit = nout, file = files(2))
               read (nin,'(a)') titles(1)
               read (nout,'(a)') titles(2)
               read (nin,*) nrow, ncol
               read (nout,*) nrow, ncol
c
c create a = cov_1 + cov_2 and variances diagv1, diagv2
c
               k = 0
               i = 0
               do while (ready .and. i.lt.lpar)
                  i = i + 1
                  if (ready) read (nin,*,iostat=ios) (c(j),j = 1,lpar)
                  if (ios.ne.0) ready = .false.
                  if (ready) read (nout,*,iostat=ios) (d(j),j = 1,lpar)
                  if (ios.ne.0) ready = .false.
                  if (ready) then
                     do j = 1, lpar
                        a(i,j) = c(j) + d(j)
                     enddo
                     k = k + 1
                     if (c(k).lt.cvmin) then
                        ready = .false.
                        call putfat ('CV(i,i) < 0 in file 1')
                     else
                        diagv1(i) = c(k)   
                     endif  
                     if (d(k).lt.cvmin) then
                        ready = .false.
                        call putfat ('CV(i,i) < 0 in file 2')
                     else   
                        diagv2(i) = d(k)
                     endif    
                  endif
               enddo
c
c create e = p_1 - p_2
c
               if (ready) read (nin,*,iostat=ios) (c(j), j = 1, lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) read (nout,*,iostat=ios) (d(j), j = 1, lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) then
                  do j = 1, lpar
                     e(j) = c(j) - d(j)
                  enddo
               endif
c
c npts
c
               if (ready) read (nin,*,iostat=ios) (temp1(j),j = 1,lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) npts1 = nint(temp1(1))
               if (ready) read (nout,*,iostat=ios) (temp2(j),j = 1,lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) npts2 = nint(temp2(1))
c
c nfree
c
               if (ready) read (nin,*,iostat=ios) (temp1(j), j = 1,lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) nfree1 = nint(temp1(1))
               if (ready) read (nout,*,iostat=ios) (temp2(j),j = 1,lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) nfree2 = nint(temp2(1))
c
c istate and jstate
c
               if (ready) read (nin,*,iostat=ios) 
     +                         (temp1(j), j = 1, lpar)
               if (ready .and. ios.ne.0) ready = .false.
               if (ready) read (nout,*,iostat=ios) 
     +                         (temp2(j), j = 1, lpar)
               if (ready .and. ios.ne.0) ready = .false.
               do i = 1, lpar
                  if (ready) then
                     istate(i) = nint(temp1(i))
                     jstate(i) = nint(temp2(i))
                     j = istate(i)
                     l = jstate(i)
                     if (j.lt.0 .or. j.gt.1 .or.
     +                   l.lt.0 .or. l.gt.1) then
                         ready = .false.
                         call putfat ('ISTATE values must be 0 or 1')
                     endif                           
                     if (ready .and. j.ne.l) then
                        ready = .false.
                        call putfat ('ISTATE values are inconsistent')
                     endif
                  endif
                  if (ready .and. j.eq.0) then
                     ci = c(i)
                     di = d(i)
                     test = abs(ci - di)/(abs(ci) + abs(di) + rtol)
                     if (test.gt.epsi) then
                        ready = .false.
                        call putfat ('Fixed parameters are not equal')
                     endif 
                  endif  
               enddo
c
c close files 1 and 2
c
               close (unit = nin)
               close (unit = nout)
c
c check NFREE and NPTS
c               
               if (ready .and. npts1.le.nfree1) then
                   ready = .false.
                   call putfat ('Must have NFREE > NPTS in file 1')
               endif    
               if (ready .and. npts2.le.nfree2) then
                  ready = .false.
                  call putfat ('Must have NFREE > NPTS in file 2')
               endif   
               if (ready .and. nfree1.ne.nfree2) then
                  ready = .false.
                  call putfat ('NFREE not identical in files 1 and 2')
               endif   
               if (ready .and. nfree1.lt.1) then
                  ready = .false.
                  call putfat ('Must have NFREE > 0')
               endif
               if (ready) then
                  nfree3 = 0
                  i = 0
                  do i = 1, lpar
                     if (istate(i).eq.1) nfree3 = nfree3 + 1
                  enddo
                  if (nfree3.ne.nfree1) then
                     ready = .false.
                     call putfat ('NFREE and ISTATE are inconsistent')
                  endif   
               endif 
               if (ready) then
                   i = 0
                   do while (ready .and. i.lt.lpar)
                      i = i + 1
                      if (istate(i).eq.0) then
                         if (diagv1(i).gt.rtol .or. 
     +                       diagv2(i).gt.rtol) then
                            ready = .false.
                            call putfat ('CV nonzero but ISTATE = 0')
                          endif
                      endif     
                   enddo  
               endif    
                       
c
c generate free(i)
c
               l = 0
               if (ready) then
                  do i = 1, lpar
                     j = istate(i)
                     if (j.eq.0) then
                        free(i) = .false.
                     else
                        l = l + 1
                        free(i) = .true.
                     endif
                  enddo
               endif
               if (l.ne.nfree1) ready = .false.
c
c creat a = [cov_1 + cov_2]^(-1)
c
               if (ready) then
                  if (nfree1.lt.lpar) then
c
c contract matrix a(i,j) and parameter difference e if some parameters are fixed
c
                     k = 0
                     do i = 1, ncol
                        if (free(i)) then
                           k = k + 1
                           e(k) = e(i)
                           l = 0
                           do j = 1, ncol
                              if (free(j)) then
                                 l = l + 1
                                 a(k,l) = a(i,j)
                              endif
                           enddo
                        endif
                     enddo
                     lpar = nfree1
                  endif
c
c copy a into upper triangle of b then invert
c
                  do j = 1, ncol
                     do i = 1, ncol
                        b(i,j) = a(i,j)
                     enddo
                  enddo
                  ifail = 1
                  call f01adf$(lpar, b, ldb, ifail)
                  call putifa (ifail, nf, 'F01ADF/PCVTST')
                  if (ifail.eq.0) then
c
c retrieve inverse from lower triangle of b offset by 1
c
                     do i = 1, lpar
                        do j = 1, i
                           a(i,j) = b(i + 1,j)
                        enddo
                     enddo
                     do i = 1, lpar - 1
                        do j = i + 1, lpar
                           a(i,j) = a(j,i)
                        enddo
                     enddo
c
c create c = a*e
c
                     do i = 1, lpar
                        f(i) = zero
                        do j = 1, lpar
                           f(i) = f(i) + a(i,j)*e(j)
                        enddo
                     enddo
c
c create chisqd = e^T*a*e then do a chi-square test
c
                     chisqd = zero
                     do i = 1, lpar
                        chisqd = chisqd + f(i)*e(i)
                     enddo
                     dof = dble(lpar)
                     ifail = 1
                     pval = g01ecf$(tail, chisqd, dof, ifail)
                     call plevel (pval, type1)
                     call putifa (ifail, nf, 'G01ECF/PCVTST')
                     write (text,500) trim80(files(1)), titles(1),
     +                                trim80(files(2)), titles(2),
     +                                chisqd, lpar, pval, type1
                     numtxt = 10
                     write (nf,'(a)') blank
                     j = 15
                     call table1 (j, 'OPEN')
                     do i = 1, numtxt
                        if (i.eq.3 .or. i.eq.5 .or. i.eq.numtxt) then
                           j = 4
                        elseif (i.eq.4 .or. i.eq.6) then
                           j = 1
                        else
                          j = 0
                        endif
                        call table1 (j, text(i))
                        write (nf,'(a)') text(i)
                     enddo
c
c now a t test on free parameters
c
                     dof1 = dble(npts1 - lpar)
                     dof2 = dble(npts2 - lpar)
                     j = 0
                     do i = 1, ncol
                        if (free(i)) then
                           top = c(i) - d(i)
                           bot = sqrt(diagv1(i) + diagv2(i))
                           tval = top/bot
                           top = (diagv1(i) + diagv2(i))**2
                           bot = diagv1(i)**2/dof1 + diagv2(i)**2/dof2
                           dof = top/bot
                           abst = abs(tval)
                           pval = two*g01ebf$(tail, abst, dof, ifail)
                           call putifa (ifail, nf, 'G01EBF/PCVTST')
                           if (pval.lt.0.01d+00) then
                              cipher = '*****'
                           elseif (pval.lt.0.05d+00) then
                              cipher = ' *** '
                           else
                              cipher = '     '
                           endif
                           write (nf,600) i, c(i), d(i), c(i) - d(i),
     +                                    tval, nint(dof), pval, cipher
                           write (line,600) i, c(i), d(i), c(i) - d(i),
     +                                      tval, nint(dof), pval,
     +                                      cipher
                        else
                           write (nf,700) i, c(i), d(i), c(i) - d(i),
     +                                    fixed
                           write (line,700) i, c(i), d(i), c(i) - d(i),
     +                                      fixed
                        endif
                        call table1 (j,line)
                     enddo
                     call table1 (j, 'CLOSE')
                  else
                     call putfat ('Cannot invert CV matrix estimate')
                  endif
               else
                  call putfat ('Files have bad or inconsistent data')
               endif
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: suppress subroutine
c ===========
c
            if (mode1.eq.1) then
               switch_off = .true.
               again = .false.
            else
               call putfat ('Cannot switch off in analysis mode')
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: help
c ===========
c
            write (text,1000)
            numtxt = 22
            numbld(1) = 1
            next = .true.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            write (text,2000)
            numtxt = 22
            numbld(1) = 1
            numbld(14) = 1
            next = .false.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            numbld(14) = 0
         else
c
c numdec = 5: exit
c ===========
c
            again = .false.
         endif
      enddo
c      
c-------------------------------------------------------------------------------------------      
c
c deallocate workspaces
c
      deallocate(istate, stat = ierr)
      deallocate(jstate, stat = ierr)
      deallocate(a, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(c, stat = ierr)
      deallocate(d, stat = ierr)
      deallocate(diagv1, stat = ierr)
      deallocate(diagv2, stat = ierr)
      deallocate(e, stat = ierr)
      deallocate(f, stat = ierr)
      deallocate(temp1, stat = ierr)
      deallocate(temp2, stat = ierr)
      deallocate(accept, stat = ierr)
      deallocate(free, stat = ierr)
c
c format statements
c
  100 format (
     + 'Testing for equality of parameter estimates'
     +/
     +/'The parameters and covariance matrices must refer'
     +/'to the same model fitted and be in the same order.'
     +/'Store current parameters/covariance matrix'
     +/'Compare parameters/covariance matrices'
     +/'Suppress this menu from now'
     +/'Help'
     +/'Quit ... Exit parameter estimates options')
  200 format (
     + 'Format for parameter and covariance matrix estimates'
     +/'Line 1: title'
     +/'Line 2: No. rows, no. of columns'
     +/'Line 3: cv(1,1), cv(1,2), ..., cv(1,n)'
     +/'Line 4: cv(2,1), cv(2,2), ..., cv(2,n)'
     +/'...'
     +/'Line n + 2: cv(n,1), cv(n,2), ..., cv(n,n)'
     +/'Line n + 3: p(1), p(2), ..., p(n) estimates'
     +/'Line n + 4: NPTS = no. data points, ..., unassigned'
     +/'Line n + 5: NFREE = no. free parameters, ..., unassigned'
     +/'Line n + 6: ISTATE = 0 for fixed and 1 for free parameters')
  300 format ('Files',I3,' (n =',I4,') and',I3,' (n =',I4,
     +        ') have inconsistent dimensions')
  400 format ('File',I4,' is the same as File',I4)
  500 format (
     + 'Mahalanobis chi-square, and corrected pairwise t tests for'
     +/'differences between parameters(A,B) and covariances(Ca,Cb).'
     +/A
     +/A
     +/A
     +/A
     +/'Q = (A-B)^T(Ca+Cb)^(-1)(A-B) =',1p,e10.3
     +/'Number of degrees of freedom =',i7
     +/'Probability(Chi-square >= Q) =',0p,f7.4,2x,a
     +/'Index    A          B          A - B      t          DOF    p')
  600 format (i5,1p,4e11.3,i7,0p,f8.4,2x,a)
  700 format (i5,1p,3e11.3,0p,10x,a)
 1000 format (
     + 'Comparing parameters and covariance matrices'
     +/
     +/'This technique is for users who want to test for equality of'
     +/'parameters and covariance matrices, and choose to store or'
     +/'retrieve the parameter/covariance matrix files that can be'
     +/'saved by Simfit after fitting models to data.'
     +/
     +/'You may want to test multivariate means and dispersions, e.g.'
     +/'after fitting a model you may wish to store the parameter and'
     +/'covariance matrix estimates in order to test for significant'
     +/'differences. For instance, you may fit the same growth model'
     +/'to different cell populations to see if there is a significant'
     +/'difference in growth rate, or you may have pharmacokinetic data'
     +/'for a drug with two populations and wish to decide if kinetics'
     +/'of elimination differ appreciably. Actually, this routine can'
     +/'be used with any multivariate mean vector and covariance matrix'
     +/'estimates (for the means) to test for significant differences,'
     +/'assuming asymptotic normality, e.g. Maximum Likelihood.'
     +/
     +/'Note that derived parameters, such as LD50 from dose response'
     +/'by GLM, or AUC from exponential fitting, must be tested by the'
     +/'pairwise procedure, as only primary parameters are stored.')
 2000 format (
     + 'Advice concerning parameter/covariance matrix files'
     +/
     +/'There will be n parameters in the model but not all have to be'
     +/'estimated, as you can denote fixed parameters by setting the'
     +/'variance to zero. It is vital that the files refer to fitting'
     +/'the same model with the same parameters, which is complicated'
     +/'with models like sums of exponentials, Gaussians, Michaelis-'
     +/'Mentens, High/Low affinity, etc. where the parameter order is'
     +/'arbitrary. Note that programs exfit, mmfit, and hlfit attempt'
     +/'to ease this process by sorting the output in increasing order'
     +/'of amplitude factors, but with qnfit you must control the order'
     +/'by judicious choice of starting estimates.'
     +/
     +/'The format for parameter/covariance matrix files a(i,j)'
     +/
     +/'a(i,j) i,j = 1 to n: covariance(i,j) (zero a(i,i) = fixed)'
     +/'a(n+1,j) j = 1 to n: parameters/means estimated and fixed'
     +/'a(n+2,j) j = 1: no. experimental point, j > 1 zero padding'
     +/'a(n+3,j) j = 1: NFREE no. free  parameters, j > 1 zero padding'
     +/'a(n+4,j) j = 1 to n ISTATE Boolean 0=fixed, 1=free/estimated'
     +/'Note that only consistent data sets can be analysed, and you'
     +/'automatically store file names in the file c_recent.cfg.')
      end
c
c
