C
C
      DOUBLE PRECISION FUNCTION PDF_BINOMIAL (K, N, NOUT,
     +                                        P)
C
C ACTION : PDF (i.e. PMF) for Binomial distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P
C
C Locals
C      
      INTEGER    IFAIL 
      DOUBLE PRECISION PLEK, PEQK, PGTK
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   PUTIFA
      EXTERNAL   G01BJF$
      IFAIL = 1
      CALL G01BJF$(N, P, K, PLEK, PGTK, PEQK, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01BJF/PDF_BINOMIAL')
      PDF_BINOMIAL = PEQK
      IF (PDF_BINOMIAL.LT.ZERO) PDF_BINOMIAL = ZERO
      END
C
C
