C
C
      DOUBLE PRECISION FUNCTION PDF_CHISQUARE (ENEG, EXPON, FACTOR, X)
C
C ACTION: PDF for chi-square distribution
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN) :: ENEG, EXPON, FACTOR, X
C
C Locals
C      
      DOUBLE PRECISION ARG
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      INTRINSIC  MAX, EXP
      IF (X.LT.ZERO) THEN
C
C Trap bad argument
C        
         PDF_CHISQUARE = ZERO
      ELSE   
C
C Calulate pdf
C        
         ARG = MAX(ENEG, - X/TWO)
         PDF_CHISQUARE = EXP(ARG)*FACTOR*(X**EXPON)
         IF (PDF_CHISQUARE.LT.ZERO) PDF_CHISQUARE = ZERO
      ENDIF     
      END
C
C