C
C
      DOUBLE PRECISION FUNCTION PDF_F (EPOS, EXPON1, EXPON2, FACTOR, 
     +                                 RATIO, RTOL, X)
C
C ACTION: PDF for F distribution using arguments as defined in program FTEST
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 16/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN) :: EPOS, EXPON1, EXPON2, FACTOR,
     +                                 RATIO, RTOL, X
C
C Locals
C           
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION ARG
      INTRINSIC LOG, EXP
      IF (X.LE.ZERO) THEN
         PDF_F = ZERO
      ELSEIF (X.LE.RTOL) THEN
         PDF_F = FACTOR*(X**EXPON1)*((ONE + RATIO*X)**EXPON2)
      ELSE
         ARG = EXPON1*LOG(X) + EXPON2*LOG(ONE + RATIO*X)
         IF (ARG.GT.EPOS) THEN
            PDF_F = ZERO
         ELSE
            PDF_F = FACTOR*EXP(ARG)
         ENDIF
      ENDIF
      END
C
C
