C
C
      DOUBLE PRECISION FUNCTION PDF_NORMAL (X, XFACT, XMU, XSIGMA)
C
C ACTION: normal pdf
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 10/08/2007 
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (IN) :: X, XFACT, XMU, XSIGMA
C
C Locals
C      
      DOUBLE PRECISION ARG, Z
      DOUBLE PRECISION ZERO, ENEG, PNT5
      PARAMETER (ZERO = 0.0D+00, ENEG = -127.0D+00, PNT5 = 0.5D+00)
      INTRINSIC  EXP
      IF (XSIGMA.LE.ZERO) THEN
C
C Trap for sigma too small
C        
         PDF_NORMAL = ZERO
      ELSE   
C
C Calculate using XFACT = 1/{XSIGMA*SQRT(TW0*PI))
C        
         Z = (X - XMU)/XSIGMA
         ARG = - PNT5*(Z**2)
         IF (ARG.LE.ENEG) ARG = ENEG
         PDF_NORMAL = XFACT*EXP(ARG)
         IF (PDF_NORMAL.LT.ZERO) PDF_NORMAL = ZERO
      ENDIF     
      END
C
C
