C
C
      DOUBLE PRECISION FUNCTION PDF_POISSON (K, NOUT,
     +                                       R)
C
C ACTION : PDF (i.e. PMF) for Poisson distribution
C AUTHOR : W.G.Bardsely, University of Manchester, U.K., 21/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, NOUT
      DOUBLE PRECISION, INTENT (IN) :: R
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION PLEK, PEQK, PGTK
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   PUTIFA
      EXTERNAL   G01BKF$
      IFAIL = 1
      CALL G01BKF$(R, K, PLEK, PGTK, PEQK, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01BKF/PDF_POISSON')
      PDF_POISSON = PEQK
      IF (PDF_POISSON.LT.ZERO) PDF_POISSON = ZERO
      END
C
C
