C
C
      DOUBLE PRECISION FUNCTION PDFFCN (NUMDEC, NUMPAR, 
     +                                  PAR, X)
C
C ACTION : Evaluate pdfs for KS1SAM
C AUTHOR : W. G. Bardsley, University of Manchester, Derived from CDFFCN 19/08/2001
C          10/08/2007 added INTENTS 
C          17/07/2022 defined rtol, tol1 as parameters and introduced tol1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NUMDEC, NUMPAR
      DOUBLE PRECISION, INTENT (IN) :: PAR(NUMPAR), X
C
C Locals
C      
      INTEGER    IFAIL, J, K
      DOUBLE PRECISION A, B, P, Q, R, RTOL, S, TOL, TOL1, TOL2, Z
      PARAMETER (RTOL = 1.0D-290, TOL = LOG(RTOL), TOL1 = -TOL) 
      DOUBLE PRECISION AD2, APBD2, BD2
      DOUBLE PRECISION S14AAF$, S14ABF$, X02AJF$
      DOUBLE PRECISION ZERO, ONE, TWO, FNOR, HALF, PI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FNOR = 0.3989422D+00, HALF = 0.5D+00,
     +           PI = 3.1415927D+00)
      EXTERNAL   MIDDLE
      EXTERNAL   S14AAF$, S14ABF$, G01BJF$, G01BKF$, X02AJF$
      INTRINSIC  ABS, NINT, EXP, MAX, LOG, SQRT
C
C Set A, B and PDFFCN
C
      A = PAR(1)
      IF (NUMDEC.LT.6 .OR. NUMDEC.GT.7) B = PAR(2)
      PDFFCN = ZERO
      IF (NUMDEC.EQ.1) THEN
C
C uniform
C
         IF (X.LT.A .OR. X.GT.B .OR. A.GE.B) RETURN
         PDFFCN = ONE/(B - A)
      ELSEIF (NUMDEC.EQ.2) THEN
C
C normal
C
         P = SQRT(B)
         IF (P.LE.RTOL) RETURN
         Z = - HALF*((X - A)/P)**2
         CALL MIDDLE (TOL, Z, TOL1)
         PDFFCN = FNOR*EXP(Z)/P
      ELSEIF (NUMDEC.EQ.3) THEN
C
C gamma
C
         IF (ABS(B).LE.RTOL .OR. X.LE.RTOL) RETURN
         Z = X/B
         S = - Z
         CALL MIDDLE (TOL, S, TOL1)
         IFAIL = 1
         P = S14AAF$(A, IFAIL)
         IF (IFAIL.EQ.0 .AND. P.GT.RTOL) THEN
            P = P*(B**A)
            P = ONE/P
         ELSE
            RETURN
         ENDIF
         PDFFCN = P*(X**(A - ONE))*EXP(S)
      ELSEIF (NUMDEC.EQ.4) THEN
C
C beta
C
         TOL2 = 100.0D+00*X02AJF$()
         IF (X.LE.TOL2 .OR. X.GE.(ONE - TOL2)) RETURN
         IFAIL = 1
         P = S14ABF$(A + B, IFAIL)
         IFAIL = 1
         Q = S14ABF$(A, IFAIL)
         IFAIL = 1
         R = S14ABF$(B, IFAIL)
         S = EXP(P - Q - R)
         PDFFCN = S*(X**(A - ONE))*((ONE - X)**(B - ONE))
      ELSEIF (NUMDEC.EQ.5) THEN
C
C binomial
C
         J = NINT(A)
         K = NINT(X)
         CALL G01BJF$(J, B, K, P, Q, R, IFAIL)
         PDFFCN = R
      ELSEIF (NUMDEC.EQ.6) THEN
C
C exponential
C
         IF (X.LE.RTOL .OR. A.LE.RTOL) RETURN 
         Z = - X/A
         PDFFCN = (ONE/A)*EXP(Z)
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Poisson
C
         J = NINT(X)
         CALL G01BKF$(A, J, P, Q, R, IFAIL)
         PDFFCN = R
      ELSEIF (NUMDEC.EQ.8) THEN
C
C lognormal
C
         IF (X.LE.RTOL) RETURN
         P = MAX(SQRT(B), RTOL)
         Z = - HALF*((LOG(X) - A)/P)**2
         CALL MIDDLE (TOL, Z, TOL1)
         PDFFCN = FNOR*EXP(Z)/(P*X)
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Weibull
C
         Z = - (A*X)**B
         CALL MIDDLE(TOL, Z, TOL1)
         Q = (A*X)**(B - ONE)
         PDFFCN = A*B*Q*EXP(Z)
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t distribution
C
         S = (A + ONE)/TWO
         IFAIL = 1
         P = S14ABF$(S, IFAIL)
         R = A/TWO
         IFAIL = 1
         Q = S14ABF$(R, IFAIL)
         R = EXP(P - Q)/SQRT(A*PI)
         PDFFCN = R*(ONE + (X**2)/A)**(- S)
      ELSEIF (NUMDEC.EQ.11) THEN
C
C Chi-square distribution
C
         IF (X.LE.RTOL) RETURN
         AD2 = A/TWO
         IFAIL = 1
         R = S14AAF$(AD2, IFAIL)
         IF (IFAIL.NE.0) RETURN
         S = R*(TWO**AD2)
         Z = - X/TWO
         CALL MIDDLE (TOL, Z, TOL1)
         Q = AD2 - ONE
         PDFFCN = (X**Q)*EXP(Z)/S
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F distribution
C
         IF (X.LE.RTOL) RETURN
         AD2 = A/TWO
         BD2 = B/TWO
         APBD2 = (A + B)/TWO
         IFAIL = 1
         P = S14ABF$(APBD2, IFAIL)
         IFAIL = 1
         Q = S14ABF$(AD2, IFAIL)
         IFAIL = 1
         R = S14ABF$(BD2, IFAIL)
         S = (A**AD2)*(B**BD2)*EXP(P - Q - R)
         P = X**((A - TWO)/TWO)
         Q = A*X + B
         R = - APBD2
         PDFFCN = S*P*(Q**R)
      ENDIF
      END
C
C
