c
c
      subroutine pdfout (ndist, ngraf, nmax, npar, nz,
     +                   par, xgraf, x1, x2, ygraf, y1, y2, z)
c
c action: plot a barchart/histogram for a pdf from ks1sam
c author: w.g.bardsley, university of manchester, uk, 18/08/2001
c         28/02/2002 introduced nrmax to dimension xmat
c         20/03/2002 added symbol plot to histogram option
c         21/01/2006 revised and introduced allocatable workspace 
c         16/08/2006 corrected error with definition of ngraf1
c         21/03/2012 replaced BCPLOT$ by BCPLOT
c         14/07/2022 added intents
c         14/07/2022 added E_NUMBERS and E_FORMATS, etc.
c         18/07/2022 made xstart = zmin for arbitrary continuous distributions 
c
c ndist: (input/unchanged) number of the distribution (as in pdffcn)
c                          as follows: 5 or 7 discrete, o/w continuous
c ngraf: (input/unchanged) dimension of xgraf, ygraf as follows:
c                          a) discrete distribution: not referenced
c                          b) continous distribution: smooth pdf curve
c                          ...suggest 120
c  nmax: (input/unchanged) dimension for x1, x2, y1, y2 as follows:
c                          a) discrete distribution: no. bars =< nmax/3
c                          ...suggest minimum(z(nz),3000)
c                          b) continuous distribution: no. cells =< nmax/4 - 1
c                          ...suggest minimum(4*npts,4*ntop + 1) say ntop = 200
c  npar: (input/unchanged) number of parameters in distribution
c    nz: (input/unchanged) sample size z(nz)
c   par: (input/unchanged) parameters in distribution
c     z: (input/unchanged) sample
c xgraf, x1, x2, ygraf, y1, y2 are workspaces
c
c         Note: ndist = number of distribution (in pdffcn and cdffcn)
c               the sample z must be in ascending order
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: ndist, ngraf, nmax, npar, nz
      double precision, intent (in) :: par(npar), z(nz) 
      double precision  xgraf(ngraf), x1(nmax), x2(nmax),
     +                  ygraf(ngraf), y1(nmax), y2(nmax)
c
c local allocatable workspace
c
      double precision, allocatable :: xmat(:,:)
c
c locals
c
      integer    i, iadd1, ierr, iz, j, k, nbig, ncells, nrow, numdec
      integer    icolor, isend, ix, iy, ncol, nswap,
     +           ntop, numopt
      parameter (icolor = 7, isend = 2, ix = 4, iy = 4, ncol = 2,
     +           nswap = 51, ntop = 200, numopt = 6)
      integer    n0, n1, n2, n3, n4, n5
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5)
      integer    ngraf1, ngmax, nrmax, nupper
      parameter (ngmax = 200, nupper = 4000)
      integer    numpos(numopt)
      double precision zero, one, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00)
      double precision epsi, cells(ntop), dnz, xdelta, xstart, xstop,
     +                 xtest, zlim, zmax, zmin
      double precision x3(2), x4(2)
      double precision y3(2), y4(2)
      double precision pdffcn
      double precision x02ajf$
      character (len = 12) i12(2), form12
      character (len = 13) d13(2), showlj
      character  labels(nswap)*3, line*100, text(30)*100, titles(4)*40
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats 
      logical    notyet, repeet
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   e_formats, form12, showlj
      external   putwar, pdffcn, lbox02, getjm1, getdle, getdge, putadv,
     +           putfat
      external   bcplot, gks004
      external   x02ajf$
      intrinsic  min, nint, dble, trim
      save       ncells
      data       ncells / 10 /
      data       numpos /numopt*1 /
c
c return if sample too small or not in increasing order
c
      if (nz.lt.n3) then
         call putfat ('Must have > 2 points in call to PDFOUT')
         return
      endif
      do i = n2, nz
         if (z(i).lt.z(i - 1)) then
            call putfat ('Data in decreasing order in call to PDFOUT')
            return
         endif
      enddo
      e_numbers = e_formats()
c
c check ndist and assign titles
c
      if (ndist.eq.1) then
         titles(1) = 'Fitting a Uniform Distribution'
      elseif (ndist.eq.2) then
         titles(1) = 'Fitting a Normal Distribution'
      elseif (ndist.eq.3) then
         titles(1) = 'Fitting a Gamma Distribution'
      elseif (ndist.eq.4) then
         titles(1) = 'Fitting a Beta Distribution'
      elseif (ndist.eq.5) then
         titles(1) = 'Fitting a Binomial Distribution'
      elseif (ndist.eq.6) then
         titles(1) = 'Fitting an Exponential Distribution'
      elseif (ndist.eq.7) then
         titles(1) = 'Fitting a Poisson Distribution'
      elseif (ndist.eq.8) then
         titles(1) = 'Fitting a Lognormal Distribution'
      elseif (ndist.eq.9) then
         titles(1) = 'Fitting a Weibull Distribution'
      elseif (ndist.eq.10) then
         titles(1) = 'Fitting a t Distribution'
      elseif (ndist.eq.11) then
         titles(1) = 'Fitting a chi-sqd Distribution'
      elseif (ndist.eq.12) then
         titles(1) = 'Fitting a F Distribution'
      else
         return
      endif
c
c initialise
c                  
      ngraf1 = min(ngraf, ngmax)
      dnz = dble(nz)
      titles(2) = 'Values'
      titles(3) = 'Frequencies'
      titles(4) = blank
c
c Discrete distributions if ndist = 5 or ndist = 7 o/w continuous
c ---------------------------------------------------------------
c
      if (ndist.eq.5 .or. ndist.eq.7 ) then
c
c initialise the xmat array
c
         titles(3) = 'O/E Frequencies'
         nrmax = nint(z(nz)) + n1
         if (nrmax.gt.nupper) nrmax = nupper

         ierr = n0
         if (allocated(xmat)) deallocate(xmat, stat = ierr)
         if (ierr.ne.n0) return
         allocate(xmat(nrmax,n2), stat = ierr)
         if (ierr.ne.n0) return
         do i = n1, nrmax
            xmat(i,n1) = zero
            xmat(i,n2) = zero
         enddo
         iadd1 = n0
         nbig = n0
         do i = n1, nz
            iz = nint(z(i))
            k = iz + n1
            if (k.le.nrmax) then
c
c increment cell count k and nbig if required
c
               xmat(k,n1) = xmat(k,n1) + one
               if (k.gt.nbig) nbig = k
            else
               iadd1 = iadd1 + n1
            endif
         enddo
         if (iadd1.gt.n1) then
            i12(1) = form12(iadd1)
            i12(2) = form12(nupper)
            write (line,100) trim(i12(1)), i12(2)
            call putwar (line)
         endif
         nrow = min(nbig,nrmax)
         do i = n1, nrow
            k = i - n1
            xmat(i,n2) = dnz*pdffcn (ndist, npar,
     +                               par, dble(k))
         enddo
         if (nrow.le.nswap) then
c
c assign labels then plot as a bar chart
c
            do i = n1, nrow
               k = i - n1
               write (labels(i),'(i3)') k
            enddo
            call bcplot (isend, ncol, nrmax, nrow,
     +                   xmat, labels, titles)
         else
c
c assign x1,y1 = data, x2,y2 = pdf then plot as a line/symbol plot
c
            if (nrow.gt.nmax/n3) nrow = nmax/n3
            iadd1 = n0
            do i = n1, nrow
               x1(i) = dble(i - n1)
               y1(i) = xmat(i,n2)
               iadd1 = iadd1 + n1
               x2(iadd1) = x1(i)
               y2(iadd1) = zero
               iadd1 = iadd1 + n1
               x2(iadd1) = x1(i)
               y2(iadd1) = xmat(i,n1)
               iadd1 = iadd1 + n1
               x2(iadd1) = x1(i)
               y2(iadd1) = zero
            enddo
            call gks004 (n0, n1, n0, n0, n5, n0, n0, n0,
     +                   nrow, iadd1, n2, n2,
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   titles(1), titles(2), titles(3),
     +                   axes, gsave)
         endif
         deallocate(xmat, stat = ierr)
      else
c
c continuous distributions: define ngraf1 then find the data range
c
         if (ndist.eq.1) then
            xstart = par(1)
            xstop = par(2)
         elseif (ndist.eq.4) then
            xstart = 100.0d+00*x02ajf$()
            xstop = one - xstart   
         else
            zmin = z(n1)
            zmax = z(nz)
            xstart = zmin
            xstop = zmax
         endif
c
c Main loop
c
         repeet = .true.
         do while (repeet)
            i12(1) = form12(ncells)
            if (e_numbers) then
               write (text,200) trim(i12(1)), xstart, xstop
            else
               d13(1) = showlj(xstart)
               d13(2) = showlj(xstop)
               write (text,250) trim(i12(1)), trim(d13(1)), trim(d13(2))
            endif  
            numdec = 1
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, text)
            if (numdec.eq.4) then
               if (ndist.ne.2 .and. ndist.ne.10) then
                  numdec = 0
                  call putadv ('Not allowed with this distribution')
               endif
            elseif (numdec.eq.5) then
               if (ndist.eq.1 .or. ndist.eq.4) then
                  numdec = 0
                  call putadv ('Not allowed with this distribution')
               endif
            endif
            if (numdec.eq.1) then
c
c Histogram
c
               if (ncells.gt.nmax/n4 - 1) ncells = nmax/n4 - 1
               xdelta = (xstop - xstart)/(dble(ncells))
               x1(1) = xstart
               do i = n1, ncells
                  x1(i + n1) = x1(i) + xdelta
                  cells(i) = zero
               enddo
               epsi = xdelta/100.0d+00
               x1(1) = xstart - epsi
               x1(ncells + n1) = xstop + epsi
               iadd1 = n0
               do i = n1, nz
                  xtest = z(i)
                  notyet = .true.
                  do j = n1, ncells
                     if (notyet) then
                        if (xtest.gt.x1(j) .and.
     +                      xtest.le.x1(j + n1)) then
                           notyet = .false.
                           iadd1 = iadd1 + n1
                           cells(j) = cells(j) + n1
                        endif
                     endif
                  enddo
               enddo
               if (iadd1.ne.nz) call putadv ('iadd1 .ne. nz')
               x1(n1) = xstart
               x1(ncells + n1) = xstop
               iadd1 = n0
               do i = n1, ncells
                  iadd1 = iadd1 + n1
                  x2(iadd1) = x1(i)
                  y2(iadd1) = zero
                  iadd1 = iadd1 + n1
                  x2(iadd1) = x1(i)
                  y2(iadd1) = cells(i)
                  iadd1 = iadd1 + n1
                  x2(iadd1) = x1(i + n1)
                  y2(iadd1) = cells(i)
                  iadd1 = iadd1 + n1
                  x2(iadd1) = x1(i + n1)
                  y2(iadd1) = zero
               enddo
               iadd1 = iadd1 + n1
               x2(iadd1) = x1(n1)
               y2(iadd1) = zero
               xdelta = (xstop - xstart)/(dble(ngraf1) - one)
               xgraf(n1) = xstart
               do i = n2, ngraf1 - n1
                  xgraf(i) = xgraf(i - n1) + xdelta
               enddo
               xgraf(ngraf1) = xstop
               xdelta = dnz*(xstop - xstart)/dble(ncells)
               do i = n1, ngraf1
                  ygraf(i) = xdelta*pdffcn (ndist, npar,
     +                                      par, xgraf(i))
               enddo
               call gks004 (n2, n1, n0, n0, n0, n0, n0, n0,
     +                      ngraf1, iadd1, n2, n2,
     +                      xgraf, x2, x3, x4,
     +                      ygraf, y2, y3, y4,
     +                      titles(1), titles(2), titles(3),
     +                      axes, gsave)
            elseif (numdec.eq.2) then
c
c Symbols
c
               if (ncells.gt.nmax/n4) ncells = nmax/n4
               xdelta = (xstop - xstart)/(dble(ncells))
               x1(1) = xstart
               do i = n1, ncells
                  x1(i + n1) = x1(i) + xdelta
                  cells(i) = zero
               enddo
               epsi = xdelta/100.0d+00
               x1(1) = xstart - epsi
               x1(ncells + n1) = xstop + epsi
               iadd1 = 0
               do i = n1, nz
                  xtest = z(i)
                  notyet = .true.
                  do j = n1, ncells
                     if (notyet) then
                        if (xtest.gt.x1(j) .and.
     +                      xtest.le.x1(j + n1)) then
                           notyet = .false.
                           iadd1 = iadd1 + n1
                           cells(j) = cells(j) + n1
                        endif
                     endif
                  enddo
               enddo
               if (iadd1.ne.nz) call putadv ('iadd1 .ne. nz')
               x1(n1) = xstart
               x1(ncells + n1) = xstop
               iadd1 = n0
               do i = n1, ncells
                  iadd1 = iadd1 + n1
                  x2(iadd1) = (x1(i) + x1(i + n1))/two
                  y2(iadd1) = cells(i)
               enddo   
               xdelta = (xstop - xstart)/(dble(ngraf1) - one)
               xgraf(n1) = xstart
               do i = n2, ngraf1 - n1
                  xgraf(i) = xgraf(i - n1) + xdelta
               enddo
               xgraf(ngraf1) = xstop
               xdelta = dnz*(xstop - xstart)/dble(ncells)
               do i = n1, ngraf1
                  ygraf(i) = xdelta*pdffcn (ndist, npar, par, xgraf(i))
               enddo
               call gks004 (n2, n0, n0, n0, n0, n5, n0, n0,
     +                      ngraf1, iadd1, n2, n2,
     +                      xgraf, x2, x3, x4,
     +                      ygraf, y2, y3, y4,
     +                      titles(1), titles(2), titles(3),
     +                      axes, gsave)
           elseif (numdec.eq.3) then
c
c Change number of bins
c
              if (ncells.gt.nmax/n4 - 1) ncells = nmax/n4 - 1
              i = 1
              j = min(ntop,nmax/n4 - 1)
              if (ncells.gt.j) ncells = j
              call getjm1 (i, ncells, j,
     +                    'Number of histogram bins required')
           elseif (numdec.eq.4) then
c
c Xstart
c
              zlim = zmin
              if (e_numbers) then
                 write (line,300) zlim
              else
                 d13(1) = showlj(zlim)
                 write (line,350) trim(d13(1))
              endif  
              call getdle (xstart, zlim, line)
           elseif (numdec.eq.5) then
c
c Xstop
c
              zlim = zmax
              if (e_numbers) then
                 write (line,400) zlim
              else
                 d13(1) = showlj(zlim)
                 write (line,450) trim(d13(1)) 
              endif  
              call getdge (xstop, zlim, line)
           elseif (numdec.eq.numopt) then
              repeet = .false.
           endif
        enddo
      endif
  100 format (
     +'Number of values out of range =',1x,a,', re-scale so all <',1x,a)
  200 format (
     + 'Plot best-fit-pdf on data (histogram)'
     +/'Plot best-fit-pdf on data (symbols)'
     +/'Change number of histogram bins (',a,')'
     +/'Change x_start for histogram (',1p,e11.3,')'
     +/'Change x_stop for histogram (',1p,e11.3,')'
     +/'Quit ... Exit these plotting options')
  250 format (
     + 'Plot best-fit-pdf on data (histogram)'
     +/'Plot best-fit-pdf on data (symbols)'
     +/'Change number of histogram bins (',a,')'
     +/'Change x_start for histogram (',a,')'
     +/'Change x_stop for histogram (',a,')'
     +/'Quit ... Exit these plotting options')   
  300 format ('Start value for first bin (=<',1p,e11.3,')')
  350 format ('Start value for first bin (=<',1x,a,')')
  400 format ('End value for last bin (>=',1p,e11.3,')')
  450 format ('End value for last bin (>=',1x,a,')')
      end
c
c
