C
C
      SUBROUTINE PDTEST (ICOUNT, IX, NMAX, NOUT, NTOP,
     +                   E, EBINS, O, OBINS, RR, X,
     +                   TITLE,
     +                   SUPPLY)
C
C ACTION : Chi-square tests for Poisson distribution on X values
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          05/04/2000 adapted from TESTBN for Poisson distribution
C          26/09/2007 derived fron TESTPN of program BINOMIAL 
C          11/07/2022 added E_BINS and E_FORMATS, etc. 
C
C Note: if SUPPLY = .TRUE. then NMAX must be the sample size 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT, NMAX, NTOP
      INTEGER,             INTENT (OUT)   :: ICOUNT(0:NTOP), IX(NMAX)
      DOUBLE PRECISION,    INTENT (IN)    :: RR
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: E(NTOP + 1),
     +                                       EBINS(NTOP + 1),
     +                                       O(NTOP + 1),
     +                                       OBINS(NTOP + 1)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY       
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N10, N20
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N10 = 10, N20 = 20)
      INTEGER    I, IFAIL, J, K, L, NBINS, NDOF, NMIN
      INTEGER    NDEC, NPLUS1, NPLUS2, NUM
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NUMOPT, NUMTXT
      PARAMETER (ICOLOR = 9)
      INTEGER    NUMBLD(20), NUMPOS(3)
      DOUBLE PRECISION ZERO, ONE, RFIX, RMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, RMIN = 0.001D+00)
      DOUBLE PRECISION CLEVEL
      PARAMETER (CLEVEL = 0.95)
      DOUBLE PRECISION ESUM, OSUM, R
      DOUBLE PRECISION XBAR, XSIG, XVAR, YBAR
      DOUBLE PRECISION CHISQ, PGCHI, PH95, PL95, P95, P99
      DOUBLE PRECISION PDF_POISSON, RNUM
      CHARACTER (LEN = 12) I12(2), FORM12 
      CHARACTER (LEN = 13) D13(10), SHOWLJ
      CHARACTER  FNAME1*1024, RESUL*30, TITLES(7)*45
      CHARACTER  DLINES(2)*100, LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*20, CTEMP(15)*80
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, FIXNPT, LABEL, USEHAT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PDF_POISSON
      EXTERNAL   PUTWAR, VEC1IN, NXSORT, NXXBAR, EOBINS, CHISQD,
     +           LBOX01, PATCH1, PUTADV, PUTIFA, GETDGE, TABLE1
      EXTERNAL   OEBINS
      EXTERNAL   PDVALU 
      EXTERNAL   G07ABF$
      INTRINSIC  DBLE, NINT, SQRT, MAX, TRIM
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 3*1 /
C
C Copy RR into R so R is unchanged
C      
      R = RR
      IF (R.LT.RMIN) R = ONE
      RFIX = R  
      IF (SUPPLY) THEN
         L = NMAX
      ELSE   
C
C Read in data, check then put into order
C
         I = N3
         J = N3
         K = NMAX
         FIXNPT = .FALSE.
         LABEL = .TRUE.
         CALL VEC1IN (I, J, K, L,
     +                X, 
     +                FNAME1, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = J)
         IF (ABORT) RETURN
      ENDIF  
      E_NUMBERS = E_FORMATS()
      IF (L.LT.N10) THEN
         CALL PUTWAR ('Sample size to small for chi-square test')
         RETURN
      ELSEIF (L.LT.N20) THEN
         CALL PUTADV ('Sample size is rather small for a chi-sq. test')
      ENDIF
      NUM = L
      DO I = N1, NUM
        IF (X(I).LT.ZERO) THEN
           I12(1) = FORM12(I)
           WRITE (LINE,100) I12(1)
           CALL PUTWAR (LINE)
           RETURN
        ENDIF
      ENDDO
      CALL NXSORT (NUM,
     +             X)
      DO I = N1, NUM
        IX(I) = NINT(X(I))
        X(I) = DBLE(IX(I))
      ENDDO
C
C Calculate DLINES
C      
      CALL PDVALU (NUM,
     +             X,
     +             DLINES) 
C
C Calculate sample mean and standard deviation
C
      CALL NXXBAR (NUM, 
     +             X, XBAR, XVAR)
      IF (XBAR.LE.ZERO .OR. XVAR.LE.ZERO) THEN
         CALL PUTWAR ('Sample values are all identical')
         RETURN
      ENDIF
      XSIG = SQRT(XVAR)
      IFAIL = 0
      CALL G07ABF$(NUM, XBAR, CLEVEL, PL95, PH95, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G07ABF/PDTEST')
      IF (XVAR.LT.PL95) THEN
         CIPHER = 'Under-dispersed ?'
      ELSEIF (XVAR.GT.PH95) THEN
         CIPHER = 'Over-dispersed ?'
      ELSE
         CIPHER = ' '
      ENDIF
      DO I = N0, NTOP
         ICOUNT(I) = N0
      ENDDO
      RNUM = DBLE(NUM)
      DO I = N1, NUM
         J = IX(I)
         ICOUNT(J) = ICOUNT(J) + N1
      ENDDO
C
C Decide whether to use RHAT or R from option 1
C
      IF (E_NUMBERS) THEN
         WRITE (TEXT,200) R, XBAR
      ELSE
         D13(1) = SHOWLJ(R)
         D13(2) = SHOWLJ(XBAR)  
         WRITE (TEXT,250) D13(1), D13(2)
      ENDIF  
      IXL = N4
      IYL = N4
      LSHADE = N1
      NUMBLD(1) = N1
      NDEC = N2
      NUMOPT = N3
      NSTART = N6
      NUMTXT = NSTART + NUMOPT - N1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NUMTXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(1) = N0
      IF (NDEC.EQ.N1) THEN
         USEHAT = .FALSE.
      ELSEIF (NDEC.EQ.N2) THEN
         USEHAT = .TRUE.
         R = XBAR
      ELSE
        USEHAT = .FALSE.
        CALL GETDGE (R, RMIN, 'Lambda to use in chi-square test')   
        RFIX = R
      ENDIF
      YBAR = RFIX
C
C Minimal bin size (by NMIN < 1) then prepare data for chi-square test
C
      NPLUS1 = IX(NUM) + N1
      ESUM = ZERO
      OSUM = ZERO
      DO I = N1, NPLUS1
         J = I - N1
         E(I) = RNUM*PDF_POISSON (J, NOUT,
     +                            R)
         O(I) = DBLE(ICOUNT(J))
         ESUM = ESUM + E(I)
         OSUM = OSUM + O(I)
      ENDDO
      NMIN = - N1
      NPLUS2 = NPLUS1 + N1
      O(NPLUS2) = ZERO
      E(NPLUS2) = MAX(ZERO,OSUM - ESUM)
      IF (E(NPLUS2).LE.ZERO) E(NPLUS2) = ONE
      CALL EOBINS (NPLUS2, NBINS, NMIN,
     +             E, EBINS, O, OBINS)
C
C Fix degrees of freedom
C
      NDOF = NBINS - N1
      IF (USEHAT) NDOF = NDOF - N1
      IF (NDOF.LE.N0) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) XBAR, PL95, PH95, XBAR, XVAR, CIPHER
            WRITE (NOUT,300) XBAR, PL95, PH95, XBAR, XVAR, CIPHER
         ELSE
            D13(1) = SHOWLJ(XBAR)
            D13(2) = SHOWLJ(PL95)
            D13(3) = SHOWLJ(PH95)
            D13(4) = SHOWLJ(XVAR)
            WRITE (TEXT,350) D13(1), D13(2), D13(3), D13(1),
     +                       TRIM(D13(4)), CIPHER
            WRITE (NOUT,350) D13(1), D13(2), D13(3), D13(1),
     +                       TRIM(D13(4)), CIPHER
         ENDIF  
         IXL = N4
         IYL = N4
         LSHADE = N0
         NUMTXT = N7
         NUMBLD(NUMTXT) = N1
         CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                TEXT, BORDER)
         RETURN
      ENDIF
C
C Chi-square test
C
      CALL CHISQD (NBINS, NDOF, NOUT,
     +             CHISQ, EBINS, OBINS, PGCHI, P95, P99)
      IF (PGCHI.GE.0.05D+00) THEN
         RESUL = 'Consider accepting H0'
      ELSEIF (PGCHI.GE.0.01D+00) THEN
         RESUL = 'Reject H0 at 5% level'
      ELSE
         RESUL = 'Reject H0 at 1% level'
      ENDIF
C
C Output results
C
      IF (E_NUMBERS) THEN
         WRITE (CTEMP,400) R, TITLE
         WRITE (NOUT,400) R, TITLE
      ELSE
         D13(1) = SHOWLJ(R)
         WRITE (CTEMP,450) TRIM(D13(1)), TITLE
         WRITE (NOUT,450) TRIM(D13(1)), TITLE
      ENDIF  
      DO I = N1, N4
         TEXT(I) = CTEMP(I + N1)
      ENDDO
      IF (USEHAT) THEN
         WRITE (TEXT(5),500)
         WRITE (NOUT,500)
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (TEXT(5),600) RFIX
            WRITE (NOUT,600) RFIX
         ELSE
            D13(1) = SHOWLJ(RFIX)  
            WRITE (TEXT(5),650) TRIM(D13(1))
            WRITE (NOUT,650) TRIM(D13(1))
         ENDIF  
      ENDIF
            
      I12(1) = FORM12(NBINS)
      I12(2) = FORM12(NDOF)
      IF (E_NUMBERS) THEN
         WRITE (CTEMP,700) XBAR, PL95, PH95, XBAR, XVAR, CIPHER, XSIG,
     +                     YBAR, DLINES(1), DLINES(2),
     +                     I12(1), I12(2), CHISQ, PGCHI, RESUL,
     +                     P95, P99
         WRITE (NOUT,700) XBAR, PL95, PH95, XBAR, XVAR, CIPHER, XSIG,
     +                    YBAR, DLINES(1), DLINES(2),
     +                    I12(1), I12(2), CHISQ, PGCHI, RESUL,
     +                    P95, P99
      ELSE
         D13(1) = SHOWLJ(XBAR) 
         D13(2) = SHOWLJ(PL95) 
         D13(3) = SHOWLJ(PH95) 
         D13(4) = SHOWLJ(XBAR) 
         D13(5) = SHOWLJ(XVAR) 
         D13(6) = SHOWLJ(XSIG) 
         D13(7) = SHOWLJ(YBAR) 
         D13(8) = SHOWLJ(CHISQ) 
         D13(9) = SHOWLJ(P95) 
         D13(10) = SHOWLJ(P99) 
         WRITE (CTEMP,750) D13(1), D13(2), D13(3), D13(4), D13(5),
     +                     CIPHER, D13(6),
     +                     D13(7), DLINES(1), DLINES(2),
     +                     I12(1), I12(2), D13(8), PGCHI, RESUL,
     +                     D13(9), D13(10)
         WRITE (NOUT,750) D13(1), D13(2), D13(3), D13(4), D13(5),
     +                     CIPHER, D13(6),
     +                     D13(7), DLINES(1), DLINES(2),
     +                     I12(1), I12(2), D13(8), PGCHI, RESUL,
     +                     D13(9), D13(10)
      ENDIF  
      DO I = N6, N20
         TEXT(I) = CTEMP(I - N5)
      ENDDO
       J = 15
       CALL TABLE1 (J, 'OPEN')
       J = 0
       DO I = 1, N20
          IF (I.EQ.1) THEN
             J = 4
          ELSEIF (I.EQ.4) THEN
             J = 1
          ELSE
             J = 0
          ENDIF           
          CALL TABLE1 (J, TEXT(I))
       ENDDO
       CALL TABLE1 (J, 'CLOSE')   
C
C Tables and graphs output if required
C
      IF (E_NUMBERS) THEN
         WRITE (TITLES,800) R, R
      ELSE
        D13(1) = SHOWLJ(R)
        WRITE (TITLES,850) TRIM(D13(1)), TRIM(D13(1))
      ENDIF     
      CALL OEBINS (IX, NPLUS1, NBINS, NOUT, NUM,
     +             E, EBINS, O, OBINS,
     +             TITLES)
C       
C Format statements       
C        
  100 FORMAT ('X =< 0 ... Check value number',1X,A)
  200 FORMAT (
     + 'Decide which lambda to use'
     +/
     +/'The null hypothesis is:'
     +/'H0: X is distributed as P(lambda)'
     +/
     +/'Use fixed lambda =',   1P,E10.3
     +/'Use sample estimate =',   E10.3
     +/'Input/use new fixed lambda')
  250 FORMAT (
     + 'Decide which lambda to use'
     +/
     +/'The null hypothesis is:'
     +/'H0: X is distributed as P(lambda)'
     +/
     +/'Use fixed lambda =',1X,A
     +/'Use sample estimate =',1X,A
     +/'Input/use new fixed lambda')   
  300 FORMAT (/
     + 'Sample estimate for lambda    =',F10.4
     +/'Lower 95% confidence limit    =',F10.4
     +/'Upper 95% confidence limit    =',F10.4
     +/'Mean of x values supplied     =',   1P,E10.3
     +/'Variance of x values supplied =',   E10.3,1X,A
     +/'Not enough bins: DOF too small for meaningful chi-square test')
  350 FORMAT (/
     + 'Sample estimate for lambda    =',1X,A
     +/'Lower 95% confidence limit    =',1X,A
     +/'Upper 95% confidence limit    =',1X,A
     +/'Mean of x values supplied     =',1X,A
     +/'Variance of x values supplied =',1X,A,1X,A
     +/'Not enough bins: DOF too small for meaningful chi-square test')   
  400 FORMAT (
     +/'Chi-square test for P(',1P,E9.3,')'
     +/
     +/'H0: Poisson distribution for data with title:'
     +/A)
  450 FORMAT (
     +/'Chi-square test for P(',A,')'
     +/
     +/'H0: Poisson distribution for data with title:'
     +/A)   
  500 FORMAT ('Sample estimate used in chi-square test')
  600 FORMAT ('Fixed lambda =',1P,E10.3,1X,'used in chi-square test')
  650 FORMAT ('Fixed lambda =',1X,A,1X,'used in chi-square test')
  700 FORMAT (
     + 'Sample estimate for lambda       =',1P,E10.3
     +/'Lower 95% confidence limit       =',   E10.3
     +/'Upper 95% confidence limit       =',   E10.3
     +/'Mean of x-values                 =',   E10.3
     +/'Variance of x-values             =',   E10.3,1X,A
     +/'Standard deviation of x          =',   E10.3
     +/'Mean using fixed lambda          =',   E10.3
     +/A
     +/A
     +/'Number of partitions (bins) used =',1X,A
     +/'Number of degrees of freedom     =',1X,A
     +/'Chi-square test statistic C      =',1P,E10.3
     +/'p = P(chi-square >= C)           =',0P,F7.4,5X,A
     +/'Upper tail 5% critical point     =',1P,E10.3
     +/'Upper tail 1% critical point     =',   E10.3)
  750 FORMAT (
     + 'Sample estimate for lambda       =',1X,A
     +/'Lower 95% confidence limit       =',1X,A
     +/'Upper 95% confidence limit       =',1X,A
     +/'Mean of x-values                 =',1X,A
     +/'Variance of x-values             =',1X,A,1X,A
     +/'Standard deviation of x          =',1X,A
     +/'Mean using fixed lambda          =',1X,A
     +/A
     +/A
     +/'Number of partitions (bins) used =',1X,A
     +/'Number of degrees of freedom     =',1X,A
     +/'Chi-square test statistic C      =',1X,A
     +/'p = P(chi-square >= C)           =',F7.4,5X,A
     +/'Upper tail 5% critical point     =',1X,A
     +/'Upper tail 1% critical point     =',1X,A)    
  800 FORMAT (
     + 'Chi-sq. bins assuming P(',1P,E9.3,')'     
     +/'Bin number'
     +/'O/E Frequencies'
     +/' '
     +/'Sample and pmf assuming P(',1P,E9.3,')'
     +/'X-values'
     +/'O/E Frequencies')   
  850 FORMAT (
     + 'Chi-sq. bins assuming P(',A,')'     
     +/'Bin number'
     +/'O/E Frequencies'
     +/' '
     +/'Sample and pmf assuming P(',A,')'
     +/'X-values'
     +/'O/E Frequencies')       
      END
C
C
      SUBROUTINE PDVALU (N,
     +                   X,
     +                   LINES)
C
C Calculate Poisson D
C     
      IMPLICIT NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: N
      DOUBLE PRECISION,    INTENT (IN)  :: X(N)
      CHARACTER (LEN = *), INTENT (OUT) :: LINES(2) 
C
C Locals
C  
      INTEGER I, IFAIL
      DOUBLE PRECISION D, DOF, PROB, XBAR
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER (LEN = 30) SYMBOL
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   PLEVEL
      EXTERNAL   G01ECF$
      INTRINSIC  DBLE
C
C Initialise then check input
C      
      LINES(1) = 'No dispersion test data'     
      LINES(2) = 'No dispersion test data'  
      IF (N.LT.2) THEN
         LINES(2) = 'N < 2 in PDVALU'
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Calculate XBAR
C      
      XBAR = ZERO 
      DO I = 1, N
         IF (X(I).LT.ZERO) THEN
            LINES(2) = 'Negative frequency encountered in PDVALU'
            RETURN
         ENDIF   
         XBAR = XBAR + X(I)
      ENDDO 
      IF (XBAR.LE.ZERO) THEN
         LINES(2) = 'Zero mean encountered in PDVALU'
         RETURN
      ELSE
         XBAR = XBAR/DBLE(N)
      ENDIF 
C
C Calculate D
C      
      D = ZERO
      DO I = 1, N
         D = D + (X(I) - XBAR)**2
      ENDDO
      IF (D.LE.ZERO) THEN
         LINES(2) = 'D =< 0 in PDVALU' 
         RETURN
      ELSE
         D = D/XBAR
      ENDIF
C
C Calculate chi-square probability
C      
      DOF = DBLE(N - 1) 
      IF (D.GE.ONE) THEN
         PROB = G01ECF$('U', D, DOF, IFAIL)
      ELSE 
         PROB = G01ECF$('L', D, DOF, IFAIL)
      ENDIF  
      CALL PLEVEL (PROB,
     +             SYMBOL)
C
C Write the results onto LINES
C     
      IF (E_NUMBERS) THEN
         WRITE (LINES(1),100) D
      ELSE
         D13 = SHOWLJ(D)
         WRITE (LINES(1),150) D13 
      ENDIF  
      IF (D.GE.ONE) THEN
         WRITE (LINES(2),200) PROB, SYMBOL
      ELSE
         WRITE (LINES(2),300) PROB, SYMBOL
      ENDIF
  100 FORMAT ('Poisson dispersion value D       =',1P,E10.3)
  150 FORMAT ('Poisson dispersion value D       =',1X,A)
  200 FORMAT ('p = P(chi-square >= D)           =',F7.4,5X,A)   
  300 FORMAT ('p = P(chi-square =< D)           =',F7.4,5X,A)   
      END
C
C      

                                       