C
C
      SUBROUTINE PHAT95 (ILIM, KX, N, NOUT, PBOT, PHAT, PTOP)
C
C ACTION : Find upper and lower 90%, 95%, 99% con. lims. on PHAT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/11/95
C          Developed from BINOMIAL
C          10/6/95 Added special cases x = 0 and x = N
C          1/9/98 added ILIM
C          08/04/2000 replaced F method by G07AAF$
C
      IMPLICIT   NONE
      INTEGER    ILIM, KX, N, NOUT
      INTEGER    IFAIL
      DOUBLE PRECISION PBOT, PHAT, PTOP
      DOUBLE PRECISION CLEVEL, RN, X
      DOUBLE PRECISION ZERO, F100
      PARAMETER (ZERO = 0.0D+00, F100 = 100.0D+00)
      EXTERNAL   G07AAF$
      EXTERNAL   PUTIFA, PUTFAT
      INTRINSIC  DBLE
C
C Check the input data and initialise PBIG, PSMALL
C
      PBOT = ZERO
      PHAT = ZERO
      PTOP = ZERO
      IF (KX.LT.0 .OR. KX.GT.N .OR. N.LT.1) THEN
         CALL PUTFAT ('KX < 0, KX > N  or N < 1 in call to PHAT95')
         RETURN
      ENDIF
      IF (ILIM.EQ.90 .OR. ILIM.EQ.95 .OR. ILIM.EQ.99) THEN
         CLEVEL = DBLE(ILIM)/F100
      ELSE
         CALL PUTFAT ('ILIM not 90, 95 or 99 in call to PHAT95')
         RETURN
      ENDIF
C
C First the limits by G07AAF$
C
      IFAIL = 0
      CALL G07AAF$(N, KX, CLEVEL, PBOT, PTOP, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G07AAF/PHAT95')
C
C Finally PHAT
C
      RN = DBLE(N)
      X = DBLE(KX)
      PHAT = X/RN
      END
C
C
