C
C
      SUBROUTINE PKURVE (NPAR, 
     +                   P)
C
C ACTION: Plot parameteric r(theta), [x(t),y(t)], [x(t),y(t),z(t)], curves
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 29/09/2000
C         16/10/2001 introduced KMAX_A, KMAX_F, KMAX_J, KMAX_Y
C         08/11/2001 introduced multimodels
C         02/01/2008 added INTENTS and increased NGRAFS to 300
C         18/01/2008 removed NMAX, X, XTEMP, Y, YTEMP, Z from argument list
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NPAR
      DOUBLE PRECISION, INTENT (INOUT) :: P(NPAR)

C
C Locals
C      
      INTEGER    I, ISEND, IFAIL, J, K1, K2, K3, N, NEQN, NPAR1, NVAR,
     +           NVAR1
      INTEGER    NMAX
      PARAMETER (NMAX = 10000, NVAR = 1)
      INTEGER    N0, N1, NX
      PARAMETER (N0 = 0, N1 = 1, NX = 10)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    JCOLOR, NIN, NGRAFS, NFILES
      PARAMETER (JCOLOR = 9, NGRAFS = 300)
      INTEGER    NUMBLD(30), NUMPOS(30)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = 3*NGRAFS, KMAX_J = 2, KMAX_Y = 2)
      DOUBLE PRECISION X(NMAX), XTEMP(NMAX),
     +                 Y(NMAX), YTEMP(NMAX), Z(NMAX)      
      DOUBLE PRECISION F(KMAX_F), X1, Y1, YDE(KMAX_Y), YJA(KMAX_J), Z1
      DOUBLE PRECISION XDELTA, XSTART, XSTOP
      DOUBLE PRECISION R, THETA
      DOUBLE PRECISION ASYMP, EPSI, PI, ZERO
      PARAMETER (ASYMP = -1.0D+00, EPSI = 1.0D-12, PI = 3.1415927D+00,
     +           ZERO = 0.0D+00)
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER (LEN = 10) FORMGR, WORD10(2)
      CHARACTER  LINE*100, MODNAM(24)*80, TEXT(30)*100
      CHARACTER  FNAME(NGRAFS)*1024, FTITLE(NGRAFS)*80
      CHARACTER  BLANK*1, PTITLE*20, XTITLE*1, YTITLE*1
      PARAMETER (BLANK = ' ', XTITLE = 'x', YTITLE = 'y')
      LOGICAL    ABORT, AGAIN, OK(4), TOFILE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AXES, GSAVE, DEQN, DEQN1
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE., DEQN = .FALSE.)
      LOGICAL    ASKIF, LIB_FILE, NO, THERE, YES
      PARAMETER (ASKIF = .FALSE., LIB_FILE = .FALSE., NO = .FALSE.,
     +           YES = .TRUE.)
      LOGICAL    FRAME, NEXT, SUPPLY, UPDOWN
      PARAMETER (FRAME = .FALSE., SUPPLY = .TRUE., UPDOWN = .FALSE.)
      EXTERNAL   FORM12, FORMGR
      EXTERNAL   QNUSER, LBOX01, GETJM1, GETDG2, GKST04, EDITOR,
     +           SPACE0, NX3FIL, TUTORS, PUTADV, GETNOU,
     +           SPACE1, GETTMP, DELEET
      INTRINSIC  DBLE, COS, SIN
      SAVE       N, XSTART, XSTOP
      DATA       N / 200 /
      DATA       XSTART, XSTOP / 0.0D+00, 10.0D+00 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
C
C Initialise
C
      NFILES = 1
      KMAX_A = NPAR
      DO I = 1, 4
        OK(I) = .FALSE.
      ENDDO
      TOFILE = .TRUE.
      X1 = ZERO
      Y1 = ZERO
      Z1 = ZERO
      DO I = 1, KMAX_F
         F(I) = ZERO
      ENDDO
      DO I = 1, KMAX_J
         YJA(I) = ZERO
      ENDDO
      DO I = 1, KMAX_Y
         YDE(I) = ZERO
      ENDDO
      NPAR1 = 0
      NUMDEC = 12
      NEQN = 1
      WRITE (MODNAM,100)
C
C Main loop ....................................................
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WORD12 = FORM12(N)
         WORD10(1) = FORMGR(XSTART)
         WORD10(2) = FORMGR(XSTOP)
         WRITE (TEXT,200) (MODNAM(I), I = 1, 6), TRIM(WORD12),
     +                    TRIM(WORD10(1)), WORD10(2)
         NSTART = 9
         NUMOPT = 13
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.LE.4) THEN
C
C Plot
C
            IF (OK(NUMDEC)) THEN
               XDELTA = (XSTOP - XSTART)/DBLE(N - 1)
C
C X becomes t temporarily
C
               XTEMP(1) = XSTART
               DO I = 2, N - 1
                 XTEMP(I) = XTEMP(I - 1) + XDELTA
               ENDDO
               XTEMP(N) = XSTOP
               ISEND = 2
               IF (NEQN.LE.3) THEN
                  DO I = 1, N
C
C Set X1 = t, then calculate F
C
                     X1 = XTEMP(I)
                     CALL QNUSER (ISEND,
     +                            KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                            NEQN, NPAR1, NVAR1, NX,
     +                            P, F, X1, Y1, YDE, YJA, Z1,
     +                            MODNAM, ABORT, DEQN1)

                     IF (OK(1)) THEN
C
C r(theta)
C
                        R = F(1)
                        THETA = X1
                        IF (R.LT.ZERO) THEN
                           R = - R
                           THETA = THETA + PI
                        ENDIF
                        X(I) = R*COS(THETA)
                        Y(I) = R*SIN(THETA)
                     ELSEIF (NUMDEC.EQ.2) THEN
C
C x(t), y(t)
C
                        X(I) = F(1)
                        Y(I) = F(2)
                     ELSEIF (NUMDEC.EQ.3) THEN
C
C x(t), y(t), z(t)
C
                        X(I) = F(1)
                        Y(I) = F(2)
                        Z(I) = F(3)
                     ENDIF
                  ENDDO
               ELSE
                  K1 = - 2
                  K2 = - 1
                  K3 = 0
                  DO J = 1, NFILES
                     K1 = K1 + 3
                     K2 = K2 + 3
                     K3 = K3 + 3
                     DO I = 1, N
C
C Set X1 = t, then calculate F
C
                        X1 = XTEMP(I)
                        CALL QNUSER (ISEND,
     +                               KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                               NEQN, NPAR1, NVAR1, NX,
     +                               P, F, X1, Y1, YDE, YJA, Z1,
     +                               MODNAM, ABORT, DEQN1)

C
C x(t), y(t), z(t)
C
                        X(I) = F(K1)
                        Y(I) = F(K2)
                        Z(I) = F(K3)
                     ENDDO
                     CALL GETNOU (NIN)
                     CALL GETTMP (IFAIL, FNAME(J))
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FNAME(J))
                     WRITE (NIN,'(A)') 'Temporary file'
                     WRITE (NIN,'(2I6)') N, 3
                     DO I = 1, N
                        WRITE (NIN,'(3E12.4)') X(I), Y(I), Z(I)
                     ENDDO
                     CLOSE (UNIT = NIN)
                  ENDDO
               ENDIF
               IF (OK(1) .OR. OK(2)) THEN
C
C Plot x,y
C
                  CALL GKST04 (N1, N0, N0, N0,
     +                         N0, N0, N0, N0,
     +                          N, N1, N1, N1,
     +                         ASYMP,
     +                         X, XTEMP, XTEMP, XTEMP,
     +                         Y, YTEMP, YTEMP, YTEMP,
     +                         PTITLE, XTITLE, YTITLE,
     +                         AXES, GSAVE)
               ELSEIF (OK(3)) THEN
C
C Plot x, y, z
C
                  CALL SPACE0 (N, NMAX,
     +                         X, XTEMP, Y, YTEMP, Z)
                  IF (TOFILE) THEN
C
C Save x, y, z
C
                     WRITE (TEXT,300)
                     NSTART = 4
                     NUMOPT = 3
                     NTEXT = 6
                     NUMDEC = NUMOPT
                     CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD,
     +                            NUMDEC, NUMOPT, NUMPOS, NSTART, NTEXT,
     +                            TEXT,
     +                            BORDER, FLASH, HIGH)
                     IF (NUMDEC.EQ.1) THEN
C
C Re-calculate since SPACE0$ normalises x, y, z
C
                        XDELTA = (XSTOP - XSTART)/DBLE(N - 1)
                        X(1) = XSTART
                        DO I = 2, N - 1
                          X(I) = X(I - 1) + XDELTA
                        ENDDO
                        X(N) = XSTOP
                        ISEND = 2
                        DO I = 1, N
                           X1 = X(I)
                           CALL QNUSER (ISEND,
     +                                  KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                                  NEQN, NPAR1, NVAR1, NX,
     +                                  P, F, X1, Y1, YDE, YJA, Z1,
     +                                  MODNAM, ABORT, DEQN1)
                           X(I) = F(1)
                           Y(I) = F(2)
                           Z(I) = F(3)
                        ENDDO
                        CALL NX3FIL (N, X, Y, Z)
                        TOFILE = .TRUE.
                     ELSEIF (NUMDEC.EQ.2) THEN
                        TOFILE = .TRUE.
                     ELSE
                        TOFILE = .FALSE.
                     ENDIF
                  ENDIF
               ELSEIF (OK(4)) THEN
                  CALL SPACE1 (N1, NIN, NGRAFS, NFILES, NMAX,
     +                         XTEMP, YTEMP, X, XTEMP, Y, YTEMP, Z,
     +                         FNAME, FTITLE,
     +                         LIB_FILE, SUPPLY)
                  DO I = 1, NFILES
                     CALL DELEET (FNAME(I), ASKIF, THERE)
                  ENDDO
               ENDIF
            ELSE
               CALL PUTADV ('No current model for this plot')
               NUMDEC = NUMDEC + 3
            ENDIF
         ELSEIF (NUMDEC.LE.8) THEN
C
C New file
C
            DO I = 1, 4
               OK(I) = .FALSE.
            ENDDO
            DO I = 1, 6
               MODNAM(I) = BLANK
            ENDDO
            IF (NUMDEC.EQ.5) THEN
               NEQN = 1
               CALL PUTADV (
     +'Open a file for 1 equation in 1 variable, like rose.mod')
            ELSEIF (NUMDEC.EQ.6) THEN
               NEQN = 2
               CALL PUTADV (
     +'Open a file for 2 equations in 1 variable, like ellipse.mod')
            ELSEIF (NUMDEC.EQ.7) THEN
               NEQN = 3
               CALL PUTADV (
     +'Open a file for 3 equations in 1 variable, like helix.mod')
            ELSEIF (NUMDEC.EQ.8) then
                I = 1
                J = NGRAFS
                CALL GETJM1 (I, NFILES, J,
     +'Number of curves specified in file (this MUST be correct)')
                NEQN = 3*NFILES
                WRITE (LINE,400) NEQN
                CALL PUTADV (LINE)
            ENDIF
            NVAR1 = NVAR
            DEQN1 = DEQN
            ISEND = 1
            CALL QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR1, NVAR1, NX,
     +                   P, F, X1, Y1, YDE, YJA, Z1,
     +                   MODNAM, ABORT, DEQN1)
            IF (ABORT) THEN
               NPAR1 = 0
               WRITE (MODNAM,100)
               NEQN = 1
               NUMDEC = NUMOPT - 1
            ELSE
               IF (NEQN.EQ.1) THEN
                  OK(1) = .TRUE.
                  PTITLE = '  r = r(theta)'
                  NUMDEC = 1
               ELSEIF (NEQN.EQ.2) THEN
                  OK(2) = .TRUE.
                  PTITLE = 'x = x(t), y = y(t)'
                  NUMDEC = 2
               ELSEIF (NEQN.EQ.3) THEN
                  OK(3) = .TRUE.
                  NUMDEC = 3
               ELSE
                  OK(4) = .TRUE.
                  NUMDEC = 4
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.9) THEN
C
C New NPTS
C
            IF (OK(1) .OR. OK(2) .OR. OK(3) .OR. OK(4)) THEN
               I = 2
               CALL GETJM1 (I, N, NMAX,
     +                     'NPTS, the number of points required')
               IF (NEQN.LE.3) THEN
                  NUMDEC = NEQN
               ELSE
                  NUMDEC = 4
               ENDIF
            ELSE
               CALL PUTADV ('There is no current model')
               NUMDEC = NUMOPT - 1
            ENDIF
         ELSEIF (NUMDEC.EQ.10) THEN
C
C New x-start, x_stop
C
            IF (OK(1) .OR. OK(2) .OR. OK(3) .OR. OK(4)) THEN
               CALL GETDG2 (XSTART, XSTOP,
     +         't_start, t_stop required (t_stop > t_start)')
               IF (XSTOP - XSTART.LT.EPSI) THEN
                  XSTOP = XSTOP + EPSI
                  CALL PUTADV (
     +           't_stop too close to t_start, so adjusted')
               ENDIF
               IF (NEQN.LE.3) THEN
                  NUMDEC = NEQN
               ELSE
                  NUMDEC = 4
               ENDIF
            ELSE
               CALL PUTADV ('There is no current model')
               NUMDEC = NUMOPT - 1
            ENDIF
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Edit parameters
C
            IF (OK(1) .OR. OK(2) .OR. OK(3) .OR. OK(4)) THEN
               IF (NPAR1.GT.0) THEN
                  ISEND = 2
                  CALL EDITOR (ISEND, N1, N1, NPAR1, NPAR1, P,
     +                         'Editing model parameters', NO, YES, YES,
     +                          YES, NO, NO)
               ELSE
                  CALL PUTADV ('No current parameters')
               ENDIF
               IF (NEQN.LE.3) THEN
                  NUMDEC = NEQN
               ELSE
                  NUMDEC = 4
               ENDIF
            ELSE
               CALL PUTADV ('There is no current model')
               NUMDEC = NUMOPT - 1
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            WRITE (TEXT,500)
            NTEXT = 20
            NUMBLD(1) = 1
            NUMBLD(8) = 1
            NUMBLD(11) = 1
            NUMBLD(14) = 1
            NUMBLD(17) = 1
            NEXT = .FALSE.
            CALL TUTORS (JCOLOR, NUMBLD, NTEXT, 
     +                   TEXT, 
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(8) = 0
            NUMBLD(11) = 0
            NUMBLD(14) = 0
            NUMBLD(17) = 1
         ELSE
C
C Cancel
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'A user defined model must now be supplied.'
     +/'Consult the example test files:'
     +/'rose.mod, 1 equation for r = r(theta)'
     +/'ellipse.mod, 2 equations for x(t), y(t)'
     +/'helix.mod, 3 equations for x(t), y(t), z(t)'
     +/'family3d.mod, 4 curves for x(t), y(t), z(t)')
  200 FORMAT (
     + A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/'NPTS =',1X,A,', t_start =',1X,A,', t_stop =',1X,A,
     +/
     +/'Plot r = r(theta)'
     +/'Plot x = x(t), y = y(t)'
     +/'Plot x = x(t), y = y(t), z = z(t) (1 curve)'
     +/'Plot x = x(t), y = y(t), z = z(t) (n curves)'
     +/'Input model file for r(theta)'
     +/'Input model file for x(t), y(t)'
     +/'Input model file for x(t), y(t), z(t) (1 curve)'
     +/'Input model file for x(t), y(t), z(t) (n curves)'
     +/'Input new value for NPTS = numbere of points'
     +/'Input new values for t_start, t_stop'
     +/'Edit model parameters'
     +/'Help'
     +/'Quit ... Exit these plotting options')
  300 FORMAT (
     + 'These (x,y,z) coordinates can be saved'
     +/'for re-use by SIMPLOT if required. You'
     +/'can temporarily switch off this control.'
     +/'Save (x,y,z) to file'
     +/'Do not save (x,y,z)'
     +/'Disable this menu')
  400 FORMAT (
     +'Input a file (like family3d.mod) defining',I4,' functions')
  500 FORMAT ('User defined parametric plane and space curves'
     +/
     +/'In order to facilitate the plotting and fitting of some'
     +/'functions they must be expressed in parametric form,'
     +/'using the SIMFIT user-defined model format.'
     +/'The test files provided illustrate this as follows:'
     +/
     +/'rose.mod [r = r(theta), 1 function of 1 variable]'
     +/'The 5-leaved rose, r = A*sin(5*theta)'
     +/
     +/'ellipse.mod [x(t), y(t), 2 functions of 1 variable]'
     +/'The ellipse, x = A*cos(t), y = B*sin(t)'
     +/
     +/'helix.mod [x(t), y(t), z(t), 3 functions of 1 variable]'
     +/'The helix, x = A*cos(t), y = B*sin(t), z = C*t'
     +/
     +/'family3d.mod [4 diffusion curves = 12 functions of 1 variable]'
     +/'Note that n curves need 3n equations. Details in the manual,'
     +/'but try p(1) = 0.25, p(2) = 0.5, p(3) = 0.75, p(4) = 1.0 and'
     +/'x varying from -3 to 3 in order to understand this model.')
      END
C
C
