C
C
      SUBROUTINE PLEVBI (N, 
     +                   P, 
     +                   SYMBOL)
C
C ACTION : Supply N and P then return SYMBOL ... N and P are unchanged
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          19/09/2007 derived from PLEVEL but using Bonferroni n
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: N      
      DOUBLE PRECISION,    INTENT (IN)  :: P
      CHARACTER (LEN = *), INTENT (OUT) :: SYMBOL
C
C Locals
C      
      DOUBLE PRECISION ONE, PNT01, PNT05
      PARAMETER (ONE = 1.0D+00, PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION DBLE_N
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      INTRINSIC  LEN, DBLE
      DBLE_N = DBLE(N)
      IF (DBLE_N.LT.ONE) DBLE_N = ONE
      IF (P.GT.PNT05/DBLE_N) THEN
         SYMBOL = BLANK
      ELSEIF (LEN(SYMBOL).LE.23) THEN
         IF (P.LE.PNT01/DBLE_N) THEN
C***********SYMBOL = 'Reject at 1% sig. level'
            SYMBOL = 'Reject H0 at 1% s-level'
         ELSE
C***********SYMBOL = 'Reject at 5% sig. level'
            SYMBOL = 'Reject H0 at 5% s-level'
         ENDIF
      ELSE
         IF (P.LE.PNT01/DBLE_N) THEN
            SYMBOL = 'Reject H0 at 1% sig.level'
         ELSE
            SYMBOL = 'Reject H0 at 5% sig.level'
         ENDIF
      ENDIF
      END
C
C
