C
C
      SUBROUTINE PLEVEL (P, 
     +                   SYMBOL)
C
C ACTION : Supply P then return SYMBOL ... P is unchanged
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 29,6,92
C          27/08/1996 Changed SYMBOL
C          27/01/2003 allowed for longer strings than the original 23
C          19/09/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)  :: P
      CHARACTER (LEN = *), INTENT (OUT) :: SYMBOL
C
C Locals
C      
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      INTRINSIC  LEN
      IF (P.GT.PNT05) THEN
         SYMBOL = BLANK
      ELSEIF (LEN(SYMBOL).LE.23) THEN
         IF (P.LE.PNT01) THEN
C***********SYMBOL = 'Reject at 1% sig. level'
            SYMBOL = 'Reject H0 at 1% s-level'
         ELSE
C***********SYMBOL = 'Reject at 5% sig. level'
            SYMBOL = 'Reject H0 at 5% s-level'
         ENDIF
      ELSE
         IF (P.LE.PNT01) THEN
            SYMBOL = 'Reject H0 at 1% sig.level'
         ELSE
            SYMBOL = 'Reject H0 at 5% sig.level'
         ENDIF
      ENDIF
      END
C
C
