c
c
      subroutine plscor (ldt, ldu, maxfact, n, nout,
     +                   t, u)
c
c action: correlation for PLS scores
c author: w.g.bardsley, university of manchester, u.k., 11/04/2007
c                   
c Note: arguments are all (input/unchanged)
c
c           ldt: leading dimension of t
c           ldu: leading dimension of u
c       maxfact: maximum number of factors
c             n: number of observations
c          nout: unit connected for results log
c             t: predictor scores
c             u: response scores
c
      implicit none
c
c arguments
c
      integer,          intent (in) :: ldt, ldu, maxfact, n, nout
      double precision, intent (in) :: t(ldt,maxfact),
     +                                 u(ldu,maxfact) 
c
c local allocatable arrays
c     
      double precision, allocatable :: x(:), y(:)   
c
c locals
c       
      integer    i, ierr, ios, jmax, jmin, jx, jy, l, m, nlines, numdec   
      integer    len200, lx, ly
      integer    numopt 
      parameter (numopt = 7)
      character  line*100, text(numopt)*100, word8x*8, word8y*8 
      character  cipher*10, ptitle*60, xtitle*11, ytitle*11
      parameter (ptitle = 'PLS Scores Plot') 
      logical    file1, print1, repeet      
      parameter (print1 = .true.)
      external   putfat, triml1, listbx, getjm1, gks001, len200, revpro,
     +           linfit, writer
      save       file1
      save       jx, jy
      data       jx, jy / 1, 1 / 
      data       file1 / .false. /
c
c check input
c       
      if (n.lt.3) then
         write (line,100)
         call putfat (line)
         return
      endif  
c
c allocate
c       
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      allocate(x(n), stat = ierr)
      if (ierr.ne.0) return  
      allocate(y(n), stat = ierr)
      if (ierr.ne.0) return  
c
c initialise
c      
      if (jx.lt.1 .or. jx.gt.maxfact) jx = 1   
      if (jy.lt.1 .or. jy.gt.maxfact) jy = 1  
      jmin = 1
      jmax = maxfact
      write (word8x,'(i8)') jx
      call triml1 (word8x)    
      write (word8y,'(i8)') jy
      call triml1 (word8y)
      do i = 1, n 
         x(i) = t(i,jx)
         y(i) = u(i,jy)
      enddo
c
c main loop
c                
      repeet = .true.
      do while (repeet)
         if (file1) then
            cipher = '[Yes]'
         else
            cipher = '[No]'
         endif       
         numdec = 3 
         write (text,200) word8x, word8y, cipher
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then 
c
c change X-index
c          
            if (maxfact.eq.1) then
               jx = 1
            else
               write (line,300) 'X'
               call getjm1 (jmin, jx, jmax,
     +                      line)
               write (word8x,'(i8)') jx
               call triml1 (word8x)
               do i = 1, n
                  x(i) = t(i,jx)
               enddo    
            endif
         elseif (numdec.eq.2) then
c
c change Y-index
c         
            if (maxfact.eq.1) then
               jy = 1
            else
               write (line,300) 'Y'
               call getjm1 (jmin, jy, jmax,
     +                      line)
               write (word8y,'(i8)') jy
               call triml1 (word8y)
               do i = 1, n
                  y(i) = u(i,jy)
               enddo    
            endif  
         elseif (numdec.eq.3) then     
c
c simple scatter plot
c         
            xtitle = 't'//word8x
            ytitle = 'u'//word8y  
            l = 0
            m = 5
            call gks001 (l, m, n,
     +                   x, y,
     +                   ptitle, xtitle, ytitle)              
         elseif (numdec.eq.4) then 
c
c full correlation analysis
c                            
            if (file1) then     
               xtitle = 't'//word8x
               ytitle = 'u'//word8y 
               lx = len200(xtitle)
               ly = len200(ytitle)
               write (text(1),400) xtitle(1:lx), ytitle(1:ly)
               nlines = 1
               call writer (ios, nlines, nout,
     +                      text)               
            endif     
            call linfit (nout, n,
     +                   x, y,
     +                   file1, print1) 
         elseif (numdec.eq.numopt - 2) then
c
c change file1
c         
             file1 = .not.file1      
         elseif (numdec.eq.numopt - 1) then
c
c review progress
c         
             call revpro (nout)         
         else
            repeet = .false.
         endif                                 
      enddo            
c
c deallocate
c      
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c      
  100 format ('Must have at least three rows')
  200 format (
     + 'Change X-score index: current =',1x,a   
     +/'Change Y-score index: current =',1x,a 
     +/'Simple scatter plot'
     +/'Full correlation analysis' 
     +/'Change archiving results to log file: current =',1x,a    
     +/'Results'
     +/'Quit ... Exit these PLS correlation options') 
  300 format ('New factor to plot for',1x,a) 
  400 format ('Full correlation analysis for x =',1X,A,', y =',1x,a) 
     
      end     
c
c 